C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine SS_apply( tri, work, MapTrace, nsamp, samps, linear )

c routine to apply stretch/squeeze to trace using MapTrace() as a map.

#include <f77/lhdrsz.h>

c variables passed from calling routine

      integer nsamp

      real tri(nsamp), work(nsamp), MapTrace(nsamp), samps(nsamp)

      logical linear

c local variables

      integer  iz(8*SZLNHD), icinit

      real zz(8*SZLNHD), rinter

c initialize variables

      if(.not.linear)then

         icinit = 1

c using cubic spline interpolation fill work() with the 
c interpolated amplitudes from tri() as requested by
c the indices in MapTrace().

         call fcuint( samps, tri, nsamp, MapTrace, work, nsamp, iz, zz, 
     :        icinit )

      else

         do i=1,nsamp

            tshift = MapTrace(i)
            intshift = tshift
            realshift = tshift - intshift
            work(i) = rinter( tri(intshift), tri(intshift+1), 
     :           realshift )

         enddo

      endif

      call vmov ( work, 1, tri, 1, nsamp )
 
      return
      end
