C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c                            arcsstack
c
c Adjacent Record Cummulative Static: Pilot and Object Stack Generation
c  
c declare standard USP variables
 
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
 
      integer     itr ( SZLNHD )
      integer     nsamp, nsi, ntrc, ntrco, nrec, nreco, iform
      integer     luin , lbytes, nbytes, lbyout, obytes
      integer     irs, ire, ns, ne, argis

      character   ntap*255, otap*255, name*9

      logical     verbos

c declare variables used in dynamic memory allocation

      integer    ShotHeaders
      integer    PickIndex
      integer    CDPlocation
      integer    errcdi, errcd1, errcd2, errcd3, errcd4, errcd5, errcd6
      integer    abort, itemHeader, itemRec, itemTrace

      real        Record, Pilot, Object
      real        StructurePicks

      pointer     (wkadri, ShotHeaders(200000))
      pointer     (wkadr1, Record(200000))
      pointer     (wkadr2, Pilot(200000))
      pointer     (wkadr3, Object(200000))
      pointer     (wkadr4, StructurePicks(200000))
      pointer     (wkadr5, CDPlocation(200000))
      pointer     (wkadr6, PickIndex(200000))

c declare program specific static memory variables

      integer   ifmt_SrcLoc, l_SrcLoc, ln_SrcLoc
      integer   ifmt_RecInd, l_RecInd, ln_RecInd
      integer   ifmt_DphInd, l_DphInd, ln_DphInd, DphInd
      integer   ifmt_DstSgn, l_DstSgn, ln_DstSgn, DstSgn
      integer   ifmt_StaCor, l_StaCor, ln_StaCor, StaCor
      integer   AgcWindow
      integer   length
      integer   nsegs, npicks, datumCDP, PilotDatumCDP
      integer   lupilot, luobject, lupick, count
      integer   Pilotheader(ITRWRD), index, hindex

      real      samps(SZLNHD), static(SZLNHD), work(SZLNHD)
      real      AgcAmplitude, MapTrace(SZLNHD)
      real      PilotDatum(SZLNHD), NextPilotDatum(SZLNHD)

      character   pilottap*255, objecttap*255, picktap*255
      character   SortFlag*1

      logical linear

c initialize variables at compile

      data lbytes / 0 /
      data nbytes / 0 /
      data name/'ARCSSTACK'/
      data abort/0/
      data AgcWindow/501/
      data AgcAmplitude /307.05/
      data count/0/

c get command line help if requested

      if ( argis ( '-?' ) .gt. 0 .or. 
     :     argis ( '-h' ) .gt. 0 .or. 
     :     argis ( '-help' ) .gt. 0 ) then
         call help()
         stop
      endif

c initialize arrays

      call vclr ( PilotDatum, 1, SZLNHD )
      call vclr ( NextPilotDatum, 1, SZLNHD )
      call vclr ( Static, 1, SZLNHD )
      call vclr ( work, 1, SZLNHD )
      call vclr ( MapTrace, 1, SZLNHD )
      
c open printout file

#include <f77/open.h>

c get command line parameters

      call cmdln ( ntap, ns, ne, irs, ire, pilottap, objecttap, 
     :     picktap, SortFlag, linear, verbos)

c open input and output of seismic datasets

      call getln ( luin , ntap, 'r', 0)

      call alloclun(lupilot)
      call getln( lupilot, pilottap, 'w+', 1)
      call alloclun(luobject)
      call getln( luobject, objecttap, 'w+', 1)
      
c open structural pickfile if attached

      if (picktap .ne. ' ' ) then
         call alloclun(lupick)
         length = lenth(picktap)
         open(unit=lupick,file=picktap(1:length),status='old',
     :        err=990)
      endif

c build pointers to required traceheader entries

      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)

c read input line header 

      call rtape  ( luin, itr, lbytes)
      if(lbytes .eq. 0) then
         write(LER,*)'ARCS: no header read from unit ',luin
         write(LER,*)'FATAL'
         stop
      endif
 
c save global dataset parameters

      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'Format', iform, LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'UnitSc', unitsc, LINHED)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(itr, 'UnitSc', unitsc, LINHED)
      endif

c check compatability of command line parameters with data
      
      call cmdchk ( ns, ne, irs, ire, ntrc, nrec )
 
c print the historical line header to the printout file and load to
c modified historical line header in memory 

      call hlhprt (itr, lbytes, name, 9, LERR)
 
c  allocate only memory were going to use
c
c     memory needed:
c
c     Array        Size
c     -----        ----
c
c ShotHeaders  ntrc * LNTRHD*SZSMPD*2  (input shot trace headers)
c Pilot        nsamp * SZSMPD          (output stacked Pilot trace)
c Object       nsamp * SZSMPD          (output stacked Object trace)
c StructurePicks    2*npicks*SZSMPD    (structural picks)
c CDPlocation       2*npicks*SZSMPD    (structural pick index)
c                                       at max found in window)

      itemHeader = ntrc * ITRWRD * 2
      itemRec = ntrc * nsamp 
      itemTrace = nsamp 
 
      call galloc (wkadri, itemHeader * SZSMPD , errcdi, abort)
      call galloc (wkadr1, itemRec * SZSMPD, errcd1, abort)
      call galloc (wkadr2, itemTrace * SZSMPD, errcd2, abort)
      call galloc (wkadr3, itemTrace * SZSMPD, errcd3, abort)

      if ( errcdi .ne. 0 .or. 
     :     errcd1 .ne. 0 .or. 
     :     errcd2 .ne. 0 .or. 
     :     errcd3 .ne. 0 ) then

         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) itemHeader,'  bytes'
         write(LERR,*) itemRec,'  bytes'
         write(LERR,*) 2*itemTrace,'  bytes'
         write(LERR,*)' '
         write(LER,*)' '
         write(LER,*)'Unable to allocate workspace:'
         write(LER,*) itemHeader,'  bytes'
         write(LER,*) itemRec,'  bytes'
         write(LER,*) 2*itemTrace,'  bytes'
         write(LER,*)' '
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) itemHeader,'  bytes'
         write(LERR,*) itemRec,'  bytes'
         write(LERR,*) 2*itemTrace,'  bytes'
         write(LERR,*)' '
      endif

c initialize memory

      call vclr ( Record, 1, itemRec )
      call vclr ( Pilot, 1, itemTrace )
      call vclr ( Object, 1, itemTrace )
      
      do i = 1, itemHeader
         ShotHeaders(i) = 0
      enddo

c modify line header to reflect actual number of traces output

c note: there is 1 less record output since the first record is only
c       used as a pilot and the last as only an object

      nreco = ire - irs + 1
      ntrco   = ne - ns + 1
      call savew(itr, 'NumRec', nreco, LINHED)
      call savew(itr, 'NumTrc', ntrco  , LINHED)
 
c number output bytes

      obytes = SZTRHD + nsamp * SZSMPD
 
c move hlh into output line header 
 
      call savhlh ( itr, lbytes, lbyout )

c set agc window length in samples

      AgcWindow = AgcWindow / nsi

c write LineHeader to Pilot and Object datasets 

      call savew(itr,'NumRec',nreco-1,LINHED)
      call savew(itr,'NumTrc',1,LINHED)
      call savew(itr,'EqpCod',SortFlag,LINHED)
      call wrtape ( lupilot, itr, lbyout )
      call wrtape ( luobject, itr, lbyout )
 
c output of all pertinent information to printout file 
c before processing begins

      call verbal ( ntap, otap, ns, ne, irs, ire, pilottap, objecttap, 
     :     picktap, SortFlag, nsamp, nsi, ntrco, nreco, linear, verbos )
 
      if ( picktap .ne. ' ' ) then

c do this here so it happens only once to speed things up
c This stuff is required for the rshift() subroutine which
c does a phase shift in fft to allow floating point static application

         do i = 1, nsamp
            samps(i) = float(i)
         enddo

c allocate memory for pick file info

         call PickCount ( lupick, npicks, nsegs )

         itemPicks = 2 * npicks
         itemSegs = 4 * nsegs
         call galloc ( wkadr4, itemPicks * SZSMPD, errcd4, abort )
         call galloc ( wkadr5, itemPicks * SZSMPD, errcd5, abort )
         call galloc ( wkadr6, itemSegs * SZSMPD, errcd6, abort )

         if ( errcd4 .ne. 0 .or. 
     :        errcd5 .ne. 0 .or. 
     :        errcd6 .ne. 0 ) then
            write(LERR,*)' '
            write(LERR,*)'Unable to allocate workspace:'
            write(LERR,*) 2*itemPicks+itemSegs* SZSMPD,'  bytes'
            write(LERR,*)' '
            write(LER,*)' '
            write(LER,*)'Unable to allocate workspace:'
            write(LER,*) 2*itemPicks+itemSegs* SZSMPD,'  bytes'
            write(LER,*)' '
            go to 999
         else
            write(LERR,*)' '
            write(LERR,*)'Allocating workspace:'
            write(LERR,*) 2*itemPicks+itemSegs* SZSMPD,'  bytes'
            write(LERR,*)' '
         endif

c initialize memory

         call vclr( StructurePicks, 1, itemPicks )
         
         do i = 1, itemPicks
            CDPlocation(i) = 0
         enddo

         do i = 1, itemSegs
            PickIndex(i) = 0
         enddo

c read in structural correction control file 

         call ReadPicks ( lupick, StructurePicks, CDPlocation, 
     :        PickIndex, nsegs, npicks )
      endif

c skip down to first record to process

      call recskp( 1, irs-1, luin, ntrc, itr )

      DO JJ = irs, ire

c count is used to keep track of the number of records processed

         count = count + 1

c skip to start trace

         call trcskp ( JJ, 1, ns-1, luin, ntrc, itr )
      
c initialize array indices

         index = 1 - nsamp
         hindex = 1 - ITRWRD
         
         if ( picktap .ne. ' ' ) then
            datumCDP = 0
            MinOffset = 99999
         endif

c load record

         DO KK = 1, ntrco
            
            call rtape(luin,itr,lbytes)
            if(lbytes.eq.0)goto 991
            index = index + nsamp
            hindex = hindex + ITRWRD
            call vmov (itr(ITHWP1), 1, Record(index), 1, nsamp)
            call vmov(itr, 1, ShotHeaders(hindex), 1, ITRWRD)

            if ( picktap .ne. ' ' ) then

c determine the pilot record datum cdp if structural correction is being done
c this is the minimum offset cdp in the record

               call saver2(itr,ifmt_DstSgn,l_DstSgn,ln_DstSgn,DstSgn,
     :              TRACEHEADER)
               call saver2(itr,ifmt_DphInd,l_DphInd,ln_DphInd,DphInd,
     :              TRACEHEADER)
               call saver2(itr,ifmt_StaCor,l_StaCor,ln_StaCor,StaCor,
     :              TRACEHEADER)
               if( iabs(DstSgn) .lt. MinOffset .and. StaCor .ne. 30000 )
     :              then
                  MinOffset = iabs(DstSgn)
                  datumCDP = DphInd
               endif
            endif

         ENDDO
         
         IF ( count .eq. 1 ) then

c Pilot Trace
c -----------

            if ( picktap .ne. ' ' ) then

c Structural Correction
c ---------------------
c
c find  pilot datum for each structural event in xsd header value 
c at pick location file 

               PilotDatumCDP = datumCDP
               call GetDatum(PilotDatumCDP, PickIndex, 
     :              StructurePicks, CDPlocation, npicks, nsegs, 
     :              PilotDatum )

c do cdp based structural correction to pilot record.  The datums are in PilotDatum().
c The associated Horizon() times will be found for each trace and the trace 
c stretch/squeezed using the psdm algorithm to move the Horizons to the Datums.

               call Structure( ShotHeaders, Record, work, samps, linear, 
     :              nsamp, ntrco, nsi, nsegs, npicks, 
     :              Pilotdatum, PickIndex, StructurePicks, CDPlocation, 
     :              ifmt_DphInd, l_DphInd, ln_DphInd,
     :              ifmt_StaCor, l_StaCor, ln_StaCor ) 

            endif

c stack trace 1 of Pilot stack

            call Stack(Record, Pilot, nsamp, ntrco)

c agc 

            call agc( nsamp, AgcWindow, AgcAmplitude, Pilot, work )
            call vmul( Pilot, 1, work, 1, itr(ITHWP1), 1, nsamp )

c restore trace header

            call vmov( ShotHeaders(1), 1, itr, 1, ITRWRD )
            call savew2( itr, ifmt_StaCor, l_StaCor, ln_StaCor, 0, 
     :           TRACEHEADER )

c write trace 1 of Pilot stack to output dataset

            call wrtape( lupilot, itr, obytes )
                  
         ELSEIF ( count .eq. 2 ) then

c Object Trace
c ------------

c doing second record as Object which is also a special case as only have to
c do structural correction if required based on near offset cdp from record 1
c stack ,agc
            
            if ( picktap .ne. ' ' ) then
               
c Structural Correction
c ---------------------
c
c find NextPilotDatum() to use when this record is used to build trace 2 of the
c Pilot stack

               NextPilotDatumCDP = datumCDP
               call GetDatum ( NextPilotDatumCDP,PickIndex, 
     :              StructurePicks, CDPlocation, npicks, nsegs, 
     :              NextPilotDatum )

c do cdp based structural correction to Object record.  The datum is PilotDatum()
c derived from the first record and the stretch/squeeze to apply to each trace will be 
c determined from the structure pick for that cdp and the PilotDatum()
 
               call Structure( ShotHeaders, Record, work, samps, linear, 
     :              nsamp, ntrco, nsi, nsegs, npicks, 
     :              Pilotdatum, PickIndex, StructurePicks, CDPlocation, 
     :              ifmt_DphInd, l_DphInd, ln_DphInd,
     :              ifmt_StaCor, l_StaCor, ln_StaCor ) 
               
            endif

c stack Object trace one

            call Stack( Record, Object, nsamp, ntrco )

c agc Object trace one

            call agc( nsamp, AgcWindow, AgcAmplitude, Object, work )
            call vmul( Object, 1, work, 1, itr(ITHWP1), 1, nsamp )

c restore Object trace one header

            call vmov( ShotHeaders(1), 1, itr, 1, ITRWRD )
            call savew2( itr, ifmt_StaCor, l_StaCor, ln_StaCor, 0, 
     :           TRACEHEADER )


c save Object header for output as next Pilot trace header

            call vmov( ShotHeaders(1), 1, PilotHeader, 1, ITRWRD )

c write Object stack trace one

            call wrtape( luobject, itr, obytes )

         ELSE

c Pilot Trace
c -----------

            if ( picktap .ne. ' ' ) then

c Structural Correction
c ---------------------
c
c remove structure stretch/squeeze from object trace
c apply structure stretch/squeeze to be used as pilot
c to do this use the existing PilotDatum() as Horizon()
c and NextPilotDatum() as Datum() in SS_map and SS_apply

               call SS_map( nsi, nsamp, nsegs, NextPilotDatum, 
     :              PilotDatum, MapTrace ) 
               call SS_apply( Object, work, MapTrace, nsamp, samps, 
     :              linear )

c advance pilot datum and pilot datum cdp to current pilot requirements

               PilotDatumCDP  = NextPilotDatumCDP

               do i = 1, nsegs
                  PilotDatum(i) = NextPilotDatum(i)
               enddo

c agc Object trace one

            call agc( nsamp, AgcWindow, AgcAmplitude, Object, work )
            call vmul( Object, 1, work, 1, itr(ITHWP1), 1, nsamp )

            else
               call agc( nsamp, AgcWindow, AgcAmplitude, Object, work )
               call vmul( Object, 1, work, 1, itr(ITHWP1), 1, nsamp )
            endif

c load Pilot trace header 
            
            call vmov( PilotHeader, 1, itr, 1, ITRWRD)
            call savew2( itr, ifmt_StaCor, l_StaCor, ln_StaCor, 0, 
     :           TRACEHEADER )

c output Pilot trace

            call wrtape( lupilot, itr, obytes )

c Object Trace
c ------------

            if ( picktap .ne. ' ' ) then

c Structural Correction
c ---------------------
c
c apply structural correction, stack, agc

               NextPilotDatumCDP = datumCDP
               call GetDatum ( NextPilotDatumCDP, PickIndex, 
     :              StructurePicks, CDPlocation, npicks, nsegs, 
     :              NextPilotDatum )

c apply structural correction to currect record based on current PilotDatum

               call Structure( ShotHeaders, Record, work, samps, linear, 
     :              nsamp, ntrco, nsi, nsegs, npicks, 
     :              Pilotdatum, PickIndex, StructurePicks, CDPlocation, 
     :              ifmt_DphInd, l_DphInd, ln_DphInd,
     :              ifmt_StaCor, l_StaCor, ln_StaCor ) 

            endif

c stack object record

            call Stack(Record, Object, nsamp, ntrco)

c agc object trace

            call agc( nsamp, AgcWindow, AgcAmplitude, Object, work )
            call vmul( Object, 1, work, 1, itr(ITHWP1), 1, nsamp )

c build object trace header

            call vmov( ShotHeaders(1), 1, itr, 1, ITRWRD )
            call savew2( itr, ifmt_StaCor, l_StaCor, ln_StaCor, 0, 
     :           TRACEHEADER )

c save next pilot trace header 

            call vmov( ShotHeaders(1), 1, PilotHeader, 1, ITRWRD )

c output object stack trace

            call wrtape( luobject, itr, obytes )

         ENDIF
         
c  skip to end of record

         call trcskp ( JJ, ne + 1, ntrc, luin, ntrc, itr )

      ENDDO

c NORMAL TERMINATION

c close data files flush data left in output buffer
c NOTE: if the output buffer is not closed you can sometimes end up
c with missing data

      call lbclos(luin)
      call lbclos(lupilot)
      call lbclos(luobject)

c Termination Messages

      if ( picktap .ne. ' ' ) close(lupick)

      write(LERR,*)' '
      write(LERR,*)' '
      write(LERR,*)'processed',nreco,' record(s)',' with ',ntrco, 
     :     ' traces'
      write(LERR,*)'       Normal Termination'

      write(LER,*)'arcsstack: Normal Termination'

      stop

c ERROR MESSAGES


 990  continue

      write(LER,*)' ARCSSTACK: Cannot open structural pickfile ',picktap
      write(LER,*)'       Check existance/ spelling and try again.'
      write(LER,*)'  '
      write(LER,*)' FATAL'

      write(LERR,*)'ARCSSTACK: Cannot open structural pickfile ',picktap
      write(LERR,*)'       Check existance/spelling and try again.'
      write(LERR,*)'       try again.'
      write(LERR,*)'  '
      write(LERR,*)' FATAL'
      stop

 991  continue

      write(LERR,*)' '
      write(LERR,*)' ARCSSTACK: Premature EOF on input data.'
      write(LERR,*)'        Check command line parameters '
      write(LERR,*)'        and rerun.'
      write(LERR,*)' '
      write(LERR,*)' FATAL'
      write(LER,*)' '
      write(LER,*)' ARCSSTACK: Premature EOF on input data.'
      write(LER,*)'        Check command line parameters '
      write(LER,*)'        and rerun.'
      write(LER,*)' '
      write(LER,*)' FATAL'
      stop

c Abnormal Termination

 999  continue
 
c close data files flush data left in output buffer
c NOTE: if the output buffer is not closed you can sometimes end up
c with missing data

      call lbclos(luin)
      call lbclos(lupilot)
      call lbclos(luobject)

c Termination Messages

      if ( picktap .ne. ' ' ) close(lupick)

      write(LERR,*)' '
      write(LERR,*)' '
      write(LERR,*)'processed',nreco,' record(s)',' with ',ntrco, 
     :     ' traces'
      write(LERR,*)'       Abnormal Termination'

      write(LER,*)'arcsstack: Abnormal Termination'

      stop
      end
