C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine cmdln ( ntap, ns, ne, irs, ire, pilottap, objecttap, 
     :     picktap, SortFlag, linear, verbos )

c ntap : input dataset name
c ns,ne : start and end traces
c irs,ire : start and end records
c pilottap : pilot stack dataset name 
c objecttap : object stack dataset name
c picktap : pickfile dataset name [used if StructureFLag is set only]
c SortFlag : G = group input, S = shot [the default]
c verbos : verbosity flag
c linear: interpolation flag [default = cubic spline]
 
#include <f77/iounit.h>

      integer    ns, ne, irs, ire, argis

      character  ntap*(*), pilottap*(*), objecttap*(*)
      character  picktap*(*), SortFlag*(*), otap*100

      logical     verbos, linear

      linear =  (argis('-linear') .gt. 0)
 
      call argi4 ( '-ns', ns ,   0  ,  0    )
      call argi4 ( '-ne', ne ,   0  ,  0    )
      call argstr( '-N', ntap, ' ', ' ' )

      call argstr( '-O', otap, ' ', ' ' )

      call argstr( '-P', picktap, ' ', ' ' )

      call argi4 ( '-rs', irs ,   0  ,  0    )
      call argi4 ( '-re', ire ,   0  ,  0    )

      SortFlag = 'U'
      if ( argis('-shot') .gt. 0 ) SortFlag = 'S'
      if ( argis('-group') .gt. 0 ) SortFlag = 'G'
 
      verbos =   (argis('-V') .gt. 0)
  
c assign Pilot and Object Stack Filenames

      if ( SortFlag .eq. 'S' .and. otap .eq. ' ' ) then
         pilottap = 'ShotPilot'
         objecttap = 'ShotObject'
      elseif  ( SortFlag .eq. 'S' .and. otap .ne. ' ' ) then   
         leotap = lenth(otap)
         pilottap = otap(1:leotap)//'ShotPilot'
         objecttap = otap(1:leotap)//'ShotObject'
      elseif ( SortFlag .eq. 'G' .and. otap .eq. ' ' ) then
         pilottap = 'GroupPilot'
         objecttap = 'GroupObject'
      elseif  ( SortFlag .eq. 'G' .and. otap .ne. ' ' ) then   
         leotap = lenth(otap)
         pilottap = otap(1:leotap)//'GroupPilot'
         objecttap = otap(1:leotap)//'GroupObject'
      else
         write(LERR,*)' ARCSSTACK: You must have one of -shot'
         write(LERR,*)'            or -group on the command line'
         write(LERR,*)'            Correct and re-run.'
         write(LERR,*)' FATAL'

         write(LER,*)' ARCSSTACK: You must have one of -shot'
         write(LER,*)'            or -group on the command line'
         write(LER,*)'            Correct and re-run.'
         write(LER,*)' FATAL'
         stop
      endif

      return
      end
