C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine verbal ( ntap, otap, ns, ne, irs, ire, pilottap, 
     :     objecttap, picktap, SortFlag, nsamp, nsi, ntrco, nreco, 
     :     linear, verbos )

#include <f77/iounit.h>
 
      integer     nsamp, nsi, ntrco, nreco
      integer     length

      character   ntap*(*), otap*(*)
      character   pilottap*(*), objecttap*(*)
      character   picktap*(*), SortFlag*(*)

      logical     verbos, linear
 
            write(LERR,*)' '
            write(LERR,*)' line header values after default check '
            write(LERR,*) ' # of samples/trace      =  ', nsamp
            write(LERR,*) ' sample interval         =  ', nsi
            write(LERR,*) ' traces per record       =  ', ntrco
            write(LERR,*) ' records per line        =  ', nreco
            length = lenth(ntap)
	    if (length .gt. 0) then
              write(LERR,*) ' input data set name =  ', ntap(1:length)
	    else
              write(LERR,*) ' input data set      =  stdin'
	    endif
            if ( otap .ne. ' ' ) then
               length = lenth(otap)
               write(LERR,*) ' output prefix    =  ', otap(1:length)
            endif
            write(LERR,*)' '
            write(LERR,*)' command line entries used '
            write(LERR,*)' '
            write(LERR,*)' start trace               = ',ns
            write(LERR,*)' end trace                 = ',ne
            write(LERR,*)' start record              = ',irs
            write(LERR,*)' end record                = ',ire
            length = lenth(pilottap)
	    if (length .gt. 0)
     :         write(LERR,*)' Pilot Stack dataset name  = ',
     :           pilottap(1:length)
            length = lenth(objecttap)
	    if (length .gt. 0)
     :         write(LERR,*)' Object Stack dataset name = ',
     :           objecttap(1:length)

            if ( picktap .ne. ' ' ) then
               length = lenth(picktap)
               write(LERR,*)' Structural pickfile name  = ',
     :              picktap(1:length)
            endif

            if(SortFlag.eq.'G')
     :      write(LERR,*)' Input data in Receiver Sorted Order'
            if(SortFlag.eq.'S')
     :      write(LERR,*)' Input data in Shot Sorted Order'

            if(linear)then
               write(LERR,*)' Using Linear Interpolation'
            else
               write(LERR,*)' Using Cubic Spline Interpolation'
            endif

      return
      end
