C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C**********************************************************************C
C
C     PROGRAM MODULE  arms
C
C**********************************************************************C
C
C arms READS SEISMIC TRACE DATA FROM AN INPUT FILE,
C and record-by-record compute the average or rms trace
C and writes the output
C
C SUBROUTINE CALLS: RTAPE, HLH, WRTAPE, SAVE
C
C**********************************************************************C
C
C     DECLARE VARIABLES
C

#include <localsys.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

      INTEGER     itr(SZLNHD)
      INTEGER     LHED( SZLNHD )
      INTEGER     NSAMP, NSI, NTRC, NREC, IFORM
      INTEGER     LUIN, LUOUT,LBYTES,NBYTES,obytes
      integer     argis
      REAL        xtr( SZLNHD ), wtrce(SZLNHD)
      CHARACTER   NAME * 4, ntap * 256, otap * 256
#include <f77/pid.h>
      logical     verbos,query,ave
 
c     EQUIVALENCE ( ITR(129), xtr(1) )
      EQUIVALENCE ( ITR(  1), LHED(1) )
      DATA NAME     /'ARMS'/
      DATA LUIN / 1 /, LUOUT  / 2 /, LBYTES / 0 /, NBYTES / 0 /
      DATA  obytes / 0 /
      data verbos/.false./,ave/.true./

c---------------------------------
c  get online help if necessary
c---------------------------------
      query = (argis('-?').gt.0 .or. argis('-h').gt.0)
      if ( query ) then
           call help ()
           stop
      endif

c-------------------------------------
c  open printout file
c-------------------------------------
#include <f77/open.h>

C**********************************************************************C
C     READ PROGRAM PARAMETERS FROM COMMAND LINE
C**********************************************************************C
      call cmdln (ntap,otap,ist,iend,nstr,nend,nrst,nred,
     &               ave,verbos)

C**********************************************************************C
C     READ AND UPDATE LINE HEADER,
C     WRITE LINE HEADER, SAVE KEY PARAMETERS.
C**********************************************************************C
      call getln ( luin, ntap, 'r', 0 )
      call getln (luout, otap, 'w', 1 )

      lbytes=0
      CALL RTAPE4 ( LUIN, ITR, LBYTE, LBYTES           )
      if(lbytes .eq. 0) then
         write(LERR,*)'ARMS: no header read on unit ',ntap
         write(LERR,*)'FATAL'
         write(LERR,*)'Check existence of file & rerun'
         stop
      endif
      CALL HLHprt    ( ITR, LBYTE, NAME, 4,         LERR)

c-------------------------------
c  save key header values
#include <f77/saveh.h>
      if(nsamp .gt. SZLNHD) nsamp=SZLNHD

c-------------------------
c  verbos printout
      if( verbos ) then
         write(LERR,*)
         write(LERR,*)' Values read from input data set line header'
         write(LERR,*)
         write(LERR,*) ' # of Samples/Trace =  ', nsamp
         write(LERR,*) ' Sample Interval    =  ', nsi  
         write(LERR,*) ' Traces per Record  =  ', ntrc 
         write(LERR,*) ' Records per Line   =  ', nrec 
         write(LERR,*) ' Format of Data     =  ', iform
      endif

C**********************************************************************C
C     CHECK CARD DEFAULTS AND SET PARAMETERS
C**********************************************************************C
      iend=iend/nsi + .5
      ist=ist/nsi
      if(ist .le. 1) ist=1
      if(iend .eq. 0) iend=nsamp
      if(iend .gt. nsamp) iend=nsamp
      nsampo=iend-ist+1
      call cmdchk (nstr,nend,nrst,nred,ntrc,nrec)
      jtrc=nend-nstr+1
      nrecc=nred-nrst+1

c-------------------------------------------------------
c  update line header & write out header
       call savew( itr, 'NumTrc',  1   , LINHED)
       call savew( itr, 'NumRec', nrecc, LINHED)
       call savew( itr, 'NumSmp', nsampo, LINHED)
      obytes = SZTRHD + SZSMPD * nsampo
      call savhlh ( itr, lbyte, lbyout )
      CALL WRTAPE ( LUOUT, ITR, LBYOUT                 )

c----------------------------------------
c  verbos printout
      if( verbos ) then
         write(LERR,*)
         write(LERR,*)' Line header values after default check '
         write(LERR,*)
         write(LERR,*) ' # of Samples/Trace =  ', nsampo
         write(LERR,*) ' Sample Interval    =  ', nsi  
         write(LERR,*) ' Traces per Record  =  ', jtrc 
         write(LERR,*) ' Records per Line   =  ', nrecc
         write(LERR,*) ' Format of Data     =  ', iform
      endif

c----------------------------------
c  skip to start record
      call recskp(1,nrst-1,luin,ntrc,itr)

C**********************************************************************C
C
C     READ TRACE, COMPUTE AVERAGE/RMS FOR EACH RECORD, 
C     WRITE OUT RESULTS
C
C**********************************************************************C

      xc = nend - nstr + 1

      DO 100 JJ = NRST, NRED

c--------------------------------------
c  skip to start trace of this record
            call trcskp(jj,1,nstr-1,luin,ntrc,itr)
c--------------------------------------

c-------------------------------
c  null out average trace
           call vclr (wtrce,1,nsampo)
c-------------------------------

           DO 99 KK = NSTR, NEND

c-----------------
c  read data
                nbytes = 0
                CALL RTAPE  ( LUIN , ITR, NBYTES         )
                if(nbytes .eq. 0) then
                   write(LERR,*)'End of file on input:'
                   write(LERR,*)'  rec= ',jj,'  trace= ',kk
                   go to 999
                endif
                call vmov (itr(ITHWP1), 1, xtr, 1, nsamp)
c-----------------

c---------------------------------
c  move data do average
                if(ave) then
                   do 56 ii=1,nsamp
                         wtrce(ii)=wtrce(ii) + xtr(ii)
   56              continue
                else
                   do 57 ii=1,nsamp
                         wtrce(ii)=wtrce(ii) + xtr(ii)**2
   57              continue
                endif
c---------------------------------

   99      CONTINUE

c--------------------------------
c  normalize average/rms trace
           if(ave) then
                  call vsdiv (wtrce,1,xc,xtr,1,nsampo)
           else
                  call vsdiv (wtrce,1,xc,xtr,1,nsampo)
                  call vsqrt (xtr,1,xtr,1,nsampo)
           endif
c--------------------------------

c------------------------------------------
c  skip to end of current record
            call trcskp(jj,nend+1,ntrc,luin,ntrc,itr)
c------------------------------------------

c---------------
c  write data
      call vmov (xtr, 1, itr(ITHWP1), 1, nsamp)
      call wrtape(luout,itr,obytes)
c---------------

  100 CONTINUE

  999 continue
         call lbclos(luin)
         call lbclos(luout)
      END

c-------------------------------------------
c  online help section
c-------------------------------------------
      subroutine  help
#include <f77/iounit.h>

        write(LER,*)' '
        write(LER,*)'Command Line Arguments for ARMS: data average/rms'
        write(LER,*)' '
        write(LER,*)'Input....................................... (def)'
        write(LER,*)' '
        write(LER,*)'-N[ntap]   -- input data set'
        write(LER,*)'-O[otap]   -- output data set'
        write(LER,*)'-ns[nstr]  -- start trace number           (first)'
        write(LER,*)'-ne[netr]  -- end trace number              (last)'
        write(LER,*)'-rs[nrst]  -- start record             (first rec)'
        write(LER,*)'-re[nred]  -- end record                (last rec)'
        write(LER,*)'-A         -- do average (else do rms)'
        write(LER,*)'-V         -- verbos printout'
        write(LER,*)' '
        write(LER,*)'Usage:'
        write(LER,*)'        arms -N[] -O[] -ns[] -ne[] -rs[] -re[]'
        write(LER,*)'              -A -V'
        write(LER,*)' '

      return
      end

c-----
c     get command arguments
c
c     ntap  - C*100  input file name
c     otap  - C*100  output file name
c     ist   - I      start sample
c    iend   - I      stop sample
c    nstr   - I      start trace
c    nend   - I      stop end trace
c    nrst   - I      start record
c    nred   - I      stop end record
c    verbos - L      verbose output or not
c-----
      subroutine cmdln (ntap,otap,ist,iend,nstr,nend,nrst,nred,
     &               ave,verbos)
#include <f77/iounit.h>
      character   ntap*(*), otap*(*)
      integer     argis,ist,iend,nstr,nend,nrst,nred
      logical     ave,verbos

          call argstr('-N',ntap,' ',' ')
          call argstr('-O',otap,' ',' ')
          call argi4('-s',ist,1,1) 
          call argi4('-e',iend,0,0) 
          call argi4('-ns',nstr,0,0)
          call argi4('-ne',nend,0,0)
          call argi4('-rs',nrst,1,1)
          call argi4('-re',nred,0,0)
          ave = ( argis( '-A' ) .gt. 0 )
          verbos = ( argis( '-V' ) .gt. 0 )

      return
      end
