C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine Linterp ( tri, nsamp, xtr, nsampo, tabl1, tabl2)

c linear interpolation done between first non - zero and last non -zero
c entry in tri[].  The time or depth value for each input sample is in 
c tabl1[] while the time or depth value for each output sample is in tabl2[].

c declare variables passed from calling routine

      integer nsamp, nsampo

      real tri( nsamp ), xtr( nsampo )
      real tabl1( nsamp ), tabl2 ( nsampo )

c declare local variables

      integer i, j, pointer

      real slope

      pointer = 2

      DO 10 i = 1, nsampo

         if ( ( tabl2(i) - tabl1(1) ) .lt. 1.e-4 ) then

c tabl2[i] < tabl1[1]  -- looking for amplitude value outside range of
c                         input trace which we will not allow [for now]
            xtr(i) = 0.0

         elseif ( ( tabl2(i) - tabl1(nsamp) ) .gt. 1.e-4 ) then

            xtr(i) = 0.0

         else

            DO j = pointer, nsamp
               
               if ( ( tabl2(i) - tabl1(j-1) ) .ge. 1.e-4
     :              .and. ( tabl2(i) - tabl1(j) ) .le. 1.e-4 ) then

                  slope = (tabl2(i) - tabl1(j-1)) / 
     :                 (tabl1(j) - tabl1(j-1))
                  xtr(i) = tri(j-1) + slope * (tri(j) - tri(j-1))
                  pointer = j
                  goto 10
               endif

            ENDDO

         endif

 10   CONTINUE

         izero = nsampo
         do  i = 1, nsampo
             if ( xtr(i) .ne. 0.0 ) then
                izero = i
                go to 11
             endif
         enddo
11       continue
         if (izero .lt. nsampo) then
             do  i = 1, izero-1
                 xtr(i) = xtr (izero)
             enddo
         endif

      return
      end

         
