C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c**********************************************************************c
c asig1d reads in 3D data set and outputs the envelope, phase and
c frequency values for every trace.
c**********************************************************************c
c______________________________________________________________________
c          Kelly D. Crawford (Amoco E&PT, Tulsa, OK, USA).  99% of this
c          program was shamelessly (but with permission) copied from
c          Kurt J. Marfurt (Amoco E&PT, Tulsa, OK, USA) on May 4, 1995.
c______________________________________________________________________
c 
c This is the list of operations:
c
c          icflg - attribute calculations
c          ------------------------------
c          0 absolute value
c          1 signed value
c          2 quadrature
c          3 envelope
c          4 inst. phase (-IP)
c          5 resp. phase (-RP)
c          6 inst. freq (-IF)
c          7 resp. freq (-RF)
c          8 0-phase decomp (-P0)
c          9 90-phase decomp (-P90)
c          10 resp. amp
c          11 resp. length (-RL)
c          12 env. skewness (-S)
c          13 env. risetime (-RT)
c          14 inst. bandwidth (-IBW)
c          15 inst. envelope (-IE)
c          16 resp. envelope (-RE)
c          17 resp. bandwidth (-RBW)
c          18 carrier (-C)
c
c     declare variables
c
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

      integer ifmt_StaCor,l_StaCor,ln_StaCor

      integer rs, re, ns, ne, ss, se
      logical horizons
      character*(8) uh, lh

c______________________________________________________________________
c     parameters needed for dynamic memory allocation routine 'galloc'.
c______________________________________________________________________
      parameter (maxs=0 000 002)
      dimension s(maxs)
      pointer   (pntrs,s)
c______________________________________________________________________
      parameter   (pi=3.1415926,twopi=2.*pi)
      integer     hbegin
      integer     sheader(SZLNHD)
      integer     ipwr(4)
      real        cputim(20),waltim(20)
#include <f77/pid.h>
#include <save_defs.h>
      parameter (i2fact=8/szsmpd,lenhed=lntrhd/i2fact,hbegin=1-lenhed)
c
      character*(120) file_in,file_out
      character*(6)   name

c Grab the declarations for the process identifiers
#include "initproc.h"

c     pipelen should be big enough to handle all of the settings in
c     the initproc subroutine.
      integer        pipelen
      parameter     (pipelen = 20)

      integer        pipe(pipelen), lunit(pipelen)
      logical        wrout(pipelen), calc(pipelen), available(pipelen)
      character*(4)  keyword(pipelen)
      character*(40) description(pipelen)

      logical        verbose,query,depth_section,eof,wrint,IKP
      logical        live

      character*(2)  int2str
      character*(6)  hdkey

      integer        argis
      integer        stdin,stdout,stderr
      character*(9)  host,blank9
      data           name/'ASIG1D'/
      data           host/'         '/
      data           blank9/'         '/
      data           luang/88/

c_______________________________________________________________
c     check to see if we are running under IKP.
c_______________________________________________________________
      call ikpchk(host)
      if(host .ne. blank9) then
         IKP=.true.
         write(LER,*)'asig1d running inside XIKP'
c        Set up pipes from 3..pipelen+2
c        Note that pipes may run into conflicts with
c        /home/gp17/usp/include/f77/iounit.h
         do 1 i=1,pipelen
            pipe(i) = i+2
 1       continue
      else
         IKP=.false.
      endif
c_______________________________________________________________
c     initialize timing arrays.
c_______________________________________________________________
      call vclr(cputim,1,20)
      call vclr(waltim,1,20)
      call timstr(vtot,wtot)
      call timstr(v1,w1)
      stdin=LIN
      stdout=LOT
      stderr=LER
c_______________________________________________________________
c     Help?
c_______________________________________________________________
      query=((argis('-?') .gt. 0) .or. (argis('-h') .gt. 0)
     1  .or. (argis('-help') .gt. 0))
      if (query) then
         call help(ler)
         call exitfu(0)
      endif

c_______________________________________________________________
c     Does user just want a list of what is available?
c_______________________________________________________________
      query=((argis('-a') .gt. 0) .or. (argis('-avail') .gt. 0)
     1  .or. (argis('-available') .gt. 0))
      if (query) then
c        Call initproc to set up the arrays.
         call initproc(pipelen, available, keyword, description)
c        Check each option.
         write(ler,*) 'The following options are available:'
         do 6 i = 1, pipelen
            if (available(i)) then
              write(ler,*) '    ', keyword(i), ':', description(i)
            endif
 6       continue
         call exitfu(0)
      endif

c_______________________________________________________________
c     open printout files
c_______________________________________________________________
#include <f77/open.h>
c_______________________________________________________________
c     get i/o data set names
c_______________________________________________________________
      call argstr('-N',file_in, ' ', ' ')
      call argstr('-O',file_out,' ', ' ')
      power=1.
      ierror=0
c_______________________________________________________________
c     open logical unit numbers for input and output
c_______________________________________________________________
      call getln(luin,file_in,'r',0)
      call getln(luout, file_out,'w', 1)
c_______________________________________________________________
c     read line header of input file.
c_______________________________________________________________
      lbytes=0
      call rtape(luin,sheader,lbytes)
      if(lbytes .eq. 0) then
         write(lerr,*)'ASIG1D: no header read from unit ',luin
         write(ler,*)'ASIG1D: no header read from unit ',luin
         call exitfu(4666)
      endif

c_______________________________________________________________
c     Note that we may want to substitute the encoded headers
c     found in windstat rather than this method.
c_______________________________________________________________
c     Does the user want me to decode an asig1d-generated file
c     to see what order the reductions were done in?
c_______________________________________________________________
      if (argis('-decode') .gt. 0) then
c        Call initproc to set up the arrays.
         call initproc(pipelen, available, keyword, description)
 
c        Note: only 16 of these defined so far...may need to encode...
         do 8 i = 1, min(pipelen,16)
c           Grab the i'th (MCLEii) header word
            hdkey='MCLE'//int2str(i,'0')
            call saver(sheader,hdkey,j,LINEHEADER)
 
            if (j .gt. 0) then
               write(ler,7)'Number ',i,' : ',description(j)
 7             format(1x,a7,i3,a3,a)
            endif
 8       continue
         call exitfu(0)
      endif

C_______________________________________________________________________
c     pull relevant values from line header.
C_______________________________________________________________________
      call saver(sheader,'NumSmp',nsamp_in,LINEHEADER)
      call saver(sheader,'SmpInt',nsi,LINEHEADER)
      call saver(sheader,'NumRec',nrec_in,LINEHEADER)
      call saver(sheader,'NumTrc',ntr_in,LINEHEADER)
      call saver(sheader,'TmMsFS',tstart_orig,LINEHEADER)
      call saver(sheader,'TmMsSl',jtstart_orig,LINEHEADER)
      call saver(sheader,'TmSlIn',jtslice_orig,LINEHEADER)
C_______________________________________________________________________
c     Historical line header stuff
C_______________________________________________________________________
      call savhlh(sheader,lbytes,lbyout)

c_______________________________________________________________
c     check keywords for each explicit attribute
c     if they are detected, open a file or add to the data stream.
c_______________________________________________________________
      nstream=0
      nfile=0

c_______________________________________________________________
c     Initialize the process details.
c_______________________________________________________________
      call initproc(pipelen, available, keyword, description)

c_______________________________________________________________
c     Initialize the smart rtape.
c_______________________________________________________________
      call argi4('-rs', rs, 1, 1)
      call argi4('-re', re, nrec_in, nrec_in)
      call argi4('-ns', ns, 1, 1)
      call argi4('-ne', ne, ntr_in, ntr_in)
      call init_srtape(luin, ntr_in, lerr, rs, re, ns, ne)

c_______________________________________________________________
c     Grab the start and end sample, or the trace header words
c     that store the upper and lower horizon values
c_______________________________________________________________
      call argstr('-uh', uh, '*NONE*', '*NONE*')
      call argstr('-lh', lh, '*NONE*', '*NONE*')
      if (uh .eq. '*NONE*' .and. lh .eq. '*NONE*') then
         horizons = .FALSE.
      else
         horizons = .TRUE.
      endif

      call argi4('-s', ss, -1, -1)
      call argi4('-e', se, -1, -1)
      if (ss .le. 0) then
         ss = 0
      else
         ss = int(0.5 + real(ss - tstart_orig)/real(nsi))
         if (ss .le. 0) ss = 0
      endif
      if (se .le. 0) then
         se = nsamp_in - 1
      else
         se = int(0.5 + real(se - tstart_orig)/real(nsi))
         if (se .gt. (nsamp_in-1)) se = nsamp_in - 1
      endif

c_______________________________________________________________________
c     Add any start/end record/trace info
c_______________________________________________________________________
      nrec_out  = re - rs + 1
      ntr_out   = ne - ns + 1
      call savew(sheader,'NumRec',nrec_out,LINEHEADER)
      call savew(sheader,'NumTrc',ntr_out,LINEHEADER)

c_______________________________________________________________
c        Open the file or pipe
c_______________________________________________________________
      do 5 i = 1, pipelen
         call chkfile(i,description(i),keyword(i),
     1                calc(i),wrout(i),lunit(i),
     2                nstream,nfile,luout,lerr,sheader,
     3                IKP,pipelen,pipe(i),nsamp_in,
     4                nrec_out,nrec_aug,lbyout)
         if ( calc(i) ) then
	  if ( available(i) ) then
	    if (wrout(i))
     1        call wrtape(lunit(i),sheader,lbyout)
          else
            write(ler,'(a,a12,a,a30,a)') 'Option ',keyword(i),' (',
     1       description(i),') is not yet implemented...'
            write(lerr,'(a,a12,a,a30,a)') 'Option ',keyword(i),' (',
     1       description(i),') is not yet implemented...'
            calc(i) = .FALSE.
	  endif
	 endif
 5    continue

      if(nstream .gt. 0) then
c_______________________________________________________________
c        Output line header for multicomponent file.
c_______________________________________________________________
         call savew(sheader,'NumCmp',nstream,LINEHEADER)
         call savew(sheader,'NumRec',nrec_aug,LINEHEADER)
         call wrtape(luout,sheader,lbyout)
      elseif(nfile .eq. 0.) then             
         write(lerr,*) 'command line error!'
         write(lerr,*) 'must specify one or more of attributes' 
     1                     //' on command line'
         write(ler,*) 'command line error!'
         write(ler,*) 'must specify one or more of attributes' 
     1                     //' on command line'
         call exitfu(3666)
      endif
      call argr4('-dz',dz,0.,0.)            
      wrint=(argis('-int') .gt. 0)
      if (wrint) then
         write(lerr,*) '-int currently not available...'
      endif
      verbose=(argis('-V') .gt. 0)
      if(dz .lt. 0.) then
         write(lerr,*) 'error! ',
     1                 ' non-negative dz must be entered '
     2                 //'after -dz on command line!'
         write(lerr,*) 'dz = ',dz
         write(ler,*) 'error! ',
     1                 ' non-negative dz must be entered '
     2                 //'after -dz on command line!'
         write(ler,*) 'dz = ',dz
         ierror=ierror+1
      endif
      if(dz .gt. 0.) then
         depth_section=.true.
         if(fref .eq. 0.) fref=30.
      else
         depth_section=.false.
         if(fref .eq. 0.) fref=60.
      endif
      if(nsi .gt. 16) then
         dtmsec=.001*nsi
      else
         dtmsec=nsi
      endif
      if(depth_section) then
         dtmsec=dz
         dt=.001*dz
         dsamp=dz
      else
         dsamp=dtmsec
      endif
      ierror=0
      dt=.001*dtmsec
      nsamp_out=nsamp_in          

      nbytes_out=(nsamp_out+lenhed)*szsmpd
      nbytes_out_r=(1+lenhed)*szsmpd
      nt=nsamp_in-1  
c______________________________________________________________________
c     calculate length of mixed radix fft that fits lenwnd best.
c     limit to radices 2,3 and 5 to allow use both cray scilib
c     and qtc routines.
c______________________________________________________________________
      call nrfft(nt+1,5,nfft,ipwr)

      lentr2=lntrhd+(nt+1)*i2fact
c
      call hlhprt (sheader,lbytes,name,len(name),lerr)
c
      write(lerr,*)
      write(lerr,'(a,t40,i5,t50,a)') 'input seismic file name',
     1                         luin,file_in
      write(lerr,'(a,t40,i5,t50,a)') 'output multi-attribute file name',
     1                         luout,file_out
      write(lerr,'(a,t40,i5)') 'number of input records',nrec_in 
      write(lerr,'(a,t40,i5)') 'number of input traces',ntr_in  
      write(lerr,'(a,t40,i5)') 'number of input samples',nsamp_in
      write(lerr,'(a,t40,f12.6)') 'input data sample interval (msec)', 
     1                         dtmsec
      write(lerr,'(a,t40,f12.6)') 'sample interval (sec)', dt
      write(lerr,'(a,t40,i5)') 'number of output records',nrec_out
      write(lerr,'(a,t40,i5)') 'number of output traces',ntr_out
      write(lerr,'(a,t40,i5)') 'number of output samples',nsamp_out
      write(lerr,'(a,t40,i5)') 'nt',nt,'nfft',nfft
      write(lerr,'(a,t40,i5)') 'lentr2',lentr2,'nbytes_out',nbytes_out
c
      write(lerr,'(a,t40,l5)') 'scale output between (-128:+127)?',
     1                           wrint
      write(lerr,'(a,t40,l5)') 'verbose output?',verbose     
      write(lerr,*)' '
c______________________________________________________________________
c     calculate buffer requirements for nested mixed radix ffts.
c     cray scilib routine rfftmlt runs twice as fast as mathadvantage
c     routine rnfftm.
c
c     buffer   mathadvantage rnfftm        cray scilib rfftmlt
c
c     itab      nfft+34                      2*nfft
c     rtab      3(nfft/2)+13                 2*nfft
c     work      18*ntrace                    4*nfft*ntrace
c______________________________________________________________________
      if(szsmpd .eq. 4) then
         lenitab=nfft+34
         lenrtab=3*(nfft/2)+13
         lenwork=18
      else
         lenitab=max(2*nfft,nfft+34)
         lenrtab=max(2*nfft,3*(nfft/2)+13)
         lenwork=max(4*(1+1)*nfft,18)
      endif
c______________________________________________________________________
c     calculate memory requirements
c______________________________________________________________________
      write(lerr,'(///,80a1)') ('_',i=1,80)
      write(lerr,'(A)')'storage map of major arrays'
      write(lerr,'(80a1)') ('_',i=1,80)
C
      l_free=1
      lenattr=(nt+1)*ntr_out
c____________________________________________________________________
      write(lerr,'(a20,3a10)')'variable name','begin','end','length'
      call mapmem('uin',l_uin,l_free,nfft,lerr)
      call mapmem('uquad',l_uquad,l_free,nfft,lerr)
      call mapmem('env',l_ienv,l_free,nt+1,lerr)
      call mapmem('peak',l_peak,l_free,nt+1,lerr)
      call mapmem('slope',l_slope,l_free,nt,lerr)
      call mapmem('tracebuf',l_tracebuf,l_free,(nt+1+lenhed),lerr)
c
      call mapmem('ienv',l_ienv,l_free,lenattr,lerr)
      call mapmem('iphase',l_iphase,l_free,lenattr,lerr)
      call mapmem('ifreq',l_ifreq,l_free,lenattr,lerr)
      call mapmem('ibw',l_ibw,l_free,lenattr,lerr)
      call mapmem('renv',l_renv,l_free,lenattr,lerr)
      call mapmem('rphase',l_rphase,l_free,lenattr,lerr)
      call mapmem('rfreq',l_rfreq,l_free,lenattr,lerr)
      call mapmem('rbw',l_rbw,l_free,lenattr,lerr)
      call mapmem('rlength',l_rlength,l_free,lenattr,lerr)
      call mapmem('rt',l_rt,l_free,lenattr,lerr)
      call mapmem('car',l_car,l_free,lenattr,lerr)
      call mapmem('skew',l_skew,l_free,lenattr,lerr)
      call mapmem('p0',l_p0,l_free,lenattr,lerr)
      call mapmem('p90',l_p90,l_free,lenattr,lerr)
c
      call mapmem('rtabf',l_rtabf,l_free,lenrtab,lerr)
      call mapmem('itabf',l_itabf,l_free,lenitab,lerr)
      call mapmem('rtabi',l_rtabi,l_free,lenrtab,lerr)
      call mapmem('itabi',l_itabi,l_free,lenitab,lerr)
      call mapmem('work',l_work,l_free,lenwork,lerr)
c___________________________________________________________________
C     allocate dynamic memory.
C_______________________________________________________________________
      lens=l_free-1
      write(ler,'(//,a)') 'allocate dynamic memory for ASIG1D: '
      write(ler,*) 1.e-6*lens,' Mwords'
      write(ler,*) 1.e-6*lens*szsmpd,' Mbytes'
      write(lerr,'(a20,10x,i10)') 'total vector length',lens
      call galloc(pntrs,lens*szsmpd,ierrcd,0)
      if(ierrcd .ne. 0 ) then
         write(lerr,*)'galloc memory allocation error from main'
         write(lerr,*)'ierrcd = ',ierrcd
         write(lerr,*)
         write(lerr,*)'probable cause: too much memory requested!'
         write(lerr,*)'go check your seismic headers and command'//
     1                ' line arguments!'
         write(lerr,*)'memory can be decreased by using the -M option'
         write(lerr,*)
         write(lerr,*)'program ASIG1D aborted'
c
         write(ler,*)'galloc memory allocation error from main'
         write(ler,*)'ierrcd = ',ierrcd
         write(ler,*)
         write(ler,*)'probable cause: too much memory requested!'
         write(ler,*)'go check your seismic headers and command'//
     1                ' line arguments!'
         write(ler,*)'memory can be decreased by using the -M option'
         write(ler,*)
         write(ler,*)'program ASIG1D aborted'
         call exit(101)
      endif
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
c_______________________________________________________________________
c     set fft initialization flag.
c_______________________________________________________________________
      initfftf=1
c_______________________________________________________________________
c     loop over all traces.
c_______________________________________________________________________
      ntraces = (re - rs + 1) * (ne - ns + 1)

      do 80000 jrec=1,ntraces
c_______________________________________________________________________
c      read angle stacks and pointer to angle having maximum semblance.
c_______________________________________________________________________
         call rdtrace(s(l_tracebuf),s(l_uin),s(l_uquad),
     1                live,luin,
     2                l_StaCor,ifmt_StaCor,ln_StaCor,
     3                eof,lenhed,nt,nfft,lerr,
     4                s(l_rtabf),s(l_itabf),s(l_rtabi),
     5                s(l_itabi),s(l_work),
     6                lenrtab,lenitab,lenwork,initfftf,
     7                cputim,waltim)

c_______________________________________________________________________
c      calculate attributes.
c_______________________________________________________________________
         call process(s(l_uin),s(l_uquad),s(l_ienv),
     1                s(l_peak),s(l_slope),tstart_orig,nsi,
     2                s(l_tracebuf),nbytes_out,nbytes_out_r,
     3                lenhed,nt,nfft,dt,live,
     4                ss,se,horizons,uh,lh,
     5                pipelen,calc,lunit,
     6                s(l_ienv),s(l_iphase),s(l_ifreq),s(l_ibw),
     7                s(l_renv),s(l_rphase),s(l_rfreq),s(l_rbw),
     8                s(l_rlength),s(l_car),s(l_rt),s(l_skew),
     9                s(l_p0),s(l_p90),nsamp_in,
     a                lerr,cputim,waltim)
80000 continue
c_____________________________________________________________
c     close out those attribute files that were opened.
c_____________________________________________________________
      do 999 i = 1, pipelen
         if (wrout(i)) call lbclos(lunit(i))
 999  continue
      if (nstream .gt. 0 .and. luout .ne. stdout) call lbclos(luout)
      call lbclos(luin)
c_____________________________________________________________
c     write out timing statistics.
c_____________________________________________________________
      call timend(cputim(20),vtot,v2,waltim(20),wtot,w2)
      write(lerr,'(A30,2A15,/)') 'routine','cpu time','wall time'
      write(lerr,'(A30,2f15.3)')
     1         'read input',cputim(1),waltim(1),
     2         'calculate quadrature',cputim(2),waltim(2),
     2         'write output',cputim(10),waltim(10),
     7         'total',cputim(20),waltim(20)

      write(ler,*)'normal completetion. routine ASIG1D'           
      write(lerr,*)'normal completetion. routine ASIG1D'           
      close(lerr)
      call exitfu(0)
      call exitfu(666)
c
      end
      subroutine help(ler)

      write(ler,*)
     1'**************************************************************'
      write(ler,*)'3D seismic attributes using a freqlance algorithm'
      write(ler,*)
     1'**************************************************************'
      write(ler,*)'execute asig1d by typing asig1d and list of'
     1                   //' program parameters.'

      write(ler,*)'Not all options are available.  To check the list'
      write(ler,*)'of available options, use option -a'

      write(ler,*)
     1'note that each parameter is proceeded by -x where "x" is '
      write(ler,*)
     1'a character(s) correlation to some parameter.'
      write(ler,*)
     1'users enter the following parameters, or use the default values'
      write(ler,*)' '
      write(ler,*)
     1' -N [file_in]  (stdin)      : input seismic file name'          
      write(ler,*)
     1' -O [file_out]  (stdout)    : output multi-attribute file name'        
      write(ler,*)
     1'       -rs [start_record]   : starting record number'
      write(ler,*)
     1'       -re [end_record]     : ending record number'
      write(ler,*)
     1'       -ns [start_trace]    : starting trace number'
      write(ler,*)
     1'       -ne [end_trace]      : ending trace number'
      write(ler,*)
     1'       -dz [dz]             : depth interval'

        write(ler,*) 'Attributes:'
        write(ler,*)
     1' -IE [file_ienv] (optional): output instantaneous envelope '
     2                           //'file name'             
        write(ler,*)
     1' -IP [file_iphase] (optional): output instantaneous phase '
     2                           //'file name'             
        write(ler,*)
     1' -IF [file_ifreq] (optional): output instantaneous frequency '
     2                           //'file name'             
        write(ler,*)
     1' -IBW [file_ibw] (optional): output instantaneous bandwidth '
     2                           //'file name'             
        write(ler,*)
     1' -RE [file_ienv] (optional): output instantaneous envelope '
     2                           //'file name'
        write(ler,*)
     1' -RP [file_iphase] (optional): output instantaneous phase '
     2                           //'file name'
        write(ler,*)
     1' -RF [file_ifreq] (optional): output instantaneous frequency '
     2                           //'file name'
        write(ler,*)
     1' -RBW [file_ibw] (optional): output instantaneous bandwidth '
     2                           //'file name'
        write(ler,*)
     1' -RL [file_rl] (optional): output response length '             
     2                           //'file name'
        write(ler,*)
     1' -S [file_skew] (optional): output skewness '                    
     2                           //'file name'
        write(ler,*)
     1' -C [file_carrier] (optional): output carrier '                    
     2                           //'file name'
        write(ler,*)
     1' -RT [file_rl] (optional): output rise time '                   
     2                           //'file name'
        write(ler,*)
     1' -P0 [file_rl] (optional): output 0 deg phase component '           
     2                           //'file name'
        write(ler,*)
     1' -P90 [file_rl] (optional): output 90 deg phase '           
     2                           //'component file name'

        write(ler,*) 
     1'   if -IE, -IP, -IF -IBW -RE -RP -RF -RBW'
     2   //' -RL -S -C -RT -P0 -P90 '
        write(ler,*) 
     1'   are entered without explicit files they'
     2   //' will be out output back-to-back'
        write(ler,*)
     1'   in file=file_out'
        write(ler,*)
        write(ler,*)
     1' -V                    : if present, verbose printout'
       write(ler,*)' '
       write(ler,*)'usage:'
       write(ler,*)
       write(ler,*)'asig1d -N[file_in] -O[file_out]'
       write(ler,*)'       -rs[start_record] -re[end_record]'
       write(ler,*)'       -ns[start_trace] -ne[end_trace]'
       write(ler,*)'       -dz[dz] [-V]'
       write(ler,*)'    Attributes:'
       write(ler,*)'       -IE[file_ienv] -IP[file_iphase]'
       write(ler,*)'       -IF[file_ifreq] -IBW[file_ibw]'
       write(ler,*)'       -RE[file_renv] -RP[file_rphase]'
       write(ler,*)'       -RF[file_rfreq] -RBW[file_rbw]'
       write(ler,*)'       -RL[file_rlength] -S[file_skewness]'
       write(ler,*)'       -C[file_carrier] -RT[file_risetime]'
       write(ler,*)'       -P0[file_phase0] -P90[file_phase90]'
       write(ler,*)'       -TPT[file_time_pt] -APT[file_amp_pt]'
       write(ler,*)' '
       write(ler,*)

      return
      end
