C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE ALEN(A,NPT)
C
C  JH BODINE 9/2/81
C
C  ROUTINE TO SET ANALYTIC SIGNAL ENVELOPE LOBES TO VALUE OF
C  THE TIME WIDTH OF THE ENVELOPE LOBES.
C  THE VALUE OF THE ENVELOPE IS SET FROM TROUGH
C  TO TROUGH. THE RESULTING "ENVELOPE" MAY BE CONSIDERED TO
C  REPRESENT A MODIFICATION OF
C     A = COMPLEX ENVELOPE
C   NPT = NUMBER OF SAMPLE POINTS
C
C  PROGRAM ASSUMES THE FIRST POINT IN THE SIGNAL IS A TROUGH
C  AND THE FIRST MAXIMA IS A PEAK. IF THE FIRST MAXIMA IS A TROUGH,
C  IT WILL BE SKIPPED (STATEMENT #50).
C
      DIMENSION A(*),ITRF(10000)
C
      JT = 1
      JP = 1
      SLOP = 0.
C
C  FIND ARRAY POSITIONS OF MAXIMA AND MINIMA
C
      NPT1 = NPT - 1
      DO 100 I = 2,NPT1
      SLAST = SLOP
      SLOP = A(I+1) - A(I)
      CHNG = SLAST * SLOP
      IF(CHNG.GE.0.) GO TO 100
      IF(CHNG.LT.0. .AND. SLAST.LT.0.) GO TO 50
      JP = JP+1
      GO TO 100
C
   50 IF(JP.EQ.1) GO TO 100
      ITRF(JT) = I
      JT = JT+1
C
  100 CONTINUE
      ITRF(JT)=NPT
      JP = JP-1
      IF(JP.EQ.0) JP=1
C
C  SET ENVELOPE LOBES TO VALUE OF ENVELOPE LOBE WIDTH
C
      J = 1
      ISTRT = 1
  250 IEND = ITRF(J)
      VALUE = IEND - ISTRT
      DO 300 I = ISTRT,IEND
  300 A(I) = VALUE
C
      J = J+1
      IF(IEND.EQ.NPT) GO TO 350
      ISTRT = IEND
      GO TO 250
C
  350 CONTINUE
C
      RETURN
      END
      SUBROUTINE ASLP(A,NPT)
C
C  JH BODINE 9/2/81
C
C  ROUTINE TO SET ANALYTIC SIGNAL ENVELOPE LOBES TO A VALUE
C  PROPORTIONAL TO THE MAX SLOPE OF THE ENVELOPE LOBES.
C
C    SLOPE = MAX(A(I+1)-A(I))/MAX(A(I)) * 1000.
C
C  THE VALUE OF THE ENVELOPE IS SET FROM TROUGH
C  TO TROUGH. THE RESULTING "ENVELOPE" MAY BE CONSIDERED TO
C  REPRESENT A MODIFICATION OF
C     A = COMPLEX ENVELOPE
C   NPT = NUMBER OF SAMPLE POINTS
C
C  PROGRAM ASSUMES THE FIRST POINT IN THE SIGNAL IS A TROUGH
C  AND THE FIRST MAXIMA IS A PEAK. IF THE FIRST MAXIMA IS A TROUGH,
C  IT WILL BE SKIPPED (STATEMENT #50).
C
      DIMENSION A(*),ITRF(10000),SLOPMX(10000),ENVMAX(10000)
C
      JT = 1
      JP = 1
      SLOP = 0.
C
C  FIND ARRAY POSITIONS OF MAXIMA AND MINIMA
C
      NPT1 = NPT - 1
      SMAX = 0.
      AMAX = 0.
      DO 100 I = 2,NPT1
      SLAST = SLOP
      SLOP = A(I+1) - A(I)
      CHNG = SLAST * SLOP
      IF(ABS(SLOP).GT.ABS(SMAX)) SMAX = SLOP
      IF(ABS(A(I)).GT.ABS(AMAX)) AMAX = A(I)
      IF(CHNG.GE.0.) GO TO 100
      IF(CHNG.LT.0. .AND. SLAST.LT.0.) GO TO 50
      JP = JP+1
      GO TO 100
C
   50 IF(JP.EQ.1) GO TO 100
      ENVMAX(JT) = AMAX
      SLOPMX(JT) = SMAX
      SMAX = 0.
      ITRF(JT) = I
      JT = JT+1
C
  100 CONTINUE
      ITRF(JT)=NPT
      JP = JP-1
      IF(JP.EQ.0) JP=1
C
C  SET ENVELOPE LOBES TO VALUE OF ENVELOPE LOBE WIDTH
C
      J = 1
      ISTRT = 1
  250 IEND = ITRF(J)
      DO 300 I = ISTRT,IEND
      IF (ENVMAX(J).EQ.0.) ENVMAX(J) = 1.
  300 A(I) = SLOPMX(J)/ENVMAX(J)*1000.
C
      J = J+1
      IF(IEND.EQ.NPT) GO TO 350
      ISTRT = IEND
      GO TO 250
C
  350 CONTINUE
C
      RETURN
      END
      SUBROUTINE ASKW(A,NPT)
C
C  JH BODINE 9/2/81
C
C  ROUTINE TO CALCULATE THE ASYMMETRY OF THE ENVELOPE
C
C  ROUTINE TO SET ANALYTIC SIGNAL ENVELOPE LOBES TO VALUE OF
C  THE DIFFERENCE BETWEEN THE ARRAY POSITIONS OF THE ENVELOPE LOBE
C  PEAK AND THE FIRST MOMENT OF THE LOBE.
C  THE VALUE OF THE ENVELOPE IS SET TO THAT OF THIS DIFFERENCE * 100
C  FROM TROUGH TO TROUGH. THE RESULTING "ENVELOPE" MAY BE
C  CONSIDERED TO BE A MEASURE OF THE DEGREE OF ASYMMETRY OF EACH
C  ENVELOPE LOBE.
C
C  SEE TANER ET AL., 1979, GEOPHYSICS, V.44, #6,P.1041.
C     A = COMPLEX ENVELOPE
C   NPT = NUMBER OF SAMPLE POINTS
C
C  PROGRAM ASSUMES THE FIRST POINT IN THE SIGNAL IS A TROUGH
C  AND THE FIRST POINT OF ZERO SLOPE IS A PEAK. IF THIS POINT
C  IS A TROUGH IT WILL BE SKIPPED (STATEMENT #50).
C
C  NOTE FOR USER'S;
C     THIS ROUTINE WILL FIND EVERY ENVELOPE PEAK REGARDLESS
C     OF RELATIVE AMPLITUDE. DISPLAY OF RESULTS FOR NOISY
C     DATA IS THUS MOST EFFECTIVE WITH A COLOR PLOT WHERE COLOR
C     INTENSITY IS AMPLITUDE MODULATED.
C
C
      DIMENSION A(*),ITRF(10000),IPEAK(10000)
C
      JT = 1
      JP = 1
      SLOP = 0.
C
C  FIND ARRAY POSITIONS OF MAXIMA AND MINIMA
C
      NPT1 = NPT - 1
      DO 100 I = 2,NPT1
         SLAST = SLOP
         SLOP = A(I+1) - A(I)
         CHNG = SLAST * SLOP
         IF(CHNG.GE.0.) GO TO 100
         IF(CHNG.LT.0. .AND. SLAST.LT.0.) GO TO 50
         IPEAK(JP) = I
         JP = JP+1
         GO TO 100
C
   50    IF(JP.EQ.1) GO TO 100
         ITRF(JT) = I
         JT = JT+1
C
  100 CONTINUE
      ITRF(JT)=NPT
      JP = JP-1
      IF(JP.EQ.0) JP=1
C
C  SET ENVELOPE LOBES TO DIFFERENCE IN ARRAY POSITION OF ENVELOPE
C  PEAK AND FIRST MOMENT
C
      J = 1
      ISTRT = 1
  250 IEND = ITRF(J)
      SUMM = 0.
      ASUM = 0.
C  GET FRACTIONAL ARRAY POSITION OF ENVELOPE PEAK
      K = IPEAK(J)
C
C KDC - Change FPEAK to Marfurt's tpeak (0-based).
C     FP = FPEAK(A,K)
      fp = tpeak(a,k-1)
C KDC - End of change
C
C  GET POSITION OF FIRST MOMENT
      DO 260 II = ISTRT,IEND
         SUMM = SUMM + (FP-II)*A(II)
         ASUM = ASUM + A(II)
  260 CONTINUE
      IF(ASUM.EQ.0.) ASUM = 1.
      AMOM = SUMM/ASUM
      IF(ASUM.EQ.0.) AMOM = 0.
C  SET ENVELOPE ARRAY TO DIFFERENCE OF PEAK AND 1ST MOM POSITIONS
      DO 300 I = ISTRT,IEND
  300    A(I) = AMOM *100.
C
      J = J+1
      IF(IEND.EQ.NPT) GO TO 350
      ISTRT = IEND
      GO TO 250
C
  350 CONTINUE
C
      RETURN
      END
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C                                                                      *
C***********************************************************************
C  ROUTINE:       FPEAK                                                *
C  ROUTINE TYPE:  FUNCTION  REAL                                       *
C  PURPOSE: ROUTINE TO FIND INFERRED FRACTIONAL ARRAY POSITION         *
C         (TK +/- FRACTION) OF A PEAK OF AN ARRAY.                     *
C  ENTRY POINTS:                                                       *
C      FPEAK  REAL  (A,K)                                              *
C  ARGUMENTS:                                                          *
C      A       REAL         I*  (1) - INPUT ARRAY OF VALUES            *
C      K       INTEGER      O*      - INDEX OF LOCAL MAXIMUM IN A      *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   J.H. BODINE                        ORIGIN DATE: 82/10/17  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 83/06/03  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:                                         *
C      FLOAT   REAL    -                                               *
C      ABS     GENERIC -                                               *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  NONE                                               *
C  GENERAL DESCRIPTION:  LATERAL SYMMETRY ABOUT PEAK IS ASSUMED.       *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NON-STANDARD FEATURES:  NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
      FUNCTION FPEAK (A,K)
      DIMENSION A(*)
C
      TK = FLOAT(K)
      DAL = ABS(A(K)-A(K-1))
      DAH = ABS(A(K)-A(K+1))
C
      TEST = DAL-DAH
      IF(TEST.GT.0.)FPEAK = TK+(1.-DAH/DAL)*.5
      IF(TEST.LT.0.)FPEAK = TK-(1.-DAL/DAH)*.5
      IF(TEST.EQ.0.)FPEAK = TK
C
      RETURN
      END
