C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      function tpeak(y,k)
      real      y(0:*)
c_________________________________________________________________
c     interpolate the position of the 'peak' value of function a, 
c     by running a parabola throught 3 points centered at point 'k'.
c
c     eqn of the parabola has the form:
c
c     y(t)=a*(t-t0)**2+b
c
c     where t and t0 are measured relative to k 
c     such that:
c
c     y(+dt)=a*(dt**2-2*dt*t0+t0**2)+b
c     y(  0)=a*(                 t0**2)+b
c     y(-dt)=a*(dt**2+2*dt*t0+t0**2)+b
c
c     dy=y(+dt)-y(-dt)=-4*a*dt*t0
c
c     d2y=y(+dt)-2.*y(0)+y(-dt)=2*a*dt**2
c
c     giving:
c
c     tpeak=-.5*dt*dy/d2y
c
c     a=-(y+dt)-y(-dt))/(4*dt*t0)
c     b=y(0)-a*t0**2 
c     
c_________________________________________________________________
      d2y=y(k+1)-2.*y(k)+y(k-1)
      if(d2y .eq. 0.) then
         t0=0.
      else
         dy=y(k+1)-y(k-1)
         t0=-.5*dy/d2y
      endif
c
c     a=-(y(k+1)-y(k-1))/(4*t0)
c     b=y(k)-a*(-t0)**2 
c
      tpeak=k+t0
C
      return
      end


