C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c**********************************************************************c
c asig1d reads in 3D data set and outputs the envelope, phase and
c frequency values for every trace.
c**********************************************************************c
c______________________________________________________________________
c          Kelly D. Crawford (Amoco E&PT, Tulsa, OK, USA).  99% of this
c          program was shamelessly (but with permission) copied from
c          Kurt J. Marfurt (Amoco E&PT, Tulsa, OK, USA) on May 4, 1995.
c______________________________________________________________________
c
c This is the list of operations:
c
c          icflg - attribute calculations
c          ------------------------------
c          0 absolute value
c          1 signed value
c          2 quadrature
c          3 envelope
c          4 inst. phase (-IP)
c          5 resp. phase (-RP)
c          6 inst. freq (-IF)
c          7 resp. freq (-RF)
c          8 0-phase decomp (-P0)
c          9 90-phase decomp (-P90)
c          10 resp. amp
c          11 resp. length (-RL)
c          12 env. skewness (-S)
c          13 env. risetime (-RT)
c          14 inst. bandwidth (-IBW)
c          15 inst. envelope (-IE)
c          16 resp. envelope (-RE)
c          17 resp. bandwidth (-RBW)
c          18 carrier (-C)
c
c     declare variables
c

      implicit none

#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

      
      integer ifmt_StaCor,l_StaCor,ln_StaCor
      integer i, luang
      real    vtot, wtot, v1, w1
c______________________________________________________________________
c     parameters needed for dynamic memory allocation routine 'galloc'.
c______________________________________________________________________
      integer   maxs, luin, luout, lbytes, nsamp_in, nsi, nrec_in
      integer   ntr_in, jtstart_orig, jtslice_orig
      integer   ntr_out, nrec_out
      real      tstart_orig, dzh, unitsc, lbyout, dz, fref, dtmsec
      real      v2,w2,dsamp,dt,dfine,s
      integer nstream,nfile,nrec_aug,ntfine,nsamp_out,nangs,nbytes_out
      integer nt,nfft,lentr2,maxtrace,lenitab,lenrtab,lenwork
      integer l_free,lenattr,l_uin,l_uquad,l_env,l_ienv,l_peak,l_slope
      integer l_jextremum,l_iphase,l_ifreq,l_ibw,l_renv
      integer l_tracebuf,l_rphase,l_rfreq,l_rbw
      integer l_rlength,l_rt,l_car,l_skew,l_p0,l_p90
      integer l_itabi,l_work,initfftf,jrec
      integer jerr,i2fact,lenhed,hbegin,ierrcd

      integer l_rtabf,l_itabf,l_rtabi,lens

      parameter (maxs=0 000 002)
      dimension s(maxs)
      pointer   (pntrs,s)
c______________________________________________________________________
      real        pi, twopi

      parameter   (pi=3.1415926,twopi=2.*pi)
      integer     sheader(SZLNHD)
      integer     ipwr(4)
      real        cputim(20),waltim(20)
#include <f77/pid.h>
#include <save_defs.h>
      parameter (i2fact=8/szsmpd,lenhed=lntrhd/i2fact,hbegin=1-lenhed)
c
      character*(120) file_in,file_out
      character*(6)   name

c Grab the declarations for the process identifiers
#include "initproc.h"

c     pipelen should be big enough to handle all of the settings in
c     the initproc subroutine.
      integer        pipelen
      parameter     (pipelen = 20)

      integer        pipe(pipelen), lunit(pipelen)
      logical        wrout(pipelen), calc(pipelen), available(pipelen)
      character*(4)  keyword(pipelen)
      character*(40) description(pipelen)

      logical        verbose,query,depth_section,eof,wrint,IKP
      logical        live


      integer        argis
      integer        stdin,stdout,stderr
      character*(9)  host,blank9
      data           name/'ASIG1D'/
      data           host/'         '/
      data           blank9/'         '/
      data           luang/88/

c_______________________________________________________________
c     check to see if we are running under IKP.
c_______________________________________________________________
      call ikpchk(host)
      if(host .ne. blank9) then
         IKP=.true.
         write(LER,*)'asig1d running inside XIKP'
c        Set up pipes from 3..pipelen+2
c        Note that pipes may run into conflicts with
c        /home/gp17/usp/include/f77/iounit.h
         do 1 i=1,pipelen
            pipe(i) = i+2
 1       continue
      else
         IKP=.false.
      endif
c_______________________________________________________________
c     initialize timing arrays.
c_______________________________________________________________
      call vclr(cputim,1,20)
      call vclr(waltim,1,20)
      call timstr(vtot,wtot)
      call timstr(v1,w1)
      stdin=LIN
      stdout=LOT
      stderr=LER
c_______________________________________________________________
c     Help?
c_______________________________________________________________
      query=((argis('-?') .gt. 0) .or. (argis('-h') .gt. 0)
     1  .or. (argis('-help') .gt. 0))
      if (query) then
         call help(ler)
         call exitfu(0)
      endif

c_______________________________________________________________
c     Does user just want a list of what is available?
c_______________________________________________________________
      query=((argis('-a') .gt. 0) .or. (argis('-avail') .gt. 0)
     1  .or. (argis('-available') .gt. 0))
      if (query) then
c        Call initproc to set up the arrays.
         call initproc(pipelen, available, keyword, description)
c        Check each option.
         write(ler,*) 'The following options are available:'
         do 6 i = 1, pipelen
            if (available(i)) then
              write(ler,*) '    ', keyword(i), ':', description(i)
            endif
 6       continue
         call exitfu(0)
      endif

c_______________________________________________________________
c     open printout files
c_______________________________________________________________
    
#include <f77/open.h>
c_______________________________________________________________
c     get i/o data set names
c_______________________________________________________________
      call argstr('-N',file_in, ' ', ' ')
      call argstr('-O',file_out,' ', ' ')

c_______________________________________________________________
c     open logical unit numbers for input and output
c_______________________________________________________________
      call getln(luin,file_in,'r',0)
      call getln(luout, file_out,'w', 1)
c_______________________________________________________________
c     read line header of input file.
c_______________________________________________________________
      lbytes=0
      call rtape(luin,sheader,lbytes)
      if(lbytes .eq. 0) then
         write(lerr,*)'ASIG1D: no header read from unit ',luin
         write(ler,*)'ASIG1D: no header read from unit ',luin
         call exitfu(4666)
      endif

c_______________________________________________________________
c     Note that we may want to substitute the encoded headers
c     found in windstat rather than this method.
c_______________________________________________________________












C_______________________________________________________________________
c     pull relevent values from line header.
C_______________________________________________________________________
      call saver(sheader,'NumSmp',nsamp_in,LINEHEADER)
      call saver(sheader,'SmpInt',nsi,LINEHEADER)
      call saver(sheader,'NumRec',nrec_in,LINEHEADER)
      call saver(sheader,'NumTrc',ntr_in,LINEHEADER)
      call saver(sheader,'TmMsFS',tstart_orig,LINEHEADER)
      call saver(sheader,'TmMsSl',jtstart_orig,LINEHEADER)
      call saver(sheader,'TmSlIn',jtslice_orig,LINEHEADER)
      call saver(sheader,'OrNTRC',ntr_out,LINEHEADER)
      call saver(sheader,'OrNREC',nrec_out,LINEHEADER)
      call saver(sheader,'Dz1000',dzh,LINEHEADER)
      call saver(sheader, 'UnitSc', unitsc, LINEHEADER)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(sheader, 'UnitSc', unitsc, LINEHEADER)
      endif
C_______________________________________________________________________
c     modify line header to reflect actual number of traces output
c     determine if the attributes will go to separate files or
c     one large files with attribute lines written back to back.
C_______________________________________________________________________
      call savhlh(sheader,lbytes,lbyout)
      call savew(sheader,'NumTrc',ntr_out,LINEHEADER)


c_______________________________________________________________
c     Initialize the process details.
c_______________________________________________________________
      call initproc(pipelen, available, keyword, description)










c_______________________________________________________________
c     check keywords for each explicit attribute
c     if they are detected, open a file or add to the data stream.
c_______________________________________________________________
      nstream=0
      nfile=0


c_______________________________________________________________
c        Open the file or pipe
c_______________________________________________________________
      do 5 i = 1, pipelen

         call chkfile(i,description(i),keyword(i),
     1                calc(i),wrout(i),lunit(i),
     2                nstream,nfile,luout,lerr,sheader,
     3                IKP,pipelen,pipe(i),nsamp_in,
     4                nrec_out,nrec_aug,lbyout)
         if ( calc(i) ) then
c           write(ler,*) 'calc true = ',i
           if ( available(i) ) then
             if (wrout(i))
     1         call wrtape(lunit(i),sheader,lbyout)
             else
               write(ler,'(a,a12,a,a30,a)') 'Option ',keyword(i),' (',
     1         description(i),') is not yet implemented...'
             write(lerr,'(a,a12,a,a30,a)') 'Option ',keyword(i),' (',
     1       description(i),') is not yet implemented...'
             calc(i) = .FALSE.
           endif
         else
c           write(ler,*) 'calc false = ',i
         endif
 5    continue


      if(nstream .gt. 0) then
c_______________________________________________________________
c        Output line header for multicomponent file.
c_______________________________________________________________
         call savew(sheader,'NumCmp',nstream,LINEHEADER)
         call savew(sheader,'NumRec',nrec_aug,LINEHEADER)
         call wrtape(luout,sheader,lbyout)
      elseif(nfile .eq. 0.) then             
         write(lerr,*) 'command line error!'
         write(lerr,*) 'must specify one or more of attributes' 
     1                     //'on command line'
         write(ler,*) 'command line error!'
         write(ler,*) 'must specify one or more of attributes' 
     1                     //'on command line'
         call exitfu(3666)
      endif
      call argr4('-dz',dz,0.,0.)            
      wrint=(argis('-int') .gt. 0)
      verbose=(argis('-V') .gt. 0)
      if(dz .lt. 0.) then
         write(lerr,*) 'error! ',
     1                 ' non-negative dz must be entered '
     2                 //'after -dz on command line!'
         write(lerr,*) 'dz = ',dz
         write(ler,*) 'error! ',
     1                 ' non-negative dz must be entered '
     2                 //'after -dz on command line!'
         write(ler,*) 'dz = ',dz

      endif
      if(dz .gt. 0.) then
         depth_section=.true.
         if(fref .eq. 0.) fref=30.
      else
         depth_section=.false.
         if(fref .eq. 0.) fref=60.
      endif
      dtmsec = 1000 * nsi * unitsc
      if(depth_section) then
         dtmsec = dz
         dsamp = dz
         dt = dtmsec * unitsc
      else
         dsamp = dtmsec
         dt = nsi * unitsc
      endif
      dfine=dsamp/ntfine

      nsamp_out=nsamp_in          
      nangs=ntr_in-1

      nbytes_out=(nsamp_out+lenhed)*szsmpd
      nt=nsamp_in-1  
c______________________________________________________________________
c     calculate length of mixed radix fft that fits lenwnd best.
c     limit to radices 2,3 and 5 to allow use both cray scilib
c     and qtc routines.
c______________________________________________________________________
      call nrfft(nt+1,5,nfft,ipwr)

      lentr2=lntrhd+(nt+1)*i2fact
c
      call hlhprt (sheader,lbytes,name,len(name),lerr)
c
      write(lerr,*)
      write(lerr,'(a,t40,i5,t50,a)') 'input seismic file name',
     1                         luin,file_in
      write(lerr,'(a,t40,i5,t50,a)') 'output multi-attribute file name',
     1                         luout,file_out
      write(lerr,'(a,t40,i5)') 'number of input records',nrec_in 
      write(lerr,'(a,t40,i5)') 'number of input traces',ntr_in  
      write(lerr,'(a,t40,i5)') 'number of input angles',nangs   
      write(lerr,'(a,t40,i5)') 'number of input samples',nsamp_in
      write(lerr,'(a,t40,f12.6)') 'input data sample interval (msec)', 
     1                         dtmsec
      write(lerr,'(a,t40,f12.6)') 'sample interval (sec)', dt
      write(lerr,'(a,t40,i5)') 'number of output records',nrec_out
      write(lerr,'(a,t40,i5)') 'number of output traces',ntr_out
      write(lerr,'(a,t40,i5)') 'number of output samples',nsamp_out
      write(lerr,'(a,t40,i5)') 'nt',nt,'nfft',nfft
      write(lerr,'(a,t40,i5)') 'lentr2',lentr2,
     1                         'nbytes_out',nbytes_out           
c
      write(lerr,'(a,t40,l5)') 'scale output between (-128:+127)?',
     1                           wrint
      write(lerr,'(a,t40,l5)') 'verbose output?',verbose     
      write(lerr,*)' '
c______________________________________________________________________
c     calculate buffer requirements for nested mixed radix ffts.
c     cray scilib routine rfftmlt runs twice as fast as mathadvantage
c     routine rnfftm.
c
c     buffer   mathadvantage rnfftm        cray scilib rfftmlt
c
c     itab      nfft+34                      2*nfft
c     rtab      3(nfft/2)+13                 2*nfft
c     work      18*ntrace                    4*nfft*ntrace
c______________________________________________________________________
      maxtrace=nangs                  
      if(szsmpd .eq. 4) then
         lenitab=nfft+34
         lenrtab=3*(nfft/2)+13
         lenwork=18*maxtrace
      else
         lenitab=max(2*nfft,nfft+34)
         lenrtab=max(2*nfft,3*(nfft/2)+13)
         lenwork=max(4*(maxtrace+1)*nfft,18*maxtrace)
      endif
c______________________________________________________________________
c     calculate memory requirements
c______________________________________________________________________
      write(lerr,'(///,80a1)') ('_',i=1,80)
      write(lerr,'(A)')'storage map of major arrays'
      write(lerr,'(80a1)') ('_',i=1,80)
C
      l_free=1
      lenattr=(nt+1)*ntr_out
c____________________________________________________________________
      write(lerr,'(a20,3a10)')'variable name','begin','end','length'
      call mapmem('uin',l_uin,l_free,nangs*nfft,lerr)
      call mapmem('uquad',l_uquad,l_free,nangs*nfft,lerr)
      call mapmem('env',l_env,l_free,nangs*(nt+1),lerr)
      call mapmem('peak',l_peak,l_free,nangs*(nt+1),lerr)
      call mapmem('slope',l_slope,l_free,nt,lerr)
      call mapmem('jextremum',l_jextremum,l_free,nt+1,lerr)
      call mapmem('tracebuf',l_tracebuf,l_free,(nt+1+lenhed),lerr)
c
      call mapmem('ienv',l_ienv,l_free,lenattr,lerr)
      call mapmem('iphase',l_iphase,l_free,lenattr,lerr)
      call mapmem('ifreq',l_ifreq,l_free,lenattr,lerr)
      call mapmem('ibw',l_ibw,l_free,lenattr,lerr)
      call mapmem('renv',l_renv,l_free,lenattr,lerr)
      call mapmem('rphase',l_rphase,l_free,lenattr,lerr)
      call mapmem('rfreq',l_rfreq,l_free,lenattr,lerr)
      call mapmem('rbw',l_rbw,l_free,lenattr,lerr)
      call mapmem('rlength',l_rlength,l_free,lenattr,lerr)
      call mapmem('rt',l_rt,l_free,lenattr,lerr)
      call mapmem('car',l_car,l_free,lenattr,lerr)
      call mapmem('skew',l_skew,l_free,lenattr,lerr)
      call mapmem('p0',l_p0,l_free,lenattr,lerr)
      call mapmem('p90',l_p90,l_free,lenattr,lerr)
c
      call mapmem('rtabf',l_rtabf,l_free,lenrtab,lerr)
      call mapmem('itabf',l_itabf,l_free,lenitab,lerr)
      call mapmem('rtabi',l_rtabi,l_free,lenrtab,lerr)
      call mapmem('itabi',l_itabi,l_free,lenitab,lerr)
      call mapmem('work',l_work,l_free,lenwork,lerr)
c___________________________________________________________________
C     allocate dynamic memory.
C_______________________________________________________________________
      lens=l_free-1
      write(ler,'(//,a)') 'allocate dynamic memory for ASIG3D: '
      write(ler,*) 1.e-6*lens,' Mwords'
      write(ler,*) 1.e-6*lens*szsmpd,' Mbytes'
      write(lerr,'(a20,10x,i10)') 'total vector length',lens
      call galloc(pntrs,lens*szsmpd,ierrcd,0)
      if(ierrcd .ne. 0 ) then
         write(lerr,*)'galloc memory allocation error from main'
         write(lerr,*)'ierrcd = ',ierrcd
         write(lerr,*)
         write(lerr,*)'probable cause: too much memory requested!'
         write(lerr,*)'go check your seismic headers and command'//
     1                ' line arguments!'
         write(lerr,*)'memory can be decreased by using the -M option'
         write(lerr,*)
         write(lerr,*)'program ASIG3D aborted'
c
         write(ler,*)'galloc memory allocation error from main'
         write(ler,*)'ierrcd = ',ierrcd
         write(ler,*)
         write(ler,*)'probable cause: too much memory requested!'
         write(ler,*)'go check your seismic headers and command'//
     1                ' line arguments!'
         write(ler,*)'memory can be decreased by using the -M option'
         write(ler,*)
         write(ler,*)'program ASIG3D aborted'
         call exit(101)
      endif
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
c_______________________________________________________________________
c     set fft initialization flag.
c_______________________________________________________________________
      initfftf=1
c_______________________________________________________________________
c     loop over all angle gathers.
c_______________________________________________________________________
      do 80000 jrec=1,nrec_in         

c_______________________________________________________________________
c      read angle stacks and pointer to angle having maximum semblance.
c_______________________________________________________________________
       call rdgather(s(l_tracebuf),s(l_uin),s(l_uquad),s(l_jextremum),
     1               live,luin,nangs,
     2               l_StaCor,ifmt_StaCor,ln_StaCor,
     3               eof,lenhed,nt,nfft,lerr,
     4               s(l_rtabf),s(l_itabf),s(l_rtabi),
     5               s(l_itabi),s(l_work),
     6               lenrtab,lenitab,lenwork,initfftf,
     7               cputim,waltim)
c_______________________________________________________________________
c      calculate attributes.
c_______________________________________________________________________

       call process(s(l_uin),s(l_uquad),s(l_env),
     1              s(l_peak),s(l_slope),
     2              s(l_jextremum),s(l_tracebuf),nbytes_out,
     3              lenhed,nt,nfft,nangs,dt,live,
     4              pipelen,calc,lunit,
     7              s(l_ienv),s(l_iphase),s(l_ifreq),s(l_ibw),
     8              s(l_renv),s(l_rphase),s(l_rfreq),s(l_rbw),
     9              s(l_rlength),
     9              s(l_car),s(l_rt),s(l_skew),s(l_p0),s(l_p90),
     d              lerr,cputim,waltim)
80000 continue

c_____________________________________________________________
c     close out those attribute files that were opened.
c_____________________________________________________________
      do 999 i = 1, pipelen
         if (wrout(i)) call lbclos(lunit(i))
 999  continue

      if(nstream .gt. 0 .and. luout .ne. stdout) call lbclos(luout)  
      call lbclos(luin)  
c_____________________________________________________________
c     write out timing statistics.
c_____________________________________________________________
      call timend(cputim(20),vtot,v2,waltim(20),wtot,w2)
      write(lerr,'(A30,2A15,/)') 'routine','cpu time','wall time'
      write(lerr,'(A30,2f15.3)')
     1         'read input',cputim(1),waltim(1),
     2         'calculate quadrature',cputim(2),waltim(2),
     2         'write output',cputim(10),waltim(10),
     7         'total',cputim(20),waltim(20)

      write(ler,*)'normal completetion. routine ASIG3D'           
      write(lerr,*)'normal completetion. routine ASIG3D'           
      close(lerr)
      call exitfu(0)
      call exitfu(666)
c
      end
      subroutine help(ler)

      write(ler,*)
     1'**************************************************************'
      write(ler,*)'3D seismic attributes using a freqlance algorithm'
      write(ler,*)
     1'**************************************************************'
      write(ler,*)'execute asig3d by typing asig3d and list of'
     1                   //' program parameters.'
      write(ler,*)
     1'note that each parameter is proceeded by -a where "a" is '
      write(ler,*)
     1'a character(s) correlation to some parameter.'
      write(ler,*)
     1'users enter the following parameters, or use the default values'
      write(ler,*)' '
        write(ler,*)
     1' -N [file_in]  (stdin)      : input seismic file name'          
        write(ler,*)
     1' -O [file_out]  (stdout)    : output multi-attribute file name'        
        write(ler,*)
     1' -IE [file_ienv] (optional): output instantaneous envelope '
     2                           //'file name'             
        write(ler,*)
     1' -IP [file_iphase] (optional): output instantaneous phase '
     2                           //'file name'             
        write(ler,*)
     1' -IF [file_ifreq] (optional): output instantaneous frequency '
     2                           //'file name'             
        write(ler,*)
     1' -IBW [file_ibw] (optional): output instantaneous bandwidth '
     2                           //'file name'             
        write(ler,*)
     1' -RE [file_renv] (optional): output response envelope '
     2                           //'file name'
        write(ler,*)
     1' -RP [file_rphase] (optional): output response phase '
     2                           //'file name'
        write(ler,*)
     1' -RF [file_rfreq] (optional): output response frequency '
     2                           //'file name'
        write(ler,*)
     1' -RBW [file_rbw] (optional): output response bandwidth '
     2                           //'file name'
        write(ler,*)
     1' -RL [file_rl] (optional): output response length '             
     2                           //'file name'
        write(ler,*)
     1' -S [file_skew] (optional): output skewness '                    
     2                           //'file name'
        write(ler,*)
     1' -C [file_carrier] (optional): output carrier '                    
     2                           //'file name'
        write(ler,*)
     1' -RT [file_rl] (optional): output rise time '                   
     2                           //'file name'
        write(ler,*)
     1' -P0 [file_rl] (optional): output 0 deg phase component '           
     2                           //'file name'
        write(ler,*)
     1' -P90 [file_rl] (optional): output 90 deg phase '           
     2                           //'component file name'

        write(ler,*) 
     1'                     if -IE, -IP, -IF -IBW -RE -RP -RF -RBW'
     2                      //' RL -RC -RDA -S -C -RT -P0 -P90  '
        write(ler,*) 
     1'                     entered without explicit files they '
     2                      //' will be out output back-to-bak '
        write(ler,*)
     2'                     in file=file_out'
        write(ler,*)
        write(ler,*)
     1' -V                    : if present, verbose printout'
       write(ler,*)' '
       write(ler,*)'usage:'
       write(ler,*)
       write(ler,*)'asig3d -N[file_in] -O[file_out]'
       write(ler,*)'       -dz[dz]'
       write(ler,*)'       -IE[file_ienv] -IP[file_iphase]'
       write(ler,*)'       -IF[file_ifreq] -IBW[file_ibw]'
       write(ler,*)'       -RE[file_renv] -RP[file_rphase]'
       write(ler,*)'       -RF[file_rfreq] -RBW[file_rbw]'
       write(ler,*)'       -RL[file_rlength] -S[file_skewness]'
       write(ler,*)'       -C[file_carrier] -RT[file_risetime]'
       write(ler,*)'       -P0[file_phase0] -P90[file_phase90]'
       write(ler,*)'       -TPT[file_time_pt] -APT[file_amp_pt]'
       write(ler,*)'       -[V]'
       write(ler,*)' '
       write(ler,*)

      return
      end
