C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
       subroutine process(uin,uquad,env,
     1                    peaktime,slope,
     2                    jextremum,tracebuf,nbytes_out,
     3                    lenhed,nt,nfft,nangs,dt,live,
     4                    pipelen,calc,lunit,
     5                    ienv,iphase,ifreq,ibw,
     6                    renv,rphase,rfreq,rbw,rlength,
     7                    car,rt,skew,p0,p90,
     8                    lerr,cputim,waltim)
c
c      implicit none

#include <save_defs.h>

      real      tracebuf(-lenhed:nt)
      real      uin(0:nfft-1,nangs)
      real      uquad(0:nfft-1,nangs)
      real      slope(0:nt-1)
      real      env(0:nt,nangs)
      real      ienv(0:nt),iphase(0:nt),ifreq(0:nt),ibw(0:nt)
      real      renv(0:nt),rphase(0:nt),rfreq(0:nt),rbw(0:nt)
      real      rlength(0:nt),car(0:nt),skew(0:nt),rt(0:nt)
      real      p0(0:nt),p90(0:nt)
c
      real      peaktime(0:nt,nangs)
      integer   jextremum(0:nt)

c Grab the declarations for the process identifiers
#include "initproc.h"


c
      integer        pipelen
      integer        lunit(pipelen)
      logical        calc(pipelen)
      logical	     calcmap
     
      parameter (pi=3.1415926)
      parameter (degprad=180./pi,radpdeg=pi/180.)           
      real      cputim(*),waltim(*)
c
      factfreq=1./(2.*dt*2.*pi)
      factbw=1./(2.*dt*2.*pi)
      fmax=1./(2.*dt) 
c
c_______________________________________________________________
c     precompute the instantaneous envelope.
c_______________________________________________________________
      do 12000 jang=1,nangs
       do 11000 jt=0,nt
        env(jt,jang)=sqrt(uin(jt,jang)**2+uquad(jt,jang)**2)

cc        write(ler,*) 'env utaupq= ',env(jt,jang),
cc     1      uin(jt,jang),  uquad(jt,jang)

11000  continue
12000 continue
cc      call exitfu(4)
c
      calcmap=calc(pmrenv)  .or. calc(pmrphase) .or. 
     1        calc(pmrfreq) .or. calc(pmrbw)    .or.
     1        calc(pmrlength)
      if(calcmap) then
c_______________________________________________________________
c        precompute the map used in response attribute calculations.
c_______________________________________________________________
         do 31000 jang=1,nangs
          call respmap(env(0,jang),slope,peaktime(0,jang),nt)
31000    continue
      endif
c#####################################################################
c     begin calculation and output of given attributes.
c#####################################################################
      if(calc(pmienv)) then
c_______________________________________________________________
c        store the instantaneous envelope.
c_______________________________________________________________
         do 13000 jt=0,nt
          jang=jextremum(jt)
          if(jang .eq. 0) then
             ienv(jt)=-1.
          else
             ienv(jt)=env(jt,jang)
          endif
13000    continue
         call vmov(ienv,1,tracebuf(0),1,nt+1)
         call wrtape(lunit(pmienv),tracebuf(-lenhed),nbytes_out)
      endif
c
      if(calc(pmiphase)) then
c_______________________________________________________________
c        calculate the instantaneous phase.
c_______________________________________________________________
         do 22000 jt=0,nt
          jang=jextremum(jt)
          if(jang .eq. 0) then
             iphase(jt)=-181.
          else
             if(uin(jt,jang) .eq. 0. 
     1                .and. uquad(jt,jang) .eq. 0.) then
                iphase(jt)=0.
             else
                iphase(jt)=atan2(uquad(jt,jang),uin(jt,jang))
     1                              *degprad
             endif
          endif
22000    continue
         call vmov(iphase,1,tracebuf(0),1,nt+1)
         call wrtape(lunit(pmiphase),tracebuf(-lenhed),nbytes_out)
      endif
      if(calc(pmifreq)) then
c_______________________________________________________________
c        calculate the instantaneous frequency.
c
c        in principle:
c
c        f=[phase(t+dt)-phase(t-dt)]/(2.*dt)
c
c        however, to avoid phase unwrapping, we use 
c        (Tanner et al, 1979, Geophysics, pg 1043, eqn 9):
c
c                  uin(t)*duquad(t)/dt-uquad(t)*duin(t)/dt
c        f=2.*pi*--------------------------------------
c                       uin(t)**2+uquad(t)**2
c
c        minus sign added to be consistent with program 'asig'
c_______________________________________________________________
         ifreq(0)=0.
         ifreq(nt)=0.
         do 23000 jt=1,nt-1
          jang=jextremum(jt)
          if(jang .eq. 0) then
             ifreq(jt)=-1.
          else
             duquad=uquad(jt+1,jang)-uquad(jt-1,jang) 
             duin=uin(jt+1,jang)-uin(jt-1,jang) 
             denom=env(jt,jang)**2
             if(denom .ne. 0.) then
                ifreq(jt)=-factfreq*
     1            (uin(jt,jang)*duquad-uquad(jt,jang)*duin)/denom
             else
                ifreq(jt)=0.
             endif
             ifreq(jt)=min(ifreq(jt),+fmax)
             ifreq(jt)=max(ifreq(jt),0.) 
         endif
23000    continue
         call vmov(ifreq,1,tracebuf(0),1,nt+1)
         call wrtape(lunit(pmifreq),tracebuf(-lenhed),nbytes_out)
      endif
c
      if(calc(pmibw)) then
c_______________________________________________________________
C        Calculate Instantaneous Bandwidth
c            Cohen  (1993) Instantaneous Anything,
c            Proc. IEEE Int Conf. Acoust. Speech, Signal Processing,
c            vol 4, pp 105-109.
c_______________________________________________________________
         ibw(0)=0.
         ibw(nt)=0.
         do 25000 jt=1,nt-1       
          jang=jextremum(jt)
          if(jang .eq. 0) then
             ibw(jt)=-1.
          else
             duquad=uquad(jt+1,jang)-uquad(jt-1,jang)
             duin=uin(jt+1,jang)-uin(jt-1,jang)
             denom=env(jt,jang)**2                       
             if(denom .ne. 0) then
                ibw(jt)=factbw*
     1            abs(uin(jt,jang)*duin+uquad(jt,jang)*duquad)/denom
             else
                ibw(jt)=0.
             endif
          endif
25000    continue
         do 26000 jt=0,nt
          ibw(jt)=min(ibw(jt),+fmax)
26000    continue
         call vmov(ibw,1,tracebuf(0),1,nt+1)
         call wrtape(lunit(pmibw),tracebuf(-lenhed),nbytes_out)
      endif
c
      if(calc(pmcar)) then
c_______________________________________________________________
c        calculate the carrier. ucar=sin(iphase)=uin/env.
c_______________________________________________________________
         do 28000 jt=0,nt
          jang=jextremum(jt)
          if(jang .eq. 0) then
             car(jt)=0.
          else
             denom=env(jt,jang)
             if(denom .ne. 0) then
                car(jt)=uin(jt,jang)/denom
             else
                car(jt)=0.
             endif
          endif
28000    continue
         call vmov(car,1,tracebuf(0),1,nt+1)
         call wrtape(lunit(pmcar),tracebuf(-lenhed),nbytes_out)
      endif
c
      if(calc(pmrphase) .or. calc(pmp0) .or. calc(pmp90) ) then
c_______________________________________________________________
c        calculate the response phase.
c_______________________________________________________________
         do 32000 jt=0,nt
          jang=jextremum(jt)
          if(jang .eq. 0) then
             rphase(jt)=-181.
          else
             kt=nint(peaktime(jt,jang))
             delt=kt-peaktime(jt,jang)
c_______________________________________________________________
c            interpolate the real and quadrature components to the
c            fractional time sample corresponding to the peaktime of the
c            instantaneous envelope.
c            interpolating the components instead of the phase avoids
c            the problem of phase unwrapping.
c_______________________________________________________________
             if(delt .ge. 0.) then
                ur=uin(kt,jang)+delt*(uin(kt-1,jang)-uin(kt,jang))
                uq=uquad(kt,jang)
     1                 +delt*(uquad(kt-1,jang)-uquad(kt,jang))
             else
                ur=uin(kt,jang)+delt*(uin(kt,jang)-uin(kt+1,jang))
                uq=uquad(kt,jang)
     1              +delt*(uquad(kt,jang)-uquad(kt+1,jang))
             endif
             if(ur .eq. 0. .and. uq .eq. 0.) then
                rphase(jt)=0.
             else
                rphase(jt)=atan2(uq,ur)*degprad
             endif
          endif
32000    continue
      endif
      if(calc(pmrphase) ) then
         call vmov(rphase,1,tracebuf(0),1,nt+1)
         call wrtape(lunit(pmrphase),tracebuf(-lenhed),nbytes_out)
      endif
      if(calc(pmrenv) ) then
c_______________________________________________________________
c        calculate the response envelope.
c_______________________________________________________________
         do 41000 jt=0,nt
          jang=jextremum(jt)
          if(jang .eq. 0) then
             renv(jt)=-1.
          else
             kt=nint(peaktime(jt,jang))
             renv(jt)=env(kt,jang)
          endif
41000    continue
         call vmov(renv,1,tracebuf(0),1,nt+1)
         call wrtape(lunit(pmrenv),tracebuf(-lenhed),nbytes_out)
      endif
c
      if(calc(pmrfreq) ) then
c_______________________________________________________________
c        calculate the response frequency.
c_______________________________________________________________
         tracebuf(0)=0.
         tracebuf(nt)=0.
         do 51000 jt=1,nt-1
          jang=jextremum(jt)
          if(jang .eq. 0) then
             rfreq(jt)=-1.
          else
             kt=nint(peaktime(jt,jang))
             duquad=uquad(kt+1,jang)-uquad(kt-1,jang)
             duin=uin(kt+1,jang)-uin(kt-1,jang)
             denom=env(kt,jang)**2
             if(denom .ne. 0.) then
                rfreq(jt)=-factfreq*
     1         (uin(kt,jang)*duquad-uquad(kt,jang)*duin)/denom
             else
                rfreq(jt)=0.
             endif
             rfreq(jt)=min(rfreq(jt),+fmax)
             rfreq(jt)=max(rfreq(jt),0.)
          endif
51000    continue
         call vmov(rfreq,1,tracebuf(0),1,nt+1)
         call wrtape(lunit(pmrfreq),tracebuf(-lenhed),nbytes_out)
      endif
c
      if(calc(pmrbw) ) then
c_______________________________________________________________
C        Calculate Response Bandwidth
c_______________________________________________________________
         tracebuf(0)=0.
         tracebuf(nt)=0.
         do 55000 jt=1,nt-1
          jang=jextremum(jt)
          if(jang .eq. 0) then
             rbw(jt)=-1.
          else
             kt=nint(peaktime(jt,jang))
             duquad=uquad(kt+1,jang)-uquad(kt-1,jang)
             duin=uin(kt+1,jang)-uin(kt-1,jang)
             denom=uin(kt,jang)**2+uquad(kt,jang)**2
             if(denom .ne. 0) then
                rbw(jt)=factbw*
     1        abs(uin(kt,jang)*duin+uquad(kt,jang)*duquad)/denom
             else
                rbw(jt)=0.
             endif
          endif
55000    continue
         do 56000 jt=0,nt
          rbw(jt)=min(rbw(jt),+fmax)
56000    continue
         call vmov(rbw,1,tracebuf(0),1,nt+1)
         call wrtape(lunit(pmrbw),tracebuf(-lenhed),nbytes_out)
      endif
c
      if(calc(pmp0) .or. calc(pmp90) ) then
c_______________________________________________________________
c        Calculate 0 and 90 phase components.           
c_______________________________________________________________
         do 62000 jt=0,nt
          jang=jextremum(jt)
          if(jang .eq. 0) then
             p0(jt)=0.
             p90(jt)=0.
          else
             arg=rphase(jt)*radpdeg
             p0(jt)=cos(arg)
     1          *(cos(arg)*uin(jt,jang)+sin(arg)*uquad(jt,jang))
             p90(jt)=uin(jt,jang)-p0(jt)
          endif
62000    continue
      endif
      if(calc(pmp0) ) then
         call vmov(p0,1,tracebuf(0),1,nt+1)
         call wrtape(lunit(pmp0),tracebuf(-lenhed),nbytes_out)
      endif
      if(calc(pmp90) ) then
         call vmov(p90,1,tracebuf(0),1,nt+1)
         call wrtape(lunit(pmp90),tracebuf(-lenhed),nbytes_out)
      endif
c
      return
      end
