C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C******************************************************************
C                                                                 
C     PROGRAM - attsel
C                                                               
C                 AMOCO PRODUCTION CO. PROPRIETARY 
C                  TO BE MAINTAINED IN CONFIDENCE
C 
C     ABSTRACT - Perform Weighted Stacking on CDPs to produce
C                AVO attributes and select attributes based on
C                amplitude ratios
C	
C******************************************************************
c 	Metric/English flag added 10-96 by James M. Gridley USP-Tulsa
c	Mudrock line option added 10-96 by James M. Gridley USP-Tulsa
c
c  Commented out stop statements on conditions of short and long velocity
c  traces. Provision are already in the code for handling these cases.
c  I'm not sure why it still had the stops in. - Joe M. Wade 2/16/2001
c
c 29/05/01 - rlc
c  Added code around the call to fitvel to bypass fitvel if mode 3.
c  This is done to make the ray tracing for this mode same a vendors
c  and to remove "wobble" from angle calculations.
c  also added code to remove requirement for veltape when -at flag set.
#include <localsys.h>
#include <save_defs.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <f77/pid.h>
#include <f77/iounit.h>
      integer npol
      PARAMETER (npol = 6)
      external fpoly
      real vel_array(1), t_array(1),dx(1)
      real data(1), angles(1), stack(1),vsvpsqr(1)
      real sig(1),vtrms(1),vsrms(1),vism(1),vit(1),cor(1)
      integer trhd(1),LH,TH,domain
      integer pipep, pipes, in_ikp
      POINTER (pc,vel_array),(ptt,t_array),(pdx,dx)
      POINTER (pdata, data), (pang, angles)
      POINTER (pstk, stack), (ptrhd, trhd)
      POINTER (pvsvpq,vsvpsqr),(pcor,cor)
      POINTER (psig,sig),(pvtrms,vtrms),(pvsrms,vsrms)
      POINTER (pvism,vism),(pvit,vit)

      real coefs(NPOL),errparms(5)
      real timvec(SZLNHD)
      real Ritr(SZLNHD),Vtrc(SZLNHD),Vstrc(SZLNHD)
      real angb, ange
C                                                      
      CHARACTER name*6,title(17)*4
      character ntap*256,otap*256
      character vtap*256,stap*256
C
      logical query,H,ikp,xt,at,MudLine,veltape,shtape
      logical Metric,English,depth,sa,short,long
c
      integer argis,luv,lus
      integer irs, ire,rc,rc2,rc3
      integer emerg
      integer itr(SZLNHD),vitr(SZLNHD),vsitr(SZLNHD)
C
      equivalence(itr(1),Ritr(1))
      equivalence(vitr(1),Vtrc(1))
      equivalence(vsitr(1),Vstrc(1))
C
      DATA name/'ATTSEL'/
      DATA IER/0/
      data pipep/3/,pipes/4/
      DATA title/7*'    ','AVO ','Attr','ibut','es  ',6*'    '/
    
      MudLine = .false.
      veltape = .false.
      shtape  = .false.
      ival = 0
      ithw = ITHWP1-1
      const = .0174533
c +---------------------------------------------------------+
c |     check for help flag.  If found, print help and quit |
c +---------------------------------------------------------+
      H = (argis('-H').gt.0).or.(argis('-h').gt.0)
      query= ((argis ('-?').gt.0).or.H)
      if (query) then
       if(.not.H)then
        call help(LER,1)
        stop
       else
        call help(LER,0)
        stop
       endif
      endif

      ikp = .false.
      if(in_ikp().eq.1)ikp=.true.

#include <f77/open.h>
C               +------------------------------+
C               |       Begin Edit Phase       |
C               +------------------------------+
      call gcmdln(ntap,otap,vtap,stap,irs,ire,mode,angb,ange,
     :   gc,xt,Metric,English,depth,rc,sa,abcut,pscut)
  
      if(rc.le.3)then
       rc2=3
       rc3=4
      else
       rc2=rc
       rc3=rc
      endif
      if(.not.xt)at=.true.
      domain=0
      if(depth)then
       domain=1
       mode = 3
      endif

      if (.not. ikp) then
         if(vtap.eq.' '.and.xt)then
            write(LER,*)' **ATTSEL** velocity file required'
            stop 100
         endif
      endif
      
      
      if(ange.eq.0)ange=45
      if(irs.eq.0)irs=1
      if(ire.eq.0)ire = 999999
C     
      fact = .00005
      if(mode.eq.-1.and.xt)then
         write(LER,*)' Solution mode set to 1 (curved ray).'
         mode=1
      endif
c     +=========================+
c     |   print torch and oval  |
c     +=========================+
      call gamoco(title,1,LERR) 
c     +====================================+
c     |   read line header from input data |
c     +====================================+
      
      call getln(luin,ntap,'r',0)
      if(luin.lt.0)then
         write(LERR,*)'Unable to open ', ntap
         write(LER, *)'**ATTSEL** Unable to open ', ntap
         stop 100
      endif
      if (ikp) then
         call sisfdfit (luv, pipep)
      else
         call getln(luv,vtap,'r',-1)
      endif
      if(luv.ge.0)veltape=.true.
      if(luv.lt.0.and.xt)then
         write(LERR,*)'Unable to open ', vtap
         write(LER ,*)'**ATTSEL** Unable to open ', vtap
         call lbclos(luin)
         stop 100
      else
       if(.not.xt.and.luv.lt.0)then
        veltape=.false.
       endif
      endif

      if (stap.eq.' '.and.veltape) then
         MudLine=.true.
*        write(LER,*)' '
*        write(LER,*) 'No Shear (interval) velocity provided.'
*        write(LER,*) 'Using Castagna`s Mudrock Relationship.'
*        write(LER,*)' '
         write(LERR,*)' '
         write(LERR,*) 'No Shear (interval) velocity provided.'
         write(LERR,*) 'Using Castagna`s Mudrock Relationship.'
         write(LERR,*)' '
      endif
     
      IF (luin .eq. 0) call sislgbuf(luin,'off')
      if(.not.veltape)MudLine=.true.
      if (.not. MudLine) then
         if (ikp) then
            call sisfdfit (lus, pipes)
         else
            call getln(lus,stap,'r',-1)
            if(lus.ge.0)shtape=.true.
         endif
      endif
      
      if (.not. MudLine) then
         if(lus.lt.0)then
            write(LERR,*)'Unable to open ', stap
            write(LER ,*)'**ATTSEL** Unable to open ', stap
            call lbclos(luin)
            if(veltape)call lbclos(luv)
            stop 100
         endif
      endif
      
      nby = 0 
      call rtape(luin,itr,NBY)     
      if (nby.EQ.0) then         
         write(LERR,*)'No line header found on ntap. Fatal!'
         write(LER,*)'**ATTSEL** No line header found on ntap. Fatal!'
         call lbclos(luin)
         if(veltape)call lbclos(luv)
         if(shtape)call lbclos(lus)
         stop 100
      endif
C     get processing constants from line header
      call savelu('NumSmp',ifmt_NumSmp,l_NumSmp,ln_NumSmp,LINEHEADER)
      call savelu('SmpInt',ifmt_SmpInt,l_SmpInt,ln_SmpInt,LINEHEADER)
      call savelu('NumTrc',ifmt_NumTrc,l_NumTrc,ln_NumTrc,LINEHEADER)
      call savelu('NumRec',ifmt_NumRec,l_NumRec,ln_NumRec,LINEHEADER)
      call savelu('Format',ifmt_Format,l_Format,ln_Format,LINEHEADER)
      call savelu('TmSlIn',ifmt_TmSlIn,l_TmSlIn,ln_TmSlIn,LINEHEADER)
      
      LH = LINEHEADER
      TH = TRACEHEADER
      call saver2(itr,ifmt_NumSmp,l_NumSmp,ln_NumSmp,nsamp,LH)
      call saver2(itr,ifmt_SmpInt,l_SmpInt,ln_SmpInt,nsr,LH)
      call saver2(itr,ifmt_NumTrc,l_NumTrc,ln_NumTrc,ntrc,LH)
      call saver2(itr,ifmt_NumRec,l_NumRec,ln_NumRec,nrec,LH)
      call saver2(itr,ifmt_Format,l_Format,ln_Format,iform,LH)
      call saver2(itr,ifmt_TmSlIn,l_TmSlIn,ln_TmSlIn,idpthi,LH)
      
      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
C     
      if(nsr.gt.32)then
         nsi = nsr/1000
      else
         nsi = nsr
      endif
      delt = float(nsi)/1000.
      do i = 1,  nsamp
         timvec(i) = float(i) * delt
      end do
      depthint = float(idpthi)/1000.
      if(depth.and.depthint.eq.0.0)then
       write(LERR,*)'Depth sample interval must be in line header. ',
     : 'Fatal!'
       write(LER,*)'**ATTSEL** Depth sample interval must be in line ',
     : 'header. Fatal!'
       call lbclos(luin)
       if(veltape)call lbclos(luv)
       if(shtape)call lbclos(lus)
       stop 100
      endif
      n4 = 6
      call hlhprt (itr,NBY,name,n4, LERR)
      ntbyt = nsamp*iszbyt + sztrhd
      
      call getln(luout,otap,'w',1)
      if(luout.lt.0)then
         write(LERR,*)'  Unable to open ',otap
         write(LER ,*)'**ATTSEL**  Unable to open ',otap
         call lbclos(luin)
         if(veltape)call lbclos(luv)
         if(shtape)call lbclos(lus)
         stop 100
      endif
      if(ire.lt.999999.and.irs.gt.0)then
         jnrec=ire-irs+1
         call savew2(itr,ifmt_NumRec,l_NumRec,ln_NumRec,
     :	jnrec,LINEHEADER)
      endif
      
      nout = 19
      nrout=9
      call savew2(itr,ifmt_NumTrc,l_NumTrc,ln_NumTrc,nrout,LINEHEADER)
      call savhlh(itr,nby,jtbyt)
      call wrtape(luout,itr,jtbyt)
c     +==================================================+
c     | get line header parameters for velocity data set |
c     +==================================================+
      nby = 0
      if(veltape)then
      call rtape(luv,vitr,nby)
      if(nby.eq.0)then
         write(LERR,*)'EOF on velocity data set reading header. FATAL'
         write(LER,*)'**ATTSEL** EOF on velocity data set reading ',
     :'header.  FATAL!'
         call lbclos(luin)
         call lbclos(luout)
         if(veltape)call lbclos(luv)
         if(shtape)call lbclos(lus)
         stop 100
      endif
      call saver2(vitr,ifmt_NumSmp,l_NumSmp,ln_NumSmp,nvsamp,LH)
      call saver2(vitr,ifmt_SmpInt,l_SmpInt,ln_SmpInt,nsrv  ,LH)
      call saver2(vitr,ifmt_NumTrc,l_NumTrc,ln_NumTrc,ntrcv ,LH)
      call saver2(vitr,ifmt_NumRec,l_NumRec,ln_NumRec,nrecv ,LH)
      call saver2(itr,ifmt_TmSlIn,l_TmSlIn,ln_TmSlIn,idpthv ,LH)
      if(nsrv.gt.32)then
         nsiv = nsrv/1000
      else
         nsiv = nsrv
      endif
      if(.not.depth)then
       if((nsiv  .ne. nsi))then
         write(LERR,*)
     :        ' Velocity dataset not compatible with input. 
     :        Must have same'
         write(LERR,*)
     :        ' sample interval. FATAL!'
         write(LER,*)
     :        ' **ATTSEL** Velocity dataset not compatible with input. 
     :        Must have same'
         write(LER,*)
     :        ' sample interval. FATAL!'
         call lbclos(luin)
         call lbclos(luout)
         if(veltape)call lbclos(luv)
         if(shtape)call lbclos(lus)
         stop 100
       endif
      else
       if(idpthv .ne. idpthi)then
        write(LERR,*)
     :   ' Velocity dataset not compatible with input. '
         write(LERR,*)
     :   ' Data are in depth and depth sample intervals'
         write(LERR,*)
     :   ' are not the same (',idpthi,' and ',idpthv,')'
        write(LER ,*)
     :   ' Velocity dataset not compatible with input. '
         write(LER ,*)
     :   ' *ATTSEL* Data are in depth and depth sample intervals'
         write(LER ,*)
     :   ' are not the same (',idpthi,' and ',idpthv,')'
         call lbclos(luin)
         call lbclos(luout)
         if(veltape)call lbclos(luv)
         if(shtape)call lbclos(lus)
         stop 100
       endif
      endif
      short = .false.
      long  = .false.
      if((nvsamp.lt.nsamp))then
         write(LERR,*)
     :        ' Velocity dataset shorter than input.  Will '
         write(LERR,*)
     :       'fill each trace with last value.'
         write(LER,*)
     :        ' **ATTSEL** Velocity dataset shorter than input.  Will '
         write(LER,*)
     :        ' fill each trace with last value.'
         short = .true.
c        stop    - commented out - 2/16/2001 - joe m. wade
      endif
      if((nvsamp.gt.nsamp))then
         write(LERR,*)
     :        ' Velocity dataset longer than input.  Will '
         write(LERR,*)
     :       'truncate to input length.'
         write(LER,*)
     :        ' **ATTSEL** Velocity dataset longer than input.  Will '
         write(LER,*)
     :        ' truncate to input length.'
         long = .true.
c        stop    - commented out - 2/16/2001 - joe m. wade
      endif
      endif  !  end of if(veltape)
c     +========================================================+
c     | get line header parameters for shear velocity data set |
c     +========================================================+

      if (.not. MudLine.and.veltape) then
      nby = 0
      call rtape(lus,vsitr,nby)
      if(nby.eq.0)then
         write(LERR,*)'EOF on shear velocity data set reading 
     :        header.',
     :        ' FATAL'
         write(LER,*)'**ATTSEL** EOF on shear velocity data set reading 
     :        header.',
     :        ' FATAL'
         call lbclos(luin)
         call lbclos(luout)
         if(shtape)call lbclos(lus)
         if(veltape)call lbclos(luv)
         stop 100
      endif
      call saver2(vsitr,ifmt_NumSmp,l_NumSmp,ln_NumSmp,nvssamp,LH)
      call saver2(vsitr,ifmt_SmpInt,l_SmpInt,ln_SmpInt,nsrvs,LH)
      call saver2(vsitr,ifmt_NumTrc,l_NumTrc,ln_NumTrc,ntrcvs,LH)
      call saver2(vsitr,ifmt_NumRec,l_NumRec,ln_NumRec,nrecvs,LH)
      if(nsrvs.gt.32)then
         nsivs = nsrvs/1000
      else
         nsivs = nsrvs
      endif
      if((nvssamp.ne.nvsamp).or.(nsivs  .ne. nsiv))then
         write(LERR,*)
     :        ' Shear Velocity dataset not compatible ',
     :        'with Vp dataset. '
         write(LERR,*)
     :        ' Must have same number samples, and sample ',
     :        'interval. FATAL!'
         write(LER,*)
     :        ' **ATTSEL** Shear Velocity dataset not compatible ',
     :        'with Vp dataset. '
         write(LER,*)
     :        ' Must have same number samples, and sample ',
     :        'interval. FATAL!'
         call lbclos(luin)
         call lbclos(luout)
         if(veltape)call lbclos(luv)
         if(shtape)call lbclos(lus)
         stop 100
      endif
      endif
C     +==================================+
C     |   allocate the required memory   |
C     +==================================+
      ier = 0
      ner = 0
      iget =nsamp * ntrc * ISZBYT
      call galloc(pdata, iget,ier,0)
      if(ier.ne.0)ner = ner+1
      call galloc(pang,  iget,ier,0)
      if(ier.ne.0)ner = ner+1
      
      iget = nsamp * ISZBYT * nout
      call galloc(pstk  ,iget,ier,0)
      if(ier.ne.0)ner = ner+1
      
      iget= nsamp*ISZBYT
      call galloc(pvsvpq,iget,ier,0)
      if(ier.ne.0)ner = ner+1
      call galloc(pcor  ,iget,ier,0)
      if(ier.ne.0)ner = ner+1
      call galloc(psig  ,iget,ier,0)
      if(ier.ne.0)ner = ner+1
      call galloc(pvtrms,iget,ier,0)
      if(ier.ne.0)ner = ner+1
      call galloc(pvsrms,iget,ier,0)
      if(ier.ne.0)ner = ner+1
      call galloc(pvism ,iget,ier,0)
      if(ier.ne.0)ner = ner+1
      call galloc(pvit  ,iget,ier,0)
      if(ier.ne.0)ner = ner+1
      call galloc(pc    ,iget,ier,0)
      if(ier.ne.0)ner=ner+1
      call galloc(ptt,iget,ier,0)
      if(ier.ne.0)ner=ner+1

      iget = ITRWRD * ntrc * ISZBYT
      call galloc(ptrhd,iget,ier,0)
      if(ier.ne.0)ner = ner+1

      iget = ntrc*ISZBYT
      call galloc(pdx,iget,ier,0)
      if(ier.ne.0)ner=ner+1

      if(ner.ne.0)then
       write(LERR,*)' Memory allocation failed.  FATAL'
       write(LER ,*)' **ATTSEL** Memory allocation failed.  FATAL'
       call lbclos(luin)
       call lbclos(luout)
       if(veltape)call lbclos(luv)
       if(shtape)call lbclos(lus)
       stop 100
      endif

      write(LERR,*)' ATTSEL Processing Parameters :'
      write(LERR,'(a,i5)')'Start Record ...............',irs
      write(LERR,'(a,i5)')'End Record .................',ire
      write(LERR,'(a,i5)')'Mode........................',mode
      write(LERR,'(a   )')'     0 = Straight Ray'
      write(LERR,'(a   )')'     1 = Curved Ray'
      write(LERR,'(a   )')'     2 = Perturbed Curved Ray'
      write(LERR,'(a   )')'     2 = Dix Rays'
      write(LERR,'(a,i5)')'Number Stacked Traces.......',nrout
      write(LERR,'(a,f5.1)')'Start Angle.................',angb
      write(LERR,'(a,f5.1)')'End Angle...................',ange

C               +---------------------------------+
C               |       Begin Process Phase       |
C               +---------------------------------+
c +=================================+
c | Convert limit angles to radians |
c +=================================+
      angb=angb/57.2957795
      ange=ange/57.2957795
c +=================+
c | go get the data |      
c +=================+
      if(irs.gt.1)then
       do i=1,irs-1
        do j=1,ntrc
         nit = 0
         call rtape(luin,itr,nit)
         if(nit.eq.0)then
          write(LER,*)'**ATTSEL** EOF on input trying to find rs. ',
     :    ' Fatal!'
          write(LERR,*)' EOF on input trying to find rs. Fatal!'
          call lbclos(luin)
          call lbclos(luout)
          if(veltape)call lbclos(luv)
          if(shtape)call lbclos(lus)
          stop 100
         endif
        end do
        if(nrecv.gt.1.and.veltape)then
         nit = 0
         call rtape(luv,vitr,nit)
         if(nit.eq.0)then
          write(LER,*)'**ATTSEL** EOF on velocity data set. FATAL!'
          write(LERR,*)' EOF on velocity data set. FATAL!'
          call lbclos(luin)
          call lbclos(luout)
          if(veltape)call lbclos(luv)
          if(shtape)call lbclos(lus)
          stop 100
         endif
        end if
        if (.not. MudLine.and.veltape) then
        if(nrecvs.gt.1)then
         nit = 0
         call rtape(lus,vsitr,nit)
         if(nit.eq.0)then
          write(LER,*)'**ATTSEL** EOF on velocity data set. FATAL!'
          write(LERR,*)' EOF on velocity data set. FATAL!'
          call lbclos(luin)
          call lbclos(luout)
          if(veltape)call lbclos(luv)
          if(shtape)call lbclos(lus)
          stop 100
         endif
        end if
      endif
       end do
      endif
c +==========================+
c | If have only 1 velocity  |
c | record, read it up front |
c +==========================+
      if(nrecv.eq.1.and.veltape)then
       nit = 0
       call rtape(luv,vitr,nit)
       if(nit.eq.0)then
        write(LER,*)'**ATTSEL** EOF on velocity data set. FATAL!'
        write(LERR,*)' EOF on velocity data set. FATAL!'
        call lbclos(luin)
        call lbclos(luout)
        if(veltape)call lbclos(luv)
        if(shtape)call lbclos(lus)
        stop 100
       endif
      end if
c +=================================+
c | If have only 1 shear velocity   |
c | record, read it up front        |
c +=================================+
      if (.not. MudLine.and.veltape) then
      if(nrecvs.eq.1)then
       nit = 0
       call rtape(lus,vsitr,nit)
       if(nit.eq.0)then
        write(LER,*)'**ATTSEL** EOF on shear velocity data set. FATAL!'
        write(LERR,*)' EOF on shear velocity data set. FATAL!'
        call lbclos(luin)
        call lbclos(luout)
        if(veltape)call lbclos(luv)
        if(shtape)call lbclos(lus)
        stop 100
       endif
      end if
      endif
c +=================+
c |  Process data   |
c +=================+
      do while (irs.le.ire)
       do j=1,ntrc
        nby = 0   
        CALL rtape (luin,itr,nby)
        if (nby.eq.0) then
         call lbclos(luin)
         call lbclos(luout)
         if(veltape)call lbclos(luv) 
         if(shtape)call lbclos(lus)
         stop 100
        endif
        call saver2(itr,ifmt_RecNum,l_RecNum,ln_RecNum,irec,TH)
        call saver2(itr,ifmt_StaCor,l_StaCor,ln_StaCor,istat,TH)
        iaddr = (j-1)*nsamp
        if(istat.ge.30000)then
         do k=1,nsamp
          data(iaddr+k)=0.
         end do
        else
         do k=1,nsamp
          data(iaddr+k)=Ritr(ithw+k)
         end do
        endif
        if(xt)then
         call saver2(itr,ifmt_DstSgn,l_DstSgn,ln_DstSgn,idist,TH)
         idist = iabs(idist)
         dx(j) = idist
        else
         call saver2(itr,ifmt_DstSgn,l_DstSgn,ln_DstSgn,iang1,TH)
         call saver2(itr,ifmt_DstUsg,l_DstUsg,ln_DstUsg,iang2,TH)
         angl = (iang1+iang2)/2.*const
         ndx = (j-1)*nsamp
         do k=1,nsamp
          angles(ndx+k)=angl
         end do
        endif
        iaddr = (j-1)*ITRWRD
        do k=1,ITRWRD
         trhd(iaddr+k)=itr(k)
        end do
       end do
C   Get the local velocity function
       if(nrecv.gt.1.and.veltape)then
        nby=0
        call rtape(luv,vitr,nby)
        if(nby.eq.0)then
         write(LERR,*)' EOF on velocity file. FATAL.'
         write(LER,*)' **ATTSEL**  EOF on velocity file. FATAL.'
         call lbclos(luin)
         call lbclos(luout)
         if(veltape)call lbclos(luv)
         if(shtape)call lbclos(lus)
         stop 100
        endif
       endif
       nv=nsamp
       if(short)nv=nvsamp
       do i=1,nv
        vel_array(i)=Vtrc(ithw+i)
        t_array(i)=(i-1)*delt
       end do
       if(short)then
        do i=nv+1,nsamp
         vel_array(i)=Vtrc(ithw+nv)
         t_array(i)=(i-1)*delt
        end do
       endif
       do i=1,nsamp
        sig(i)=1.0
       end do
       chisq = 0.
c +======================================================+
c | Resample the input velocity field to something more  |
c | manageable by the lsq routine in fitvel, then call   |
c | fitvel to get the rms, interval, smoothed rms, and   | 
c | smoothed interval velocities (vtrms, vit, vsrms,     |
c | and vism, respectively)                              |
c +======================================================+
       if(.not.depth)then
        if(mode.ne.3.and.veltape)then
         call fitvel(t_array, vel_array, nv,nsamp, delt, coefs,
     :   sig,ch,vtrms,vsrms,vism, vit,jerr)
         if(jerr.ne.0)then
          write(LERR,*)' Error allocating memory in getvel. FATAL.'
          write(LER,*)' **ATTSEL** Error allocating memory in getvel.',
     :     '  FATAL.'
          call lbclos(luin)
          call lbclos(luout)
          if(veltape)call lbclos(luv)
          if(shtape)call lbclos(lus)
          stop 100
         endif
         if(.not.xt)then
          call rmsint(vel_array,t_array,nsamp,vism)
         endif
        else
         call vmov(vel_array,1,vtrms,1,nsamp)
         call vmov(vel_array,1,vsrms,1,nsamp)
         call rmsint(vel_array,t_array,nsamp,vism)
         call rmsint(vel_array,t_array,nsamp,vit )
        endif
       else
        call vmov(vel_array,1,vtrms,1,nsamp)
        call vmov(vel_array,1,vsrms,1,nsamp)
        call vmov(vel_array,1,vism ,1,nsamp)
        call vmov(vel_array,1,vit  ,1,nsamp)
       endif
       tmax = 0.
                     
c     Go compute the angles and do stacking
c                                       
       j1=0            !  1
       j2=j1+nsamp     !  2
       j3=j2+nsamp     !  3
       j4=j3+nsamp     !  4
       j5=j4+nsamp     !  5
       j6=j5+nsamp     !  6
       j7=j6+nsamp     !  7
       j8=j7+nsamp     !  8
       j9=j8+nsamp     !  9
       ja=j9+nsamp     !  10
       jb=ja+nsamp     !  11
       jc=jb+nsamp     !  12
       jd=jc+nsamp     !  13
       je=jd+nsamp     !  14      
       jf=je+nsamp     !  15      
       jg=jf+nsamp     !  16  
       jh=jg+nsamp     !  17 
       ji=jh+nsamp     !  18 
       jj=ji+nsamp     !  19 
       do i=1,nsamp
        stack(j1+i)=0.
        stack(j2+i)=0.
        stack(j3+i)=0.
        stack(j4+i)=0.
        stack(j5+i)=0.
        stack(j6+i)=0.
        stack(j7+i)=0.
        stack(j8+i)=0.
        stack(j9+i)=0.
        stack(ja+i)=0.
        stack(jb+i)=0.
        stack(jc+i)=0.
        stack(jd+i)=0.
        stack(je+i)=0.
        stack(jf+i)=0.
        stack(jg+i)=0.
        stack(jh+i)=0.
        stack(ji+i)=0.
        stack(jj+i)=0.
       end do
       lclr = nsamp * ntrc
       if(xt)then
        do i=1,lclr
         angles(i)=0.
        end do
        vtmax = (nsamp-1)*delt
        call GetAngleMatrix(nsamp, coefs, angles, dx,ntrc,delt,timvec,
     :  vtrms,mode,emerg,vtmax,vsrms,vism,vit,domain,ier,errparms,
     :  depthint)
        if(ier.ne.0)then
         call lbclos(luin)
         call lbclos(luout)
         if(veltape)call lbclos(luv)
         if(shtape)call lbclos(lus)
         write(LER ,'(a,i5)')
     : ' **ATTSEL** Fatal Error in Velocity Function for Record',irec
         write(LER ,'(a,f8.3,a)')
     : ' Found imaginary interval velocity at ',errparms(5),' seconds.'
         write(LERR,'(a,i5)')
     : ' Fatal Error in Velocity Function for Record',irec
         write(LERR,'(a,f8.3,a)')
     : ' Found imaginary interval velocity at ',errparms(5),' seconds.'
         write(LERR,'(a,f10.0,a,f8.3)')
     : ' V2 = ',errparms(1),' T2 = ',errparms(3)
         write(LERR,'(a,f10.0,a,f8.3)')
     : ' V1 = ',errparms(2),' T1 = ',errparms(4)
         write(LERR,*)' coefs'
         call writer(coefs,npol,1,LERR)
         write(LERR,*)'vsrms '
         call writer(vsrms,nsamp,1,LERR)
         write(LERR,*)'vism '
         call writer(vism,nsamp,1,LERR)
         write(LERR,*)'vit '
         call writer(vit,nsamp,1,LERR)
         stop 100
        endif
       endif
c +=========================+
c | Compute the vs/vp ratio |
c +=========================+
       if(nrecvs.gt.1)then
        nby=0
        call rtape(lus,vsitr,nby)
        if(nby.eq.0)then
         write(LERR,*)' EOF on shear velocity file. FATAL.'
         write(LER,*)' **ATTSEL** EOF on shear velocity file. FATAL.'
         call lbclos(luin)
         call lbclos(luout)
         if(veltape)call lbclos(luv)
         if(shtape)call lbclos(lus)
         stop 100
        endif
       endif
       if(xt)then
       vp1 = vism(1)
       if (MudLine) then
          if(Metric) then
          vs1 = (vism(1)-1360)/1.16
          elseif(English) then
             vs1 = (vism(1)-4460)/1.16
          endif
       else
          vs1 = Vstrc(ithw+1)
       endif
       
       ratio=vs1/vp1
       vsvp = ratio
       
       vsvpsqr(1)=ratio*ratio
       
       do i=2,nsamp
        vp2=vism(i)
        if (MudLine) then
         if (Metric) then
          vs2 = (vism(i)-1360.)/1.16
         elseif (English) then
          vs2 = (vism(i)-4462.)/1.16 
         else
          vs2 = vp2/2.
         endif
        else
         vs2 = Vstrc(ithw+i)
        endif
        if(vp2.ne.0)then
         fvsvp = vs2/vp2
        else
         fvsvp = vsvp
        endif
        ratio = (vsvp+fvsvp)/2.
        vsvpsqr(i) = ratio*ratio
        vsvp = fvsvp
        vit(i-1)=vp2
       end do
       vsvpsqr(nsamp)=0.25
       else
        do i=1,nsamp
         vsvpsqr(i)=0.25
        end do
       endif
c     +========================================+
c     | Now call the routines to create        |
c     | the weights for the various attributes |
c     +========================================+
c +-----------------------------------------------+
c | create the B0 and B1 attributes, 2-component  |
c +-----------------------------------------------+
       iopt=1
       call solver(nsamp,ntrc, data, vsvpsqr,stack(j1+1),
     : stack(j2+1),stack(j3+1), angles, angb,ange, rc2, cor, iopt,
     : gc,sa,ierr,abcut,pscut,stack(j8+1))
c +-------------------------------------------------------+
c | create the DVp/VP and DVs/Vs attributes, 2-component  |
c +-------------------------------------------------------+
        iopt=2
       call solver(nsamp,ntrc, data, vsvpsqr,stack(j3+1),
     : stack(j4+1),stack(j5+1), angles, angb,ange, rc2, cor, iopt,
     : gc,sa,ierr,abcut,pscut,stack(j9+1))
* +----------------------------------+
c | DRho/Rho From 2-term, no scaling |
c +----------------------------------+
       do i=1,nsamp
        stack(j5+i)=2.*stack(j1+i) - stack(j3+i)
       end do
       do i=1,nsamp
        xa=vsvpsqr(i)*4.
        if(xa.eq.0)xa=1.
        stack(j6+i)=6.*stack(j1+i)+2*stack(j2+i)
        stack(j6+i)=stack(j6+i)+2*stack(j3+i)
        if(xa.ne.3)then
         stack(j6+i)=stack(j6+i)/(3-xa)
        else
         stack(j6+i)=stack(j6+i)/2.
        endif
        stack(j7+i)=stack(j3+i)-2*stack(j2+i)
        stack(j7+i)=stack(j7+i)/xa
       end do
c +-----------------+
c | Output the data |
c +-----------------+
       call vmov(trhd(1),1,itr(1),1,ITRWRD)
       do i = 1,nrout
        ist = (i-1)*nsamp
        do k=1,nsamp
         Ritr(ithw+k)=stack(ist+k)
        end do
        call savew2(itr,ifmt_TrcNum,l_TrcNum,ln_TrcNum,i,TRACEHEADER)
c +=========================================+
c | Check the number of non-zero sample to  |
c | see if the trace is all dead or not     |
c +=========================================+
        ik = 0
        k=1
        do while(stack(ist+k).eq.0.and.k.lt.nsamp)
         k=k+1
        end do
        if(k.lt.nsamp)then
         ik=0
        else
         ik=30000
        endif
        call savew2(itr,ifmt_StaCor,l_StaCor,ln_StaCor,ik,TRACEHEADER)
        call wrtape(luout,itr,ntbyt)
       end do   
       irs = irs+1
      end do
      call lbclos(luin)                   
      call lbclos(luout)                   
      if(veltape)call lbclos(luv)
      if(shtape)call lbclos(lus)
      write(LER,*)' '
      write(LER,*)'ATTSEL: Normal Completion'
      write(LER,*)' '
      stop
      END                                                    

      subroutine gcmdln(ntap,otap,vtap,stap,rs,re,mode,angb,ange,
     :       c,xt,Metric,English,depth,rc,sa,abcut,pscut)

#include <f77/iounit.h>

      character ntap*256, otap*256, vtap*256, stap*256
      integer rs, re,argis,rc
      logical xt,at,Metric,English,depth,sa,as
c     
      English = (argis('-E').gt.0)
 
                                        
      call argstr ('-N',ntap,' ',' ')          
      call argstr ('-O',otap,' ',' ')            
      call argstr ('-v',vtap,' ',' ')

      call argstr ('-S',stap,' ',' ')

      call argi4('-rs', rs, 0,0)
      if(rs.eq.0)rs=1
      call argi4('-re', re, 0,0)
      call argstr('-md',mdc,' ',' ')
      call argi4('-md',mode,1,1)
      if(mode.gt.3)mode = 0
      call argr4('-as',angb,0.0,0.0)
      call argr4('-ae',ange,0.0,0.0)
      call argr4('-c',c,0.25,0.25)
      Metric = (argis('-M').gt.0)
      at = (argis('-at').gt.0)
      if (at ) then
         xt = .false.
      else
         xt = .true.
      endif

      if (.not. English .and. .not. Metric) then
         Metric = .true.
      endif
      depth = (argis('-D').gt.0)
      call argi4('-rc',rc,0,0)
      as = (argis('-sa').gt.0)
      sa=.true.
      if(as)sa=.false.
      if(.not.xt)sa=.false.
      call argr4('-abc',abcut,0.0,0.0)
      call argr4('-psc',pscut,0.0,0.0)

      return                                                  
      end
      subroutine help(LER,n)
          write(LER,*)  
     :'***************************************************************'
         write(LER,*)
     :'Program attsel.............AVO ATTributes with SELective muting'
      call describe
      write(LER,*)' '                                             
      write(LER,*)                                               
     :' -N[ntap]    (default = stdin)  : Input data file name'   
      write(LER,*)                                             
     :' -O[otap]    (default = stdout) : Output data file name'
      write(LER,*)                                             
     :' -v[vtap]        (required)     : RMS velocity (Vp) file'   
      write(LER,*)                                             
     :' -S[stap]        (optional)     : Shear interval velocities' 
      write(LER,*)
     :' -rs[irs]  (default = first)    : Starting sequential record'
      write(LER,*)
     :' -re[ire]  (default = last)     : Ending sequential record'
      write(LER,*)
     :' -as[as]      (default = 0)     : Beginning angle for compute'
      write(LER,*)
     :' -ae[ae]      (default = 45)    : Ending angle for compute'
      write(LER,*)
     :' -md[mode]   (Default = 1)      : Solution flag for angle comp.'
      write(LER,*)
     :'                                  0 = Straight Ray'
      write(LER,*)
     :'                                  1 = Curved Ray'
      write(LER,*)
     :'                                  2 = Perturbed Curved Ray'
      write(LER,*)
     :'                                  3 = Dix Ray Tracing'
      write(LER,*)
     :'                                 (Always usd for Depth input)'
      write(LER,*)
     :' -c[c]       (default =  0.25)  : Exponent for Gardner Vp-rho' 
      write(LER,*)
     :'                                  relation (rho = kVp^c)     '
      write(LER,*)
     :'                                  for use in 2 term soluntion.'
      write(LER,*)
     :'                                  Can be set to 0.0          '
      write(LER,*)
     :' -at         (default =  X-T )  : If present, input CDP data ' 
      write(LER,*)
     :'                                  is angle-T  domain instead '
      write(LER,*)
     :'                                  of X-T domain (see -D flag)'
      write(LER,*)' '
      write(LER,*)
     :'-M          (default)           : Units are Metric'
      write(LER,*)
     :'-E                              : Units are English'
      write(LER,*)
     :'-D                              : If present, input data are in'
      write(LER,*)
     :'                                  depth domain.  Otherwise, in '
      write(LER,*)
     :'                                  time domain.                 '
      write(LER,*)
     :' -rc         (default = 4)      : Minimum number of amplitudes'
      write(LER,*)
     :'                                  for valid regression.      '
      write(LER,*)
     :'                                  Recommend 20'
      write(LER,*)
     :' -sa       (default = average)  : If present, do NOT average'
      write(LER,*)
     :'                                  the incident angles across '
      write(LER,*)
     :'                                  each interface'
      write(LER,*)
     :' -abc       (default = no limit) : Maximum ratio allowed for '
      write(LER,*)
     :'                                  B1/B0. Attributes with ratios'
      write(LER,*)
     :'                                  greater than this are zerod'
      write(LER,*)
     :' -psc       (default = no limit) : Maximum ratio allowed for '
      write(LER,*)
     :'                                  frational Vs to frational Vp'
      write(LER,*)
     :'                                  ratio.  Attributes with ratios'
      write(LER,*)
     :'                                  greater than this are zerod'
      write(LER,*)' '
      write(LER,*)                                        
     :'Usage:  ',                                         
     :' attsel -N[] -O[] -v[] -S[] -rs[] -re[] -md[] -as[] -ae[] -c[]'
      write(LER,*)
     :' -at -M -E -D -rc[] -sa -abc[] -psc[]'
      if(n.eq.1)call summary
      return                                                          
      end                                                            
