C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C******************************************************************
C                                                                 
C     PROGRAM - avaws
C                                                               
C                 AMOCO PRODUCTION CO. PROPRIETARY 
C                  TO BE MAINTAINED IN CONFIDENCE
C                                                                     
C     ABSTRACT - Perform Weighted Stacking on CDPs to produce
C                AVO attributes
C                                                                  
C
C******************************************************************
#include <localsys.h>
#include <save_defs.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <f77/pid.h>
#include <f77/iounit.h>

      integer npol
      PARAMETER (npol = 6)
      external fpoly
      real vel_array(1), t_array(1),dx(1)
      real data(1), angles(1), stack(1),vsvpsqr(1)
      real sig(1),vtrms(1),vsrms(1),vism(1),vit(1)
      integer trhd(1),LH,TH
      integer pipep, pipes, in_ikp
      POINTER (pc,vel_array),(ptt,t_array),(pdx,dx)
      POINTER (pdata, data), (pang, angles)
      POINTER (pstk, stack), (ptrhd, trhd)
      POINTER (pvsvpq,vsvpsqr)
      POINTER (psig,sig),(pvtrms,vtrms),(pvsrms,vsrms)
      POINTER (pvism,vism),(pvit,vit)

      real coefs(NPOL),errparms(5)
      real timvec(SZLNHD)
      real Ritr(SZLNHD),Vtrc(SZLNHD),Vstrc(SZLNHD)
      real angb, ange
C                                                      
      CHARACTER name*6,title(17)*4
      character ntap*100,otap*100
      character vtap*100,stap*100
C
      logical query,H,ikp
c
      integer argis,luv,lus
      integer irs, ire
      integer emerg
      integer itr(SZLNHD),vitr(SZLNHD),vsitr(SZLNHD)
C
C
      DATA name/'AVAWS'/
      DATA IER/0/
      data pipep/3/,pipes/4/
      DATA title/7*'    ','AVO ','Attr','ibut','es  ',6*'    '/

      equivalence(itr(1),Ritr(1))
      equivalence(vitr(1),Vtrc(1))
      equivalence(vsitr(1),Vstrc(1))

      ival = 0
      ithw = ITHWP1-1
c +---------------------------------------------------------+
c |     check for help flag.  If found, print help and quit |
c +---------------------------------------------------------+
      h = (argis('-H').gt.0)
      query= ((argis ('-?').gt.0).or.H)
      if (query) then
       if(H)then
        call help(LER,1)
        stop
       else
        call help(LER,0)
        stop
       endif
      endif

      ikp = .false.
      if(in_ikp().eq.1)ikp=.true.
#include <f77/open.h>
C               +------------------------------+
C               |       Begin Edit Phase       |
C               +------------------------------+
      stap = ' '
      call gcmdln(ntap,otap,vtap,stap,irs,ire,mode,angb,ange,gc)


      if(stap.eq.' ')then
       write(LER,*)'Shear (interval) velocity file required!'
       stop
      endif
      if(ange.eq.0)ange=45
      if(irs.eq.0)irs=1
      if(ire.eq.0)ire = 999999
C
      fact = .00005
      if(mode.eq.-1)then
       write(LER,*)' Solution mode must be specified. There is',
     :' no default for it.'
       stop
      endif
c +=========================+
c |   print torch and oval  |
c +=========================+
      call gamoco(title,1,lerr) 
c +====================================+
c |   read line header from input data |
c +====================================+

      call getln(luin,ntap,'r',0)
      if(luin.lt.0)then
       write(LERR,*)'Unable to open ', ntap
       stop
      endif
      if (ikp) then
         call sisfdfit (luv, pipep)
      else
         call getln(luv,vtap,'r',-1)
      endif
      if(luv.lt.0)then
       write(LERR,*)'Unable to open ', vtap
       call lbclos(luin)
       stop
      endif
      IF (luin .eq. 0) call sislgbuf(luin,'off')
      if (ikp) then
         call sisfdfit (lus, pipes)
      else
         call getln(lus,stap,'r',-1)
      endif
      if(luv.lt.0)then
       write(LERR,*)'Unable to open ', stap
       call lbclos(luin)
       call lbclos(luv)
       stop
      endif
      nby = 0 
      call rtape(luin,itr,NBY)     
      if (nby.EQ.0) then         
       write(LERR,*)'No line header found on ntap. Fatal!'
       write(LER,*)'No line header found on ntap. Fatal!'
       call lbclos(luin)
       stop
      endif
C   get processing constants from line header
      call savelu('NumSmp',ifmt_NumSmp,l_NumSmp,ln_NumSmp,LINEHEADER)
      call savelu('SmpInt',ifmt_SmpInt,l_SmpInt,ln_SmpInt,LINEHEADER)
      call savelu('NumTrc',ifmt_NumTrc,l_NumTrc,ln_NumTrc,LINEHEADER)
      call savelu('NumRec',ifmt_NumRec,l_NumRec,ln_NumRec,LINEHEADER)
      call savelu('Format',ifmt_Format,l_Format,ln_Format,LINEHEADER)

      LH = LINEHEADER
      TH = TRACEHEADER
      call saver2(itr,ifmt_NumSmp,l_NumSmp,ln_NumSmp,nsamp,LH)
      call saver2(itr,ifmt_SmpInt,l_SmpInt,ln_SmpInt,nsr,LH)
      call saver2(itr,ifmt_NumTrc,l_NumTrc,ln_NumTrc,ntrc,LH)
      call saver2(itr,ifmt_NumRec,l_NumRec,ln_NumRec,nrec,LH)
      call saver2(itr,ifmt_Format,l_Format,ln_Format,iform,LH)

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
C
      if(nsr.gt.32)then
       nsi = nsr/1000
      else
       nsi = nsr
      endif
      delt = float(nsi)/1000.
      do i = 1,  nsamp
       timvec(i) = float(i) * delt
      end do
      n4 = 6
      call hlhprt (itr,NBY,name,n4, LERR)
      ntbyt = nsamp*iszbyt + sztrhd
                           
      call getln(luout,otap,'w',1)
      if(luout.lt.0)then
       write(LERR,*)'  Unable to open ',otap
       call lbclos(luin)
       stop
      endif
      if(ire.lt.999999.and.irs.gt.0)then
        jnrec=ire-irs+1
        call savew2(itr,ifmt_NumRec,l_NumRec,ln_NumRec,jnrec,LINEHEADER)
      endif

      nout = 8
      call savew2(itr,ifmt_NumTrc,l_NumTrc,ln_NumTrc,nout,LINEHEADER)
      call savhlh(itr,nby,jtbyt)
      call wrtape(luout,itr,jtbyt)
c +==================================================+
c | get line header parameters for velocity data set |
c +==================================================+
      nby = 0
      call rtape(luv,vitr,nby)
      if(nby.eq.0)then
       write(lerr,*)'EOF on velocity data set reading header. FATAL'
       call lbclos(luin)
       call lbclos(luout)
       call lbclos(luv)
       stop
      endif
      call saver2(vitr,ifmt_NumSmp,l_NumSmp,ln_NumSmp,nvsamp,LH)
      call saver2(vitr,ifmt_SmpInt,l_SmpInt,ln_SmpInt,nsrv,LH)
      call saver2(vitr,ifmt_NumTrc,l_NumTrc,ln_NumTrc,ntrcv,LH)
      call saver2(vitr,ifmt_NumRec,l_NumRec,ln_NumRec,nrecv,LH)
      if(nsrv.gt.32)then
       nsiv = nsrv/1000
      else
       nsiv = nsrv
      endif
      if((nvsamp.ne.nsamp).or. (nsiv  .ne. nsi))then
       write(LERR,*)
     : ' Velocity dataset not compatible with input. Must have same'
       write(LERR,*)
     :' number samples and sample interval. FATAL!'
       write(LER,*)
     : ' Velocity dataset not compatible with input. Must have same'
       write(LER,*)
     :' number samples and sample interval. FATAL!'
       call lbclos(luin)
       call lbclos(luout)
       call lbclos(luv)
       stop
      endif
c +========================================================+
c | get line header parameters for shear velocity data set |
c +========================================================+
      nby = 0
      call rtape(lus,vsitr,nby)
      if(nby.eq.0)then
       write(lerr,*)'EOF on shear velocity data set reading header.',
     :' FATAL'
       call lbclos(luin)
       call lbclos(lus)
       call lbclos(luv)
       call lbclos(luout)
       stop
      endif
      call saver2(vsitr,ifmt_NumSmp,l_NumSmp,ln_NumSmp,nvssamp,LH)
      call saver2(vsitr,ifmt_SmpInt,l_SmpInt,ln_SmpInt,nsrvs,LH)
      call saver2(vsitr,ifmt_NumTrc,l_NumTrc,ln_NumTrc,ntrcvs,LH)
      call saver2(vsitr,ifmt_NumRec,l_NumRec,ln_NumRec,nrecvs,LH)
      if(nsrvs.gt.32)then
       nsivs = nsrvs/1000
      else
       nsivs = nsrvs
      endif
      if((nvssamp.ne.nvsamp).or.(nsivs  .ne. nsiv))then
       write(LERR,*)
     : ' Shear Velocity dataset not compatible with Vp dataset. '
       write(LERR,*)
     :' Must have same number samples, and sample interval. FATAL!'
       write(LER,*)
     : ' Shear Velocity dataset not compatible with Vp dataset. '
       write(LER,*)
     :' Must have same number samples, and sample interval. FATAL!'
        call lbclos(luin)
        call lbclos(luout)
        call lbclos(luv)
        call lbclos(lus)
       stop
      endif
C +==================================+
C |   allocate the required memory   |
C +==================================+
      ier = 0
      ner = 0
      iget =nsamp * ntrc * ISZBYT
      call galloc(pdata,iget,ier,0)
      if(ier.ne.0)ner = ner+1
      call galloc(pang, iget,ier,0)
      if(ier.ne.0)ner = ner+1

      iget = nsamp * ISZBYT * (nout+4)
      call galloc(pstk  ,iget,ier,0)
      if(ier.ne.0)ner = ner+1

      iget= nsamp*ISZBYT
      call galloc(pvsvpq,iget,ier,0)
      if(ier.ne.0)ner = ner+1

      iget = ITRWRD * ntrc * ISZBYT
      call galloc(ptrhd,iget,ier,0)
      if(ier.ne.0)ner = ner+1

      iget = nsamp*ISZBYT
      call galloc(psig  ,iget,ier,0)
      if(ier.ne.0)ner = ner+1
      call galloc(pvtrms,iget,ier,0)
      if(ier.ne.0)ner = ner+1
      call galloc(pvsrms,iget,ier,0)
      if(ier.ne.0)ner = ner+1
      call galloc(pvism ,iget,ier,0)
      if(ier.ne.0)ner = ner+1
      call galloc(pvit  ,iget,ier,0)
      if(ier.ne.0)ner = ner+1
      call galloc(pc    ,iget,ier,0)
      if(ier.ne.0)ner=ner+1
      call galloc(ptt,iget,ier,0)
      if(ier.ne.0)ner=ner+1

      iget = ntrc*ISZBYT
      call galloc(pdx,iget,ier,0)
      if(ier.ne.0)ner=ner+1

      if(ner.ne.0)then
       write(LERR,*)' Memory allocation failed.  FATAL'
       call lbclos(luin)
       call lbclos(luout)
       stop
      endif

      write(LERR,*)' AVAWS Processing Parameters :'
      write(LERR,'(a,i5)')'Start Record ...............',irs
      write(LERR,'(a,i5)')'End Record .................',ire
      write(LERR,'(a,i5)')'Mode........................',mode
      write(LERR,'(a   )')'     0 = Straight Ray'
      write(LERR,'(a   )')'     1 = Curved Ray'
      write(LERR,'(a   )')'     2 = Perturbed Curved Ray'
      write(LERR,'(a,i5)')'Number Stacked Traces.......',nout
      write(LERR,'(a,f5.1)')'Start Angle.................',angb
      write(LERR,'(a,f5.1)')'End Angle...................',ange
C               +---------------------------------+
C               |       Begin Process Phase       |
C               +---------------------------------+
c +=================================+
c | Convert limit angles to radians |
c +=================================+
      angb=angb/57.2957795
      ange=ange/57.2957795
c +=================+
c | go get the data |      
c +=================+
      if(irs.gt.1)then
       do i=1,irs-1
        do j=1,ntrc
         nit = 0
         call rtape(luin,itr,nit)
         if(nit.eq.0)then
          write(LER,*)'EOF on input trying to find rs. Fatal!'
          write(LERR,*)' EOF on input trying to find rs. Fatal!'
          call lbclos(luin)
          call lbclos(luout)
          stop
         endif
        end do
        if(nrecv.gt.1)then
         nit = 0
         call rtape(luv,vitr,nit)
         if(nit.eq.0)then
          write(LER,*)'EOF on velocity data set. FATAL!'
          write(LERR,*)' EOF on velocity data set. FATAL!'
          call lbclos(luin)
          call lbclos(luout)
          call lbclos(luv)
          stop
         endif
        end if
        if(nrecvs.gt.1)then
         nit = 0
         call rtape(lus,vsitr,nit)
         if(nit.eq.0)then
          write(LER,*)'EOF on velocity data set. FATAL!'
          write(LERR,*)' EOF on velocity data set. FATAL!'
          call lbclos(luin)
          call lbclos(luout)
          call lbclos(luv)
          call lbclos(lus)
          stop
         endif
        end if
       end do
      endif
c +==========================+
c | If have only 1 velocity  |
c | record, read it up front |
c +==========================+
      if(nrecv.eq.1)then
       nit = 0
       call rtape(luv,vitr,nit)
       if(nit.eq.0)then
        write(LER,*)'EOF on velocity data set. FATAL!'
        write(LERR,*)' EOF on velocity data set. FATAL!'
        call lbclos(luin)
        call lbclos(luout)
        call lbclos(luv)
        stop
       endif
      end if
c +=================================+
c | If have only 1 shear velocity   |
c | record, read it up front        |
c +=================================+
      if(nrecvs.eq.1)then
       nit = 0
       call rtape(lus,vsitr,nit)
       if(nit.eq.0)then
        write(LER,*)'EOF on shear velocity data set. FATAL!'
        write(LERR,*)' EOF on shear velocity data set. FATAL!'
        call lbclos(luin)
        call lbclos(luout)
        call lbclos(luv)
        call lbclos(lus)
        stop
       endif
      end if
c +=================+
c |  Process data   |
c +=================+
      do while (irs.le.ire)
       do j=1,ntrc
        nby = 0   
        CALL rtape (luin,itr,nby)
        if (nby.eq.0) then
         call lbclos(luin)
         call lbclos(luout)
         call lbclos(luv) 
         stop
        endif
        call saver2(itr,ifmt_RecNum,l_RecNum,ln_RecNum,irec,TH)
        call saver2(itr,ifmt_StaCor,l_StaCor,ln_StaCor,istat,TH)
        iaddr = (j-1)*nsamp
        if(istat.ge.30000)then
         do k=1,nsamp
          data(iaddr+k)=0.
         end do
        else
         do k=1,nsamp
          data(iaddr+k)=Ritr(ithw+k)
         end do
        endif
        call saver2(itr,ifmt_DstSgn,l_DstSgn,ln_DstSgn,idist,TH)
        idist = iabs(idist)
        dx(j) = idist
        iaddr = (j-1)*ITRWRD
        do k=1,ITRWRD
         trhd(iaddr+k)=itr(k)
        end do
       end do
C   Get the local velocity function
       if(nrecv.gt.1)then
        nby=0
        call rtape(luv,vitr,nby)
        if(nby.eq.0)then
         write(lerr,*)' EOF on velocity file. FATAL.'
         call lbclos(luin)
         call lbclos(luout)
         call lbclos(luv)
         stop
        endif
       endif
       nv=nsamp
       do i=1,nv
        vel_array(i)=Vtrc(ITHWP1+i-1)
        t_array(i)=i*delt
       end do
       do i=1,nsamp
        sig(i)=1.0
       end do
       chisq = 0.
c +======================================================+
c | Resample the input velocity field to something more  |
c | manageable by the lsq routine in fitvel, then call   |
c | fitvel to get the rms, interval, smoothed rms, and   | 
c | smoothed interval velocities (vtrms, vit, vsrms,     |
c | and vism, respectively)                              |
c +======================================================+
       call sloper(t_array, vel_array, nv,fact)
       call fitvel(t_array, vel_array, nv,nsamp, delt, coefs,
     :   sig,ch,vtrms,vsrms,vism, vit,jerr)
       if(jerr.ne.0)then
        write(lerr,*)' Error allocating memory in getvel. FATAL.'
        write(ler,*)' Error allocating memory in getvel. FATAL.'
        call lbclos(luin)
        call lbclos(luout)
        call lbclos(luv)
        stop
       endif
c                                          
c     Go compute the angles and do stacking
c                                       
       j1=0
       j2=j1+nsamp
       j3=j2+nsamp
       j4=j3+nsamp
       j5=j4+nsamp
       j6=j5+nsamp
       j7=j6+nsamp
       j8=j7+nsamp
       j9=j8+nsamp
       ja=j9+nsamp
       jb=ja+nsamp
       lclr = nsamp * ntrc
       do i=1,lclr
        angles(i)=0.
       end do
       vtmax = (nsamp-1)*delt
       call GetAngleMatrix(nsamp, coefs, angles, dx,ntrc,delt,timvec,
     :  vtrms,mode,emerg,vtmax,vsrms,vism,vit,ier,errparms)
       if(ier.ne.0)then
        call lbclos(luin)
        call lbclos(luout)
        call lbclos(luv)
        write(LERR,'(a,i5)')
     : ' Fatal Error in Velocity Function for Record',irec
         write(LERR,'(a,f8.3,a)')
     : ' Found imaginary interval velocity at ',errparms(5),' seconds.'
        write(LERR,'(a,f10.0,a,f8.3)')
     : ' V2 = ',errparms(1),' T2 = ',errparms(3)
        write(LERR,'(a,f10.0,a,f8.3)')
     : ' V1 = ',errparms(2),' T1 = ',errparms(4)
        write(LERR,*)' coefs'
        call writer(coefs,npol,1,LERR)
        write(LERR,*)'vsrms '
        call writer(vsrms,nsamp,1,LERR)
        write(LERR,*)'vism '
        call writer(vism,nsamp,1,LERR)
        write(LERR,*)'vit '
        call writer(vit,nsamp,1,LERR)
        stop
       endif
c +======================================+
c | If shear velocity file is input, use |
c | it to compute the vs/vp ratio        |
c +======================================+
       if(nrecvs.gt.1)then
        nby=0
        call rtape(lus,vsitr,nby)
        if(nby.eq.0)then
         write(lerr,*)' EOF on shear velocity file. FATAL.'
         call lbclos(luin)
         call lbclos(luout)
         call lbclos(luv)
         call lbclos(lus)
         stop
        endif
       endif
       vp1 = vism(1)
       vs1 = Vstrc(ITHWP1)
       ratio=vs1/vp1
       vsvpsqr(1)=ratio*ratio
       do i=2,nsamp
        vp2=vism(i)
        vs2 = Vstrc(ITHWP1+i-1)
        vp2 = 0.5*(vp2+vp1)
        vs2 = 0.5*(vs2+vs1)
        if(vp2.ne.0.)then
         ratio = vs2/vp2
         vsvpsqr(i) = ratio*ratio
        else
         vsvpsqr(i)=0.
        endif
        vp1=vp2
        vs1=vs2
       end do
c +========================================+
c | Now call the routines to create        |
c | the weights for the various attributes |
c +========================================+

c +-----------------------------------------------+
c | create the B0 and B1 attributes, 2-component  |
c +-----------------------------------------------+
       call WeightAB(nsamp,ntrc, data, stack(j1+1), stack(j2+1),
     :           angles, angb,ange,gc,vism,ierr)
c +-------------------------------------------------------+
c | create the DVp/VP and DVs/Vs attributes, 2-component  |
c +-------------------------------------------------------+
       call WeightIJ(nsamp,ntrc, data, stack(j3+1), stack(j4+1),
     :   vsvpsqr, angles, angb,ange,gc,vism,ierr)
c +----------------------------------------------------+
c | create the B0, B1, and B2 attributes, 3-component  |
c +----------------------------------------------------+
       call WeightB0(nsamp,ntrc, data, stack(j9+1),
     :  stack(ja+1), stack(jb+1),vsvpsqr, angles, angb,ange,vism,ierr)

c +----------------------------------------+
c | make combinations for other attributes |
c +----------------------------------------+
c +-----------+
c | Br and Bz |
c +-----------+
       do i=1,nsamp
        if(stack(j1+i).ne.0.0)then
         stack(j6+i)=stack(j1+i)/abs(stack(j1+i))*stack(j2+i)
         stack(j7+i)=stack(j2+i)/stack(j1+i)
        else
         stack(j6+1)=0.
         stack(j7+1)=0.
        endif
       end do
c +-----------------------------+
c | DRho/Rho and DVp/Vs / Vp/Vs |
c +-----------------------------+
       do i=1,nsamp
        stack(j5+i)=2*stack(j9+i) - stack(j3+i)
        stack(j8+i)=stack(j3+i)-stack(j4+i)
       end do
c +-----------------+
c | Output the data |
c +-----------------+
       call vmov(trhd(1),1,itr(1),1,ITRWRD)
       do i = 1,nout
        ist = (i-1)*nsamp
        do k=1,nsamp
         Ritr(ITHWP1+k-1)=stack(ist+k)
        end do
        call savew2(itr,ifmt_TrcNum,l_TrcNum,ln_TrcNum,i-1,TRACEHEADER)
c +=========================================+
c | Check the number of non-zero sample to  |
c | see if the trace is all dead or not     |
c +=========================================+
        ik = 0
        k=1
        do while(stack(ist+k).eq.0.and.k.lt.nsamp)
         k=k+1
        end do
        if(k.lt.nsamp)then
         ik=0
        else
         ik=30000
        endif
        call savew2(itr,ifmt_StaCor,l_StaCor,ln_StaCor,ik,TRACEHEADER)
        call wrtape(luout,itr,ntbyt)
       end do   
       irs = irs+1
      end do
      call lbclos(luin)                   
      call lbclos(luout)                   
      call lbclos(luv)
      call lbclos(lus)
      stop
      END                                                    
      subroutine gcmdln(ntap,otap,vtap,stap,rs,re,mode,angb,ange,c)
#include <f77/iounit.h>
      character ntap*100, otap*100, vtap*100,stap*100
      character mdc*2,cc*8
      integer rs, re
c                                                         
      call argstr ('-N',ntap,' ',' ')          
      call argstr ('-O',otap,' ',' ')            
      vtap = ' '
      call argstr ('-v',vtap,' ',' ')
      if(vtap.eq.' ')then
       write(ler,*)' velocity file required'
       stop
      endif
      stap = ' '
      call argstr('-S',stap,' ',' ')
      call argi4('-rs', rs, 0,0)
      if(rs.eq.0)rs=1
      call argi4('-re', re, 0,0)
      call argstr('-md',mdc,' ',' ')
      if(mdc.eq.'0'.or.mdc.eq.'1'.or.mdc.eq.'2')then
        read(mdc,'(I1)')mode
      else
        mode = -1
      endif
      if(mode.gt.2)mode = 0
      call argr4('-as',angb,0.0,0.0)
      call argr4('-ae',ange,0.0,0.0)
      call argstr('-c',cc,' ',' ')
      if(cc.ne.' ')then
       read(cc,'(f8.0)')c
      else
       c = 0.25
      endif
      return                                                  
      end
      subroutine help(LER,n)
          write(LER,*)  
     :'***************************************************************'
         write(LER,*)
     :'Program avaws.............AVo Attributes from Weighted Stacking'
      call describe
      write(LER,*)' '                                             
      write(LER,*)                                               
     :' -N[ntap]    (default = stdin)  : Input data file name'   
      write(LER,*)                                             
     :' -O[otap]    (default = stdout) : Output data file name'
      write(LER,*)                                             
     :' -v[vtap]        (required)     : RMS velocity (Vp) file'   
      write(LER,*)                                             
     :' -S[stap]        (required)     : Shear interval velocities' 
      write(LER,*)
     :' -rs[irs]  (default = first)    : Starting sequential record'
      write(LER,*)
     :' -re[ire]  (default = last)     : Ending sequential record'
      write(LER,*)
     :' -as[as]      (default = 0)     : Beginning angle for compute'
      write(LER,*)
     :' -ae[ae]      (default = 45)    : Ending angle for compute'
      write(LER,*)
     :' -md[mode]   (No Default -      : Solution flag for angle comp.'
      write(LER,*)
     :'              value require)      0 = Straight Ray'
      write(LER,*)
     :'                                  1 = Curved Ray'
      write(LER,*)
     :'                                  2 = Perturbed Curved Ray'
      write(LER,*)
     :' -c[c]       (default =  0.25)  : Exponent for Gardner Vp-rho' 
      write(LER,*)
     :'                                  relation (rho = kVp^c)     '
      write(LER,*)
     :'                                  for use in 2 term soluntion.'
      write(LER,*)
     :'                                  Can be set to 0.0          '
      write(LER,*)' '
      write(LER,*)                                        
     :'Usage:  ',                                         
     :' avaws -N[] -O[] -v[] -S[] -rs[] -re[] -md[] -as[] -ae[] -c[]'
      if(n.eq.1)call summary
      return                                                          
      end                                                            
c*****************************************************************
c                                                                 
c     SUBROUTINE - WeightStackAB
c                                                               
c     LANGUAGE - FORTRAN 77                                    
c     SYSTEM(S) - SUN, CRAY2                                         
c     AUTHOR - Richard Crider                                
c     DATE WRITTEN - January 28, 1991
c                                                          
c                AMOCO PRODUCTION CO. PROPRIETARY
c                 TO BE MAINTAINED IN CONFIDENCE
c                                                        
c     ABSTRACT - Compute weighted stack equivalents for B0 and B1
c                using least squares solution for truncated
c                Aki and Richards eqn             
c           R()=B0 + B1*tan^2(theta)+(-B1+B0/(c+1))tan^2*sin^2
c                     or
c           R()=B0(1.+1./(1+c)*tan^2*sin^2)+B1*sin^2
c                                                            
c     USAGE                                                 
c                                                          
c       call WeightStackAB(nsamp,ntr, data, stacka, 
c                     stackb, angles, astrt,aend,c,ier)
c                                                       
c            nsamp    =  Number of samples per trace (rows)
c              ntr    =  Number of traces per record (columns)
c              data   =  Matrix of trace data
c             stacka  =  Returned weighted stack for B0
c             stackb  =  Returned weighted stack for B1
c             angles  =  Matrix of incident angles from ray tracing
c             astrt   =  Start angle for sum for angle-limited stack
c             aend    =  End angle for sum for angle-limited stack
c              C      =  User-supplied constant from Gardner relation
c                        for Vp-density (density=K*V^C)
c             IERR    =  Error flag 
c                                                      
c     ERROR/RETURN CODES - ier                 
c                          1 = singular matrix
c                                              
c***************************************************************
      subroutine WeightAB(nsamp,ntr, data, 
     :  stacka, stackb, angles,astrt,aend,c, vp,ier)
#include <localsys.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
c                                                            
      real data(*), stacka(nsamp), stackb(nsamp)
      real angles(*),astrt,aend,c,vp(*)
      integer ier
      real Sxx1, Sxx2, Sx1y, Sx2y

c +===========================+
c | Build the matrix elements |
c | Get the solutions         |
c +===========================+
      add = 1./(1.+c)
      vp1 = vp(1)
      do i=1,nsamp
       Sxx1  = 0.
       Sxx2  = 0.
       Sx1y  = 0.
       Sx2y  = 0.
       Sx1x2 = 0.
       n     = 0
       vp2 = vp(i)
       vc = vp1/vp2
       do j=1,ntr
        indx=(j-1)*nsamp+i
        theta=angles(indx)
        y = data(indx)
        sine = sin(theta)
        tang = tan(theta)
*       if(sine.gt.vc)y=0.
        if(theta.ge.astrt.and.theta.le.aend.and.y.ne.0.0)then
         sine = sine*sine
         tang = tang*tang
         ax1 = (1.0 + add*tang*sine)
         ax2 = sine
         if(c.eq.0.0)ax2=tang
         Sxx1 = Sxx1 + ax1*ax1
         Sxx2 = Sxx2 + ax2*ax2
         Sx1x2 = Sx1x2 + ax1*ax2
         Sx1y  = Sx1y + ax1*y
         Sx2y  = Sx2y + ax2*y
         n = n + 1
        endif
       end do
       if(n.ge.3)then
        D = Sx1x2*Sx1x2 - Sxx1*Sxx2
        x1 = Sx2y*Sx1x2 - Sx1y*Sxx2
        x2 = Sx1x2*Sx1y - Sx2y*Sxx1
        if(D.ne.0)then
         stacka(i)=x1/D
         stackb(i)=x2/D
        else
         stacka(i)=0.
         stackb(i)=0.
        endif
       else
        stacka(i)=0.
        stackb(i)=0.
       endif
       vp1 = vp2
      end do
      return
      end
c******************************************************************
c                                                                 
c     SUBROUTINE - WeightStackIJ 
c                                                               
c     LANGUAGE - FORTRAN 77                                    
c     SYSTEM(S) - SUN, CRAY2                                         
c     AUTHOR - Richard Crider                                
c     DATE WRITTEN - January 28, 1991
c                                                          
c                AMOCO PRODUCTION CO. PROPRIETARY
c                 TO BE MAINTAINED IN CONFIDENCE
c                                                        
c     ABSTRACT - Compute weighted stack equivalents for delVp/Vp
c                and delVs/Vs using Smith and Gidlow (1987) solution
c                for A and B in the equation
c                   R()=A*delVp/Vp + B*delVs/Vs
c                       A=0.5*(1+tan^2+c-cKsin^2)
c                       B=-K*sin^2, where 
c                       K = (2*Vs/Vp)^2
c                                                            
c     USAGE                                                 
c                                                          
c        call WeightStackIJ(nsamp,ntr, data, stacka, 
c          stackb, ratio, angles, astrt,aend,c,ier)
c                                                       
c            nsamp    =  Number of samples per trace (rows)
c              ntr    =  Number of traces per record (columns)
c              data   =  Matrix of trace data
c             ratio   =  Vs/Vp ratio squared vector
c             stacka  =  Returned weighted stack for delVp/Vp
c             stackb  =  Returned weighted stack for delVs/Vs
c             angles  =  Matrix of incident angles from ray tracing
c             astrt   =  Start angle for sum for angle-limited stack
c             aend    =  End angle for sum for angle-limited stack
c               c     =  Gardner coefficient (rho = K*Vp^c)
c             IERR    =  Error flag to be returned by crvray(creray)
c                                                      
c     ERROR/RETURN CODES - ier                 
c                          .ne. 0 = memory allocation error
c                                              
c***************************************************************
      subroutine WeightIJ(nsamp,ntr, data,
     *  stacka, stackb, ratio,angles,astrt,aend,c,vp, ier)
#include <localsys.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
c                                                            
      real data(*), stacka(nsamp), stackb(nsamp),ratio(*)
      real angles(*),astrt,aend,c,vp(*)
      integer ier
      real Sxx1, Sxx2, Sx1y, Sx2y
      real K

c +===========================+
c | Build the matrix elements |
c | Get the solutions         |
c +===========================+
      vp1 = vp(1)
      do i=1,nsamp
       Sxx1  = 0.
       Sxx2  = 0.
       Sx1y  = 0.
       Sx2y  = 0.
       Sx1x2 = 0.
       n     = 0
       K = ratio(i)*4.
       vp2 = vp(i)
       vc = vp1/vp2
       do j=1,ntr
        indx=(j-1)*nsamp+i
        theta=angles(indx)
        y = data(indx)
        sine = sin(theta)
        tang = tan(theta)
*       if(sine.gt.vc)y=0.
        if(theta.ge.astrt.and.theta.le.aend.and.y.ne.0.0)then
         sine = sine*sine
         tang = tang*tang
         ax1 = 0.5*(1.0 + tang + c *(1. - K*sine))
         ax2 = -sine*K
         Sxx1 = Sxx1 + ax1*ax1
         Sxx2 = Sxx2 + ax2*ax2
         Sx1x2 = Sx1x2 + ax1*ax2
         Sx1y  = Sx1y + ax1*y
         Sx2y  = Sx2y + ax2*y
         n = n + 1
        endif
       end do
       if(n.ge.3)then
        D = Sx1x2*Sx1x2 - Sxx1*Sxx2
        x1 = Sx2y*Sx1x2 - Sx1y*Sxx2
        x2 = Sx1x2*Sx1y - Sx2y*Sxx1
        if(D.ne.0)then
         stacka(i)=x1/D
         stackb(i)=x2/D
        else
         stacka(i)=0.
         stackb(i)=0.
        endif
       else
        stacka(i)=0.
        stackb(i)=0.
       endif
       vp1 = vp2
      end do
      return
      end
c*****************************************************************
c                                                                 
c     SUBROUTINE - WeightStackB0
c                                                               
c     LANGUAGE - FORTRAN 77                                    
c     SYSTEM(S) - SUN, CRAY2                                         
c     AUTHOR - Richard Crider                                
c     DATE WRITTEN - January 28, 1991
c                                                          
c                AMOCO PRODUCTION CO. PROPRIETARY
c                 TO BE MAINTAINED IN CONFIDENCE
c                                                        
c     ABSTRACT - Compute weighted stack equivalents for B0, B1, and
c                B2 using least squares solution for Aki and Richards
c                eqn             
c                   R()=A*B0 + B*B1 + C*B2
c                     A = 1.0
c                     B = tan^2(theta)
c                     C = tan^2(theta) * sin^2(theta)
c                                                            
c     USAGE                                                 
c                                                          
c       call WeightStackB0(nsamp,ntr, data, stacka, 
c                     stackb, stackc, angles, astrt,aend,ier)
c                                                       
c            nsamp    =  Number of samples per trace (rows)
c              ntr    =  Number of traces per record (columns)
c              data   =  Matrix of trace data
c             stacka  =  Returned weighted stack for B0
c             stackb  =  Returned weighted stack for B1
c             stackc  =  Returned weighted stack for B2
c             angles  =  Matrix of incident angles from ray tracing
c             astrt   =  Start angle for sum for angle-limited stack
c             aend    =  End angle for sum for angle-limited stack
c             IERR    =  Error flag 
c                                                      
c     ERROR/RETURN CODES - ier                 
c                          .ne. 0 = memory allocation error
c                                              
c***************************************************************
      subroutine WeightB0(nsamp,ntr, data,
     :  stacka, stackb, stackc, ratio, angles,astrt,aend, vp,
     :  ier)
#include <localsys.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
c                                                            
      real data(*), stacka(nsamp), stackb(nsamp),vp(*)
      real ratio(*),angles(*),astrt,aend, stackc(nsamp)
      real*8  Sxx1,Sxx2,Sx1y,Sx2y,Sx1x2,Sxx3,Sx1x3,Sx2x3
      real*8  ax1, ax2, ax3, D
      integer ier
c +===========================+
c | Build the matrix elements |
c | Get the solutions         |
c +===========================+
      vp1 = vp(1)
      do i=1,nsamp
       Sxx1 = 0.
       Sxx2 = 0.
       Sxx3  = 0.
       Sx1x2 = 0.
       Sx1x3 = 0.
       Sx2x3 = 0.
       Sx1y  = 0.
       Sx2y  = 0.
       Sx3y  = 0.
       n     = 0
       vp2 = vp(i)
       vc = vp1/vp2
       do j=1,ntr
        indx=(j-1)*nsamp+i
        theta=angles(indx)
        y = data(indx)
        sine = sin(theta)
        tang = tan(theta)
        sine = sine*sine
        tang = tang*tang
*       if(sine.gt.vc)y = 0.
        if(theta.ge.astrt.and.theta.le.aend.and.y.ne.0.0)then
         ax1 = 1.
         ax2 = tang
         ax3 = sine*tang
         Sxx1  = Sxx1  + ax1*ax1
         Sxx2  = Sxx2  + ax2*ax2
         Sxx3  = Sxx3  + ax3*ax3
         Sx1x2 = Sx1x2 + ax1*ax2
         Sx1x3 = Sx1x3 + ax1*ax3
         Sx2x3 = Sx2x3 + ax2*ax3
         Sx1y  = Sx1y + ax1*y
         Sx2y  = Sx2y + ax2*y
         Sx3y  = Sx3y + ax3*y
         n = n+1
        endif
       end do
       if(n.ge.4)then
        D = Sxx1*Sxx2*Sxx3-Sxx1*Sx2x3*Sx2x3-Sx1x2*Sx1x2*Sxx3
        D = D + Sx1x2*Sx2x3*Sx1x3
        D = D + Sx1x3*Sx1x2*Sx2x3 - Sx1x3*Sx1x3*Sxx2
        x1 = Sx1y*(Sxx2*Sxx3-Sx2x3*Sx2x3)
        x1 = x1 - Sx1x2*(Sx2y*Sxx3 - Sx3y*Sx2x3)
        x1 = x1 + Sx1x3*(Sx2y*Sx2x3 - Sx3y*Sxx2)
        x2 = Sxx1*(Sx2y*Sxx3 - Sx3y*Sx2x3)
        x2 = x2 - Sx1y*(Sx1x2*Sxx3 - Sx1x3*Sx2x3)
        x2 = x2 + Sx1x3*(Sx1x2*Sx3y - Sx2y*Sx1x3)
        x3 = Sxx1*(Sxx2*Sx3y - Sx2y*Sx2x3)
        x3 = x3 - Sx1x2*(Sx1x2*Sx3y - Sx1x3*Sx2y)
        x3 = x3 + Sx1y*(Sx1x2*Sx2x3 - Sx1x3*Sxx2)
        if(D.ne.0)then
         stacka(i)=x1/D
         stackb(i)=x2/D
         stackc(i)=x3/D
        else
         stacka(i)=0.
         stackb(i)=0.
         stackc(i)=0.
        endif
       else
        stacka(i)=0.
        stackb(i)=0.
        stackc(i)=0.
       endif
       vp1 = vp2
      end do
      return
      end
c*****************************************************************
c                                                                 
c     SUBROUTINE - WeightStackVrho
c                                                               
c     LANGUAGE - FORTRAN 77                                    
c     SYSTEM(S) - SUN, CRAY2                                         
c     AUTHOR - Richard Crider                                
c     DATE WRITTEN - January 28, 1991
c                                                          
c                AMOCO PRODUCTION CO. PROPRIETARY
c                 TO BE MAINTAINED IN CONFIDENCE
c                                                        
c     ABSTRACT - Compute weighted stack equivalents for delVp/Vp,
c                delVs/Vs, and delrho/rho using least squares solution
c                for Aki and Richards eqn             
c           R()=A*delVp/Vp + B*delVs/Vs + C * delrho/rho
c             A = 0.5*(1.+ tan^2(theta))
c             B = -K*sin^2(theta)
c             C = +0.5 * (1.0 - K*sin^2(theta))
c             K = 4*(Vs/Vp)^2
c                                                            
c     USAGE                                                 
c                                                          
c       call WeightStackVrho(nsamp,ntr, data, stacka, 
c                     stackb, stackc, ratio, angles, astrt,aend,ier)
c                                                       
c            nsamp    =  Number of samples per trace (rows)
c              ntr    =  Number of traces per record (columns)
c              data   =  Matrix of trace data
c             ratio   =  Vs/Vp ratio squared vector
c             stacka  =  Returned weighted stack for delVp/Vp
c             stackb  =  Returned weighted stack for delVs/Vs
c             stackc  =  Returned weighted stack for delrho/rho
c             angles  =  Matrix of incident angles from ray tracing
c             astrt   =  Start angle for sum for angle-limited stack
c             aend    =  End angle for sum for angle-limited stack
c             IERR    =  Error flag 
c                                                      
c     ERROR/RETURN CODES - ier                 
c                          .ne. 0 = memory allocation error
c                                              
c***************************************************************
      subroutine WeightVrho(nsamp,ntr, data,
     :  stacka, stackb, stackc, ratio, angles,astrt,aend, 
     :  ier)
#include <localsys.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
c                                                            
      real data(*), stacka(nsamp), stackb(nsamp),stackc(nsamp)
      real ratio(*),angles(*),astrt,aend
      real K
      real *8 Sxx1, Sxx2,Sxx3,Sx1x2,Sx1x3,Sx2x3,Sx1y,Sx2y,Sx3y
      real *8 ax1, ax2, ax3, D
      integer ier
c +===========================+
c | Build the matrix elements |
c | Get the solutions         |
c +===========================+
      do i=1,nsamp
       Sxx1  = 0.
       Sxx2  = 0.
       Sxx3  = 0.
       Sx1x2 = 0.
       Sx1x3 = 0.
       Sx2x3 = 0.
       Sx1y  = 0.
       Sx2y  = 0.
       Sx3y  = 0.
       n = 0
       do j=1,ntr
        indx=(j-1)*nsamp+i
        theta=angles(indx)
        y = data(indx)
        if(theta.ge.astrt.and.theta.le.aend.and.y.ne.0.0)then
         K = -ratio(i)*4.
         sine = sin(theta)
         sine = sine*sine
         tang = tan(theta)
         tang = tang*tang
         ax1 = 0.5*(1.0 + tang)
         ax2 = -K*sine
         ax3 = 0.5*(1.0 - K*sine)
         Sxx1 = Sxx1 + ax1*ax1
         Sxx2 = Sxx2 + ax2*ax2
         Sxx3 = Sxx3 + ax3*ax3
         Sx1x2 = Sx1x2 + ax1*ax2
         Sx1x3 = Sx1x3 + ax1*ax3
         Sx2x3 = Sx2x3 + ax2*ax3
         Sx1y  = Sx1y + ax1*y
         Sx2y  = Sx2y + ax2*y
         Sx3y  = Sx3y + ax3*y
         n = n+1
        endif
       end do
       if(n.ge.4)then
        D = Sxx1*Sxx2*Sxx3-Sxx1*Sx2x3*Sx2x3-Sx1x2*Sx1x2*Sxx3
        D = D + Sx1x2*Sx2x3*Sx1x3
        D = D + Sx1x3*Sx1x2*Sx2x3 - Sx1x3*Sx1x3*Sxx2
        x1 = Sx1y*(Sxx2*Sxx3-Sx2x3*Sx2x3)
        x1 = x1 - Sx1x2*(Sx2y*Sxx3 - Sx3y*Sx2x3)
        x1 = x1 + Sx1x3*(Sx2y*Sx2x3 - Sx3y*Sxx2)
        x2 = Sxx1*(Sx2y*Sxx3 - Sx3y*Sx2x3)
        x2 = x2 - Sx1y*(Sx1x2*Sxx3 - Sx1x3*Sx2x3)
        x2 = x2 + Sx1x3*(Sx1x2*Sx3y - Sx2y*Sx1x3)
        x3 = Sxx1*(Sxx2*Sx3y - Sx2y*Sx2x3)
        x3 = x3 - Sx1x2*(Sx1x2*Sx3y - Sx1x3*Sx2y)
        x3 = x3 + Sx1y*(Sx1x2*Sx2x3 - Sx1x3*Sxx2)
        if(D.ne.0)then
         stacka(i)=x1/D
         stackb(i)=x2/D
         stackc(i)=x3/D
        else
         stacka(i)=0.
         stackb(i)=0.
         stackc(i)=0.
        endif
       else
        stacka(i)=0.
        stackb(i)=0.
        stackc(i)=0.
       endif
      end do
      return
      end
