C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c -----------------  Subroutine -----------------------

c pick up command line arguments 

      subroutine cmdln ( ntap, otap, irs, ire, ist, iend, f1, df, nfr, 
     :     name, Linear, Quadratic, Play, Play_nsampo, scal, 
     :     ssam, verbos )

#include <f77/iounit.h>

      integer    ist, iend, irs, ire, argis, nfr, Play_nsampo

      real       f1, df, scal

      character  ntap*(*), otap*(*), name*(*)

      logical    Linear, Quadratic, Play, verbos, ssam

           call argr4 ( '-df', df, 2.0, 2.0 )

           call argi4 ( '-e', iend, 0, 0 )

           call argr4 ( '-f1', f1, 5.0, 5.0 )

           call argr4 ( '-gscal', scal, 9.0, 9.0 )

           call argi4 ( '-nf', nfr, 20, 20 )
           call argstr ( '-N', ntap, ' ', ' ' ) 

           call argstr ( '-O', otap, ' ', ' ' ) 

           call argi4 ( '-play_nsamp', Play_nsampo, 0, 0 )
           Play = (argis('-play') .gt. 0)

           Linear = .true.
           Quadratic = (argis('-Q') .gt. 0)
           if ( Quadratic ) Linear = .false.
           
           call argi4 ( '-re', ire, 0, 0 )
           call argi4 ( '-rs', irs, 0, 0 )

           call argi4 ( '-s', ist, 1, 1 )
           ssam = (argis('-ssam') .gt. 0)

           verbos = (argis('-V') .gt. 0)

c check for extraneous arguments and abort if found to
c catch all manner of user typo's

      call xtrarg ( name, ler, .FALSE., .FALSE. )
      call xtrarg ( name, lerr, .FALSE., .TRUE. )

           
      return
      end
