C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c--------------------------- subroutine gtf ----------------------------
c  subroutine to compute gaussian taper where half amplitude of
c  gaussian is given by the parameter scal

      subroutine gtf ( gtab, nsmp, tcnt, scal )

      integer nsmp
      real gtab(nsmp), scal, tcnt
      parameter (pi=3.141592654 )

      hamp = -alog(0.5)
      alft = scal**2/(4.0*hamp)
      asct = 10./(2.0*sqrt(pi*alft))
      alfw = 1.0/alft
      ascw = 1.0/(2.0*sqrt(pi*alfw))
        do ismp = 1,nsmp
        t2 = (tcnt - real(ismp))**2
        gtab(ismp) = asct*exp(-t2/(4.0*alft))
        wtab = ascw*exp(-t2/(4.0*alfw))
        enddo
      gnrm = 0.0
        do ismp = 1,nsmp
        gnrm = gnrm + gtab(ismp)
        enddo
        do ismp = 1,nsmp
        gtab(ismp) = gtab(ismp)/gnrm
        enddo
      return
      end
c-----------------------------------------------------------------------
