C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
       SUBROUTINE ASIG(R,Q,SAMP,NSAMP,NOP,DATA)
C
C  JH BODINE  7/81
C
C  Returns desired complex trace attribute
C        R = Seismic trace
C     SAMP = Sample interval
C    NSAMP = No. samples per trace
C      NOP = Desired attribute
C          = 1 Seismic trace
C          = 2 Quadrature
C          = 3 Envelope
C          = 4 Inst. Phase
C          = 5 Response Phase
C          = 6 Inst. Frequency
C          = 7 Response Frequency
C          = 8 0-Phase Decomposition
C          = 9 90-Phase Decomposition
C          = 10 Response Amplitude
C          = 11 Response length
C          = 12 Envelope skewness
C          = 13 Envelope rise time
C
C     DATA = Output attribute
C
      DIMENSION DATA(4096)
      DIMENSION R(4096),Q(4096),DUM(4096)
C     DIMENSION F(4096),A(4096),FREQ(4096),PH(4096)
      DIMENSION A(4096),FREQ(4096),PH(4096)
C
      PI = 3.14159265
      RADDEG = 360./(2.*PI)
C
      NF = 101
      WC = 3
      NZ = NF + NSAMP
C
C
C Calculate quadrature.
C
      CALL HILBRT(NZ,NF,WC,DUM,SAMP,NSAMP,R,Q)
C
C Calculate envelope, inst. phase, inst. freq.
C
      DO 10 I = 1,NSAMP
         A(I) = 0.
         IF(R(I).NE.0. .AND. Q(I).NE.0.) A(I) = (R(I)**2 + Q(I)**2)**.5
         PH(I) = PHAS(R(I),Q(I)) * RADDEG
C        IF(PH(I).GT.180.) PH(I) = PH(I) - 360.
         FREQ(I) =  XFREQ(R,Q,SAMP,NSAMP,I)/(2.*PI)
         DATA(I) = A(I)
   10 CONTINUE
      PH(1)=PH(2)
C
C Route to attribute to be calculated
C Real trace, quadrature, envelope amp., phase, inst. freq
C
      GO TO (20,40,60,70 ,90 ,100,120,130,130,160,170,180,190), NOP
C
C Seismic trace
C
   20 CONTINUE
      DO 30 I=1,NSAMP
         DATA(I)=R(I)
   30 CONTINUE
      GO TO 200
C
C Quadrature
C
   40 CONTINUE
      DO 50 I=1,NSAMP
         DATA(I)=Q(I)
   50 CONTINUE
      GO TO 200
C
C Envelope
C
   60 CONTINUE
      GO TO 200
C
C Inst. phase
C
   70 CONTINUE
      DO 80  I=1,NSAMP
         DATA(I)= PH(I)
   80 CONTINUE
      GO TO 200
C
C Resp. phase
C
   90 CONTINUE
      CALL RPHS(PH,DATA,NSAMP)
      GO TO 200
C
C Inst. frequency
C
  100 CONTINUE
      DO 110 I=1,NSAMP
C 125    DATA(I) = FREQ(I)
         DATA(I) = -1.0*FREQ(I)
  110 CONTINUE
      GO TO 200
C
C Response frequency
C
  120 CONTINUE
      CALL PKDT(FREQ,DATA,NSAMP)
C
C Calculate 0 and 90 phase decomposed signals.
C
  130 CONTINUE
  140 CALL RPHS(PH,DATA,ISAMP)
      CALL QCON(R,Q,DATA,ISAMP)
      DO 150 I=1,ISAMP
         IF (NOP.EQ.8) DATA(I) = R(I)
         IF (NOP.EQ.9) DATA(I) = Q(I)
  150 CONTINUE
      GO TO 200
C
C Calculate response amplitude
C
  160 CONTINUE
      CALL PKDT(A,DATA,ISAMP)
      GO TO 200
C
C Calculate length of each envelope lobe.
C
  170 CONTINUE
      CALL ALEN(DATA,ISAMP)
      GO TO 200
C
C Calculate skewness of envelope lobe
C
  180 CONTINUE
      CALL ASKW(DATA,ISAMP)
      GO TO 200
C
C Calculate max slope of envelope lobe
C
  190 CONTINUE
      CALL ASLP(DATA,ISAMP)
C
  200 CONTINUE
C
      RETURN
      END
