C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE GETFAC(F,ANGLE,WEIGHT,TYPE,Q,DELTAT,SCALEP,SCALEA,
     :                  IERROR)
C
C Routine to let user calculate the scaler(s) needed to true amplitude
C correct a FILT1D filtered dataset.  Arguments are as described below:
C
C     F(4)   - Ormsby filter representing actual data
C     ANGLE  - Phase angle
C     WEIGHT - 0 = no weight
C              1 = apply weighting
C     TYPE   - 0 = Ross
C              1 = Bartlett
C     Q      - Ross exponent
C     DELTAT - Sample interval
C     SCALEP - Scaler required to match peak value to R.C.
C     SCALEA - Scaler required to match area (sum) to R.C.
C     IERROR - 0 = all OK
C              1 = error occured calculating scalers
C
      REAL    F(4),SCALEP,SCALEA,DELTA(256),TRACE(256),DELTAT,SUM
      REAL    ANGLE,Q
      INTEGER I,ISTART,ISTOP,NSAMP,WEIGHT,TYPE,IERROR
      IERROR = 0
      NSAMP = 255
C
C Null input trace
C
      DO 10 I=1,NSAMP
          DELTA(I) = 0.0
   10 CONTINUE
      DELTA(128) = 1.0
C
C Filter DELTA into TRACE with F
C
      CALL FILT1D(DELTA,TRACE,NSAMP,DELTAT,F,ANGLE,WEIGHT,TYPE,Q)
C
C Find peak scaler, SCALEP
C
      IF(TRACE(128).NE.0.0) THEN
          SCALEP = 1.0 / TRACE(128)
      ELSE
          SCALEP = 1.0
          IERROR = 1
      ENDIF
C
C Find area scaler, SCALEA
C     Find upper zero crossing
C
      DO 20 I=NSAMP/2,1,-1
          IF(TRACE(I).LT.0.0) GOTO 30
   20 CONTINUE
C
C     Target for upper zero crossing found
C
   30 CONTINUE
C
C     Set index of first positive sample in lobe
C
      ISTART = I+1
C
C     Find lower zero crossing
C
      DO 40 I=128,NSAMP
          IF(TRACE(I).LT.0.0) GOTO 50
   40 CONTINUE
C
C     Target for lower zero crossing found
C
   50 CONTINUE
C
C     Set index of last positive sample in lobe
C
      ISTOP = I-1
C
C     Sum samples over the lobe
C
      SUM = 0.0
      DO 60 I=ISTART,ISTOP
          SUM = SUM + TRACE(I)
   60 CONTINUE
C
C     Assign scaler SCALEA
C
      IF(SUM.NE.0.0) THEN
          SCALEA = 1.0 / SUM
      ELSE
          SCALEA = 1.0
          IERROR = 1
      ENDIF
C
      RETURN
      END
