C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine gruns(data,c0,c1,x,runs,nsampn)
      real data(*),c0,c1,x(*),runs
      real line(4096),count
      integer nsampn
      integer nsamp,osign
C 
C This routine measures the number of "runs" of points on each side
C of a least squares fitted line.  The "runs" are normalized by the 
C number of points in the curve "data".
C
C 25 April 1994, R. O. Lindsay.
C
C data(*) - input array of points
C c0      - intercept of line
C c1      - slope of line
C x(*)    - independent variable
C runs    - normalized number of runs in data(*)
C nsampn  - number of points in data(*)
C
C Test that 0 < nsamp < 4097.
C
      if(nsampn.lt.1) return
      if(nsampn.gt.4096) then
          nsamp = 4096
      else
          nsamp = nsampn
      endif
C
C Synthesize the curve from the linear equation.
C
      do 10 i=1,nsamp
          line(i) = c0 + c1 * x(i)
   10 continue
C
C Count the number of runs.
C
      count = 1.0
      if(data(1) - line(1).gt.0.0) then
          osign = 1
      else
          osign = -1
      endif
      do 20 i=2,nsamp
          if(data(i) - line(i).gt.0.0) then
              if(osign.eq.-1) count = count + 1.0
              osign = 1
          else
              if(osign.eq. 1) count = count + 1.0
              osign = -1
          endif
   20 continue
C
C Normalize "count" into "runs".
C
      runs = count / float(nsamp)
C
C Return to calling object.
C
      return
      end
