C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE HILF(TDEL,WC,LF,F)
C                            FORTRAN BY KEN PEACOCK  11-11-76
C      Subroutine HILF constructs the operator for Hilbert
C      transformation. Weighting is available on option.
C         Inputs are:
C           TDEL = Sample increment in seconds
C             WC = 0 output raw operator
C                NE 0 use a Ross weight function with exponent WC
C             LF = Length of filter in samples (Must be odd)
C        Output is:
C              F = The LF-LENGTH output array
C      Coded for the IBM 370/158 computer
C      Version as of 11-11-76
C
      DIMENSION F(1)
      N = LF/2
      ISTA = N+2
      KFACT = 1-ISTA
      JFACT = LF+1
      DO 10 I=1,LF
         F(I) = 0.
   10 CONTINUE
      FACT = -2./(TDEL*3.14159265)
      DO 20 I=1,N,2
         J = N+1+I
         K = N+1-I
         F(J) = FACT/I
         F(K) = -F(J)
   20 CONTINUE
      IF(WC.EQ.0.) GO TO 40
      DO 30 I=ISTA,LF
         AK = I+KFACT
         F(I) = F(I)*((1.-(AK/N)**2)**WC)
         J = JFACT-I
         F(J) = -F(I)
   30 CONTINUE
   40 CONTINUE
      RETURN
      END
