C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE LMODEA(TRACE,W0,NSAMP,IMODE)
      INTEGER NSIL,NSAMP,IMODE,OSIGN,NSIGN,I,J,K
      REAL TRACE(*),W0(*),SUM,MAX,TEMP
C
C Calculate response values, etc. using TRACE as a guide replacing
C W0 with output samples.  Using IMODE as below:
C     IMODE =  3 = square value = sum
C     IMODE =  2 = square value = center
C     IMODE =  1 = square value = max
C     IMODE =  0 = NO OPERATION
C     IMODE = -1 =  spike value = max    at time = max
C     IMODE = -2 =  spike value = center at time = center
C     IMODE = -3 =  spike value = sum    at time = max
C     IMODE = -4 =  spike value = sum    at time = center
C
C Preset constants and variables
C
      NSIL = 0
      IF(TRACE(1).GE.0.0) THEN
          OSIGN = 1
      ELSE
          OSIGN = -1
      ENDIF
C
C Sample-by-sample loop
C
      DO 70 I=1,NSAMP
C
C     Find the lobes
C         Set the NSIGN for the sample
C
          IF(TRACE(I).GT.0.0) THEN
              NSIGN = 1
          ELSE
              NSIGN = -1
          ENDIF
C
C         Is the polarity the same?
C
          IF(NSIGN.EQ.OSIGN) THEN
C
C             Yes - still in lobe, add 1 to NSIL counter
C
              NSIL = NSIL + 1
          ELSE
C
C             No - end of lobe so calculate values
C
              IF(IMODE.EQ.1.OR.IMODE.EQ.-1.OR.IMODE.EQ.-3) THEN
C
C                 Find index K, for the maximum absolute sample values
C
                  MAX = 0.0
                  DO 10 J=I-NSIL+1,I
                      IF(ABS(TRACE(J)).GT.MAX) THEN
                          MAX = ABS(TRACE(J))
                          K = J
                      ENDIF
   10             CONTINUE
              ENDIF
C
              IF(IMODE.EQ.2.OR.IMODE.EQ.-2.OR.IMODE.EQ.-4) THEN
C
C                 Find index K, for the center sample value
C
                   K = I - NSIL / 2
              ENDIF
C
C     Apply the changes to W0
C
              IF(IMODE.EQ.3) THEN
C
C                 Total the sample values
C
                  SUM = 0.0
                  DO 20 J=I-NSIL+1,I
                      SUM = SUM + W0(J)
   20             CONTINUE
C
C                 Assign sum to each sample in the lobe
C
                  DO 30 J=I-NSIL+1,I
                      W0(J) = SUM
   30             CONTINUE
                  NSIL = 0
              ENDIF
C
              IF(IMODE.EQ.2.OR.IMODE.EQ.1) THEN
C
C                 Assign W0(K) to each sample in the lobe
C
                  DO 40 J=I-NSIL+1,I
                      W0(J) = W0(K)
   40             CONTINUE
                  NSIL = 0
              ENDIF
C
              IF(IMODE.EQ.-2.OR.IMODE.EQ.-1) THEN
C
C                 Zero lobe then assign W0(K) to a single sample at K
C
                  TEMP = W0(K)
                  DO 50 J=I-NSIL+1,I
                      W0(J) = 0.0
   50             CONTINUE
                  W0(K) = TEMP
                  NSIL = 0
              ENDIF
C
              IF(IMODE.EQ.-4.OR.IMODE.EQ.-3) THEN
C
C                 Total the sample values
C
                  SUM = 0.0
                  DO 60 J=I-NSIL+1,I
                      SUM = SUM + W0(J)
   60             CONTINUE
C
C                 Zero lobe then assign W0(K) to the sum
C
                  W0(K) = SUM
                  NSIL = 0
              ENDIF
          ENDIF
   70 CONTINUE
      RETURN
      END
