C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       MNMX                                                 *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  TO PICK RELATIVE MINIMA AND MAXIMA FOR INPUT FUNCTION.    *
C  ENTRY POINTS:                                                       *
C      MNMX  (A,NPT,IPEAK,JP,ITRF,JT)                                  *
C  ARGUMENTS:                                                          *
C      A       REAL         I*  (1) - INPUT ARRAY TO SCAN FOR MIN/MAX  *
C      NPT     INTEGER      I*      - NUMBER OF SAMPLES IN ARRAY 'A'   *
C      IPEAK   INTEGER      O*  (1) - INDEX  ARRAY OF RELATIVE PEAKS   *
C      JP      INTEGER      O*      - NUMBER OF RELATIVE PEAKS IN IPEAK*
C      ITRF    INTEGER      O*  (1) - INDEX  ARRAY OF RELATIVE TROUGHS *
C      JT      INTEGER      O*      - NUMBER OF REL TROUGHS IN ITRF    *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   J. NORRIS                          ORIGIN DATE: 83/06/03  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 90/10/15  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  IF NPT <=1, SUBROUTINE IS NOT EXECUTED.            *
C  GENERAL DESCRIPTION:  EVERY PEAK OR TROUGH IS FOUND REGARDLESS OF   *
C       AMPLITUDE.  THIS CODE ADAPTED FROM PKDT AND RPHS BY J.H.BODINE.*
C       +------------------------------------------------------+       *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
      SUBROUTINE MNMX(A,NPT,IPEAK,JP,ITRF,JT)
      DIMENSION A(1), ITRF(1), IPEAK(1)
C
      JT = 0
      JP = 0
      SLOP = 0.
      ILAST=0
C
C Find array positions of maxima and minima after cheching valid loop
C index.
C
      NPT1 = NPT-1
      IF(NPT1.LE.0) GO TO 30
      DO 20  I=1,NPT1
         SLAST = SLOP
         SLOP = A(I+1)-A(I)
         CHNG = SLAST*SLOP
         IF (CHNG.GT.0.) GO TO 20
         IF (SLOP.EQ.0..AND.SLAST.EQ.0.) GO TO 20
         IF (SLAST.LE.0..AND.SLOP.GE.0.) GO TO 10
C
C Here for a peak. Check for two consecutive peaks. Ignore subsequent
C until a trough is found. ILAST=1 for peak.
C
         IF(ILAST.EQ.1)GO TO 20
         JP = JP+1
         IPEAK(JP) = I
         ILAST=1
         GO TO 20
C
C Here for a trough. See if peak already picked first. Calling routines
C expect first point of zero slope to be peak. Check for two consecutive
C troughs. Ignore subsequent troughs until a peak is found.
C ILAST=-1 for trough.
C
   10    IF (JP.EQ.0) GO TO 20
         IF(ILAST.EQ.-1)GO TO 20
         JT = JT+1
         ITRF(JT) = I
         ILAST=-1
   20 CONTINUE
C
C Assign last point of trough array to be last sample. If no peaks
C found, default set JP to one point.
C
      ITRF(JT+1) = NPT
C
   30 CONTINUE
      IF(JP.EQ.0)JP=1
      RETURN
      END
