C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine ofa1d(arrayn,arrayo,points,deltat,f,filtfa,filtfp)
      real arrayn(*),arrayo(*),deltat,f(*),filtfa(*),filtfp(*)
      real datat(4096),datafa(2048),datafp(2048),fn,deltaf,total
      real ave
      integer points
      integer i,j,nsamp
C
C This routine applies an Ormsby filter in the frequency domain
C returning a filtered array.  The input array is arrayn.  The
C output array is arrayo.  Both in and out arrays are points
C long.  Deltat is the time sample interval. From points and
C deltat the frequency sample interval is calculated.  F is the
C four ormsby filter points with only f2 being used to determin 
C if the DC bias needs to be reapplied to arrayo.  Filtfa and
C filtfp are the filter.  The "a" indicates amplitude while the
C "p" indicates phase.
C
C Filter is a 19 April 1994 revision of the 8 May 1990 Lindsay and
C Kelly FILT1D filter algorithm.
C
C Find Nyquist frequency, fn
C
      fn = 1.0 / (2.0 * deltat)
C
C Find size of the input array and set nsamp to the next higher
C integer power of 2.
C
      j=1
   10 continue
      if(2**j.ge.points) goto 20
      if(2**j.eq.4096) goto 20
      j=j+1
      goto 10
   20 continue
      nsamp = 2**j
C
C Pad zeros on the input array, if needed
C
      do 30 i=1,nsamp
          datat(i) = 0.0
   30 continue
      do 40 i=1,points
          datat((nsamp-points)/2+i) = arrayn(i)
   40 continue
C
C Find deltaf
C
      deltaf = fn / float(nsamp/2)
C
C Remove average value (DC) from data
C
      total = 0.0
      do 50 i=1,nsamp
          total = total + datat(i)
   50 continue
      ave = total / float(nsamp)
      do 60 i=1,nsamp
          datat(i) = datat(i) - ave
   60 continue
C
C Transform DATAT to frequency
C
      call fftmck(datat,datafa,datafp,nsamp,+1)
C
C Apply filter
C
      do 70 i=1,nsamp/2
          datafa(i) = datafa(i) * filtfa(i)
          datafp(i) = datafp(i) + filtfp(i)
   70 continue
C
C Transform DATAT back to time
C
      call fftmck(datat,datafa,datafp,nsamp,-1)
C
C Replace DC bias if f2=0
C
      if(f(2).eq.0.0) THEN
          do 80 i=1,nsamp
              datat(i) = datat(i) + ave
   80     continue
      endif
C
C Remove padded zeros from output array, if needed
C
      if(points.eq.nsamp) then
          do 90 i=1,nsamp
              arrayo(i) = datat(i)
   90     continue
      else
          do 100 i=1,points
              arrayo(i) = datat(i+(nsamp-points)/2)
  100     continue
      endif
C
C Return to calling object
C
      return
      end
