C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       RPHS                                                 *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  TO CALCULATE RESPONSE PHASE.                              *
C  ENTRY POINTS:                                                       *
C      RPHS  (PHASE,A,NPT)                                             *
C  ARGUMENTS:                                                          *
C      PHASE   REAL         U*  (1) - WORKING ARRAY CONTAINS INST PHAS *
C      A       REAL         U*  (1) - COMPLEX ENVELOPE ARRAY ON INPUT  *
C                                   - RESPONSE PHASE ON OUTPUT         *
C      NPT     INTEGER      I*      - NUMBER OF SAMPLE POINTS          *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   J. BODINE                          ORIGIN DATE: 81/09/02  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 90/10/15  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      MNMX         - TO FIND RELATIVE MAXIMA/MINIMA IN AMPLITUDE ARRAY*
C      UNWRAP       - TO UNWRAP PHASE                                  *
C      FPEAK   REAL - TO FIND MAXIMUM VALUE ARRAY POSITION             *
C  INTRINSIC FUNCTIONS CALLED:                                         *
C      ABS     GENERIC -                                               *
C      FLOAT   REAL -                                                  *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  NONE                                               *
C  GENERAL DESCRIPTION:                                                *
C       ROUTINE TO SET ANALYTIC SIGNAL ENVELOPE LOBES TO VALUE OF      *
C       THE INSTANTANEOUS PHASE AT THE POINT WHERE THE ENVELOPE        *
C       IS A MAXIMUM.                                                  *
C       THE VALUE OF THE ENVELOPE IS SET TO THAT OF THE INSTANTANEOUS P*
C       FROM TROUGH TO TROUGH. THE RESULTING "ENVELOPE" MAY BE         *
C       CONSIDERED TO BE A MEASURE OF THE PHASE OF AN ASSUMED NON-DISPE*
C       SEISMIC RESPONSE CONTAINED WITHIN THE ENVELOPE.                *
C       SEE TANER ET AL., 1979, GEOPHYSICS, V.44, #6,P.1041.           *
C                                                                      *
C       PROGRAM ASSUMES THE FIRST POINT IN THE SIGNAL IS A TROUGH      *
C       AND THE FIRST POINT OF ZERO SLOPE IS A PEAK. IF THIS POINT     *
C       IS A TROUGH IT WILL BE SKIPPED IN MNMX.                        *
C                                                                      *
C       NOTE FOR USERS:                                                *
C     THIS ROUTINE WILL FIND EVERY ENVELOPE PEAK REGARDLESS            *
C     OF RELATIVE AMPLITUDE. DISPLAY OF RESPONSE PHASE OF NOISY        *
C     DATA IS THUS MOST EFFECTIVE WITH A COLOR PLOT WHERE COLOR        *
C     INTENSITY IS AMPLITUDE MODULATED AND A COLOR WHEEL IS USED       *
C     FOR PHASE (0-360 DEGREES).                                       *
C                                                                      *
C  REVISED BY:  J. NORRIS                     REVISION DATE: 83/06/01  *
C       MODIFY MIN/MAX LOCATOR LOGIC TO BE SUBROUTINE CALL.            *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C*****************  ITEMS DELETED FROM DOCPACK  ************************
C  =============================== DATE: 90/10/15 ==================   *
C      6  ( OUTPUT SEQUENTIAL ) - DEBUG OUTPUT                         *
C********************  END OF DELETED ITEMS  ***************************
C***********************************************************************
      SUBROUTINE RPHS (PHASE,A,NPT)
      DIMENSION A(1), PHASE(1), ITRF(4096), IPEAK(4096), P(3)
C***********************************************************************
C       FIND ARRAY POSITIONS OF MAXIMA AND MINIMA. THEN
C       SET IPEAK VALUES TO INTEGER VALUE OF INSTANTANEOUS
C       PHASE AT IPEAK(I) + FRACTION ARRAY POSITIONS.
C***********************************************************************
      CALL MNMX (A,NPT,IPEAK,JP,ITRF,JT)
C
      DO 20  I=1,JP
         K = IPEAK(I)
              DO 10 M=1,3
                   P(M) = PHASE(K-2+M)
                   IF( ABS(P(M)) .GT. 1.0E20 ) P(M)=0.0
                   IF( 1/ABS(P(M)) .GT. 1.0E20 ) P(M)=0.0
C  50              P(M) = PHASE(K-2+M)
C                  WRITE(*,*)M,P(M)
   10         CONTINUE
         CALL UNWRAP(P)
         FP = FPEAK(A,K)
         TK = FLOAT(K)
         IF(FP.LT.TK)IPEAK(I) = P(2)+(TK-FP)*(P(1)-P(2))
         IF(FP.GE.TK)IPEAK(I) = P(2)+(TK-FP)*(P(2)-P(3))
         IF(IPEAK(I).GT.180)IPEAK(I) = IPEAK(I)-360
C        WRITE (6,*) K,IPEAK(I),ITRF(I),PHASE(K)
   20 CONTINUE
C
C Set envelope lobes to ipeak values
C
      J = 1
      ISTRT = 1
   30 IEND = ITRF(J)
      PEAK = FLOAT(IPEAK(J))
      DO 40  I=ISTRT,IEND
         A(I) = PEAK
   40 CONTINUE
C
      J = J+1
      IF (IEND.EQ.NPT) GO TO 50
      ISTRT = IEND
      GO TO 30
C
   50 CONTINUE
C
      RETURN
      END
