C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C**********************************************************************C
C
C     PROGRAM MODULE  Average Predictive Deconvolution
C
C**********************************************************************C
C
C AVEPRED READS SEISMIC TRACE DATA FROM AN INPUT FILE,
C does a predictive deconvolution with optional filtering and
C WRITES THE RESULTS TO AN OUTPUT FILE
C
C SUBROUTINE CALLS: RTAPE, HLH, WRTAPE, predictive routines
C
C**********************************************************************C
C
C     DECLARE VARIABLES
C

#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

      INTEGER     ITR ( SZLNHD )
      INTEGER     STR ( SZLNHD )
      INTEGER     NSAMP, NSI, NTRC, NREC, IFORM
      INTEGER     LUIN , LUOUT, LBYTES, NBYTES,obytes,fbytes
      INTEGER     ns, ne, rs, re
      integer     argis
#include <f77/pid.h>
      REAL        xtr ( SZLNHD ), wtrace(4*SZLNHD),work(2*SZLNHD)
      REAL        weight ( SZLNHD )
      integer     mutes(SZLNHD), itimes(SZLNHD), itimee(SZLNHD)
      
      integer     itrhdr
      pointer     (wkitrhdr, itrhdr(1))
      real        array, acorr
      pointer     (wrkadr  , array(1))
      pointer     (wrkacorr, acorr(1))

      real        pf(SZLNHD), pfr(SZLNHD)
      CHARACTER   NAME * 7, ntap * 256, otap * 256, ftap * 256
      CHARACTER   hdrwrd * 6, hdrwdp*6, hdrwdo*6
      logical     verbos, predict, heap, dead, pef, cost, bart
      logical     debug, absl, gate, dlim
      logical     watbot, sword, TV, ave, hdrp, hdro, filout
 
      DATA  NAME     /'AVEPRED'/
      DATA  LUIN / 1 /, LUOUT  / 2 /, LBYTES / 0 /, NBYTES / 0 /
      DATA  obytes / 0 /
      data  verbos/.false./

C**********************************************************************C
C     get online help if necessary
C**********************************************************************C
      if ( argis('-?') .gt. 0 .or. 
     :     argis('-h') .gt. 0.or. 
     :     argis('-help') .gt. 0 ) then
         call help()
         stop
      endif

C**********************************************************************C
C     open printout files
C**********************************************************************C
#include <f77/open.h>

C**********************************************************************C
C     read program parameters from the command line
C**********************************************************************C
      call cmdln(ntap,otap,ftap,ist,iend,ns,ne,rs,re,vel1,
     1     vel2,mave,pr,ol,prew,predict, disl, dish,
     2     verbos,cost,bart,debug,absl,gate,dlim,
     3     watbot,sword,hdrwrd,TV,lslide,hdrwdp, hdrwdo, 
     4     hdrp, hdro, filout)
      disls = disl
      dishs = dish	

C**********************************************************************C
C     open data units
C**********************************************************************C
      call getln( luin, ntap, 'r', 0)
      call getln(luout, otap, 'w', 1)

      if ( filout ) call getln(luflt, ftap, 'w', -1)

C**********************************************************************C
C     read lineheader; save key parameters; modify parameters;
C     update header; write out header
C**********************************************************************C
      lbytes = 0
      CALL RTAPE ( LUIN, ITR, LBYTES        )
      CALL HLHprt    ( ITR , LBYTES, NAME, 7,         LERR)
      if(lbytes .eq. 0) then
         write(LERR,*)'AVEPRED: no header read on unit ',ntap
         write(LERR,*)'check existence of data file'
         write(LERR,*)'FATAL'
         stop
      endif

c------
c     save certain parameters
#include <f77/saveh.h>
 
c     For trace header values we take mnemonics and build a
c     set of pointers to an I*2 array equivalenced to the
c     RTAPE  Integer array (headers + data)
c     TRACEHEADER is a value in the include file <sisdef.h> that
c     refers to the trace header
 

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('LinInd',ifmt_LinInd,l_LinInd,ln_LinInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu('WDepDP',ifmt_WDepDP,l_WDepDP,ln_WDepDP,TRACEHEADER)


      if (sword) then
         call savelu(hdrwrd,ifmt_hdrwrd,l_HdrWrd,ln_hdrwrd,TRACEHEADER)
      endif
      if (hdrp) then
         call savelu(hdrwdp,ifmt_hdrwdp,l_hdrwdp,ln_hdrwdp,TRACEHEADER)
      endif
      if (hdro) then
         call savelu(hdrwdo,ifmt_hdrwdo,l_hdrwdo,ln_hdrwdo,TRACEHEADER)
      endif

      if (watbot) then
         if (vel1 .eq. 9999999.) then
            call saver( itr, 'WatVel', ivel , LINHED)
            vel1 = float (ivel)
            if (vel1 .lt. 100. .or. vel1. gt. 30000.) then
               write(LERR,*)'Line Header water vel entry bad'
               write(LERR,*)'Use utop to put proper value,'
               write(LERR,*)'e.g. 5000 or 1500'
               stop
            endif
         endif
      endif


      if(nsamp .gt. SZLNHD) nsamp=SZLNHD
      call cmdchk(ns,ne,rs,re,ntrc,nrec)
      ntr = ntrc
      nrecc = nrec

      dt = real (nsi) * unitsc

      if (TV) then

         lslide = lslide / nsi
         iovlp  = lslide / 2
         ilast = 0
         do while (ilast.lt.nsamp)
            if(ilast.eq.0)then
               ifirst = 1
               ilast = lslide + iovlp
               nwin = 1
            else
               nmove = lslide+iovlp
               ifirst = ifirst + iovlp
               ilast = ifirst + nmove -1
               nwin = nwin+1
            endif
         end do
         nwin0 = nwin

      endif

      iend = iend/nsi + .5
      ist  = ist/nsi
      if(ist .le. 1)      ist = 1
      ist0 = ist
      if(iend .eq. 0)     iend = nsamp
      if(iend .gt. nsamp) iend = nsamp
      iend0 = iend
      
      veldt1 = vel1 * dt
      veldt2 = vel2 * dt

      if (TV) then
         iwnd = nsi * (iend - ist + 1)
         if(ol.gt.iwnd/2)then
            write(LER,*)' '
            write(LER,*)'Fatal: time variant option error'
            write(LER,*)'Operator too long.  Max is 1/2 window length'
            write(LER,*)'Window length is ',iwnd,' op length is ',ol
            write(LER,*)'Fatal'
            call lbclos(luin)
            stop
         endif
      endif
      
      lpr = pr/nsi
      if(lpr .eq. 0) lpr=1
      lpf = ol/nsi
      lf  = lpf + lpr
      lfm = lf
      lacorr = (lpf + lpr) * 2
      IF(TV .AND. lacorr.gt.lslide) lacorr = lslide
      IF (TV .and. hdro) THEN
         lacorr = lslide
      ENDIF
      nsampo = iend - ist + 1

      call savew( itr, 'NumSmp', nsamp , LINHED)
      call savew( itr, 'NumTrc', ntr  , LINHED)
      call savew( itr, 'NumRec', nrecc, LINHED)

C**********************************************************************C
C     print line header values
C**********************************************************************C
      if( verbos ) then
         write(LERR,*)
         write(LERR,*)' Values read from input data set line header'
         write(LERR,*)
         write(LERR,*) ' # of Samples/Trace =  ', nsamp
         write(LERR,*) ' Sample Interval    =  ', nsi  
         write(LERR,*) ' Traces per Record  =  ', ntrc 
         write(LERR,*) ' Records per Line   =  ', nrec 
         write(LERR,*) ' Format of Data     =  ', iform
      endif
      write(LERR,*)
      write(LERR,*)' Line header values after default check '
      write(LERR,*)
      write(LERR,*) ' # of Samples in design window =  ', nsamp
      write(LERR,*) ' Sample Interval    =  ', nsi  
      write(LERR,*) ' Traces per Record  =  ', ntr 
      write(LERR,*) ' Records per Line   =  ', nrecc 
      write(LERR,*) ' Format of Data     =  ', iform
      write(LERR,*)' '
      if (hdrp) then
        write(LERR,*) 'Prediction distance from hdr wd ',hdrwdp
      else
        write(LERR,*) 'Prediction distance= ',pr,' ms ',lpr,' samples'
      endif
      if (hdro) then
        write(LERR,*)'Operator length from hdr wd ',hdrwdo
      else
        write(LERR,*)'Operator length= ',ol,'  ms ',lpf,' samples'
      endif
      if (.not.hdrp .AND. .not.hdro) then
        write(LERR,*)'Total pred filt length = ',lf,' samples'
      endif
      write(LERR,*)'Prewhitening= ',prew
      write(LERR,*)'Number traces to spatially ave =  ',ne-ns+1
      write(LERR,*)'Design window start time (samps) = ',ist0
      write(LERR,*)'Design window end time           =  ',iend
      write(LERR,*)'Start design velocity (m or ft/s)= ',vel1
      write(LERR,*)'End design velocity (m or ft/s)  = ',vel2
      write(LERR,*)'Design window lower range limit  = ',disl
      write(LERR,*)'Design window upper range limit  = ',dish
      write(LERR,*)' '
      write(LERR,*)'Cosine weighting of auto-corr  = ',cost
      write(LERR,*)'Bartlett weighting of auto-corr= ',bart
      write(LERR,*)' '
      write(LERR,*)'Process between rec            =  ',rs,' and'
      write(LERR,*)'record                         =  ',re
      write(LERR,*)'Process between trc            =  ',ns,' and'
      write(LERR,*)'trace                          =  ',ne
      write(LERR,*)' '
      if (absl)
     1     write(LERR,*)'Use absolute autocorrelations  =  ', absl
      if (watbot) then
         write(LERR,*)'Key window start time to water depth in trace'
         write(LERR,*)'Water depth trace hdr position= ',l_WDepDP
      endif
      write(LERR,*)' '
      if (sword) then
         write(LERR,*)'Start time stored in trc header wrd= ',hdrwrd
         write(LERR,*)'Start time stored in trc header pos= ',l_HdrWrd
      endif
      write(LERR,*)' '
      if (dlim) then
         write(LERR,*)'Apply filter only to data within distance limits'
      endif
      if (TV) then
         write(LERR,*)'For time varying option:'
         if (hdro) then
         write(LERR,*)'max autocorrelation length = ',lacorr
         else
         write(LERR,*)'autocorrelation length = ',lacorr
         endif
         write(LERR,*)'sliding window length  = ',nwin
      endif
      
      prew = prew / 100.

      call bldwt (nsampo, cost, bart, weight)

      obytes = SZTRHD + SZSMPD * nsamp
      call savhlh( itr, lbytes, lbyout)
      CALL WRTAPE ( LUOUT, ITR, LBYOUT                 )

      if ( filout ) then
         call savew (itr, 'NumSmp',  lfm , LINHED)
         call savew (itr, 'NumTrc',  1   , LINHED)
         fbytes = SZTRHD + SZSMPD * lfm
         CALL WRTAPE ( LUFLT, ITR, LBYOUT                 )
      endif

c---------------------------------------------------
c  malloc only space we're going to use
      heap = .true.

      itemi = (ne - ns + 1) * ITRWRD
      item  = nsamp * (ne - ns + 1)

      if (TV) then
         itema = nwin * lacorr * SZSMPD
      else
         itema =        lacorr * SZSMPD
      endif

      call galloc (wkitrhdr, itemi*SZSMPD, errcod, abort)
      if (errcod .ne. 0) heap = .false.

      call galloc (wrkadr, item *SZSMPD, errcod, abort)
      if (errcod .ne. 0) heap = .false.

      call galloc (wrkacorr, itema *SZSMPD, errcod, abort)
      if (errcod .ne. 0) heap = .false.

      if (.not. heap) then
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) item * SZSMPD,'  bytes'
         write(LERR,*) itemi* SZSMPD,'  bytes'
         write(LERR,*) itema* SZSMPD,'  bytes'
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) item * SZSMPD,'  bytes'
         write(LERR,*) itemi* SZSMPD,'  bytes'
         write(LERR,*) itema* SZSMPD,'  bytes'
      endif
c---------------------------------------------------

C**********************************************************************C
C     don't process unwanted records
C**********************************************************************C
      nbytes = obytes
      call recrw (1,rs-1,luin,ntrc,itr,luout, nbytes)
      if (nbytes  .eq. 0) go to 999

C**********************************************************************C
C     main processing loop:
C          read trace; deconvolve; write output
C**********************************************************************C

      DO 100 JJ = rs, re

         live = 0
         pef  = .false.
         ave  = .true.
         call vfill (0.0,pf,1,lpf)
         call vclr  (work, 1, nsamp)

c------------------------
c  pass first par of rec
         
         nbytes = obytes
         call trcrw (JJ, 1, ns-1, luin, ntrc, itr, luout, nbytes)
         if (nbytes  .eq. 0) go to 999

         ic = 0
         id = 0
         if (.not. hdrp .AND. .not. hdro) id = 1
         
         DO 98 KK = ns, ne
            nbytes = 0
            CALL RTAPE  ( LUIN , ITR, NBYTES         )
            if(nbytes .eq. 0) then
               write(LERR,*)'End of file on input:'
               write(LERR,*)'  rec= ',jj,'  trace= ',kk
               go to 999
            endif
            call vmov (itr(ITHWP1), 1, xtr, 1, nsamp)
c-------------------------
c  preserve dead tr flag
            call saver2(itr,ifmt_StaCor,l_StaCor,ln_StaCor,istatic,
     1           TRACEHEADER)
            
            if (istatic .eq. 30000) call vclr (xtr, 1, nsamp)

c-------------------------
c  get trace distance and
c  other indeces (from
c  1st live trc of gather)
            
            call saver2(itr,ifmt_DstSgn,l_DstSgn,ln_DstSgn,idist,
     1           TRACEHEADER)
            dist    = iabs(idist)
            if (istatic .ne. 30000 .AND. id .eq. 0) then
               call saver2(itr,ifmt_DphInd,l_DphInd,ln_DphInd,ipw,
     1              TRACEHEADER)
               call saver2(itr,ifmt_LinInd,l_LinInd,ln_LinInd,iow,
     1              TRACEHEADER)
            endif
c---------------------------------
c  pack entire record into array
            ic = ic + 1
            istrc = (ic-1) * nsamp
            ishdr = (ic-1) * ITRWRD
            call vmov (itr,1, itrhdr(ishdr+1),1,ITRWRD)
            call vmov (xtr, 1, array(istrc+1), 1, nsamp)

c------------------
c  detect mute zone
            call detmut ( xtr, mutes(ic), nsamp)

c-----
c    options to get window start times keyed to:
            ist  = ist0
            iend = iend0
c-----
c       (1) water bottom (need water depth for this cdp
            if (watbot) then
               call saver2(itr,ifmt_WDepDP,l_WDepDP,
     1              ln_WDepDP, idep, TRACEHEADER)
               dep  = idep
               ist  = ist  + 2 * dep/veldt1
               iend = ist + nsampo - 1
            endif
c-----
c       (2) start time in trace headers (could be I*4, R, I*2)
            if (sword) then
               call saver2(itr,ifmt_hdrwrd,l_HdrWrd,
     1              ln_HdrWrd, ist1 , TRACEHEADER)
               ist  = ist + ist1 / nsi
               iend = ist + nsampo - 1
            endif
c-----
c       (3) trace distance / velocity
            if (vel1 .ne. 9999999.) then
               ist  = ist  + dist/veldt1
               if (vel2 .eq. 9999999.) then
                  iend = ist  + nsampo - 1
               else
                  iend = iend + dist/veldt2
               endif
            endif
            if (iend .gt. nsamp) iend = nsamp
            
            nsampk     = iend - ist + 1
            
            if (nsampk .le. lf .and. istatic .ne. 30000) then
               write(LERR,*)'Design window time LT filter'
               write(LERR,*)'length -- FATAL'
               write(LERR,*)'Increase window start velocity'
               write(LERR,*)'-v1[], and/or decrease end windw'
               write(LERR,*)'vel -v2[] & re-run'
               write(LER ,*)'Design window time LT filter'
               write(LER ,*)'length -- FATAL'
               write(LER ,*)'Increase window start velocity'
               write(LER ,*)'-v1[], and/or decrease end windw'
               write(LER ,*)'vel -v2[] & re-run'
               go to 999
            endif

            IF (istatic .ne. 30000 .AND. id .eq. 0) THEN

                  call move (1, str, itr, nbytes)
c----------------
c  option to get
c  pred dist from
c  trc hdr of 1st
c  live trace
                  if (hdrp) then
                     call saver2(itr,ifmt_hdrwdp,l_hdrwdp,ln_hdrwdp,
     1                           ipw, TRACEHEADER)
                     lpr = float(ipw)/float(nsi)
                     if (lpr .le. 1) lpr = 1
                  endif
c----------------
c----------------
c  option to get
c  op length from
c  trc hdr of 1st
c  live trace
                  if (hdro) then
                     call saver2(itr,ifmt_hdrwdo,l_hdrwdo,ln_hdrwdo,
     1                           iow, TRACEHEADER)
                     lpf = float(iow)/float(nsi)
                  endif
c----------------
                  if (lpf .le. 1 .AND. hdro) then
                    write(LERR,*)'FATAL ERROR in avepred hdr wd option:'
                    write(LERR,*)'detected bad operator length= ',iow
                    write(LERR,*)'in header wd ',hdrwdo
                    write(LERR,*)'rec/trc/LI,DI= ',jj,kk,ili,idi
                    write(LER ,*)'FATAL ERROR in avepred hdr wd option:'
                    write(LER ,*)'detected bad operator length= ',iow
                    write(LER ,*)'in header wd ',hdrwdo
                    write(LER ,*)'rec/trc/LI,DI= ',jj,kk,ili,idi
                     go to 999
                  endif

                  lf = lpr + lpf
c-------
c  if new op length
c  rebuild auto wts
c  the reset 1st
c  live trc flag
c     write(0,*)jj,kk,ipw,iow,lpr,lpf
                  if (hdro) call bldwt (lpf, cost, bart, weight)
                  id = 1

            ENDIF

 
c------------------
c  and store for future use
            itimes(ic) = ist
            itimee(ic) = iend

            if (verbos)
     1           write(LERR,*)'Rec/trc= ',jj,kk,
     2           ' start time (samps)= ',ist,
     3           ' end time (samps)= ',iend,
     4           ' static= ',istatic
            
c************************************
c  distance limit for auto calc

            IF (dist .ge. disls .AND. dist .le. dishs) THEN

c------------------------------------
c  only do anything to live traces

               if (istatic .ne. 30000) then
 
c-------------------------
c does this trace really
c have anything in the
c design window

                  if (debug) then
                     write(LERR,*)'JJ= ',jj,' kk= ',kk,' ist= ',ist,
     1                    ' iend= ',iend,' samps= ',nsampk,
     2                    ' dist= ',dist,
     3                    ' mute start= ',mutes(ic)
                  endif

                  call dotpr (xtr(ist),1,xtr(ist),1,xdot,nsampk)
                  if (xdot .eq. 0.0) then
                     dead = .true.
                  else
                     live = live + 1
                     dead = .false.
                  endif


c++++++++++++++++++++++++++++++++
c if design window is live then
c compute autocorr & keep running
c sum
                  if (.not. dead) then

                     if (TV) then
                        
                        ilast = 0
                        do while (ilast.lt.nsampk)
                           if(ilast.eq.0)then
                              ifirst = 1
                              ilast = lslide + iovlp
                              nwin = 1
                           else
                              nmove = lslide+iovlp
                              ifirst = ifirst + iovlp
                              ilast = ifirst + nmove -1
                              nwin = nwin+1
                           endif
                        end do
                        
                        
                        call decon_tv(xtr(ist),nsampk,lpf,lpr,prew,
     1                       acorr,wtrace,ierr,lslide,nwin,
     2                       iovlp,weight,lacorr,ave,absl,
     3                       live,nwin0)
                        
                     else
                        call predvrg(nsampk,xtr(ist),lpr,lpf,
     1                       pf,ase,prew,wtrace,pef,live,
     2                       weight,work,absl)
                     endif

                  endif

               endif

            ENDIF

 98      CONTINUE

c************************************
c  compute distance limits if not
c  limits to filter application

         if (.not. dlim) then
            disl = -999999.
            dish = +999999.
         endif

c++++++++++++++++++++++++++++++++
c for non-time varying...
c now compute pred filter based
c on averaged auto-corr
         if (.not. TV) then
            xlive = live
            pef = .true.
            call predvrg(nsampk,xtr(ist),lpr,lpf,
     1           pf,ase,prew,wtrace,pef,live,
     2           weight,work,absl)
         endif

         ic  = 0
         ave = .false.

         DO 99 KK = ns, ne


            ic = ic + 1
            istrc = (ic-1) * nsamp
            ishdr = (ic-1) * ITRWRD
            call vmov (itrhdr(ishdr+1),1,itr,1,ITRWRD)
            call vmov (array(istrc+1), 1, xtr, 1, nsamp)

c************************************
c  distance limit for filter appl.
 
            call saver2(itr,ifmt_DstSgn,l_DstSgn,ln_DstSgn,
     1           idist, TRACEHEADER)
            dist    = iabs(idist)
            
            IF (dist .ge. disl .AND. dist .le. dish) THEN

c---------------------
c  apply filter only if
c  design data was live
               IF (live .ge. 1) THEN

c---------------------
c  apply filter to design
c  window or whole trc
                  if (TV) then

                     ist  = itimes(ic)
                     iend = itimee(ic)
                     nsampk = iend - ist + 1
                     ilast = 0
                     do while (ilast.lt.nsampk)
                        if(ilast.eq.0)then
                           ifirst = 1
                           ilast = lslide + iovlp
                           nwin = 1
                        else
                           nmove = lslide+iovlp
                           ifirst = ifirst + iovlp
                           ilast = ifirst + nmove -1
                           nwin = nwin+1
                        endif
                     end do
                     
                     
                     call vclr (wtrace, 1, nsamp)
                     
                     call decon_tv(xtr(ist),nsampk,lpf,lpr,prew,
     1                    acorr,wtrace,ierr,lslide,nwin,
     2                    iovlp,weight,lacorr,ave,absl,
     3                    live,nwin0)
                     call vmov (wtrace, 1, xtr(ist), 1, nsampk)
                     
                  else
                     
                     if (gate) then
                        
                        ist  = itimes(ic)
                        iend = itimee(ic)
                        nsampk = iend - ist + 1
                        
                        call vclr (work, 1, nsamp)
                        
                        if( predict ) then
                           do 71  ii = 1, lf-1
                              pfr(ii) = - pf (ii+1)
 71                        continue
                           call fold(lf,pfr,nsampk,xtr(ist),
     1                          nfld, work)
                           call vmov(work,1,xtr(ist),1,nsampk)
                           call vrvrs(pfr,1,lf)
                           call fold (lf, pfr, nsampk,xtr(ist),
     1                          nfld, work)
                        else
                           call fold (lf, pf, nsampk, xtr(ist),
     1                          nfld, work)
                        endif
                        call vmov (work,1,xtr(ist),1,nsampk)
                     else
c-----------------------------
c     if desired apply prediction
c     filter instead of pef
                        call vclr (work, 1, nsamp)
                        
                        if( predict ) then
                           do 51  ii = 1, lf-1
                              pfr(ii) = - pf (ii+1)
 51                        continue
                           call fold(lf,pfr,nsamp,xtr,nfold,
     1                          work)
                           call vmov(work,1,xtr,1,nsamp)
                           call vrvrs(pfr,1,lf)
                           call fold (lf, pfr, nsamp, xtr,
     1                          nfold, work)
                        else
                           call fold (lf, pf, nsamp, xtr,
     1                          nfold, work)
                        endif
                        call vmov (work,1,xtr,1,nsamp)
                     endif
                  endif
                  
               ENDIF
            ENDIF
            
c  distance limit for filter appl.
c************************************

c------------------
c  reapply zone
            call resmut (xtr, mutes(ic), nsamp)
c-----------------------------

            call vmov (xtr, 1, itr(ITHWP1), 1, nsamp)
            call wrtape(luout,itr,obytes)

 99      CONTINUE

         if ( filout ) then
            call vmov (pf, 1, str(ITHWP1), 1, lfm)
            call wrtape(luflt,str,fbytes)
         endif

         if(verbos) then
            write(LERR,*)'Record= ',jj
         endif

c------------------------
c  pass remainder of rec
         nbytes = obytes
         call trcrw (JJ, ne+1, ntrc, luin, ntrc, itr, luout, nbytes)

 100  CONTINUE

c------------------------
c  pass remainder of recs
      nbytes = obytes
      call recrw (re+1, nrec, luin, ntrc, itr, luout, nbytes)
      if (nbytes .eq. 0) go to 999

  999 continue

      call lbclos(luin)
      call lbclos(luout)
      if ( filout ) call lbclos(luflt)

      END


c---------------------------------------
c  online help section
c---------------------------------------
      subroutine help
#include <f77/iounit.h>

        write(LER,*)' '
        write(LER,*)'Command Line Arguments for AVEPRED: predictive '
        write(LER,*)'deconvolution with operator averaging'
        write(LER,*)' '
        write(LER,*)'Input....................................... (def)'
        write(LER,*)' '
        write(LER,*)'-N[ntap]   -- input data set name'
        write(LER,*)'-O[otap]   -- output data set name'
        write(LER,*)'-F[ftap]   -- optional p.e.f. filter data set name'
        write(LER,*)' '
        write(LER,*)'-ns[ns]    -- process start trace          (first)'
        write(LER,*)'-ne[ne]    -- process end trace             (last)'
        write(LER,*)'-rs[rs]    -- process start record         (first)'
        write(LER,*)'-re[re]    -- process end record            (last)'
        write(LER,*)'data not within limits will be passed unprocessed'
        write(LER,*)' '
        write(LER,*)'design window:'
        write(LER,*)'-s[ist]    -- start time                    (0 ms)'
        write(LER,*)'-e[iend]   -- end time                 (last samp)'
        write(LER,*)'-vs[vel1]  -- start design velocity (m,ft/s)(flat)'
        write(LER,*)'-ve[vel2]  -- end design velocity (m,ft/s)  (flat)'
        write(LER,*)' '
        write(LER,*)'-TV        -- decon time varying:'
        write(LER,*)'-w[lslide] -- sliding window length (ms)     (500)'
        write(LER,*)'Note:         -G, -S options below & -F[ftap]'
        write(LER,*)'              above ignored'
        write(LER,*)' '
        write(LER,*)'prediction parameters:'
        write(LER,*)'-p[pr]     -- wavelet length, ms          (1 samp)'
        write(LER,*)'-ol[ol]    -- operator length, ms'
        write(LER,*)'-P[prew]   -- prewhitening                   (.01)'
        write(LER,*)'-xl[disl]  -- lower range limit for auto corr'
        write(LER,*)'              default = -99999'
        write(LER,*)'-xu[disu]  -- upper range limit for auto corr(max)'
        write(LER,*)'              default = +99999'
        write(LER,*)' '
        write(LER,*)'-S         -- output predictable part of data'
        write(LER,*)'              default = non-predictable (normal pre 
     1d'
        write(LER,*)'-C         -- cosine weighting of auto-corr'
        write(LER,*)'-B         -- bartlett weighting of auto-corr'
        write(LER,*)'           -- default is no weighting of auto-corr'
        write(LER,*)'-A         -- absolute auto-correlations: no norm'
        write(LER,*)'-G         -- only apply operator to data in design 
     1 window'
        write(LER,*)'-D         -- only apply operator to traces within 
     1distance limits'
        write(LER,*)'-W         -- key start time on water depth in hdr'
        write(LER,*)'-H         -- key start time on trc hdr word'
        write(LER,*)'-hw[hdrwrd]-- trc hdr word with start time (none)'
        write(LER,*)'Note: can have sum of const + dx/v + hdr time + ...
     1'
        write(LER,*)'-V         -- verbos printout'
        write(LER,*)' '
        write(LER,*)'Usage:'
        write(LER,*)'     avepred -N[] -O[] -s[] -e[] -p[] -ol[] -P[]'
        write(LER,*)'             -xl[] -xu[] -F[] -vs[] -ve[] -ns[]'
        write(LER,*)'             -ne[] -re[] [-W -H [-hw[]]i]'
        write(LER,*)'             [-C -B -S -A -G -D -V]'
        write(LER,*)' '
 
      return
      end

c-----
c     get command arguments
c
c     ntap  - C*100  input file name
c     otap  - C*100  output file name
c     ftap  - C*100  output filter file name
c       s   - I      start time
c       e   - I      stop time
c     nst   - I      start trace
c     ned   - I      stop trace
c    nrst   - I      start record
c    nred   - I      end record
c    mave   - I      number traces to spatially average operator
c     vel   - R      design window velocity
c      pr   - R      prediction distance
c      ol   - R      operator length
c    prew   - R      prewhitening
c    disl   - R      inside distance limit for auto-corr
c    disu   - R      outside distance limit for auto-corr
c   predict - L      output predictable part of data
c    absl   - L      do not normalize auto-corr's
c    gate   - L      only apply operator to data in design window
c    verbos - L      verbose output or not
c-----
      subroutine cmdln(ntap,otap,ftap,ist,iend,ns,ne,rs,re,vel1,
     1                vel2,mave,pr,ol,prew,predict, disl, dish,
     2                 verbos,cost,bart,debug,absl,gate,dlim,
     3                 watbot,sword,hdrwrd,TV,lslide,
     4                 hdrwdp, hdrwdo, hdrp, hdro, filout)
#include <f77/iounit.h>
      character  ntap*(*), otap*(*), ftap*(*), hdrwrd * 6
      character  hdrwdp*6, hdrwdo*6
      integer    ist,iend,ns,ne,rs,re,mave, argis
      real       pr,ol,prew,vel1, vel2
      logical    verbos, predict,cost,bart, debug, absl, gate
      logical    watbot,sword,dlim,TV,hdrp, hdro, filout

      filout = .false.

          call argstr('-N',ntap,' ',' ')
          call argstr('-O',otap,' ',' ')
          call argstr('-F',ftap,' ',' ')

          hdrp = .false.
          hdro = .false.
          call argstr('-hwp',hdrwdp,' ',' ')
          call argstr('-hwo',hdrwdo,' ',' ')
          if (hdrwdp(1:1) .ne. ' ') hdrp = .true.
          if (hdrwdo(1:1) .ne. ' ') hdro = .true.

          call argi4('-s',ist,1,1) 
          call argi4('-e',iend,0,0) 
          call argi4('-ns',ns,0,0) 
          call argi4('-ne',ne,0,0) 
          call argi4('-rs',rs,0,0) 
          call argi4('-re',re,0,0) 
          call argr4('-vs',vel1,9999999.,9999999.)
          call argr4('-ve',vel2,9999999.,9999999.)
          if (vel1 .eq. 9999999.)
     1    call argr4('-v', vel1,9999999.,9999999.)
          call argr4('-p',pr,0.,0.)
          call argr4('-ol',ol,0.,0.)
          call argr4('-P',prew,.01,.01)
          call argr4('-xl',disl,-999999.,-999999.)
          call argr4('-xu',dish,+999999.,+999999.)
          nst = 0
          ned = 0

          mave = 1
          if(ol .eq. 0. .AND. .not. hdro) then
             write(LERR,*)'No operator length given -- FATAL'
             write(LER,*)'AVEPRED: '
             write(LER,*)'No operator length -ol[] given'
             write(LER,*)'FATAL'
             stop
          endif
c         if(ol .eq. 0. .AND. hdro) then
c            write(LERR,*)'FATAL ERROR: avepred hdr word option'
c            write(LERR,*)'Must supply a maximum operator length'
c            write(LER ,*)'FATAL ERROR: avepred hdr word option'
c            write(LER ,*)'Must supply a maximum operator length'
c            stop
c         endif

          cost     = ( argis( '-C' ) .gt. 0 )
          bart     = ( argis( '-B' ) .gt. 0 )
          predict  = ( argis( '-S' ) .gt. 0 )
          verbos   = ( argis( '-V' ) .gt. 0 )
          absl     = ( argis( '-A' ) .gt. 0 )
          gate     = ( argis( '-G' ) .gt. 0 )
          dlim     = ( argis( '-D' ) .gt. 0 )
          debug    = ( argis( '-dbg' ) .gt. 0 )
          TV       = ( argis( '-TV' ) .gt. 0 )
          call argi4('-w',lslide,500,500)

          watbot   = ( argis( '-W' ) .gt. 0 )
          sword    = ( argis( '-H' ) .gt. 0 )
          if (watbot .and. sword) then
             write(LERR,*)'Cannot have both water bottom & header word'
             write(LERR,*)'start time options - choose one & rerun'
             stop
          endif
          if (sword) then
             call argstr ('-hw', hdrwrd, ' ', ' ')
             if (hdrwrd(1:1) .eq. ' ') then
                write(LERR,*)'Must enter header word mnemonic'
                write(LERR,*)'Use -hw[] cmd line arg & rerun'
                stop
             endif
          endif

          if (ftap(1:1) .ne. ' ' .AND. TV) then
             write(LERR,*)'Cannot have output decon operator file with'
             write(LERR,*)'time varying option. Will ignore output file'
             write(LER ,*)'Cannot have output decon operator file with'
             write(LER ,*)'time varying option. Will ignore output file'
             do i = 1, 100
                ftap(i:i) = ' '
             enddo
             filout = .false.
          elseif (ftap(1:1) .ne. ' ' .AND. .not. TV) then
             if (ol .eq. 0. .AND. hdro) then
                write(LERR,*)'FATAL ERROR in avepred:'
                write(LERR,*)'For hdr word option & output filter file'
                write(LERR,*)'you must specify a global max for -ol[]'
                write(LER ,*)'FATAL ERROR in avepred:'
                write(LER ,*)'For hdr word option & output filter file'
                write(LER ,*)'you must specify a global max for -ol[]'
                stop
             endif
             filout = .true.
          endif


      return
      end
