C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c
c     program module backus
c
c**********************************************************************c
c
c backus reads seismic trace data from an input file,
c applies a 3-point backus reverberation filter, and
c writes the results to an output file
c
c
c**********************************************************************c
c
c     declare variables
c
#include     <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

      integer     itr ( SZLNHD )
      integer     lhed( SZLNHD )
      integer     nsamp, nsi, ntrc, nrec, iform
      integer     luin , luout, lbytes, nbytes,  lbyout,lbyte
      integer     irs,ire,ns,ne
#include <f77/pid.h>
      integer     recnum, trcnum, static,  ginum
      real        tri ( SZLNHD ), buf( SZLNHD ), wdepth(SZLNHD)
      character   ntap * 256, otap * 256, name*6,fmt*256 ,cfile*256
      logical     verbos, query
      integer     argis

c     equivalence ( itr(129), tri (1) )
      equivalence ( itr(  1), lhed(1) )
      data lbytes / 0 /, nbytes / 0 /, name/'BACKUS'/
c	fmt ='(5x,12f5.0,15x)'
c-----
c     read program parameters from command line card image file
c-----
      query = ( argis ( '-?' ) .gt. 0 )
      if ( query )then
            call help()
            stop
      endif
c-----
c     open printout files
c-----
#include <f77/open.h>
      call gcmdln(ntap,otap,cfile,ns,ne,irs,ire,
     :		verbos,r,ngi,v,fmt)
c-----
c     get logical unit numbers for input and output
c-----
      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)
c-----
c     read line header of input
c     save certain parameters
c-----
	lbytes = 0
      call rtape  ( luin, itr, lbytes)
      if(lbytes .eq. 0) then
         write(LOT,*)'BACKUS'
         write(LOT,*)'FATAL'
         stop
      endif
      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)
      call saver(itr, 'UnitSc', unitsc, LINHED)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(itr, 'UnitSc', unitsc, LINHED)
      endif

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu('WDepDP',ifmt_WDepDP,l_WDepDP,ln_WDepDP,TRACEHEADER)

      if (v .eq. 0.0) then
         call saver(itr, 'WatVel', iv   , LINHED)
         v = iv
      endif
      tdel = float(nsi) * unitsc
c-----
c     ensure that command line values are compatible with data set
c-----
      call cmdchk(ns,ne,irs,ire,ntrc,nrec)
c-----
c     modify line header to reflect actual number of traces output
c-----
	call hlhprt(itr, lbytes, name, 6, LERR)
      nrecc=ire - irs+1
      call savew(itr, 'NumRec', nrecc, LINHED)
      jtr=ne-ns+1
      call savew(itr, 'NumTrc', jtr  , LINHED)
      call savhlh(itr,lbytes,lbyout)
      call wrtape ( luout, itr, lbyout                 )
c-----
c     verbose output of all pertinent information before
c     processing begins
c-----
      if( verbos ) then
      	    call verbal(nsamp, nsi, ntrc, nrec, iform, r, ngi, v,
     :            	ntap,otap,cfile,fmt)
      end if
c-----
c     read in water depths from a set of index cards
c-----
	if (ngi .gt. 0) then
      		open(unit=10, form = 'formatted', 
     :		file=cfile)
		read (10,fmt)(wdepth(i),i=1,ngi)
	endif
c-----
c     BEGIN PROCESSING
c     read trace, do filtering, write to output file
c-----
c-----
c     skip unwanted records
c-----
      call recskp(1,irs-1,luin,ntrc,itr)
c-----
c     process desired trace records
c-----
      do 1000 jj = irs, ire
            call trcskp(jj,1,ns-1,luin,ntrc,itr)
            do 1001 kk=ns, ne
                  nbytes = 0
                  call rtape ( luin, itr, nbytes)
99	format(5e12.3)
                  if(nbytes .eq. 0) then
                     write(LERR,*)'End of file on input:'
                     write(LERR,*)'  rec= ',jj,'  trace= ',kk
                     go to 999
                  endif
                call vmov (itr(ITHWP1), 1, tri, 1, nsamp)

               call saver2(lhed,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                      static, TRACEHEADER)
               call saver2(lhed,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                      recnum, TRACEHEADER)
               call saver2(lhed,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                      trcnum, TRACEHEADER)
               call saver2(lhed,ifmt_RecInd,l_RecInd, ln_RecInd,
     1                      ginum , TRACEHEADER)
               call saver2(lhed,ifmt_WDepDP,l_WDepDP, ln_WDepDP,
     1                      iwdep , TRACEHEADER)

		if (ginum .eq. 0 ) ginum = trcnum 
		if(ngi .eq. 0) then
                    z  = iwdep
	        else
		    z=wdepth(ginum)
		endif
                  if(static .ne. 30000)then
			call vmov(tri,1,buf,1,nsamp)
			call backus1(v,z,r,tdel,nsamp,buf,tri)
                  else
                        call vclr(tri,1,nsamp)
                  endif
                  call vmov  (tri, 1, itr(ITHWP1), 1, nsamp)
                  call wrtape( luout, itr, nbytes)
 1001             continue
                  if(verbos)write(LER,*)'backus processed rec ',recnum
            call trcskp(jj,ne+1,ntrc,luin,ntrc,itr)
 1000       continue
c-----
c     close data files
c-----
  999 continue
      call lbclos ( luin )
      call lbclos ( luout )
      if(verbos) then
            write(LERR,*)'end of backus , processed',nrec,' record(s)',
     :               ' with ',ntrc, ' traces'
       endif
      end


      subroutine help
#include <f77/iounit.h>
         write(LER,*)
     :'***************************************************************'
      write(LER,*)
     :'Execute backus by typing backus followed by program parameters.'
      write(LER,*)
     :'Note that each parameter is proceeded by -a where "a" is '
      write(LER,*)
     :'a character(s) corresponding to some parameter.'
        write(LER,*)
     :'Users enter the following parameters, or use the default values'
        write(LER,*)
     :' -N [ntap]    (no default)      : input data file name'
        write(LER,*)
     :' -O [otap]    (no default)      : output data file name'
        write(LER,*)
     :' -C [cfile]    (no default)      : optional card file '
        write(LER,*)
     :' -f [fmt] (default=(5x,12f5.0,15x)) : card file format '
        write(LER,*)
     :'    -f used only when you read water depths from card file'
        write(LER,*)
     :' -rs[irs] (default = 1st record) : starting record number '
        write(LER,*)
     :' -re[ire] (default = last record) : final record number '
        write(LER,*)
     :' -ns[ns] (default = trace 1) : first trace in record '
        write(LER,*)
     :' -ne[ne] (default = last trace) : last trace in each record '
	write(LER,*)
     :' -r[r]   (default = 0.30) : water bottom reflection coeff'
	write(LER,*)
     :' -vel[v] (default = line header) : water velocity'
	write(LER,*)
     :' -GI[ngi] (default = header):   num. of gis'
        write(LER,*)
     :'    -GI used only when you read water depths from card file'
	write(LER,*)
     :' -V[verbos] (optional printing) : print additional info'
	write(LER,*)
	write(LER,*)
     :' EXAMPLE'
	write(LER,*)
     :' backus -N/home/data/ntap -O/home/data/otap -C/home/data/cfile '
	write(LER,*)
     :'        -f(12f5.0) -rs10 -re12 -r0.5 -vel1500. -GI298 -V'
	write(LER,*)
	write(LER,*)
     :'***************************************************************'
      return
      end

      subroutine gcmdln(ntap,otap,cfile,ns,ne,irs,ire,verbos,r,ngi,v,
     :                          fmt)
c-----
c     get command arguments
c
c     ntap  - c*120     input file name
c     otap  - c*120     output file name
c     fmt   - c*120     input card format 
c     cfile - c*120     input card file name
c     ns    - i*4 starting trace index
c     ne    - i*4 ending trace index
c     irs   - i*4 starting record index
c     ire   - i*4 ending record index
c     verbos      - l   verbose output or not
c     r     - r*4 water bottom reflection coefficient
c     ngi   - i*4 number of gi's on line
c     v     - r*4 water velocity
c-----
#include <f77/iounit.h>
      character ntap*(*), otap*(*), cfile*(*),fmt*(*)
      integer *4 ns, ne, irs, ire
      real    * 4 r
      logical verbos
      integer argis
            call argstr( '-N', ntap, ' ', ' ' )
            call argstr( '-O', otap, ' ', ' ' )
            call argstr( '-f', fmt ,'(5x,12f5.0,15x)','(5x,12f5.0,15x)')
            call argstr( '-C', cfile,
     :			'/home/gpsc/zdew05/milo/card.data',
     :			'/home/gpsc/zdew05/milo/card.data' )
            call argi4 ( '-ns', ns ,    0  ,  0    )
            call argi4 ( '-ne', ne ,    0  ,  0    ) 
            call argi4 ( '-rs', irs ,   0  ,  0    )
            call argi4 ( '-re', ire ,   0   , 0    )
            call argi4 ( '-GI', ngi ,   0  ,  0    )
            call argr4( '-r'  ,  r  , 0.3,  0.3    )
            call argr4( '-vel'  ,v  , 0.0,  0.0    )
            verbos = ( argis( '-V' ) .gt. 0 )
      return
      end

      subroutine verbal(nsamp, nsi, ntrc, nrec, iform, r,ngi,v,
     :            	ntap,otap,cfile,fmt)
c-----
c     verbose output of processing parameters
c
c     nsamp - I*4 number of samples in trace
c     nsi   - I*4 sample interval in ms
c     ntrc  - I*4 traces per record
c     nrec  - I*4 number of records per line
c     iform - I*4 format of data
c     ngi   - I*4 number of gi's on line
c     r     - R*4 Relection coefficient of water bottom
c     v     - R*4 Water velocity
c     ntap  - C*120     input file name
c     otap  - C*120     output file name
c     cfile - C*120     optional card input file name
c     fmt   - C*120     inpit card format
c-----
#include <f77/iounit.h>
      integer nsamp, nsi, ntrc, nrec, iform
      character ntap*(*), otap*(*), cfile*(*), fmt*(*)

            write(LER,*)' '
            write(LER,*)' line header values after default check '
            write(LER,*) ' # of samples/trace =  ', nsamp
            write(LER,*) ' sample interval    =  ', nsi
            write(LER,*) ' traces per record  =  ', ntrc
            write(LER,*) ' records per line   =  ', nrec
            write(LER,*) ' format of data     =  ', iform
            write(LER,*) ' W. bot. refl coeff. =  ', r
            write(LER,*) ' gis in card input = ', ngi
            write(LER,*) ' Water velocity     = ', v
            write(LER,*) ' Input file = ', ntap
            write(LER,*) ' Output file = ', otap
		if (ngi .gt. 0) then
            		write(LER,*) ' Card input file = ', cfile
			write(LER,*) ' Input card format = ', fmt
		endif
            write(LER,*)' '

      return
      end

      subroutine backus1(v,h,r,tdel,lx,x,y)
c            a confidential Amoco subroutine
c                  fortran by Ken Peacock  1-18-89
c      backus filters an input array with a 3-pt Backus operator to form
c      an output array.   The operator is simulated (no null coefficients are
c      acually convolved) based upon the input parameters.
c      inputs are...
c            v, velocity of the water layer.
c            h, water thickness.
c            r, reflection coefficient for water bottom.
c            tdel, data sample increment, sec.
c            lx, length of the x array.
c            x, the input seismic trace.
c      outputs are...
c            y, the lx-length output seismic trace.
c      coded for the sun 3/60
c      version as of 1-18-89
c
      real*4 v,h,r,tdel,time,c1,c2,x(*),y(*)
      integer*4 ind,ista,isto
      time = 2.*h/v
      ind = time/tdel+.5
      c1 = 2.*r
      c2 = r*r
      do 1 i=1,ind
    1 y(i) = x(i)
      ista = ind+1
      isto = 2*ind
      do 2 i=ista,isto
      j = i-ind
    2 y(i) = x(i)+c1*x(j)
      ista = isto+1
      do 3 i=ista,lx
      j = i-ind
      k = i-2*ind
    3 y(i) = x(i)+c1*x(j)+c2*x(k)
      return
      end
