C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine GetStart ( dist, offsets, times, trndx, trndx2, start )

      integer trndx, trndx2

      real dist, offsets(*), times(*), start

c initialize variables

      start = 0.0

c extrapolate start time if trace is not contained in segment

      if ( dist .le. offsets(trndx) .or. dist .ge. offsets(trndx2) ) 
     :     then
         if ( dist .le. offsets(trndx) ) start = times(trndx)
         if ( dist .ge. offsets(trndx2) ) start = times(trndx2)
         return
      endif

c interpolate mute start time

      do j = trndx + 1, trndx2 

         if ( dist .le. offsets(j) .and. offsets(j) .lt. 999999. ) then
            start = times(j-1) + ( times(j) -times(j-1) ) / 
     :           abs( offsets(j) - offsets(j-1) ) 
     :           * abs( dist - offsets(j-1) )
            
            return
         endif

      enddo

      start = 0.
      return
      end
      

