C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine mucoef(rec,ntr,nsamp,dt_units,trc, mute_coefs, traces,
     :     itr, l_ONword, ln_ONword, ifmt_ONword, 
     :     l_OFFword, ln_OFFword, ifmt_OFFword, times, index, nseg, 
     :     count, mtype, ramp, mvel, dist, NoExtrap, NoInterp, 
     :     NumPicks, verbos )

c Routine to build an array of mute co-efficients.  Supports
c onset mute (on or diston), surgical mute (off or distoff), as well as mute 
c using velocity with t(0) control from a pick file (nearon,nearoff).  
c Supports an onset and offset ramp.

#include <f77/iounit.h>
#include <f77/lhdrsz.h>

      integer    itr(*), NumPicks
      integer    rec,ntr,nsamp,index(2*SZSMPM,2),nseg,count
      integer    ONword,l_ONword,ln_ONword,ifmt_ONword
      integer    OFFword,l_OFFword,ln_OFFword,ifmt_OFFword
      integer    ramp,j,trc
      integer    ramp_start,ramp_end

      real       traces(NumPicks), times(NumPicks),  mute_coefs(nsamp)
      real       coef, start
      real       mvel, dist, dt_units

      character  mtype*(*),last_pick*3,rampon*3

      logical    verbos, NoExtrap, NoInterp

c   VARIABLES  
c	integer
c	-------
c	rec : active record number
c	ntr : number of traces per record
c	trc : trace number
c	nsamp : number of samples per trace
c	dt_units : sample interval in units of input data
c	index (*,*) : array of recnums and nelems/segment
c	nseg : number of segments
c	count : number of live elements in traces(*) and times(*)
c	pflag : pass/reject flag option to be added later
c	ramp : ramp length in ms
c	i,j : loop counters
c
c	real
c	----
c	traces(*) : array of pic file trace numbers
c	times(*) : array of pic file times
c	mute_coefs(*) : array of mute co-efficients
c	start : mute start time
c	coef : ramp output value
c
c	character
c	---------
c	mtype*4 : mute type ( on, off, surg )
c
c	logical
c	-------
c	verbos : level of debug output flag
c

c Initialize Variables 

      last_pick = 'off'
      ramp_start = -9999
      ramp_end = 9999

      IF(mtype.eq.'on') then	

c ON MUTE

         if(ntr.gt.1)then
            call on ( rec, index, nseg, trc, ntr, traces, times, count, 
     :           NoExtrap, NoInterp, start )
         else
           call stackon ( rec, index, nseg, trc, ntr, traces, times, 
     :           count, NoExtrap, NoInterp, start )
         endif

c load mute start time to header mute start time mnemonic

         ONword = nint(start)
         call savew2 ( itr, ifmt_ONword, l_ONword, ln_ONword, 
     :           ONword, TRACEHEADER )

c reset start to account for ramp 

         start = start - ramp

c reset coef 

         coef = 0.

c generate co-efficients for trace 

         do j = 1,nsamp

            if(j*dt_units.lt.start) then
               mute_coefs(j) = coef
            else
               if(coef.lt.1.) then
                  coef =1./(float(ramp)/dt_units)+ coef
               endif
               if(coef.gt.1.) coef = 1.
               mute_coefs(j) = coef
            endif
         enddo

         return

      ELSEIF(mtype.eq.'off') then

c OFF MUTE 

         if ( ntr .gt. 1 ) then
            call off ( rec, index, nseg, trc, ntr, traces, times, count,
     :            start, dt_units, nsamp, NoExtrap, NoInterp )
         else
           call stackoff ( rec, index, nseg, trc, ntr, traces, times, 
     :           count, start, dt_units, nsamp, NoInterp, NumPicks )
         endif
  
c load mute start time to header OFF mute start time mnemonic

         OFFword = nint(start)
         call savew2 ( itr, ifmt_OFFword, l_OFFword, ln_OFFword, 
     :           OFFword, TRACEHEADER )

c reset coef 

         coef = 1.

c reset ramp start 

         start = start - float(ramp)

c generate co-efficients for trace 

         do j = 1,nsamp

            if(j*dt_units.lt.start) then
               mute_coefs(j) = coef
            else
               if(coef.gt.0.) then
                  coef =coef -1./(float(ramp)/dt_units)
              endif
               if(coef.lt.0.) coef = 0.
               mute_coefs(j) = coef
            endif
         enddo

         return

      ELSEIF ( mtype .eq. 'nearon' .or. mtype .eq. 'nearoff' ) then

c NEAR TRACE STACK CONTROL MUTE 

c get mute start time for this trace 

         call near ( rec, index, nseg, trc, ntr, traces, times, count, 
     :        mvel, dist, dt_units, nsamp, mtype, NoExtrap, NoInterp, 
     :        start )

c reduce start time to samples to be compatible with rest of calculation
c remember that sample 1 is time 0.0

         start = start / dt_units

c load mute start time to header for use with mute 

         if ( mtype .eq. 'nearon' ) then
            ONword = ifix(start)
            call savew2 ( itr, ifmt_ONword, l_ONword, ln_ONword, 
     :           ONword, TRACEHEADER )
         endif

         if ( mtype .eq. 'nearoff' ) then
            OFFword = ifix(start)
            call savew2 ( itr, ifmt_OFFword, l_OFFword, ln_OFFword, 
     :           OFFword, TRACEHEADER )
         endif

         if ( mtype .eq. 'nearon' ) then
            coef = 0.
            rampon = 'on'
         else
            coef = 1.
            rampon = 'off'
         endif

         do j = 1 , nsamp

c want 100 percent on or off by start 

            if ( j .gt. nint( start - float(ramp) / dt_units ) 
     :           .and. j .lt. nint(start) ) then

               if ( rampon .eq. 'on' ) then
                  coef = coef + 1./(float(ramp)/dt_units)
                  if ( coef .gt. 1. ) coef = 1
               elseif ( rampon .eq. 'off' ) then
                  coef = coef - 1./(float(ramp)/dt_units)
                  if(coef.lt.0.)coef = 0.
               endif
            elseif ( mtype .eq. 'nearon' .and. j .gt. nint(start) ) then
               coef = 1.
            elseif(mtype.eq.'nearoff'.and.j.gt.start)then
               coef = 0.
            endif
            mute_coefs(j) = coef
         enddo

         return

      ELSEIF ( mtype .eq. 'diston' .or. mtype .eq. 'distoff' ) then

         if ( mtype .eq. 'diston' ) then

            call DistOn ( rec, index, nseg, dist, ntr, traces, times, 
     :           count, NoExtrap, NoInterp, start )

            ONword = nint(start)
            call savew2 ( itr, ifmt_ONword, l_ONword, ln_ONword, 
     :           ONword, TRACEHEADER )

        elseif (mtype .eq. 'distoff' ) then

            call DistOff ( rec, index, nseg, dist, ntr, traces, times, 
     :           count, start, nsamp, dt_units, NoExtrap, NoInterp )

            OFFword = nint(start)
            call savew2 ( itr, ifmt_OFFword, l_OFFword, ln_OFFword, 
     :           OFFword, TRACEHEADER )

         endif

c reset start to account for ramp

         start = start - ramp

c generate co-efficients for trace

         if ( mtype .eq. 'diston' ) then

c reset coef for ON mute

            coef = 0.

            do j = 1,nsamp

               if ( (float(j) * dt_units) .lt. start ) then
                  mute_coefs(j) = coef
               else

c ramp on then pass

                  if ( coef .lt. 1. ) then
                     coef = 1. / ( float( ramp ) / dt_units ) + coef
                  endif
                  if ( coef .gt. 1. ) coef = 1.
                  mute_coefs(j) = coef
               endif

            enddo

         elseif ( mtype .eq. 'distoff' ) then

c reset coef for OFF mute

            coef = 1.

            do j = 1,nsamp

               if ( (float(j)*dt_units)  .lt. start ) then
                  mute_coefs(j) = coef
               else

c ramp on then pass

                  if ( coef .gt. 0. ) then
                     coef = coef - 1. / ( float( ramp ) / dt_units ) 
                  endif
                  if ( coef .lt. 0. ) coef = 0.
                  mute_coefs(j) = coef
               endif

            enddo
         endif
         return

      ELSE
    
c any new options go here 

         write(LERR,*)' mute requested ',mtype, ' not an option'
         write(LERR,*)' correct entry and re-run program'

      ENDIF

      stop
      end
