C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine stackoff ( rec, index, nseg, tr, ntr, recs, times, 
     :     count, start, dt_units, nsamp, NoInterp, NumPicks )

c return a start time for off mute of a single trace record

#include <f77/lhdrsz.h>

c passed variables  

      integer rec, index(2*SZSMPM,2), nseg, tr, ntr, count, nsamp
      integer NumPicks

      real    recs(NumPicks), times(NumPicks), start, dt_units

      logical NoInterp

c local variables  

      integer nelem, k

c initialize variables  

      start = 0.0

c determine placement of record relative to pick file  

      nelem = index(1,1)

      if ( rec .lt. ifix(recs(1)) .or. 
     :     rec .gt. ifix(recs(nelem) ) ) then

c do NOT extrapolate before first or beyond last pick, 
c instead return max time 

         start = nsamp * dt_units
         return
      endif

c interpolate within function           

      do k = 2 , nelem
         if ( rec .le. recs(k) ) then

c if no interpolation flag is set then only mute when rec is in
c pickfile

            if ( NoInterp .and. rec .ne. recs(k) ) then
               start = nsamp * dt_units
               return
            endif

            start = times(k-1) + ( (times(k) - times(k-1) ) / 
     :           ( recs(k) - recs(k-1) ) * ( rec - recs(k-1) ) )
            return
         endif
      enddo

      end
