C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine stackon ( rec, index, nseg, tr, ntr, recs, times, 
     :     count, NoExtrap, NoInterp, start )

c return a start time for on mute of a single trace record

#include <f77/lhdrsz.h>

c passed variables  

      integer rec, index(2*SZSMPM,2), nseg, tr, ntr, count

      real    recs(*), times(*), start

      logical NoExtrap, NoInterp

c local variables  

      integer nelem, k

c initialize variables  

      start = 0.0

c determine placement of record relative to pick file  

      nelem = index(1,1)

      if ( rec .le. ifix(recs(1)) ) then

c extrapolate from first pick unless either no extrapolation or no interpolation 
c options are on

         if ( rec .lt. ifix(recs(1)) .and. ( NoExtrap .or. NoInterp ) ) 
     :        then
            start = 0.0
         else
            start = times(1)
            return
         endif

      elseif ( rec .ge. ifix(recs(nelem)) ) then

c extrapolate from last pick unless no extrapolation or no interpolation 
c options are on

         if ( rec .gt. ifix(recs(nelem)) .and. 
     :        ( NoExtrap .or. NoInterp ) ) then
            start = 0.0
         else
            start = times(nelem)
            return
         endif

      endif

      if ( start .lt. 1.e-29 ) then

c interpolate within function           

         do k = 2,nelem

            if ( rec .le. recs(k) ) then

c if no interpolation is on and this record is not in the pickfile
c then do not mute

               if ( rec .ne. recs(k) .and. NoInterp ) then
                  start = 0.0
                  return
               endif

               start = times(k-1) + ( (times(k) - times(k-1) ) / 
     :              ( recs(k) - recs(k-1) ) * ( rec - recs(k-1) ) )

               return
            endif
         enddo
      endif

      end
