C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine check_v(vscl, vtap)

#include <f77/iounit.h>
#include <f77/sisdef.h>

      real vscl
      character vtap*256

c local variables

      integer iargcc, num_arg, i, k, length, m
      character*1 nums(11)

      integer lnstr
      character tbuf*256

      external sargvv
      character*256 sargvv

      logical numflag

c initialize variables

      nums(1) = '0'
      nums(2) = '1'
      nums(3) = '2'
      nums(4) = '3'
      nums(5) = '4'
      nums(6) = '5'
      nums(7) = '6'
      nums(8) = '7'
      nums(9) = '8'
      nums(10) = '9'
      nums(11) = '.'

      num_arg = iargcc()

c examine command line input argument by argument

      do i = 1, num_arg-1

c sargvv(0) is actually the routine name which is noninteresting

         tbuf = sargvv(i)
         length = lnstr(tbuf)

         if ( tbuf(2:3) .eq. 'vs' ) then

c examine the entry and see if there are anything but numbers
c present.  If so parse the -v first.  If not then parse vscl first.               

            do m = 4, length

               numflag = .false.

               do 100 k = 1, 11
                  if ( tbuf(m:m) .eq. nums(k) ) then
                     numflag = .true.
                     goto 100
                  endif
 100           enddo

               if ( .not. numflag ) then
                  call argstr ('-v',vtap, ' ', ' ')
                  call argr4  ('-vs',vscl,1.0,1.0)
                  return
               endif

            enddo

            call argr4  ('-vs',vscl,1.0,1.0)
            call argstr ('-v',vtap, ' ', ' ')
            return
            
         endif
      enddo

c if we get to here then there was no -vs on the command line
c so just parse the -v entry, default the scalar and return

      call argstr ('-v',vtap, ' ', ' ')
      vscl = 1.0

      return
      end
