C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine cmdln(ntap,otap,vtap,ns,ne,irs,ire,vrs,vre,stat,
     1     remove,reverse,top,bot,nn,verbos,hdrwrd,vscl, debug,
     2     cvel,vel_const)
      
c     get command arguments
c
c     ntap  - C      input file name
c     otap  - C      output file name
c     vtap  - C      velocity file name
c      ns   - I      start trace
c      ne   - I      stop end trace
c     irs   - I      start record
c     ire   - I      stop end record
c     vrs   - I      start velocity record
c     vre   - I      end velocity record
c    stat   - L      normalize stacked trace by # live traces
c  remove   - L      remove normal moveout
c  reverse  - L      read velocity/dips in reverse order
c     top   - L      use top nmo map
c     bot   - L      use bot nmo map
c      nn   - I      output xgraph data for trace nn
c    verbos - L      verbose output or not

      real        vscl, vel_const
      integer     ns,ne,irs,ire,vrs,vre,argis,nn
      character   ntap*(*),otap*(*),vtap*(*), hdrwrd * 6
      logical     stat,remove,reverse,verbos,top,bot, debug,cvel
      
      reverse = ( argis ('-B') .gt. 0 )

      debug = ( argis ('-debug') .gt. 0 )

      call argr4  ('-cv',vel_const,0.,0.)
      cvel = .false.
      if (vel_const .ne. 0.) cvel = .true.

      call argi4  ('-ev',vre,0,0)

      bot    = ( argis ('-E') .gt. 0 )

      call argstr ('-Hw',hdrwrd, 'DstSgn', 'DstSgn')

      call argi4  ('-ne',ne,0,0)
      call argi4  ('-ns',ns,0,0)
      call argstr ('-N', ntap, ' ', ' ' )

      call argstr ('-O', otap, ' ', ' ' )
      
      call argi4  ('-re',ire,0,0)
      call argi4  ('-rs',irs,0,0)
      remove = ( argis ('-R') .gt. 0 )

      call argi4  ('-sv',vrs,1,1)
      stat = ( argis ('-S') .gt. 0 )

      top = ( argis ('-T') .gt. 0 )

      call argi4  ('-XY',nn,0,0)

      verbos = ( argis ('-V') .gt. 0 )

c look to see if -vs is really a scalar or is the name
c of a velocity file i.e. -vsouthanna vs. -vs0.95

      if (.not. cvel) call check_v(vscl, vtap)


c
c ----- if remove then use bot as default -----
c

      if(remove)then

         if(.not.top.and..not.bot) bot = .true. 

      endif
      
      return
      end
