C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine getavg(nx,ns,x,y,mode,lwin,nwin,ovlp,
     : havg, z, dead, iws, iwe, ierror)
      real x(*),y(*),work(1),havg(*),medarr(1)
      integer z(*),iws,iwe
      real hmed(1)
      logical dead(*)
      integer ovlp,lwin,nwin,mode,ns,nx,knt(1)
      POINTER (pw,work),(pk,knt),(pm,medarr)
      POINTER (phm,hmed)
#include <localsys.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
      iget = nx*nwin*ISZBYT
      error=0
      abort=0
      call galloc(pk,iget,error,abort)
      iget = ns*ISZBYT
      call galloc(pw,iget,error,abort)
      if(mode.eq.3)then
       call galloc(pm,iget,error,abort)
       iget = nx*nwin*ISZBYT
       call galloc(phm,iget,error,abort)
      endif
      if(error.ne.0)then
       ierror =error
       return
      endif
C +---------------------------------------------------------+
C |                                                         |
C | Parameters are:                                         |
C |   nx     - number of traces to be processed             |
C |   ns     - Number of samples per trace                  |
C |    x     - data to be processed                         |
C |    y     - computed average gain curve                  |
C |    z     - work array (center sample # for each window) |
C |   lwin   - Length of the sliding window                 |
C |   nwin   - Number of windows                            |
C |   ovlp   - Overlap between windows (in samples)         |
C |   scale  - % of 2047 to scale to                        |
C |                                                         |
C +---------------------------------------------------------+
      jws = iws-1
      ndos = iwe - iws + 1
      do j=0,nx-1
       ib=j*nwin
       do i=1,nwin
        havg(i+ib)=0
        knt(i+ib)=0
        y(i+ib)=0
       end do
      end do
      do itrace=1,nx
       if(.not.dead(itrace)) then
       ib=(itrace-1)*nwin
       do kk=1,nwin
        if(kk.eq.1)then
         nmove=lwin
         ilast=lwin + iws - 1
         ifirst=iws
         if(lwin.eq.ndos)nmove=ndos
         jmove=nmove
        else
         ifirst=ifirst+ovlp
         nmove=lwin
         jmove=nmove
         ilast=ifirst+lwin-1
         if(ilast.gt.ndos)then
          jmove=ndos-ifirst+1
          ilast=ndos
         endif
        endif
        mid = ifirst + ovlp 
        z(kk)=mid
        do mm=1,nmove
         work(mm)=0.
        end do
        ndx=(itrace-1)*ns+ifirst
*       call vmov(x(ndx),1,work,1,jmove)
        do m=1,jmove
         work(m)=x(ndx+m-1)+1.
        end do
c +======================+
c | Get the ensemble sum |
c +======================+
        xavg=0.
        if(mode.eq.3)then
         jk=0
         do i=1,jmove
          if(work(i).ne.0.0)then
           jk=jk+1
           medarr(jk)=abs(work(i))
          endif
         end do
         call hsort(jk,medarr)
         if(jk/2*2.ne.jk)then
          ndx=jk/2+1
          xavg = medarr(ndx)
         else
          ndx=jk/2
          ndx1=ndx+1
          xavg=medarr(ndx1)+medarr(ndx)
          xavg=xavg/2.
         endif
         hmed(ib+kk)=xavg
         knt(kk+ib)=1
        else
         xknt=0.
         do i=1,jmove
          yx = work(i)
          xy = abs(yx)
          if(xy.ne.0.0)then
           if(mode.eq.0)then
            xavg = xavg+xy
           elseif(mode.eq.2)then
            xavg=xavg+log(xy)
           elseif(mode.eq.4)then
            xavg=xavg+yx
           else
            xavg=xavg+xy*xy
           endif
           xknt = xknt+1.
          endif
         end do
         knt(ib+kk)=xknt
         havg(ib+kk)=xavg
        endif
       end do
       endif
       do m=1,jmove
        work(m)=0.
       end do
      end do
c +==========================+
c | Get the ensemble average |
c +==========================+
      do itrace=0,nx-1
       ib=itrace*nwin
       if(mode.eq.3)then
        do i=1,nwin
         havg(i+ib)=hmed(i+ib)
        end do
       else 
        do kk=1,nwin
         xknt=knt(ib+kk)
         xavg=havg(ib+kk)
         if(xknt.ne.0.0)then
          if(mode.eq.0.or.mode.eq.4)then
           xavg = xavg/xknt
          elseif(mode.eq.2)then
           xavg = xavg/xknt
           xavg = exp(xavg)
          else
           xavg=xavg/xknt
           xavg = sqrt(xavg)
          endif
         else
          xavg = 0.
         end if
         havg(ib+kk)=xavg
        end do
       endif
      end do
      call gfree(pw)
      call gfree(pk)
      if(mode.eq.3)then
       call gfree(pm)
       call gfree(phm)
      endif
      return
      end
