C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c Author:  Kelly D. Crawford
c Date:    07/31/96
c Purpose: Part of the texture classification stuff.  This code takes
c          the reduced size output and blows it back up to match the
c          size of the original dataset.

      program brightsizing

c     Always requires variables to be declared.  Saves me much grief.
      implicit none

c Get machine dependent parameters
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <save_defs.h>

      integer     line_header(SZLNHD)
      integer     jerr, luin, luout, lbytes, lbyout
      integer     argis
      character   infn*(255), outfn*(255), name*(11)

      integer istat, ierr, abort
      integer input_trace_size, output_trace_size
      integer input_record_size, output_record_size
      real input_record, output_record
      pointer (memadr_input_record, input_record(2))
      pointer (memadr_output_record, output_record(2))

c     Line header variables.
      integer NumSmp, NumTrc, OrNTRC, OrNSMP

      data abort/0/
      data name/'BRIGHTSIZING'/

c     Give command line help if requested
      if (argis ('-?') .gt. 0 .or. argis ('-h') .gt. 0) then
         call brightsizing_help(ler)
         stop
      endif
 
c Open printout file
#include <f77/open.h>

c     Grab the command line arguments
      call argstr('-N', infn, ' ', ' ')
      call argstr('-O', outfn, ' ', ' ')

c     Open the input and output files
      call getln(luin,  infn,  'r', 0)
      call getln(luout, outfn, 'w', 1)

c     Grab the line header
      call rtape(luin, line_header, lbytes)
      if (lbytes .eq. 0) then
         write(lerr,*)'BRIGHTSIZING: no header read from unit ',luin
         write(ler,*)'BRIGHTSIZING: no header read from unit ',luin
         call exitfu(1)
      endif

c     Add the historical line header stuff
      call hlhprt(line_header, lbytes, name, len(name), lerr)
      call savhlh(line_header, lbytes, lbyout)

c     Extract stuff from the line header.  Note that the original number
c     of samples is going to be stored in the OrNREC header word.
      call saver(line_header, 'NumSmp', NumSmp, LINEHEADER)
      call saver(line_header, 'NumTrc', NumTrc, LINEHEADER)
      call saver(line_header, 'OrNTRC', OrNTRC, LINEHEADER)
      call saver(line_header, 'OrNREC', OrNSMP, LINEHEADER)

      write(lerr,*)'input samples  = ', NumSmp
      write(lerr,*)'input traces   = ', NumTrc
      write(lerr,*)'output samples = ', OrNSMP
      write(lerr,*)'output traces  = ', OrNTRC

c     We need space for one input record and one output record
      input_trace_size  = (NumSmp + ITRWRD) * SZSMPD
      input_record_size = input_trace_size * NumTrc
      write(lerr,*)'input_trace_size  = ', input_trace_size
      write(lerr,*)'input_record_size = ', input_record_size
      call galloc(memadr_input_record, input_record_size,
     1            ierr, abort)
c ???????????????????????????
      ierr = istat

      output_trace_size  = (OrNSMP + ITRWRD) * SZSMPD
      output_record_size = output_trace_size * OrNTRC
      write(lerr,*)'output_trace_size  = ', output_trace_size
      write(lerr,*)'output_record_size = ', output_record_size
      call galloc(memadr_output_record, output_record_size,
     1            ierr, abort)
      istat = istat + ierr

      if (istat .ne. 0) then
         write(lerr,*)'galloc memory allocation error from main'
         write(lerr,*)'istat = ',istat
         write(lerr,*)
         write(lerr,*)'probable cause: too much memory requested!'
         write(lerr,*)'go check your seismic headers and command'//
     1                ' line arguments!'
         write(lerr,*)
         write(lerr,*)'program BRIGHTSIZING aborted'
c
         write(ler,*)'galloc memory allocation error from main'
         write(ler,*)'istat = ',istat
         write(ler,*)
         write(ler,*)'probable cause: too much memory requested!'
         write(ler,*)'go check your seismic headers and command'//
     1                ' line arguments!'
         write(ler,*)
         write(ler,*)'program BRIGHTSIZING aborted'
         call exitfu(2)
      endif

c     Initialize all memory
      call vclr(input_record, 1, input_record_size/SZSMPD)
      call vclr(output_record, 1, output_record_size/SZSMPD)

c     Set the correct number of traces and samples in the line header
c     and write it to the output file.
      call savew(line_header, 'NumSmp', OrNSMP, LINEHEADER)
      call savew(line_header, 'NumTrc', OrNTRC, LINEHEADER)
      call wrtape(luout, line_header, lbyout)

c     Read the input record
      call read_record(input_record, NumTrc, NumSmp,
     1                 luin, input_trace_size, ITRWRD)

c     Convert the input to output
      call brightsize(input_record,  NumTrc, NumSmp,
     1                output_record, OrNTRC, OrNSMP, ITRWRD)

c     Write the output record
      call write_record(output_record, OrNTRC, OrNSMP,
     1                  luout, output_trace_size, ITRWRD)

c     Close the input and output files
      call lbclos(luin)
      call lbclos(luout)

      end
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c     Read in the input record
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      subroutine read_record(input_record, NumTrc, NumSmp,
     1                       luin, input_trace_size, lenhed)
      implicit none

      integer NumTrc, NumSmp, luin, input_trace_size, lenhed
      real input_record(-lenhed+1:NumSmp, NumTrc)
      integer i

c     Read each trace
      do i = 1, NumTrc
         call rtape(luin, input_record(-lenhed+1,i),
     1              input_trace_size)
      enddo

      end
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c     Blow up the input record to match the size of the output record
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      subroutine brightsize(input_record,  NumTrc, NumSmp,
     1                      output_record, OrNTRC, OrNSMP, lenhed)
      implicit none

      integer NumTrc, NumSmp, OrNTRC, OrNSMP, lenhed
      real input_record(-lenhed+1:NumSmp, NumTrc)
      real output_record(-lenhed+1:OrNSMP, OrNTRC)

c     Trace header variables (fast header access)
      integer ifmt_TrcNum, idx_TrcNum, len_TrcNum
      integer ifmt_StaCor, idx_StaCor, len_StaCor, StaCor

      integer i, j, k, l, m, hl, sp, tn1, tn2, traceno

c     FOR DEBUGGING ONLY!  FILL OUTPUT RECORD WITH -98765.
c     print*,'IN DEBUGGING MODE...'
c     do i = 1, OrNTRC
c        do j = -lenhed+1, OrNSMP
c           output_record(j,i) = -98765.0
c        enddo
c     enddo

c     Set up fast trace header access
      call savelu('TrcNum', ifmt_TrcNum, idx_TrcNum, len_TrcNum,
     1            TRACEHEADER)
      call savelu('StaCor', ifmt_StaCor, idx_StaCor, len_StaCor,
     1            TRACEHEADER)

c     Grab the first two trace numbers
      call saver2(input_record(-lenhed+1,1),
     1            ifmt_TrcNum, idx_TrcNum, len_TrcNum,
     2            tn1, TRACEHEADER)
      call saver2(input_record(-lenhed+1,2),
     1            ifmt_TrcNum, idx_TrcNum, len_TrcNum,
     2            tn2, TRACEHEADER)

c     Compute the number of copies of each trace that will be made (hl)
c     and the distance between the last dead trace and the tn1-st trace
c     in the output record (sp). 
      hl = tn2 - tn1
      sp = (hl - 1)/2
c     print*,'tn1, tn2, hl, sp = ', tn1, tn2, hl, sp
      if (hl .lt. 0 .or. sp .lt. 0) then
         print*,'We have a problem.  Negative halflengths and spacing'
         print*,'lengths are really bad...'
         print*,'tn1, tn2, hl, sp = ', tn1, tn2, hl, sp
         call exitfu(3)
      endif

c     Add the dead traces to the beginning of the output record.
      traceno = 1
      StaCor = 30000
      do j = 1, (tn1 - sp)
c        Copy trace header
         do i = -lenhed+1, 0
            output_record(i,traceno) = input_record(i, 1)
         enddo
c        Set trace number and the static correction
         call savew2(output_record(-lenhed+1, traceno),
     1               ifmt_TrcNum, idx_TrcNum, len_TrcNum,
     2               traceno, TRACEHEADER)
         call savew2(output_record(-lenhed+1, traceno),
     1               ifmt_StaCor, idx_StaCor, len_StaCor,
     2               StaCor, TRACEHEADER)
c        Set samples to 0.0
         do i = 1, OrNSMP
            output_record(i, traceno) = 0.0
         enddo
c        Increment the trace number
         traceno = traceno + 1
      enddo

c     Create the middle section of live traces
      do j = 1, NumTrc
c        Create hl copies of each trace in input_record
         do i = 1, hl
            call create_trace(OrNTRC, OrNSMP, NumTrc, NumSmp, 
     1                        tn1, hl, sp,
     2                        input_record, j, 
     3                        output_record, traceno,
     4                        lenhed)
            traceno = traceno + 1
         enddo
      enddo

c     Add the dead traces to the end of the output record.
      do j = 1, (OrNTRC - ((NumTrc*hl) + (tn1-sp)))
c        Copy trace header
         do i = -lenhed+1, 0
            output_record(i,traceno) = input_record(i, 1)
         enddo
c        Set trace number and the static correction
         call savew2(output_record(-lenhed+1, traceno),
     1               ifmt_TrcNum, idx_TrcNum, len_TrcNum,
     2               traceno, TRACEHEADER)
         call savew2(output_record(-lenhed+1, traceno),
     1               ifmt_StaCor, idx_StaCor, len_StaCor,
     2               StaCor, TRACEHEADER)
c        Set samples to 0.0
         do i = 1, OrNSMP
            output_record(i, traceno) = 0.0
         enddo
c        Increment the trace number
         traceno = traceno + 1

      enddo

      if (traceno .ne. OrNTRC + 1) then
         print *, 'Assertion error -- traceno = ', traceno
         stop
      endif

c     Create the first and last pad traces (dead traces).
c     StaCor = 30000
c     do j = 1, pad
c        Copy trace header
c        do i = -lenhed+1, 0
c           output_record(i,j) = input_record(i,1)
c           output_record(i,OrNTRC-j+1) = input_record(i,1)
c        enddo
c        Set samples to 0.0
c        do i = 1, OrNSMP
c           output_record(i,j) = 0.0
c           output_record(i,OrNTRC-j+1) = 0.0
c        enddo
c        Set StaCor to 30000 (this will mark trace as dead)
c        call savew2(output_record(-lenhed+1,OrNTRC-j+1),
c    1               ifmt_StaCor, idx_StaCor, len_StaCor,
c    2               StaCor, TRACEHEADER)
c     enddo
c
c     Create the middle traces.  j is the counter telling us which output
c     record we are looking at (we will make hl-1 more copies of trace j,
c     and then increment j by hl).
c     j = pad + 1
c     do i = 1, NumTrc
c        Copy the trace header
c NEED TO ACCOUNT FOR TRACE NUMBERS IN THE OUTPUT HEADERS!
c INPUT TRACE HEADER NUMBERS ARE 0-BASED (CORY THINKS...HE WILL CHECK THIS OUT)!
c        do k = -lenhed+1, 0
c           output_record(k,j) = input_record(k,i)
c        enddo
c
c        Make hl total copies of each sample with pad samples at the top
c        and bottom of the trace.  Then make hl copies of this trace.
c        Note that l is counter telling us which output sample we are looking
c        at (we will make hl-1 more copies of sample l, and then increment
c        l by hl).
c        do k = 1, pad
c           output_record(k,j) = 0.0
c           output_record(OrNSMP-k+1,j) = 0.0
c        enddo
c        l = pad + 1
c        do k = 1, NumTrc
c           Make copies of the k'th sample
c           do m = 0, hl-1
c              output_record(l+m,j) = input_record(k,i)
c           enddo
c           l = l + hl
c        enddo
c        if (l .ne. OrNSMP-pad+1) then
c           print*,'Assertion error -- i, j, k, l = ', i, j, k, l 
c           print*,'   OrNSMP, pad = ', OrNSMP, pad
c           print*,'l should be OrNSMP-pad+1'
c           stop
c        endif
c
c        Copy this output trace copies times.
c        do k = 1, hl-1
c           do l = -lenhed+1, OrNSMP
c              output_record(l,j+k) = output_record(l,j)
c           enddo
c        enddo
c
c        j = j + hl
c     enddo
c     if (j .ne. OrNTRC-pad+1) then
c        print*,'Assertion error -- i, j = ', i, j
c        print*,'   OrNTRC, pad = ', OrNTRC, pad
c        print*,'j should be OrNTRC-pad+1'
c        stop
c     endif

      end
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c     Create an output trace (with number traceno) from an input trace 
c     (with number in_traceno)
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      subroutine create_trace(OrNTRC, OrNSMP, NumTrc, NumSmp, 
     1                        tn1, hl, sp,
     2                        input_record, in_traceno, 
     3                        output_record, traceno,
     4                        lenhed)
      implicit none

      integer OrNTRC, OrNSMP, NumTrc, NumSmp, tn1, hl, sp 
      integer in_traceno, traceno, lenhed
      real input_record(-lenhed+1:NumSmp, NumTrc)
      real output_record(-lenhed+1:OrNSMP, OrNTRC)
      integer i, j, samp_no

      samp_no = 1
c     Add the dead samples at the beginning of the trace
      do i = 1, (tn1 - sp)
         output_record(samp_no, traceno) = 0.0
         samp_no = samp_no + 1
      enddo

c     Create the middle section of live samples
      do j = 1, NumSmp
c        Create hl copies of each sample in input trace
         do i = 1, hl
            output_record(samp_no, traceno) = 
     1                       input_record(j, in_traceno)
            samp_no = samp_no + 1
         enddo
      enddo

c     Add the dead samples at the end of the trace
      do i = 1, (OrNSMP - ((NumSmp*hl) + (tn1-sp)))
         output_record(samp_no, traceno) = 0.0
         samp_no = samp_no + 1
      enddo

      if (samp_no .ne. OrNSMP + 1) then
         print *, 'Assertion error -- samp_no = ', samp_no
         stop
      endif

      end
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c     Write out the output record
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      subroutine write_record(output_record, OrNTRC, OrNSMP,
     1                        luout, output_trace_size, lenhed)
      implicit none

      integer OrNTRC, OrNSMP, luout, output_trace_size, lenhed
      real output_record(-lenhed+1:OrNSMP, OrNTRC)
      integer i

c     Write each trace
      do i = 1, OrNTRC
         call wrtape(luout, output_record(-lenhed+1,i),
     1               output_trace_size)
      enddo

      end
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c     Help!!!
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      subroutine brightsizing_help(ler)
      implicit none
      integer ler
      write(ler,*) 'brightsizing [-N input_file]'
      write(ler,*) '             [-O output_file]'
      write(ler,*)
      write(ler,*) '-N input_file - input from bethe2d'
      write(ler,*) '-O output_file - original sized result'
      write(ler,*)
      write(ler,*) 'This code takes the reduced size texture'
      write(ler,*) 'analysis output and blows it back up to'
      write(ler,*) 'the size of the original data.  This is'
      write(ler,*) 'useful if you want to take the results'
      write(ler,*) 'back into an interpretation system.'
      write(ler,*)
      write(ler,*) 'If you are a Dilbert fan, you''ll get'
      write(ler,*) 'the joke in the name...'
      end
