C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C**********************************************************************C
C
C     PROGRAM MODULE CLEAN
C
C**********************************************************************C
C
C CLEAN READS SEISMIC TRACE DATA FROM AN INPUT FILE,
C AND cleans up the trace by doing a 3-pt running median filter
C a la Tukey:  3rssh; and by zeroing out any flagged dead traces
C
C SUBROUTINE CALLS: RTAPE, HLH, WRTAPE, SAVE, 3rssh
C
C**********************************************************************C
C
C     DECLARE VARIABLES
C

#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

#ifdef SUNSYSTEM
      external ofkill
#endif

      INTEGER     ITR ( SZLNHD )
      INTEGER     LHED( SZLNHD )
      INTEGER     NSAMP, NSI, NTRC, NREC, IFORM
      INTEGER     LUIN , LBYTES, NBYTES,obytes
      integer     argis
      REAL        wtrce(SZLNHD),xtr(SZLNHD),ztr(SZLNHD)
      CHARACTER   NAME * 5, ntap * 256, otap * 256
      character   ieee*9
#include <f77/pid.h>
      logical     verbos,smooth,rough,query,fix,dead,live,zero,mean
 
c     EQUIVALENCE ( ITR(129), xtr (1) )
      EQUIVALENCE ( ITR(  1), LHED(1) )
      DATA NAME     /'CLEAN'/
      DATA LUIN / 1 /, LBYTES / 0 /, NBYTES / 0 /
      DATA smooth/.false./, rough/.false./

C**********************************************************************C
C     get online help if necessary
C**********************************************************************C
      query = (argis('-?').gt.0 .or. argis('-h').gt.0)
      if( query ) then
          call help ()
          stop
      endif

C**********************************************************************C
C     open printout file
C**********************************************************************C
#include <f77/open.h>

C**********************************************************************C
C     READ PROGRAM PARAMETERS FROM COMMAND LINE ARGUMENT STRING
C**********************************************************************C
      call cmdln(ntap,otap,nst,ned,nrst,nred,
     &           smooth,rough,verbos,ieee,fix,thresh,dead,live,zero,
     &           pc,mean)

      threshi = 1./thresh
C**********************************************************************C
C     ieee float handler
C**********************************************************************C
c  the next 3 statements should appear right after all your main program
c  declarations, i.e., as the first active statements of your program
c  "invalid" can be replaced by:
c   overflow
c   underflow
c   inexact
c   all
c   which are all the ieee floating point arithmetic flags

#ifdef SUNSYSTEM
      IF (ieee .ne. ' ') THEN
          if (ieee .eq. 'all') then
              ieeer = ieee_handler('set','all',ofkill)
              ieeer = ieee_handler('clear','inexact',ofkill)
          elseif (ieee .eq. 'overflow') then
              ieeer = ieee_handler('set','overflow',ofkill)
          elseif (ieee .eq. 'underflow') then
              ieeer = ieee_handler('set','underflow',ofkill)
          elseif (ieee .eq. 'inexact') then
              ieeer = ieee_handler('set','inexact',ofkill)
          elseif (ieee .eq. 'invalid') then
              ieeer = ieee_handler('set','invalid',ofkill)
          endif
          if(ieeer .ne. 0) then
              write(LERR,*)'cannot set handler'
              stop
          endif
      ENDIF
#else
      ieee = ' '
#endif


C**********************************************************************C
C     READ AND UPDATE LINE HEADER,
C     WRITE LINE HEADER, SAVE KEY PARAMETERS.
C**********************************************************************C
      call getln( luin, ntap, 'r', 0)
      call getln(luout, otap, 'w', 1)
      lbytes = 0
      CALL RTAPE  ( LUIN, ITR, LBYTES           )
      if(lbytes .eq. 0) then
         write(LERR,*)'CLEAN: no header read on unit ',ntap
         write(LERR,*)'FATAL'
         write(LERR,*)'Check existence of file & rerun'
         stop
      endif
      CALL HLHprt    ( ITR , LBYTES, NAME, 5,         LERR)
#include <f77/saveh.h>

c     For trace header values we take mnemonics and build a
c     set of pointers to an I*2 array equivalenced to the
c     RTAPE  Integer array (headers + data)
c     TRACEHEADER is a value in the include file <sisdef.h> that
c     refers to the trace header
 
      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu('FlReFN',ifmt_FlReFN,l_FlReFN,ln_FlReFN,TRACEHEADER)


c-------------------------------
c  check defaults
c-------------------------------
      call cmdchk ( nst, ned, nrst, nred, ntrc, nrec )
      if(nsamp .gt. SZLNHD) nsamp=SZLNHD
      nrecc=nred-nrst+1
       call savew( itr, 'NumRec', nrec , LINHED)
      jtrc=ned-nst+1
       call savew( itr, 'NumTrc', ntrc , LINHED)
      obytes = SZTRHD + SZSMPD * nsamp
       call savew( itr, 'NumSmp', nsamp , LINHED)

c-----------------------------------
c  verbos printout
c-----------------------------------
c     if(verbos) then
         write(LERR,*)
         write(LERR,*)' Values read from input data set line header'
         write(LERR,*)
         write(LERR,*) ' # of Samples/Trace =  ', nsamp
         write(LERR,*) ' Sample Interval    =  ', nsi  
         write(LERR,*) ' Traces per Record  =  ', ntrc 
         write(LERR,*) ' Records per Line   =  ', nrec 
         write(LERR,*) ' Format of Data     =  ', iform
         write(LERR,*) ' Output bytes       =  ', obytes
         if(smooth)
     &     write(LERR,*)'smooth traces'
         if(rough)
     &     write(LERR,*)'roughen traces'
         if(ieee .ne. ' ')
     &     write(LERR,*)'ieee floating point handler flag= ',ieee
         if (fix) then
           write(LERR,*)'Will attempt to fix up bad trace values'
           write(LERR,*)'Tiny value threshold= ', thresh
         endif
         if (dead) then
           write(LERR,*)'% dead samples before trc killed= ',pc
         endif
         if (mean) then
           write(LERR,*)'Will remove mean from each trace'
         endif
         
c     endif

      pc = pc / 100.

c---------------------------------------
c  update historical line header
c---------------------------------------
      call savhlh ( itr, lbytes, lbyout )
      call wrtape(luout,itr,lbyout)

c---------------------------------------
c  pass to start record
c---------------------------------------
c     call recskp(1,nrst-1,luin,ntrc,itr)
      nbytes = obytes
      call recrw (1,nrst-1,luin,ntrc,itr,luout, nbytes)
      if (nbytes  .eq. 0) go to 999

C**********************************************************************C
C
C     READ TRACE, DO 3rssh smoothing
C
C**********************************************************************C
 
      DO 100 JJ = NRST, NRED

c----------------------------------------
c  pass to start trace of current record
c----------------------------------------
c           call trcskp(jj,1,nst-1,luin,ntrc,itr)
            nbytes = obytes
            call trcrw (JJ, 1, nst-1, luin, ntrc, itr, luout, nbytes)
            if (nbytes  .eq. 0) go to 999


           jtr=0
           DO 99 KK = NST, NED
               nbytes = 0
               CALL RTAPE  ( LUIN , ITR, NBYTES         )
               if(nbytes .eq. 0) then
                  write(LERR,*)'End of file on input:'
                  write(LERR,*)'  rec= ',jj,'  trace= ',kk
                  go to 999
               endif
               call vmov (lhed(ITHWP1), 1, xtr, 1, nsamp)

                  call saver2(lhed,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                        irec , TRACEHEADER)
                  call saver2(lhed,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                        itrc , TRACEHEADER)
                  call saver2(lhed,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                        istatic , TRACEHEADER)


               jtr=jtr+1
c-----------------------------------------------
c   if ieee handler is ON emit info on every trc

               if (ieee .ne. ' ') then
                  write(LERR,*)'Rec= ',irec,'  trc= ',itrc,
     1                          '  ieee checked o.k. & written out'
               endif

c-----------------------------------------------
c   is a trace underfowing? fix or mark it dead
c   is a trace overfowing? fix or mark it dead

               if (fix) then
                  call underfl (xtr, nsamp, ic,thresh)
                  if (ic .ne. 0)
     1            write(LERR,*)'Fixed ',ic,
     2            '  potential underflows for rec= ',irec,
     3            '  trc= ',itrc
               endif

               call maxmgv (xtr, 1, xmax, mx, nsamp)
               call minmgv (xtr, 1, xmin, mn, nsamp)

               if (xmin.lt.thresh .AND. xmin .ne. 0.0) then
                   write(LERR,*)'Record ',irec,'  Trace ',
     1             itrc,' has minimum value of ',xmin,
     2             ' at sample ',mn
               endif

               if (zero) then

                  if (istatic .eq. 30000) then
                     call vclr (xtr,1,nsamp)
                  else
                     call dotpr  (xtr, 1, xtr, 1, xdot, nsamp)
                     if (xdot .lt. thresh) then
                        call savew2(lhed,ifmt_StaCor,l_StaCor,ln_StaCor,
     1                              30000  , TRACEHEADER)
                        istatic = 30000
                     endif
                  endif

                  idead = 0
                  do  ii = 1, nsamp
                      if (xtr(ii) .eq. 0.0) idead = idead + 1
                  enddo
                  if (idead .ge. ifix(pc*nsamp) ) then
                     call savew2(lhed,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                           30000  , TRACEHEADER)
                     call vclr (xtr, 1, nsamp)
                  endif
               endif

               if (xmax .gt. threshi) then
                   write(LERR,*)'Record ',irec,'  Trace ',
     1             itrc,' has maximum value of ',xmax,
     2             ' at sample ',mx,' Trace marked as dead'
                   if (fix) then
                      call overfl (xtr, nsamp, ic,threshi)
                      if (ic .ne. 0)
     1                write(LERR,*)'Fixed ',ic,
     2                '  potential overflows for rec= ',irec,
     3                '  trc= ',itrc
                   else
                     call savew2(lhed,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                           30000  , TRACEHEADER)
                      write(LERR,*)' trace flagged as dead'
                   endif
               endif
c-----------------------------------------------

c---------------------------------
c   clean up formerly flagged dead traces
c   and reflag as dead
c---------------------------------
               if (dead) then
                  call saver2(lhed,ifmt_FlReFN,l_FlReFN, ln_FlReFN,
     1                        idflg  , TRACEHEADER)
                  if (idflg .eq. 30000) then
                      call savew2(lhed,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                            30000  , TRACEHEADER)
                      idflg    = 0
                      call savew2(lhed,ifmt_FlReFN,l_FlReFN, ln_FlReFN,
     1                            idflg  , TRACEHEADER)
                      call vclr (xtr, 1, nsamp)
                  endif
               endif
c---------------------------------
c   restore the dead to life
c   doing a -D later will reflag them dead
c---------------------------------
               if (live) then
                  if (istatic .eq. 30000) then
                      call savew2(lhed,ifmt_FlReFN,l_FlReFN, ln_FlReFN,
     1                            30000  , TRACEHEADER)
                      call savew2(lhed,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                            0      , TRACEHEADER)
                  endif
               endif
 
c---------------------------------
c   remove mean
c---------------------------------

               if (mean) then
                  dc = 0.
                  do  i = 1, nsamp
                      dc = dc + xtr(i)
                  enddo
                  dc = dc / float(nsamp)
                  do  i = 1, nsamp
                      xtr(i) = xtr(i) - dc
                  enddo
               endif
c---------------------------------
c   do 3rssh filtering
c---------------------------------
               if(smooth) then
                  call smooth3r(xtr,wtrce,nsamp)
                  call vmov ( wtrce, 1, xtr, 1, nsamp )
               elseif(rough)  then
                  call rough3r(xtr,wtrce,ztr,nsamp)
                  call vmov ( wtrce, 1, xtr, 1, nsamp )
               endif
 
               call vmov  (xtr, 1, lhed(ITHWP1), 1, nsamp)

               call wrtape(luout,itr,obytes)

   99      CONTINUE
                if(verbos) then
                   write(LERR,*)'Smoothed record ',irec
                endif

c---------------------------------------------
c  pass to end of current record
c---------------------------------------------
c           call trcskp(jj,ned+1,ntrc,luin,ntrc,itr)
            nbytes = obytes
            call trcrw (JJ, ned+1, ntrc, luin, ntrc, itr, luout, nbytes)

  100 CONTINUE
c------------------------
c  pass remainder of recs
      nbytes = obytes
      call recrw (nred+1, nrec, luin, ntrc, itr, luout, nbytes)
      if (nbytes .eq. 0) go to 999


  999 continue
         call lbclos(luin)
         call lbclos(luout)
      END
c
c         3rssh
c
c   x - input data vector
c   y - output filtered vector
c   n - number of data values
c
      subroutine smooth3r( x, y, n )
      real x(*), y(*)

      if( n .lt. 3 )then
         call swap( x, y, n )  
      else
         call big3r( x, y, n )
         call peaks( x, y, n )
         call swap( x, y, n )
         call big3r( x, y, n )
         call peaks( x, y, n )
         call swap( x, y, n )
         call big3r( x, y, n )
         call hanng( x, y, n )
      end if
      return
      end
c
      subroutine rough3r( x, y, z, n )
      real x(*), y(*), z(*)
      integer n
      integer i
      do 1 i = 1, n
         z(i) = x(i)
    1 continue 
      call smooth3r( x, y, n )
      do 2 i = 1, n
         y(i) = z(i) - y(i)
    2 continue
      return
      end
c
      integer function big3r( x,  y, n )
      integer n
      real x(*),  y(*)
      integer passes, stable
      passes  = 0
      call r3( x, y,  n )
c     do    while( stable( x, y, n ) .le. 0 )
      do 1 i=1,n
c - j.m.wade - 8/26/92 - where are the args to stable() ???
c       if(stable .le. 0) then
        if(stable( x, y, n ) .le. 0) then
                 passes = passes + 1
                 call swap( x, y, n )
                  call r3( x, y, n )
        else
                go to 2
        endif
    1 continue
    2 continue
      call endpt( x,  y, n )
      big3r = passes
      return
      end
c
      subroutine  r3( x, y, n )
      integer n
      real x(*),  y(*)
      integer i
      real fm3
      do  1 i = 2, n-1
         y(i) = fm3( x(i-1), x(i), x(i+1) )
    1 continue
      y(1) =  x(1)
      y(n)=x(n)
      return
      end
c
      subroutine  endpt( x, y, n )
      integer n
      real x(*),  y(*)
      real erule
      x(1) =  erule( x(1), x(2), x(3) )
      x(n) =  erule( x(n), x(n-1), x(n-2) )
      return
      end
c
      real function fm3(  x, y, z )
      real x, y,  z
      real a(3),  t
      integer i,  j
      a(1) =  x
      a(2) = y
      a(3) = z
      do  1 i = 1, 2
      do 2 j = 1, 3-i
                  if( a(j) .gt. a(j+1) ) then
                             t = a(j)
                        a(j) = a(j+1)
                        a(j+1) = t
                  end if
    2 continue
    1 continue
      fm3 = a(2)
      return
      end
c
      integer function stable ( x, y, n )
      integer n
      real x(*),  y(*)
      do  1 i = 1, n
         if( x(i) .ne. y(i) ) then
                  stable = 0
                  return
         end if
    1 continue
      stable  = 1
      return
      end
c
      subroutine  swap( x, y, n )
      integer n
      real x(*),  y(*)
      integer i
      real t
      do  1 i = 1, n
         t = x(i)
         x(i) = y(i)
         y(i) = t
    1 continue
      return
      end
c
      subroutine  peaks( x, y, n )
      integer n
      real x(*),  y(*)
      integer i
      real erule
      do  1 i = 1, n
         y(i) = x(i)
    1 continue
      if( n .lt.  4 ) then
      return
      end if
      do  2 i = 2, n-2
         if( x(i) .ne. x(i+1) ) then
c                ! do nothing
         else if( x(i) .eq. x(i-1) ) then
c                ! do nothing
         else if( x(i+1) .eq. x(i+2) ) then
c                  ! do nothing
       else if( ( x(i-1) .gt. x(i) ) .and. ( x(i+1) .gt. x(i+2) ) ) then
c                  ! do nothing
       else if( ( x(i-1) .lt. x(i) ) .and. ( x(i+1) .lt. x(i+2) ) ) then
c                  ! do nothing
         else
                  if( i .gt. 2 ) then
                             y(i) = erule( x(i), x(i-1), x(i-2) )
                  else
                             y(i) = x(i-1)
                  end if
                  if( i .lt. n-2 ) then
                             y(i+1) = erule( x(i+1), x(i+2), x(i+3) )
                  else
                             y(i+1) = y(i+2)
                  end if
         end if
    2 continue
      return
      end
c
      subroutine  hanng( x, y, n )
      integer n
      real x(*),  y(*)
      integer i
      do  1 i = 2, n-1
         y(i) = 0.25 * ( x(i-1) + 2.0*x(i) + x(i+1) )
    1 continue
       y(1) =  x(1)
       y(n) = x(n)
      return
      end
c
      real function erule( x, y,  z )
      real fm3
      erule = fm3( x, y,  y-2.0*(z-y) )
      return
      end

c------------------------------------------------------------------
c  online help section
c------------------------------------------------------------------
      subroutine  help
#include <f77/iounit.h>

        write(LER,*)' '
        write(LER,*)'Command Line Arguments for CLEAN: trace cleanup'
        write(LER,*)' '
        write(LER,*)'Input....................................... (def)'
        write(LER,*)' '
        write(LER,*)'-N[ntap]   -- input data set'
        write(LER,*)'-O[otap]   -- output data set'
        write(LER,*)'-S         -- smooth input data'
        write(LER,*)'-R         -- roughen input data'
        write(LER,*)'-E[ieee]   -- ieee real number handler - Sun only'
        write(LER,*)'      [all, invalid, inexact, overflow, underflow]'
        write(LER,*)' '
        write(LER,*)'Processing limits (everything else passed)'
        write(LER,*)'-ns[nstr]  -- start process trace number   (first)'
        write(LER,*)'-ne[netr]  -- end process trace number      (last)'
        write(LER,*)'-rs[nrst]  -- start process record number  (first)'
        write(LER,*)'-re[nred]  -- end process record number     (last)'
        write(LER,*)' '
        write(LER,*)'-F         -- zero out potential underflows'
        write(LER,*)'-t[tresh]  -- tiny value threshold        (1.E-20)'
        write(LER,*)'-D         -- formerly dead traces flagged dead'
        write(LER,*)'-L         -- dead traces zeroed & flagged live'
        write(LER,*)'-Z         -- automatically flag zero traces dead'
        write(LER,*)'-pc[pc]    -- % zero samps above which trace'
        write(LER,*)'              flagged as dead (used with -Z option'
        write(LER,*)'-M         -- remove mean from each trace'
        write(LER,*)'              and zero out flagged dead traces'
        write(LER,*)'-V         -- verbos printout'
        write(LER,*)' '
        write(LER,*)'Usage:'
        write(LER,*)'    clean -N[] -O[] -ns[] -ne[] -rs[] -re[] -f[]'
        write(LER,*)'          -E[] [-V -S -R -F [-D -L] [-Z -pc[]] -M]'
        write(LER,*)' '

      return
      end


c-----
c     get command arguments
c
c     ntap  - C*100  input file name
c     otap  - C*100  output file name
c      nst  - I      start trace
c      ned  - I      stop end trace
c     nrst  - I      start record
c     nred  - I      stop end record
c     ieee  - C*9    ieee handler flag
c    fix    - L      zero out upotential undeflows
c    thresh - R      tiny value threshold
c    smooth - L      output smoothed traces
c    rough  - L      output rough parts (glitches)
c    verbos - L      verbose output or not
c-----
      subroutine cmdln(ntap,otap,nst,ned,nrst,nred,
     &           smooth,rough,verbos,ieee,fix,thresh,dead,live,zero,
     &           pc,mean)
#include <f77/iounit.h>
      character  ntap*(*), otap*(*), ieee*(*)
      integer    argis,nst,ned,nrst,nred
      logical    smooth, rough, verbos, fix, dead, live, zero, mean
      real       thresh
      real*8     thresh8

          smooth = .true.
          rough  = .false.
          dead   = .false.
          live   = .false.
          zero   = .false.
          fix    = .false.
          mean   = .false.

          call argstr('-N',ntap,' ',' ') 
          call argstr('-O',otap,' ',' ') 
          call argi4('-ns',nst,1,1)
          call argi4('-ne',ned,0,0)
          call argi4('-rs',nrst,1,1)
          call argi4('-re',nred,0,0)
          call argr4('-pc',pc,100.0,100.0)
          call argstr('-E',ieee,' ',' ') 
          call argr8('-t', thresh8, 1.d-15, 1.d-15)
          thresh = thresh8
          if (thresh .lt. 1.E-30) thresh = 1.E-30
          fix    = (argis('-F') .gt. 0)
          smooth = (argis('-S') .gt. 0)
          rough  = (argis('-R') .gt. 0)
          live   = (argis('-L') .gt. 0)
          dead   = (argis('-D') .gt. 0)
          zero   = (argis('-Z') .gt. 0)
          mean   = (argis('-M') .gt. 0)
          verbos = (argis('-V') .gt. 0)

          if (dead .and. zero) then
             write(LERR,*)'Cannot use both -Z & -D option - pick one'
             write(LERR,*)'and rerun'
             write(LER ,*)'Cannot use both -Z & -D option - pick one'
             write(LER ,*)'and rerun'
             stop
          endif
          if (live .and. zero) then
             write(LERR,*)'Cannot use both -Z & -L option - pick one'
             write(LERR,*)'and rerun'
             write(LER ,*)'Cannot use both -Z & -L option - pick one'
             write(LER ,*)'and rerun'
          endif

      return
      end



c  ieee handler

c  output statements will be sent to stdout and will show up when running
c  the debugger
c  your application program will stop when one of the ieee floating point
c  exceptions listed below are triggered

c  the next 3 statements should appear right after all your main program
c  declarations, i.e., as the first active statements of your program
c  "invalid" can be replaced by:
c   overflow
c   underflow
c   inexact
c   all
c   which are all the ieee floating point arithmetic flags


c   the function block itself (below) can be placed at the end of your code
c   as a new function

#ifdef SUNSYSTEM
      integer function ofkill(sig,code,sigcontext)
      integer sig,code,sigcontext(5)

#include <f77/iounit.h>

      write(LERR,*)' ieeee exception code ',loc(code)
      return
      end
#endif


      subroutine underfl (x, n, ic,thresh)

#include <f77/iounit.h>

      real x(*)
c  go through a vector and zero out anything less than 1.e-20

      ic = 0
      do  1  i = 1, n

          xhld = abs(x(i))
          if (xhld .lt. thresh .AND. xhld .ne. 0.0) then
             x(i) = 0.
             ic = ic + 1
          endif

1     continue

      return
      end

      subroutine overfl (x, n, ic,thresh)

#include <f77/iounit.h>

      real x(*)
c  go through a vector and zero out anything less than 1.e-20

      ic = 0
      do  1  i = 1, n

          xhld = abs(x(i))
          if (xhld .gt. thresh)  then
             x(i) = 0.
             ic = ic + 1
          endif

1     continue

      return
      end
