C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       CONV                                                 *
C  ROUTINE TYPE:  MAIN                                                 *
C  PURPOSE:  CONVERT SIS FORMAT 1 DATASET TO FORMAT 3 DATASET.         *
C  ENTRY POINTS:  MAINLINE ENTRY                                       *
C  ARGUMENTS:     NONE                                                 *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:  ARGUS DOWDY                         ORIGIN DATE: 87/10/06  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 90/11/21  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      ARGIS   REAL -                                                  *
C      HELP         -                                                  *
C      OPENPR       -                                                  *
C      ARGSTR       -                                                  *
C      LBOPEN -                                                        *
C      RTAPE  -                                                        *
C      LBCLOS -                                                        *
C      WRTAPE -                                                        *
C      MOVE   -                                                        *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:                                                              *
C      6  ( OUTPUT SEQUENTIAL ) - TERMINAL                             *
C      LERR  ( OUTPUT SEQUENTIAL ) -                                   *
C  COMMON:           NONE                                              *
C  STOP CODES:                                                         *
C      =BLANK=  ( 3) -                                                 *
C      10       ( 1) -                                                 *
C      999      ( 1) -                                                 *
C      20       ( 1) -                                                 *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  joe m. wade                   REVISION DATE: 91/05/28  *
C   Fixed lbclos for unix systems where only one unit at a time may    *
C   be specified.
C   Also type argis as integer so it would work.
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:      1 DETECTED                               *
C      INTEGER*                                                        *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C*****************  ITEMS DELETED FROM DOCPACK  ************************
C  =============================== DATE: 87/10/08 ==================   *
C      10       ( 2) -                                                 *
C  =============================== DATE: 90/11/21 ==================   *
C      =BLANK=  ( 1) - NORMAL COMPLETION                               *
C********************  END OF DELETED ITEMS  ***************************
C***********************************************************************
C     PROGRAM CONV
C        A. DOWDY  10-6-87
C        CONVERT FORMAT 1 DATA TO FORMAT 3 DATA
C
#include <f77/iounit.h>
#include <f77/sisdef.h>
#include <f77/lhdrsz.h>
 
      REAL TRACE(6064),R4DATA(6000),OUT(6065)
      INTEGER HEAD(1500)
      INTEGER*2 I2DATA(6000),I2HEAD(3000),TRHEAD(128)
      integer argis
      logical query
      character*100 ntap,otap
      character*4 name
      EQUIVALENCE (TRACE(65),I2DATA(1))
      EQUIVALENCE (TRACE(1),TRHEAD(1))
      EQUIVALENCE (OUT(65),R4DATA(1))
      EQUIVALENCE (HEAD(1),I2HEAD(1))
      DATA LUIN/10/,LUOUT/20/
      data name /'CONV'/
C
C**********************************************************************C
C     get help if necessary
C**********************************************************************C
      query = ( argis ( '-?' ) .gt. 0 )
      if ( query )then
            call help()
            stop
      endif
c
C**********************************************************************C
C     open printout file
C**********************************************************************C
#include <f77/open.h>
 
      call argstr( '-N', ntap, ' ', ' ' )
      call argstr( '-O', otap, ' ', ' ' )
 
C**********************************************************************C
C     open data set logical units
C**********************************************************************C
      if ( ntap .ne. ' ' ) then
        call lbopen ( luin, ntap, 'r' )
        write(LERR,*)'Opened ',ntap,' as unit ',luin
      else
        luin=0
      endif
 
      if ( otap .ne. ' ' ) then
        call lbopen ( luout, otap, 'w' )
        write(LERR,*)'Opened ',otap,' as unit ',luout
      else
        luout=1
      endif
 
      NBYTES=0
      CALL RTAPE(LUIN,HEAD,NBYTES)
      IF(NBYTES.EQ.0) THEN
         WRITE(6,*) ' ERROR IN READING INPUT LINE HEADER - E O J'
         CALL LBCLOS(LUIN,LUOUT)
         STOP 10
      ENDIF
C
      IFM=I2HEAD(33)
      IF(IFM.EQ.3) THEN
         WRITE(6,*) ' TAPE FORMAT = ',IFM,'  ONLY FORMAT 1 IS ACCEPTED'
         CALL LBCLOS(LUIN,LUOUT)
         STOP 999
      ENDIF
C
      NTRACE=HEAD(13)
      NREC=HEAD(14)
      NSAMP=HEAD(16)
      I2HEAD(33)=3
C
      CALL WRTAPE(LUOUT,HEAD,NBYTES)
C
      LTR=0
      LRI=0
      NTR=NTRACE*NREC
      DO 100 I=1,NTR
      NBYTES=0
      CALL RTAPE(LUIN,TRACE,NBYTES)
      IF(NBYTES.EQ.0) THEN
         WRITE(6,*) ' END OF FILE WHEN TRYING TO READ TRACES - E O J'
         WRITE(6,*) ' LAST RECORD READ ',LRI, '   LAST TRACE READ ',LTR
         CALL LBCLOS(LUIN,LUOUT)
         STOP 20
      ENDIF
C
      LRI=TRHEAD(106)
      LTR=TRHEAD(107)
      CALL MOVE(1,OUT,TRACE,256)
         DO 50 J=1,NSAMP
         R4DATA(J)=I2DATA(J)
   50 CONTINUE
C
      NBYTES=256+4*NSAMP
      CALL WRTAPE(LUOUT,OUT,NBYTES)
  100 CONTINUE
c     CALL LBCLOS(LUIN,LUOUT)
      call lbclos(luin)
      call lbclos(luout)
      WRITE(6,*) 'DATA CONVERTED ---  E O J'
      STOP
      END
 
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       HELP                                                 *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      HELP                                                            *
C  ARGUMENTS:     NONE                                                 *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 90/11/21  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 90/11/21  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:                                                              *
C      LUER  ( OUTPUT SEQUENTIAL ) -                                   *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
      subroutine help
#include <f77/iounit.h>
c-----------------------------------------------------------------------------
c     online help screen
c-----------------------------------------------------------------------------
       write(luer,*)' '
       write(luer,*)'Command Line Arguments for CONV: '
       write(luer,*)'          convert format 1 data to format 3'
       write(luer,*)' '
       write(luer,*)'Input....................................... (def)'
       write(luer,*)' '
       write(luer,*)'-N[ntap]   -- input data set'
       write(luer,*)'-O[otap]   -- output data set'
       write(luer,*)' '
       write(luer,*)'Usage:'
       write(luer,*)'      utop -N[] -O[]'
       write(luer,*)' '
      return
      end
 
