/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
**	write stdin to a series of cartridges
*/
#include "globs.h"

/*
**	IO() returns 0 until it's finished, at which time it
**	returns 1.
*/
static int IOtoTape()
{
/*
*	if you need a buffer, make one
*/
    if(iobuffer == 0) {
	iobuffer = malloc(blockSize);
	blen = blockSize;
	bgood = 0;
    }
/*
**	if you need a drive, get one.
*/
    if(tape < 0)
	setUpDrive();
/*
**	if you don't have any data, get some
*/
    if(bgood <= 0)
	bgood = getInput();

/*
**	If we've seen input EOF we're done.
*/
    if(bgood <= 0) {
	finishDrive();
	return 1;
    }
/*
**	if you have some data, write it out
*/
    bout = write(tape, iobuffer, bgood);
    if(verbose)
	fprintf(stderr, "-- %ld out\n", bout);
/*
**	we're getting bout == -1 at eot.  the man page says
**	we should have gotten 0.  i'm going to try accepting
**	either.
*/
    if(bout <= 0) {
	finishDrive();
	return 0;
    }

    if(bout < bgood) {
	fprintf(stderr, "Bout/bgood = %ld/%ld ::", bout, bgood);
	fprintf(stderr, "PANIC:: can't happen.\n");
	exit(2);
    }
    totalBytes += bout;
    bgood = 0;
    return 0;
}

int tapeout()
{
    while(IOtoTape() == 0)
	;
    return 0;
}
