C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C**********************************************************************C
C
C     PROGRAM MODULE  CROSS:  crosscorrelate 2 data sets
C
C**********************************************************************C
C
C CROSS READS SEISMIC TRACE DATA FROM TWO INPUT FILES,
C computes the 2-sided crosscorrelation function (0-lag is mid output
C trace) and writes this to the output data set
C
C SUBROUTINE CALLS: RTAPE, HLH, WRTAPE, SAVE, cross
C
C**********************************************************************C
C
c Changes:
c        Nov 22, 2000 - I changed the logic in the section of the code
c                       that writes out the shifts to the shifts file.  
c                       it now writes the shift away from t0 as opposed
c                       to the sum of t0 and the shift.  This was requested
c                       by Ricard Crider [UTG:Sunbury]
c
c                       I also included implicit none, typed all the 
c                       variables and ran access/memory checking in the 
c                       debugger.  Code passes all.
c        Garossino
c
c
C     DECLARE VARIABLES
C

      implicit none

#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

      INTEGER     ITR1( 2*SZLNHD ), ITR2( 2*SZLNHD )
      INTEGER     LHED1( 2*SZLNHD )
      INTEGER     LHED2( 2*SZLNHD )
      INTEGER     NSAMP, IFORM
      INTEGER     LUIN , LUOUT, LBYTES, NBYTES,obytes
      integer     argis, pipe, ordfft
      integer     lagl, lagr, t0, jerr

c--------------------
c dynamic memory alloc

      INTEGER     itrhd
      REAL        xtr1( SZLNHD ),x1,x2
      pointer     (wkadr1 ,    x1(1))
      pointer     (wkadr2 ,    x2(1))
      pointer     (wkitrhd, itrhd(1))

c--------------------
c static memory alloc

      integer ist1, iend1, nst1, ned1, nrst1, nred1,ist2, iend2
      integer nst2, ned2, nrst2, nred2, ihw, luin2, luin1
      integer lbytes1, nsamp1, nsi1, ntrc1, nrec1, lbytes2, nsamp2
      integer nsi2, ntrc2, nrec2, ntr1, ntr2, nrecc1, nrecc2, iend
      integer nsampo1, nsampo2, nu, npow, lag, lagm, lbyout, item1
      integer item2, itemh, errcod, abort, jflag, ic1, jj, k1, k2
      integer iflag, kk, istatic1, k1hld, istrc1, k2hld, istatic2
      integer ishdr, istrc2, kk1, kk2, index, itim, it0, itemr
      integer recnum, trcnum, dphind, linind, static, slun
      pointer (wkrecnum, recnum(1))
      pointer (wktrcnum, trcnum(1))
      pointer (wkdphind, dphind(1))
      pointer (wklinind, linind(1))
      pointer (wkstatic, static(1))
      integer ifmt_mutvel, l_mutvel, ln_mutvel
      integer ifmt_watvel, l_watvel, ln_watvel
      integer ifmt_TrcNum, l_TrcNum, ln_TrcNum
      integer ifmt_RecNum, l_RecNum, ln_RecNum
      integer ifmt_SrcLoc, l_SrcLoc, ln_SrcLoc
      integer ifmt_RecInd, l_RecInd, ln_RecInd
      integer ifmt_DphInd, l_DphInd, ln_DphInd
      integer ifmt_LinInd, l_LinInd, ln_LinInd
      integer ifmt_DstSgn, l_DstSgn, ln_DstSgn
      integer ifmt_DstUsg, l_DstUsg, ln_DstUsg
      integer ifmt_StaCor, l_StaCor, ln_StaCor
      integer ifmt_hdrwrd, l_hdrwrd, ln_hdrwrd


      REAL        xtr2( 4*SZLNHD ), w1(4*SZLNHD), w2(4*SZLNHD)
      REAL        work1( 4*SZLNHD ), work2( 4*SZLNHD )
      real UnitSc, w1dot, w2dot, xmax, wscl, c1, c2, c3, cmax, tim
      real fshft

      CHARACTER   NAME * 5,  ntap2 * 256, ntap1* 256, otap * 256
      CHARACTER   sfile * 256, xgrtag * 8
      character  hdrwrd*6

      logical     verbos,xcor,heap,revrs,flip1,flip2,dbg
      logical     nonorm, flt, verb3d
      logical     pipe1, pipe2
 
c     EQUIVALENCE ( ITR1(129), xtr1(1) ),(itr2(129),xtr2(1))
      EQUIVALENCE ( ITR1(  1), LHED1(1) )
      EQUIVALENCE ( ITR2(  1), LHED2(1) )
      DATA NAME     /'CROSS'/
      DATA LUIN / 1 /, LUOUT  / 2 /, LBYTES / 0 /, NBYTES / 0 /
      DATA  obytes / 0 /, pipe/3/, xgrtag/'"Record='/
      data verbos/.false./,revrs/.false./,flip1/.false./,flip2/.false./
      data pipe1/.false./, pipe2/.false./
      data flt/.false./
      data verb3d/.false./

c------------------------------------------------------
c  get online help if necessary
c------------------------------------------------------
      if ( argis('-?') .gt. 0 .or. 
     :     argis('-h') .gt. 0 .or. 
     :     argis('-help') .gt. 0 )then
         call help()
         stop
      endif

C**********************************************************************C
C     open printout file
C**********************************************************************C
#include <f77/open.h>

C**********************************************************************C
C     get command line parameters
C**********************************************************************C
      call cmdln(ntap1,ntap2,otap,sfile,lagl,lagr,t0,hdrwrd,
     &                  ist1,iend1,nst1,ned1,nrst1,nred1,
     &                  ist2,iend2,nst2,ned2,nrst2,nred2,
     &                  xcor,verbos,revrs,flip1,flip2,ihw,dbg,
     &                  nonorm,verb3d)

C**********************************************************************C
C     open I/O data sets & get logical units
C**********************************************************************C
      if (ntap1(1:1) .eq. ' ' .AND. ntap2(1:1) .eq. ' ') then
         pipe1 = .true.
         pipe2 = .true.
         write(LERR,*)'cross assumed to be running inside IKP'
         call getln( luin2, ntap2, 'r', 0)
         call sisfdfit (luin1, pipe)
      else
         call getln( luin1, ntap1, 'r', 0)
         if (luin1 .eq. 0) pipe1 = .true.
         call getln( luin2, ntap2, 'r', 0)
         if (luin2 .eq. 0) pipe2 = .true.
      endif
      call getln( luout, otap , 'w', 1)
      if(luin1 .le. 0 .and. luin2 .le. 0) then
         write(LERR,*)'Data sets 1 & 2 cannot both be pipes...'
         write(LERR,*)'Rerun using a named file for one of them'
         write(LERR,*)'Usually data set 2 is the larger so it should be 
     & the pipe'
         stop
      endif

      if (sfile(1:1) .ne. ' ') then
         call alloclun (slun)
         open (slun, file = sfile, status = 'unknown', err=990)
         write(LERR,*)'Opened output file to store shifts'
         go to 991
990      write(LERR,*)'Could not open file for static shifts -- FATAL'
         write(LERR,*)'Seek professional help'
         stop
      endif
991   continue

C**********************************************************************C
C     read headers; save key values
C**********************************************************************C
      lbytes1=0
      CALL RTAPE ( LUIN1, ITR1, LBYTES1           )
      call saver(itr1, 'NumSmp', nsamp1, LINHED)
      call saver(itr1, 'SmpInt', nsi1  , LINHED)
      call saver(itr1, 'NumTrc', ntrc1 , LINHED)
      call saver(itr1, 'NumRec', nrec1 , LINHED)
      call saver(itr1, 'Format', iform , LINHED)
      if(lbytes1 .eq. 0) then
         write(LERR,*)'CROSS: no header read from data set ',ntap1
         write(LERR,*)'check existence of file & rerun'
         stop
      endif
      lbytes2=0
      CALL RTAPE ( LUIN2, ITR2, LBYTES2           )
      if(lbytes2 .eq. 0) then
         write(LERR,*)'CROSS: no header read from data set ',ntap2
         write(LERR,*)'check existence of file & rerun'
         stop
      endif
      call saver(itr2, 'NumSmp', nsamp2, LINHED)
      call saver(itr2, 'SmpInt', nsi2  , LINHED)
      call saver(itr2, 'NumTrc', ntrc2 , LINHED)
      call saver(itr2, 'NumRec', nrec2 , LINHED)
      call saver(itr2, 'Format', iform , LINHED)
      call saver(itr2, 'UnitSc', unitsc, LINHED)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(itr2, 'UnitSc', unitsc, LINHED)
      endif

      call savelu('MutVel',ifmt_MutVel,l_MutVel,ln_MutVel, LINEHEADER)
      call savelu('WatVel',ifmt_WatVel,l_WatVel,ln_WatVel, LINEHEADER)
 
      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('LinInd',ifmt_LinInd,l_LinInd,ln_LinInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      if (ihw .eq. 0) then
      call savelu( hdrwrd ,ifmt_hdrwrd,l_hdrwrd,ln_hdrwrd,TRACEHEADER)
      if (hdrwrd(1:4) .eq. 'Horz') flt = .true.
      else
          l_hdrwrd = ihw
          ifmt_hdrwrd = 4
          ln_hdrwrd = ln_StaCor
      endif

      CALL HLHprt    ( ITR2, LBYTES2, NAME, 5,         LERR)
      if(nsamp1 .gt. 2*SZLNHD) nsamp=2*SZLNHD
      if(nsamp2 .gt. 2*SZLNHD) nsamp=2*SZLNHD
      call cmdchk ( nst1, ned1, nrst1, nred1, ntrc1, nrec1)
      call cmdchk ( nst2, ned2, nrst2, nred2, ntrc2, nrec2)
      ntr1=ned1-nst1+1
      ntr2=ned2-nst2+1
      if(ntr1 .gt. 1 .and. ntr1 .ne. ntr2) then
        write(LERR,*)'FATAL ERROR in cross'
        write(LERR,*)'DSN 1 & DSN 2 number of traces mismatch'
        write(LERR,*)'# trcs DSN1 = ',ntrc1,' # trcs DSN2= ',ntrc2
        write(LERR,*)'Number of traces in data set 1 must either be'
        write(LERR,*)'equal to one or ',ntr2
        write(LERR,*)'Currently it is ',ntr1,' (',nst1,ned1,')'
        write(LER ,*)'FATAL ERROR in cross'
        write(LER ,*)'DSN 1 & DSN 2 number of traces mismatch'
        write(LER ,*)'# trcs DSN1 = ',ntrc1,' # trcs DSN2= ',ntrc2
        write(LER ,*)'Number of traces in data set 1 must either be'
        write(LER ,*)'equal to one or ',ntr2
        write(LER ,*)'Currently it is ',ntr1,' (',nst1,ned1,')'
        stop
      endif
       call savew( itr2, 'NumTrc', ntr2  , LINHED)
      nrecc1 = nred1-nrst1+1
      nrecc2 = nred2-nrst2+1
      if(nrecc1 .gt. 1 .and. nrecc1 .ne. nrecc2) then
        write(LERR,*)'FATAL ERROR in cross'
        write(LERR,*)'DSN 1 & DSN 2 number of records mismatch'
        write(LERR,*)'# recs DSN1 = ',nrec1,' # recs DSN2= ',nrec2
        write(LERR,*)'Number of records in data set 1 must either be'
        write(LERR,*)'equal to one or ',nrecc2
        write(LERR,*)'Currently it is ',nrecc1,' (',nred1,nrst1,')'
        write(LER ,*)'FATAL ERROR in cross'
        write(LER ,*)'DSN 1 & DSN 2 number of records mismatch'
        write(LER ,*)'# recs DSN1 = ',nrec1,' # recs DSN2= ',nrec2
        write(LER ,*)'Number of records in data set 1 must either be'
        write(LER ,*)'equal to one or ',nrecc2
        write(LER ,*)'Currently it is ',nrecc1,' (',nred1,nrst1,')'
        stop
      endif
       call savew( itr2, 'NumRec', nrecc2, LINHED)
c     if( verbos ) then
        write(LERR,*)
        write(LERR,*)' Values read from input data set line header'
        write(LERR,*)
        write(LERR,*) ' # of Samples/Trace =  ', nsamp1,' data set 1'
        write(LERR,*) ' Sample Interval    =  ', nsi1 ,' data set 1' 
        write(LERR,*) ' Traces per Record  =  ', ntrc1 ,' data set 1'
        write(LERR,*) ' Records per Line   =  ', nrec1 ,' data set 1'
        write(LERR,*) ' # of Samples/Trace =  ', nsamp2,' data set 2'
        write(LERR,*) ' Sample Interval    =  ', nsi2 ,' data set 2' 
        write(LERR,*) ' Traces per Record  =  ', ntrc2 ,' data set 2'
        write(LERR,*) ' Records per Line   =  ', nrec2 ,' data set 2'
        write(LERR,*) ' Format of Data     =  ', iform
        if(xcor) then
           write(LERR,*)'Doing Crosscorrelation '
           write(LERR,*)'Will put relative shift in static word= ',
     1                  hdrwrd
           if (nonorm) then
           write(LERR,*)'No normalization of crosscorrelation'
           else
           write(LERR,*)'Energy normalizing crosscorrelation'
           endif
           if (flt) then
            write(LERR,*)'Storing shift as float'
           else
            write(LERR,*)'Storing shift as integer'
           endif
        else
           write(LERR,*)'Doing Convolution'
        endif
        if (revrs) write(LERR,*)' Time reverse output trace'
        if (flip1) write(LERR,*)' Time reverse data set1 traces before'
        if (flip2) write(LERR,*)' Time reverse data set2 traces before'
        if (flip2.or.flip1) write(LERR,*)' processing'
c     endif
C**********************************************************************C
C     check time values; update historical line header; write header
C**********************************************************************C
      iend1=iend1/nsi1 + .5
      ist1=ist1/nsi1
      if(ist1 .le. 1) ist1=1
      if(iend1 .eq. 0) iend1=nsamp1
      if(iend1 .gt. nsamp1) iend=nsamp1
      iend2=iend2/nsi2 + .5
      ist2=ist2/nsi2
      if(ist2 .le. 1) ist2=1
      if(iend2 .eq. 0) iend2=nsamp2
      if(iend2 .gt. nsamp2) iend=nsamp2
      nsampo1=iend1-ist1+1
      nsampo2=iend2-ist2+1
      nu = ordfft (max(nsampo1,nsampo2))
      npow = 2 ** nu

      t0 = t0 / nsi2
      if (t0 .eq. 0) then
          t0 = 1
      endif

c------------
c set x-corr
c defaults
      if(xcor) then

         lag = iabs(lagl) + lagr + 1
         lagm= max(nsampo1 , nsampo2)
         if (lag .eq. 1) then
            lagl = lagm/2
            lagr = lagm/2
         endif
         if (lagl .gt. lagm) then
            write(LERR,*)' '
            write(LERR,*)'WARNING from cross:'
            write(LERR,*)'-L[] lag must be less than ',lagm
            write(LERR,*)'Will reset and run with this lag'
            write(LER ,*)' '
            write(LER ,*)'WARNING from cross:'
            write(LER ,*)'-L[] lag must be less than ',lagm
            write(LER ,*)'Will reset and run with this lag'
            lagl = lagm
         endif
         if (lagr .gt. lagm) then
            write(LERR,*)' '
            write(LERR,*)'WARNING from cross:'
            write(LERR,*)'-R[] lag must be less than ',lagm
            write(LERR,*)'Will reset and run with this lag'
            write(LER ,*)' '
            write(LER ,*)'WARNING from cross:'
            write(LER ,*)'-R[] lag must be less than ',lagm
            write(LER ,*)'Will reset and run with this lag'
            lagr = lagm
         endif
         lag = iabs(lagl) + lagr + 1
         if (t0 .eq. 1) t0 = (iabs(lagl) + lagr)/2 + 1
c------------
c set convol
c defaults
      else

         if (lagl .eq. 0 .and. lagr .eq. 0) then
            lag = nsampo1 + nsampo2
         elseif (lagr .eq. 0) then
            lag = lagl
         elseif (lagl .eq. 0) then
            lag = lagr
         else
            lag = lagl + lagr
         endif
         if (t0 .eq. 0) t0 = 1

      endif

      if (t0 .gt. Lag) then
         write(LERR,*)'0-lag time ',t0,' samples > total lags ',lag
         write(LERR,*)'increase lags or decrease t0'
         go to 999
      endif

      if (xcor .and. t0 .eq. 0 .and. lagl .ne. 0) then
         write(LERR,*)'cross-correlation:'
         write(LERR,*)'Cannot have t0=0 and nonzero negative lags'
         write(LERR,*)'Setting negative lagl = 0 if positive lags'
         write(LERR,*)'are nonzero'
         lagl = 0
         if (lagr .ne. 0) then
            t0 = 1
         else
            write(LERR,*)'cross-correlation:'
            write(LERR,*)'Positive & negative lags = 0 -- FATAL'
            go to 999
         endif
         lag = lagl + lagr
      endif

      call savew( itr2, 'NumSmp', lag , LINHED)
      obytes = SZTRHD + SZSMPD * lag
      call savhlh( itr2, lbytes2, lbyout)
      CALL WRTAPE ( LUOUT, ITR2, LBYOUT                 )

c     if( verbos ) then
        write(LERR,*)
        write(LERR,*)' Line header values after default check '
        write(LERR,*)
        write(LERR,*) ' # Samples Correlated = ',nsampo1,' dsn 1'
        write(LERR,*) ' # Samples Correlated = ',nsampo2,' dsn 2'
        write(LERR,*) ' Sample Interval    =  ', nsi2 
        write(LERR,*) ' Start sample dsn 1 =  ',ist1
        write(LERR,*) ' Start sample dsn 2 =  ',ist2
        write(LERR,*) ' Start trace dsn 1   =  ',nst1
        write(LERR,*) ' End trace dsn 1     =  ',ned1
        write(LERR,*) ' Start trace dsn 2   =  ',nst2
        write(LERR,*) ' End trace dsn 2     =  ',ned2
        write(LERR,*) ' Start record dsn 1  =  ',nrst1
        write(LERR,*) ' End record dsn 1    =  ',nred1
        write(LERR,*) ' Start record dsn 2  =  ',nrst2
        write(LERR,*) ' End record dsn 2    =  ',nred2
        write(LERR,*) ' Traces per Record  =  ', ntr1,' dsn1'
        write(LERR,*) ' Traces per Record  =  ', ntr2,' dsn2'
        write(LERR,*) ' Records per Line   =  ', nrecc1,' dsn 1'
        write(LERR,*) ' Records per Line   =  ', nrecc2,' dsn 2'
        write(LERR,*) ' Format of Data     =  ', iform
        write(LERR,*) ' + Lags to crosscorr=  ',lagr
        write(LERR,*) ' - Lags to crosscorr=  ',lagl
        write(LERR,*) ' Total lags         =  ',lag
        if (xcor) then
           write(LERR,*) ' Time of 0-lag (samples) =  ',t0
        else
           write(LERR,*) ' Time to start outputting convolutions =  ',t0
        endif
c     endif

c---------------------------------------------------
c  malloc only space we're going to use
      heap = .true.

      item1 = ntr1 * nsampo1
      item2 = ntr2 * nsampo2
      itemh = ntr2 * ITRWRD
      itemr = ntr2

      call galloc (wkadr1, item1*SZSMPD, errcod, abort)
      if (errcod .ne. 0) heap = .false.
      call galloc (wkadr2, item2*SZSMPD, errcod, abort)
      if (errcod .ne. 0) heap = .false.
      call galloc (wkitrhd, itemh*SZSMPD, errcod, abort)
      if (errcod .ne. 0) heap = .false.
      call galloc (wkrecnum, itemr*SZSMPD, errcod, abort)
      if (errcod .ne. 0) heap = .false.
      call galloc (wktrcnum, itemr*SZSMPD, errcod, abort)
      if (errcod .ne. 0) heap = .false.
      call galloc (wkdphind, itemr*SZSMPD, errcod, abort)
      if (errcod .ne. 0) heap = .false.
      call galloc (wklinind, itemr*SZSMPD, errcod, abort)
      if (errcod .ne. 0) heap = .false.
      call galloc (wkstatic, itemr*SZSMPD, errcod, abort)
      if (errcod .ne. 0) heap = .false.

      if (.not. heap) then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) item1*SZSMPD,'  bytes'
         write(LERR,*) item2*SZSMPD,'  bytes'
         write(LERR,*) itemh*SZSMPD,'  bytes'
         write(LERR,*) itemr*SZSMPD,'  bytes'
         write(LERR,*) itemr*SZSMPD,'  bytes'
         write(LERR,*) itemr*SZSMPD,'  bytes'
         write(LERR,*) itemr*SZSMPD,'  bytes'
         write(LERR,*) itemr*SZSMPD,'  bytes'
         write(LERR,*)' '
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) item1*SZSMPD,'  bytes'
         write(LERR,*) item2*SZSMPD,'  bytes'
         write(LERR,*) itemh*SZSMPD,'  bytes'
         write(LERR,*) itemr*SZSMPD,'  bytes'
         write(LERR,*) itemr*SZSMPD,'  bytes'
         write(LERR,*) itemr*SZSMPD,'  bytes'
         write(LERR,*) itemr*SZSMPD,'  bytes'
         write(LERR,*) itemr*SZSMPD,'  bytes'
         write(LERR,*)' '
      endif
c---------------------------------------------------

C**********************************************************************C
C    skip to desired portions of data sets 1 & 2
C**********************************************************************C
      call unitrs(1,nrst1-1,luin1,ntrc1,itr1,pipe1)
      call unitrs(1,nrst2-1,luin2,ntrc2,itr2,pipe2)

C**********************************************************************C
C     READ TRACE, cross correlate data 1 with data 2
C**********************************************************************C
      jflag = 0
      ic1 = 0

      DO 100 JJ = NRST2, NRED2
           k1 = 0
           k2 = 0
           iflag = 0
c-------------------------------
c  skip initial traces
c-------------------------------
            call unitts(nrst1+ic1,1,nst1-1,luin1,ntrc1,itr1,pipe1)
            call unitts(jj,1,nst2-1,luin2,ntrc2,itr2,pipe2)

           DO 97 KK = NST1, NED1

                if(iflag .eq. 0 .and. jflag .eq. 0) then
                  CALL RTAPE  ( LUIN1 , ITR1, NBYTES         )
                  if (dbg ) then
                     write(LERR,*)'Reading N1: rec/trc= ',itr1(106),
     1                             itr1(107),'  KK= ',kk
                  endif
                  if(nbytes .eq. 0) then
                     write(LERR,*)'End of file on input 1:'
                     write(LERR,*)'  rec= ',jj,'  trace= ',kk
                     go to 999
                  endif

                  call vmov (lhed1(ITHWP1), 1, xtr1, 1, nsamp1)
                  call saver2(lhed1,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                        istatic1, TRACEHEADER)
                  k1 = k1 + 1
                  k1hld = k1
                endif
c-------------------------------------
c  grab correlating function or
c  wavelet to convolve
c-------------------------------------
                if (iflag .eq. 0 .and. jflag .eq. 0) then
                    istrc1 = (k1-1)*nsampo1
                    call vmov(xtr1(ist1),1,x1(istrc1+1),1,nsampo1)
                    if(istatic1 .eq. 30000) then
                       call vclr(x1(istrc1+1),1,nsampo1)
                    endif
                endif
                if(ntr1 .eq. 1) iflag = 1
   97      CONTINUE

           DO 98 KK = NST2, NED2
                k2 = k2 + 1
                k2hld = k2

                nbytes = 0
                CALL RTAPE  ( LUIN2 , ITR2, NBYTES         )
                if(nbytes .eq. 0) then
                   write(LERR,*)'End of file on input 2:'
                   write(LERR,*)'  rec= ',jj,'  trace= ',kk
                   go to 999
                endif
                  call vmov (lhed2(ITHWP1), 1, xtr2, 1, nsamp2)
                  call saver2(lhed2,ifmt_TrcNum,l_TrcNum,ln_TrcNum,
     1                        trcnum(k2), TRACEHEADER)
                  call saver2(lhed2,ifmt_RecNum,l_RecNum,ln_RecNum,
     1                        recnum(k2), TRACEHEADER)
                  call saver2(lhed2,ifmt_DphInd,l_DphInd,ln_DphInd,
     1                        dphind(k2), TRACEHEADER)
                  call saver2(lhed2,ifmt_LinInd,l_LinInd,ln_LinInd,
     1                        linind(k2), TRACEHEADER)
                  call saver2(lhed2,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                        istatic2, TRACEHEADER)
                  static(k2) = istatic2
c-------------------------------------
c  save header for data set 2
c-------------------------------------
                 ishdr = (k2-1) * ITRWRD
                 call vmov (lhed2, 1, itrhd(ishdr+1), 1, ITRWRD)
 
c-------------------------------------
c  grab appropriate parts of traces
c  to be correlated or convolved onto
c-------------------------------------
                istrc2 = (k2-1)*nsampo2
                call vmov(xtr2(ist2),1,x2(istrc2+1),1,nsampo2)
                if(istatic2 .eq. 30000) then
                   call vclr(x2(istrc2+1),1,nsampo2)
                endif

   98      CONTINUE
c-------------------------------
c  skip to end of current record
c-------------------------------
            if(nrecc1 .ne. 1) then
               call unitts(nrst1+ic1,ned1+1,ntrc1,luin1,ntrc1,itr1,
     1                     pipe1)
               ic1 = ic1 + 1
            else
               jflag = 1
            endif
            call unitts(jj,ned2+1,ntrc2,luin2,ntrc2,itr2,pipe2)


           kk1 = 0
           DO  99  KK2 = 1, k2hld

c-----------------------------------------------
c  do correlations
c-----------------------------------------------
                call vclr (w2, 1, max(nsampo1,nsampo2,lag))
                call vclr (xtr1, 1, max(nsampo1,nsampo2,lag))
                call vclr (xtr2, 1, max(nsampo1,nsampo2,lag))

                if (kk1 .lt. k1hld) then
                    kk1 = kk1 + 1
                    istrc1 = (kk1-1)*nsampo1
                    call vclr (w1, 1, max(nsampo1,nsampo2,lag))
                    call vmov(x1(istrc1+1),1,w1,1,nsampo1)

                endif

                istrc2 = (kk2-1)*nsampo2
                call vmov(x2(istrc2+1),1,w2,1,nsampo2)

                if (flip1) call vrvrs (w1, 1, nsampo1)
                if (flip2) call vrvrs (w2, 1, nsampo2)

c-----------------
c X-correlation
c-----------------
                IF (xcor) THEN

                   call dotpr (w1, 1, w1, 1, w1dot, nsampo1)
                   if ( nonorm ) then
                      w2dot = 1.0
                   else
                      call dotpr (w2, 1, w2, 1, w2dot, nsampo2)
                   endif

c---------------------
c negative side x-corr
                   call vmov (w1, 1, work1, 1, nsampo1)
                   call vmov (w2, 1, work2, 1, nsampo2)
                   if (lagl .gt. 0) then
c                     call crossc (w2, nsampo2, w1, nsampo1, xtr1(1),
c    1                             lagl)
                      call ccorf  (w2, w1, xtr1, lagl, npow)
                      call vmov (xtr1(2), 1, xtr2(t0-1), -1, lagl-1)
                   elseif (lagl .lt. 0) then
c                     call crossc (w2, nsampo2, w1, nsampo1, xtr1(1),
c    1                             iabs(lagl))
                      call ccorf  (w2, w1, xtr1, iabs(lagl), npow)
                      call vmov (xtr1, 1, xtr2(t0), 1, iabs(lagl))
                   endif
                   call vclr (w1, 1, npow)
                   call vclr (w2, 1, npow)
                   call vmov (work1, 1, w1, 1, nsampo1)
                   call vmov (work2, 1, w2, 1, nsampo2)
c---------------------
c positive side x-corr
                   if (lagr .ne. 0) then
c                     call crossc (w1, nsampo1, w2, nsampo2, xtr1,
c    1                             lagr+1)
                      call ccorf  (w1, w2, xtr1, lagr+1, npow)
                      call vmov (xtr1, 1, xtr2(t0), 1, lagr+1)
                   endif
                   call vclr (w1, 1, npow)
                   call vclr (w2, 1, npow)
                   call vmov (work1, 1, w1, 1, nsampo1)
                   call vmov (work2, 1, w2, 1, nsampo2)

c---------------------
c apply energy norm
                   if ( w1dot .ne. 0.0 .AND. w2dot .ne. 0.0) then
c
c added call to maxv to set index to position of max xcorr - jev
c
                       call maxv (xtr2, 1, xmax, index, lag)
                       if (.not. nonorm) then
                          wscl = sqrt ( w1dot * w2dot )
                          call vsdiv (xtr2, 1, wscl, xtr2, 1, lag)
                       endif
                       if (index .gt. 1 .AND. index .lt. lag) then
                          c1 = xtr2 (index - 1)
                          c2 = xtr2 (index)
                          c3 = xtr2 (index + 1)
                          call parab (c1, c2, c3, fshft, cmax)
                          tim = (float(index) + fshft - t0) * 
     :                         float(nsi1)
                       else
                          tim = (index - t0) * nsi1
                       endif
                   else
                       tim = 0.0
                       call vclr (xtr2, 1, lag)
                   endif
                   itim = nint ( tim )

                   if (sfile(1:1) .ne. ' ') then
                      if (verb3d) then
                       if (static(kk2) .ne. 30000) then
                       write(slun,855)recnum(kk2),trcnum(kk2),
     1                                linind(kk2),dphind(kk2),tim
                       endif
855                    format(4i10,5x,f12.3)
                      else
                       if (kk2 .eq. 1) then
                           write(slun,890) xgrtag,jj
890                        format(a8,1x,i5)
                       endif
                       write(slun,888) kk2, tim
888                    format(i6,f10.3)
                       if (kk2 .eq. k2hld) then
                           write(slun,889)
889                        format()
                       endif
                      endif
                   else
                      if (verb3d) then
                       write(LERR,*)'3D  ',recnum,trcnum,linind,dphind,
     1                                   tim
                      endif
                   endif

                   if (verbos) then
                      write(LERR,*)'Record ',JJ,
     1                   '  Trace ',KK2,'  Max Corr at sample= ',
     2                   index,'  Relative static shift= ',tim
                   endif
c-----------------
c Convolution
c-----------------
                ELSE

                   call crossf (w1, nsampo1, w2, nsampo2, xtr1,
     1                          lag)
                   if (t0 .lt. 0) then
                       it0 = -t0
                       call vmov (xtr1(1), 1, xtr2(it0), 1, lag-it0+1)
                   elseif (t0 .ge. 1) then
                       call vmov (xtr1(t0), 1, xtr2, 1, lag-t0+1)
                    endif

                ENDIF
          
                if (revrs) then
                   call vrvrs (xtr2, 1, lag)
                endif

c---------------------------------
c  get headers back
c  for x-corr put shift in trc hdr
c---------------------------------
                ishdr = (kk2-1) * ITRWRD
                call vmov (itrhd(ishdr+1), 1, lhed2, 1, ITRWRD)
                if (xcor) then
                   if (flt) then
                   call savew2(lhed2,ifmt_hdrwrd,l_hdrwrd, ln_hdrwrd,
     1                          tim   , TRACEHEADER)
                   else
                   call savew2(lhed2,ifmt_hdrwrd,l_hdrwrd, ln_hdrwrd,
     1                         itim   , TRACEHEADER)
                   endif
                endif

                call vmov (xtr2, 1, lhed2(ITHWP1), 1, lag)
 
                call wrtape( luout, itr2, obytes)
   99      CONTINUE

c------------------------------------
c  do next record
c------------------------------------
  100 CONTINUE


  999 continue
        if (sfile(1:1) .ne. ' ') close (slun)
        call lbclos(luin1)
        call lbclos(luin2)
        call lbclos(luout)
      END

c---------------------------------------------------c
c  online help section
c---------------------------------------------------c
      subroutine help
#include <f77/iounit.h>

        write(LER,*)' '
        write(LER,*)'Command Line Arguments for CROSS: crosscorrelate'
        write(LER,*)'                                  convolve'
        write(LER,*)' '
        write(LER,*)'Input....................................... (def)'
        write(LER,*)' '
        write(LER,*)'-N1,2[ntap]-- input data set names'
        write(LER,*)'              N1 should be wavelet or pilot signal'
        write(LER,*)'              N2 should be the primary data set'
        write(LER,*)'-O[otap]   -- output data set name'
        write(LER,*)'-S[sfile]  -- optional file for static shifts'
        write(LER,*)' '
        write(LER,*)'-L[lagl]   -- x-corr: number negative lags'
        write(LER,*)'-R[lagr]   -- x-corr: number positive lags'
        write(LER,*)'              conv: output samps = lagl + lagr'
        write(LER,*)'              Defaults:'
        write(LER,*)'              x-corr: none - must specify -L & -R'
        write(LER,*)'              conv: output samps = nsamp1 + nsamp2'
        write(LER,*)'              NOTE:'
        write(LER,*)'              For short wavelets (N1) use conv opt'
        write(LER,*)'              For x-corr N1 & N2 should have same'
        write(LER,*)'              trace length to avoid wrapping probs'
        write(LER,*)'-t[t0]     -- time to put 0-lag position on output'
        write(LER,*)'           -- conv: time to start output trace'
        write(LER,*)'-Hw[ihw]   -- x-corr: put shift in trc word (125)'
        write(LER,*)' '
        write(LER,*)'-s1[ist]   -- start time         (N1)       (0 ms)'
        write(LER,*)'-e1[iend]  -- end time           (N1)  (last samp)'
        write(LER,*)'-ns1[nst]  -- start trace number (N1)   (first tr)'
        write(LER,*)'-ne1[ned]  -- end trace number   (N1)    (last tr)'
        write(LER,*)'-rs1[nrst] -- start record       (N1)  (first rec)'
        write(LER,*)'-re1[nred] -- end record         (N1)   (last rec)'
        write(LER,*)' '
        write(LER,*)'-s2[ist]   -- start time         (N2)       (0 ms)'
        write(LER,*)'-e2[iend]  -- end time           (N2)  (last samp)'
        write(LER,*)'-ns2[nst]  -- start trace number (N2)   (first tr)'
        write(LER,*)'-ne2[ned]  -- end trace number   (N2)    (last tr)'
        write(LER,*)'-rs2[nrst] -- start record       (N2)  (first rec)'
        write(LER,*)'-re2[nred] -- end record         (N2)   (last rec)'
        write(LER,*)' '
        write(LER,*)'-flip1     -- time reverse data1 traces before ops'
        write(LER,*)'-flip2     -- time reverse data2 traces before ops'
        write(LER,*)'-F         -- if present time reverse output trace'
        write(LER,*)'-X         -- if present do x-correlation, '
        write(LER,*)'              else do convolution'
        write(LER,*)'-XN        -- do correlation with no normalization'
        write(LER,*)'-V         -- verbos printout'
        write(LER,*)'-V3d       -- verbos 3D printout'
        write(LER,*)' '
        write(LER,*)'Usage:'
        write(LER,*)'   cross -N1[] -N2[] -O[] -L[] -R[] [-F -X -XN -V]'
        write(LER,*)'         -s1[] -e1[] -ns2[] -ne1[] -rs1[] -re1[]'
        write(LER,*)'         -s2[] -e2[] -ns2[] -ne2[] -rs2[] -re2[]'
        write(LER,*)'         -t[] -Hw[] -S[] -V3d'
        write(LER,*)' '
      
      return
      end

c-----
c     get command arguments
c
c     ntap1 - C*100  input file name
c     ntap2 - C*100  input file name
c     otap  - C*100  output file name
c     sfile - C*100  optional file for static shifts
c     lagl  - I      number left lags (for data sets 1 & 2 - ditto for the rest)
c     lagr  - I      number right lags (for data sets 1 & 2 - ditto for the rest)
c     t0    - I      time to put 0-lag on output for x-corr
c     ist1,2- I      start time 
c    iend1,2- I      stop time
c     nst1,2- I      start trace
c     ned1,2- I      stop end trace
c    nrst1,2- I      start record
c    nred1,2- I      stop end record
c     ihw   - I      header word to put relative shift of x-corr
c    flip1  - L      time reverse data set 1 before processing
c    flip2  - L      time reverse data set 2 before processing
c    revrs  - L      time reverse output trace
c    xcor   - L      if true do x-correlation; else do convolution
c    verbos - L      verbose output or not
c    verb3d - L      verbose 3d output
c-----
      subroutine cmdln(ntap1,ntap2,otap,sfile,lagl,lagr,t0,hdrwrd,
     &                  ist1,iend1,nst1,ned1,nrst1,nred1,
     &                  ist2,iend2,nst2,ned2,nrst2,nred2,
     &                  xcor,verbos,revrs,flip1,flip2,ihw,dbg,
     &                  nonorm,verb3d)
#include <f77/iounit.h>
      character  ntap1*(*), ntap2*(*), otap*(*), sfile*(*)
      character  hdrwrd*6
      integer    argis,     nst1,ned1,nrst1,nred1,ist1,iend1
      integer               nst2,ned2,nrst2,nred2,ist2,iend2
      integer    lagl, lagr, t0, ihw
      logical    xcor, verbos, revrs, flip1, flip2, dbg, nonorm
      logical    verb3d

          call argstr('-N1',ntap1,' ',' ')
          call argstr('-N2',ntap2,' ',' ')
          call argstr('-O',otap,' ',' ')
          call argstr('-S',sfile,' ',' ')
          call argi4('-L',lagl,0,0) 
          call argi4('-R',lagr,0,0) 
          call argi4('-t',t0,0,0) 
          call argi4('-s1',ist1,1,1) 
          call argi4('-e1',iend1,0,0) 
          call argi4('-ns1',nst1,0,0)
          call argi4('-ne1',ned1,0,0)
          call argi4('-rs1',nrst1,1,1)
          call argi4('-re1',nred1,0,0)
          call argi4('-s2',ist2,1,1) 
          call argi4('-e2',iend2,0,0) 
          call argi4('-ns2',nst2,0,0)
          call argi4('-ne2',ned2,0,0)
          call argi4('-rs2',nrst2,1,1)
          call argi4('-re2',nred2,0,0)
          call argi4('-hw', ihw,0,0)
          call argstr('-Hw',hdrwrd,'StaCor','StaCor')

          flip1  = ( argis( '-flip1' ) .gt. 0 )
          flip2  = ( argis( '-flip2' ) .gt. 0 )
          revrs  = ( argis( '-F' ) .gt. 0 )
          nonorm = ( argis( '-XN' ) .gt. 0 )
          xcor   = ( argis( '-X' ) .gt. 0 )
          verb3d = ( argis( '-V3d' ) .gt. 0 )
          verbos = ( argis( '-V' ) .gt. 0 )

          if ( nonorm ) xcor = .true.

          dbg    = ( argis( '-dbg' ) .gt. 0 )

          if (.not. xcor .and. sfile(1:1) .ne. ' ') then
             write(LERR,*)'Convolution option chosen:'
             write(LERR,*)'static shift file ignored'
             sfile = '                          '
          endif

      return
      end

