C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine scaleh (x,lx,y,sm,ierr,LERR,SZSMPD,itype,nsi,
     1                   lw, amp)
      real x(*), y(*), work(1),quad(1)
      real abs_in(1),abs_out(1),temp(1)
      real amp
      integer sm, SZSMPD, lw
      POINTER (pqi,quad),(ptmp,temp)
      POINTER (pai,abs_in),(pao, abs_out)
      POINTER (pwk,work)
      integer lx,ierr,iget,iabort,i,nsi


      iget = lx*SZSMPD
      ierr = 0
      iabort = 0
      call galloc(pqi, iget,ierr,iabort)
      call galloc(pai, iget,ierr,iabort)
      call galloc(pao, iget,ierr,iabort)
      call galloc(ptmp,iget,ierr,iabort)
      call galloc(pwk,iget,ierr,iabort)
      if(ierr.ne.0)return


      IF (itype .eq. 0) THEN

         do i=1,lx
             work(i)=x(i)
         end do
         call hilbertx(work,lx,quad,ierr,SZSMPD)
         if(ierr.ne.0)return

         do i=1,lx
             a = work(i)
             a = a*a
             b = quad(i)
             b = b*b
             abs_in(i)=sqrt(a+b)
         end do
         if(sm.ne.0)then
          call smooth(abs_in,lx,temp,sm)
         endif

         do i=1,lx
             work(i)=y(i)
         end do
         call hilbertx(work,lx,quad,ierr,SZSMPD)
         if(ierr.ne.0)return

         do i=1,lx
             a = work(i)
             a = a*a
             b = quad(i)
             b = b*b
             xy=sqrt(a+b)
             abs_out(i)=xy
         end do
         if(sm.ne.0)then
          call smooth(abs_out,lx,temp,sm)
         endif

         do i=1,lx
             if(abs_out(i).ne.0.0)then
                 y(i)=y(i)*abs_in(i)/abs_out(i)
             else
                 y(i)=0.
             endif
         end do

      ELSE

         call dagcsq (x, abs_in , lx, lw, amp)
         call dagcsq (y, abs_out, lx, lw, amp)
         do  i = 1, lx
             if(abs_out(i).ne.0.0)then
                y(i)=y(i)*abs_out(i)/abs_in(i)
             else
                y(i)=0.
             endif
         enddo

      ENDIF

      call gfree(pai)
      call gfree(pao)
      call gfree(pqi)
      call gfree(ptmp)
      call gfree(pwk)

      return
      end

      subroutine smooth(x,lx,temp,sm)
      real x(*),temp(*)
      integer sm

      do i=1,lx
       jts = i-sm+1
       jte = i+sm
       if(jts.lt.1)jts=1
       if(jte.gt.lx)jte=lx
       icnt=0
       do j=jts,jte
        if(x(j).ne.0)then
         icnt=icnt+1
         temp(icnt)=x(j)
        endif
       end do
       if(icnt.gt.0)then
        avg=0
        do j=1,icnt
         avg=avg+temp(j)
        end do
        avg=avg/float(icnt)
        x(i)=avg
       endif
      end do
      return
      end
