C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       FUNCS                                                *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      FUNCS  (X,P,NP,XMIN,XMAX,ITYPE)                                 *
C  ARGUMENTS:                                                          *
C      X       REAL     ??IOU*         -                               *
C      P       REAL     ??IOU*  (MMAX) -                               *
C      NP      INTEGER  ??IOU*         -                               *
C      XMIN    REAL     ??IOU*         -                               *
C      XMAX    REAL     ??IOU*         -                               *
C      ITYPE   INTEGER  ??IOU*         -                               *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 96/04/08  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 96/04/08  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:                                         *
C      EXP     GENERIC -                                               *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
      subroutine funcs (X, P, np, xmin, xmax, itype)
 
c  fitting routine for a polynomial of degree np-1 with np coefficients
 
c  for itype = 0:
c  in this case  p1 = 1; p2 = x; p3 = x**2; p4 = x**3; ...
c  for itype = 1:
c  in this case  p1 = 1; p2 = exp(x**2); p3 = exp(2*x**2); p4 = exp(3*x**2); ...
c  which are the basis functions
 
c  xmin & xmax are the min & max limits of variable X
 
      parameter  (mmax = 50)
      real       p(mmax), xmin, xmax
      integer    itype
 
      p(1) = 1.
 
      if (itype .eq. 0) then
         do  11  j = 2, np
             p(j) = p(j-1) * x
11       continue
      elseif (itype .eq. 1) then
         do  12  j = 2, np
             p(j) = p(j-1) * exp (x**2)
12       continue
      endif
 
      return
      end
