C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c---
c  this routine takes care of the case where we are rolling off a trace
c  and we are always dropping a sample

c  j     = number of samples to drop from front of window
c  n     = # samples in original window
c  xmed  = median output
c  key   = original position of the sorted samples
c  w     = samples in last window
c  tmp1  = work array
c---
      subroutine medoff (j, n, xmed, key, w, tmp1)

      real     w(n), tmp1(n)
      integer  key(n)
      real     xmed
      integer  n, ii, i

      nj = n - j

c---
c  pick out the samples lying above position "j"
c---
      ii = 0
      do  i = 1, n
          if (key(i) .gt. j) then
              ii = ii + 1
              tmp1 (ii) = w (i)
          endif
      enddo

c---
c  extract the median from only those samples
c---
      if (mod(nj,2) .eq. 0) then
         xmed = .5 * (tmp1(nj/2) + tmp1(nj/2+1))
      else
         xmed = tmp1(nj/2+1)
      endif

      return
      end   

  
