C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>


      integer   ITH
      pointer   (wkITH, ITH(1))
      real      BBUF, SF
      pointer   (wkbuf, bbuf(1000000))
      pointer   (wksf , sf  (1000000))

      REAL      ACCUM(SZLNHD),ADD(SZLNHD)
      integer   MA(SZLNHD), NA(SZLNHD)
      REAL      BUF(SZLNHD)
      INTEGER   IBUF(SZLNHD)
      INTEGER   IHEAD(SZLNHD)
      INTEGER   ARGIS
      CHARACTER NTAP*255, OTAP*255, NAME*6
      logical   heap
      DATA NAME /'DAVC2D'/
      DATA heap /.true./
      EQUIVALENCE (IHEAD(1),IBUF(1))
C
      IF (ARGIS('-?').GT.0.OR.ARGIS('-H').GT.0) THEN
          CALL HELP
          CALL CCEXIT (0)
      ENDIF
C
C     SET INPUT AND OUTPUT UNITS
C
#include <f77/open.h>

      IP=LERR
      LWL=101
      PER=0.15
      IPER=15
C
C     OPEN THEM UP
C
      CALL ARGSTR ('-N',NTAP,' ',' ')
      CALL ARGSTR ('-O',OTAP,' ',' ')
      IF (NTAP.EQ.' ')THEN
          IN=0
      ELSE
          CALL LBOPEN (IN,NTAP,'r')
      ENDIF
      IF (OTAP.EQ.' ')THEN
          IO=1
      ELSE
          CALL LBOPEN (IO,OTAP,'w')
      ENDIF
      CALL GAMOCO ('                              2-D DAVC
     *               ',1,IP)
      K=0
C
C     PROCESS LINE HEADER
C
      CALL RTAPE (IN,IHEAD,K)
      IF (K.GT.0) GO TO 20
   10 WRITE (IP,1)
      CALL CCEXIT (100)
   20 CALL HLHPRT (IHEAD,K,'D2VC',4,IP)

c------
      call saver(ibuf, 'NumSmp', nsamp, LINHED)
      call saver(ibuf, 'SmpInt', nsi  , LINHED)
      call saver(ibuf, 'NumTrc', ntrc , LINHED)
      call saver(ibuf, 'NumRec', nrec , LINHED)
      call saver(ibuf, 'Format', iform, LINHED)
      call saver(ibuf, 'UnitSc', unitsc, LINHED)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(ibuf, 'UnitSc', unitsc, LINHED)
      endif

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)

      ISI    = nsi
      SI     = ISI
      INSAMP = nsamp
      IFOR   = iform

c      IF (INSAMP.GT.1030) GO TO 1000
c      IF (INREC.GT.1030) GO TO 1010
      IF (IFOR .ne. 3) GO TO 1030

C
C     GET PARAMETERS
C
      CALL ARGI4 ('-s',IPERR,0,0)
      CALL ARGI4 ('-w',LWLR,0,0)

      WRITE (IP,9) IPERR,LWLR
      IF (IPERR.NE.0) THEN
          IPER=IPERR
          PER=IPERR
          PER=PER/100.0
      ENDIF

      ntrc2 = ntrc / 2
      nsmp2 = nsamp / 2
      idim  = min0 (ntrc2,nsmp2)
      if (lwl .gt. idim) then
          lwl = idim - 1
      endif
      IF (LWLR.NE.0) LWL=LWLR
      LWLR = 2*(LWL/2)
      IF (LWLR.EQ.LWL) LWL=LWL+1
      IF (LWL.GT.101) GO TO 1020
   30 WRITE (IP,12) IPER,LWL
      lwl1  = lwl + 1
      LWH   = LWL/2
      ANORM = 2047.0*PER
      JHOLD = LWH+1

      itemi = ntrc * ITRWRD * SZSMPD
      item1 = ntrc * nsamp  * SZSMPD

      call galloc (wkith, itemi, errcd, abort)
      if (errcd .ne. 0.) heap = .false.
      call galloc (wkbuf, item1, errcd, abort)
      if (errcd .ne. 0.) heap = .false.
      call galloc (wksf , item1, errcd, abort)
      if (errcd .ne. 0.) heap = .false.

      if (.not. heap) then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) itemi,'  bytes'
         write(LERR,*) item1,'  bytes'
         write(LERR,*) item1,'  bytes'
         write(LERR,*)' '
         write(LER ,*)' '
         write(LER ,*)'Unable to allocate workspace:'
         write(LER ,*) itemi,'  bytes'
         write(LER ,*) item1,'  bytes'
         write(LERR,*) item1,'  bytes'
         write(LER ,*)' '
         go to 999
      else
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) itemi,'  bytes'
         write(LERR,*) item1,'  bytes'
         write(LERR,*) item1,'  bytes'
      endif

      INBYT = SZTRHD + INSAMP * SZSMPD
      INMOV = INSAMP * SZSMPD
      call savhlh (ibuf, k, kout)
      CALL WRTAPE (IO,IHEAD,kout)

C
C     LETS GO FOR THE DATA
C
      N=0
C
C     LET'S GET AFTER IT
C
50    CONTINUE

      J  = 1
      K  = 0
      ir = 1

      call vclr (bbuf, 1, nsamp * ntrc)
      call vclr (sf  , 1, nsamp * ntrc)

      DO  KK = 1, ntrc

          CALL RTAPE (IN,IBUF,K)
          if (K.EQ.0) then
                     write(LERR,*)'End of file on input:'
                     write(LERR,*)'  rec= ',ir,'  trace= ',kk
                     go to 999
          endif

          call saver2(ihead,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                irec  , TRACEHEADER)
          call saver2(ihead,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                itrc  , TRACEHEADER)
          call saver2(ihead,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                istat , TRACEHEADER)

          call vmov (ihead(ITHWP1), 1, buf, 1, nsamp)
          if (istat .eq. 30000) call vclr (buf, 1, nsamp)

          istrc = (KK-1) * nsamp
          ishdr = (KK-1) * ITRWRD
          call vmov (IBUF, 1, ITH(ishdr+1) , 1, ITRWRD)
          call vmov ( BUF, 1, BBUF(istrc+1), 1, nsamp)

          J  = J+1

      ENDDO

      JEND = ntrc
      JFIN = ntrc - LWH

c     WRITE (IP,7) IFR,LRI
C
C     GET FIRST HALF WINDOW SCALE FACTORS
C
      CALL LEADIN (ANORM,INSAMP,LWH,LWL,lwl1,ntrc,
     1             bbuf,accum,add,sf,na,ma)
C
C     GET MAIN PART OF TRACES
C
      J   = LWH+2
      JC  = 1
      JAP = 1

90    continue

      CALL MIDDLE (J,JAP,JC,ANORM,INSAMP,LWH,LWL,lwl1,ntrc,
     1             bbuf,accum,add,sf,na,ma)

      IF (J.EQ.JFIN) GO TO 100

      J   = J+1
      JAP = JAP+1

      IF (JC.EQ.JHOLD) THEN
          JC = 1
      ELSE
          JC = JC+1
      ENDIF
      GO TO 90
C
C     GET LAST BLOCK
C
  100 JAP = JAP + 1

      IF (JC.EQ.JHOLD) THEN
          JC = 1
      ELSE
          JC = JC+1
      ENDIF

      DO 110 JJ = JAP, J
         CALL APPLY (JJ,JC,INSAMP,LWH,LWL,lwl1,ntrc,
     1               bbuf,accum,add,sf,na,ma)
      IF (JC .EQ. JHOLD) THEN
          JC = 1
      ELSE
          JC = JC+1
      ENDIF
  110 CONTINUE

      J  = J+1
      JC = JC-1

      DO 120 JJ = J, JEND
          CALL APPLY (JJ,JC,INSAMP,LWH,LWL,lwl1,ntrc,
     1                bbuf,accum,add,sf,na,ma)
      call maxmgv (BBUF, 1, xmax, loc, ntrc*nsamp)
  120 CONTINUE

C
C     WRITE EM OUT
C
      call maxmgv (BBUF, 1, xmax, loc, ntrc*nsamp)
      DO 310 KK = 1,JEND

          istrc = (KK-1) * nsamp
          ishdr = (KK-1) * ITRWRD
          call vmov (ITH(ishdr+1) , 1, ihead, 1, ITRWRD)
          call vmov (BBUF(istrc+1), 1, ihead(ITHWP1) , 1, nsamp)

          CALL WRTAPE (IO,IBUF,INBYT)

  310 CONTINUE

      ir = ir + 1
      go to 50

999   continue

      CALL LBCLOS (IN)
      CALL LBCLOS (IO)
      STOP
 1000 WRITE (IP,5)
      CALL CCEXIT (100)
 1010 WRITE (IP,4)
      CALL CCEXIT (100)
 1020 WRITE (IP,6)
      CALL CCEXIT (100)
 1030 WRITE (IP,8)
      CALL CCEXIT (100)
    1 FORMAT (15X,'ERROR PROCESSING INPUT TAPE HEADER')
    2 FORMAT (10X,'MISSING RECORDS ',I8,' THROUGH',I8)
C   3 FORMAT (//,10X,'*********************************',
C    */,10X,'OUTPUT RECORDS 1 THROUGH ',I8,
C    */,10X,'*********************************')
    4 FORMAT (//,10X,'MORE THAN 1030 RECORDS ON INPUT, STEP LIMITATION')
    5 FORMAT (//,10X,'MORE THAN 1030 SAMPLES ON INPUT, STEP LIMITATION')
    6 FORMAT (//,10X,'WINDOW LENGTH MUST BE LESS THAN 101 POINTS')
    7 FORMAT (/,
     */,10X,'*******************************************************',
     */,10X,'PROCESSED: FIRST RECORD =',I8,' LAST RECORD =',I8,
     */,10X,'*******************************************************')
    8 FORMAT (10X,'INPUT MUST BE FORMAT 3')
    9 FORMAT (//20X,
     *'          1         2         3',
     *'          4         5         6         7         8',
     */21X,
     *'1---*----0----*----0----*----0----*----',
     *'0----*----0----*----0----*----0----*----0',
     */10X,'CARD INPUT ',2I5)
   11 FORMAT (2I5)
   12 FORMAT (/,
     */,10X,'***************************************************',
     */,10X,'SCALING AT ',I5,' PER CENT WITH A ',I5,' POINT WINDOW',
     */,10X,'***************************************************')
      END
C
C     !APPLY!
C
      SUBROUTINE APPLY (JAP,JC,INSAMP,LWH,LWL,lwl1,ntrc,
     1                  bbuf,accum,add,sf,na,ma)


      real    BBUF (insamp,ntrc), sf (insamp,ntrc)
      integer ma (insamp), na (insamp)

      REAL*4 ACCUM(insamp),ADD(insamp)

      DO 10 II=1,INSAMP
         BBUF(II,JAP) = BBUF(II,JAP) * SF(II,JC)
   10 CONTINUE
  100 RETURN
      END
C
C     !LEADIN!
C
      SUBROUTINE LEADIN (ANORM,INSAMP,LWH,LWL,lwl1,ntrc,
     1                   bbuf,accum,add,sf,na,ma)

      real    BBUF (insamp,ntrc), sf (insamp,ntrc)
      integer ma (insamp), na (insamp)


      REAL*4 ACCUM(insamp),ADD(insamp)

c     CALL MOVE (0,ACCUM(1),0,M8)
c     CALL MOVE (0,MA(1),0,M4)

      call vclr (accum, 1, insamp)
      call vclr (ma   , 1, insamp)

      JC = LWH+1
      DO 20 J = 1, LWL
         CALL RUNSUM (J,INSAMP,LWH,LWL,lwl1,ntrc,
     1                bbuf,accum,add,sf,na,ma)
         DO 10 I=1,INSAMP
            ACCUM(I)=ACCUM(I)+ADD(I)
            MA(I)=MA(I)+NA(I)
   10    CONTINUE
   20 CONTINUE
      DO 30 I=1,INSAMP
         IF (MA(I).NE.0) THEN
             AVG=ACCUM(I)/MA(I)
             SF(I,1)=ANORM/AVG
         ELSE
             SF(I,1)=0.0
         ENDIF
   30 CONTINUE
      DO 50 J=2,JC
         DO 40 I=1,INSAMP
            SF(I,J)=SF(I,1)
   40    CONTINUE
   50 CONTINUE
      RETURN
      END
C
C     !RUNSUM!
C
      SUBROUTINE RUNSUM (JA,INSAMP,LWH,LWL,lwl1,ntrc,
     1                   bbuf,accum,add,sf,na,ma)

      real    BBUF (insamp,ntrc), sf (insamp,ntrc)
      integer ma (insamp), na (insamp)


      REAL*4 ACCUM(insamp),ADD(insamp)
      REAL*4 A

      call vclr (add, 1, insamp)
      call vclr (na , 1, insamp)
      IC = LWH+1
      N  = 0
      A  = 0.0

      DO 10 I = 1, LWL
         IF (BBUF(I,JA).NE.0.0) THEN
            A = A + ABS(BBUF(I,JA))
            N = N + 1
         ENDIF
   10 CONTINUE
      DO 20 I = 1, IC
         ADD(I) = A
         NA(I)  = N
   20 CONTINUE
      IS = LWL + 1
      DO 30 IA = IS, INSAMP
         ID = IA-LWL
         IK = IA-LWH
         IF (BBUF(ID,JA).NE.0.0) THEN
             A = A - ABS(BBUF(ID,JA))
             N = N-1
         ENDIF
         IF (BBUF(IA,JA).NE.0.0) THEN
             A = A + ABS(BBUF(IA,JA))
             N = N + 1
         ENDIF
         ADD(IK) = A
         NA(IK)  = N
   30 CONTINUE
      IK = IK + 1
      DO 40 I = IK, INSAMP
         ADD(I)= A
         NA(I) = N
   40 CONTINUE
      RETURN
      END
C
C     !MIDDLE!
C
      SUBROUTINE MIDDLE (J,JAP,JC,ANORM,INSAMP,LWH,LWL,lwl1,ntrc,
     1                   bbuf,accum,add,sf,na,ma)

      real    BBUF (insamp,ntrc), sf (insamp,ntrc)
      integer ma (insamp), na (insamp)


      REAL*4 ACCUM(insamp),ADD(insamp)

      JA = J+LWH
      JD = JA-LWL
      IF (JD.NE.JAP) CALL CCEXIT (99)
C
C    TAKE DROP TRACE RUNNING AVERAGE FROM ACCUM
C
      CALL RUNSUM (JD,INSAMP,LWH,LWL,lwl1,ntrc,
     1             bbuf,accum,add,sf,na,ma)
      DO 10 I = 1, INSAMP
         ACCUM(I) = ACCUM(I)-ADD(I)
         MA(I)    = MA(I)-NA(I)
   10 CONTINUE
C
C    SCALE DROP TRACE
C
      CALL APPLY (JD,JC,INSAMP,LWH,LWL,lwl1,ntrc,
     1            bbuf,accum,add,sf,na,ma)
C
C    ADD ADD TRACE RUNNING AVERAGE TO ACCUM
C
      CALL RUNSUM (JA,INSAMP,LWH,LWL,lwl1,ntrc,
     1             bbuf,accum,add,sf,na,ma)
      DO 20 I = 1, INSAMP
         ACCUM(I) = ACCUM(I)+ADD(I)
         MA(I)    = MA(I)+NA(I)
   20 CONTINUE
      DO 30  I = 1, INSAMP
         IF (MA(I).NE.0) THEN
            AVG = ACCUM(I)/MA(I)
            SF(I,JC) = ANORM/AVG
         ELSE
            SF(I,JC) = 0.0
         ENDIF
   30 CONTINUE
      RETURN
      END
C
C  !CCEXIT!
C
      SUBROUTINE CCEXIT (ICODE)
#include <f77/iounit.h>
      IF(ICODE.NE.0) THEN
          WRITE (LERR,1) ICODE
          WRITE (LER,1) ICODE
      ENDIF
    1 FORMAT (' PROGRAM TERMINATION:  EXIT CODE = ',I6)
      STOP
      END
C
C  !HELP!
C
      SUBROUTINE HELP
#include <f77/iounit.h>
      WRITE (LER,*) ' ************************************************'
      WRITE (LER,*) ' PROGRAM davc2d .....ONE PASS 2-D DAVC'
      WRITE (LER,*) ' -N {ntap}  :Input seismic data set'
      WRITE (LER,*) ' -O {otap}  :Output seismic data set'
      WRITE (LER,*) ' -s         :Scale factor in per cent'
      WRITE (LER,*) ' -w         :Window width in points'
      WRITE (LER,*) ' ************************************************'
      WRITE (LER,*) ' ************************************************'
      WRITE (LER,*) ' USAGE'
      WRITE (LER,*) ' davc2d -Nntap -Ootap -s -w'
      WRITE (LER,*) ' ************************************************'
      RETURN
      END
