C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE CONA(LVTA,DIP,TIME,TDEL,LX,ASF)                        CON01000
C     A CONFIDENTIAL AMOCO SUBROUTINE - SPECIAL FOR PROGRAM CTFXSP.     CON02000
C          FORTRAN BY KEN PEACOCK  9-19-84.                             CON03000
C     CONA CONVERTS APPARENT DIP AND TIME PAIRS INTO A CONTINUOUS       CON04000
C     ARRAY OF APPARENT DIP VALUES.                                     CON05000
C     INPUTS ARE...                                                     CON06000
C         LVTA, NUMBER OF DIP, TIME PAIRS.                              CON07000
C         DIP, LVTA-LENGTH APPARENT DIP, SAMPLES/TRACE.                 CON08000
C         TIME, LVTA-LENGTH TIME VALUES, IN MS.                         CON09000
C         TDEL, SAMPLE INCREMENT, SECS.                                 CON10000
C         LX, TRACE LENGTH, SAMPLES.                                    CON11000
C     OUTPUT IS...                                                      CON12000
C         ASF, LX-LENGTH CONTINUOUS APPARENT DIP ARRAY.                 CON13000
C     CODED FOR THE IBM CMS COMPUTER.                                   CON14000
C     VERSION AS OF 10-12-84.                                           CON15000
C                                                                       CON16000
      DIMENSION DIP(1),TIME(1),ASF(1)                                   CON17000
      ISTA = 1                                                          CON18000
      ISTO = .001*TIME(1)/TDEL+1.001                                    CON19000
      DO 1 I=ISTA,ISTO                                                  CON20000
    1 ASF(I) = DIP(1)                                                   CON21000
      DO 3 J=2,LVTA                                                     CON22000
      ISTA = .001*TIME(J-1)/TDEL+1.001                                  CON23000
      ISTO = .001*TIME(J)/TDEL+1.001                                    CON24000
      DIF = DIP(J)-DIP(J-1)                                             CON25000
      INT = ISTO-ISTA                                                   CON26000
      DO 2 I=ISTA,ISTO                                                  CON27000
    2 ASF(I) = DIP(J-1)+(I-ISTA)*DIF/INT                                CON28000
    3 CONTINUE                                                          CON29000
      ISTA = .001*TIME(LVTA)/TDEL+1.001                                 CON30000
      DO 4 I=ISTA,LX                                                    CON31000
    4 ASF(I) = DIP(LVTA)                                                CON32000
      RETURN                                                            CON33000
      END                                                               CON34000
