C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE HILC(LF,ITYPE,TDEL,EX,F)
C     A CONFIDENTIAL AMOCO SUBROUTINE.
C             FORTRAN BY KEN PEACOCK  8-24-83.
C     SUBROUTINE HILC CONSTRUCTS THE OPERATOR FOR THE HILBERT TRANSFORM
C     FILTER.  OPERATOR LENGTH AND WEIGHT STRENGTH ARE COMPUTED BY THE
C     SUBROUTINE.  EITHER ROSS OR BESSEL WEIGHTING MAY BE SPECIFIED.
C     INPUTS ARE...
C        LF, LENGTH OF OPERATOR, ODD.
C        ITYPE, TYPE OF WEIGHTING DESIRED.  1 = ROSS, 2 = BESSEL.
C        TDEL, SAMPLE INCREMENT IN SECONDS.
C        EX, WEIGHTING STRENGTH.
C     OUTPUT IS...
C        F, THE OUTPUT OPERATOR.
C     CODED FOR THE IBM 3033.
C     VERSION AS OF 8-24-83.
C
      DIMENSION F(1)
      N = LF/2
      ISTA = N+2
      KFACT = 1-ISTA
      JFACT = LF+1
      DO 4 I=1,LF
    4 F(I) = 0.
      FACT = -2./(TDEL*3.1415927)
      DO 5 I=1,N,2
      J = N+1+I
      K = N+1-I
      F(J) = FACT/I
    5 F(K) = -F(J)
      IF(EX.EQ.0.) GO TO 12
      GO TO (6,8),ITYPE
C        BELOW IS ROSS WEIGHTING.
    6 DO 7 I=ISTA,LF
      AK = I+KFACT
      F(I) = F(I)*((1.-(AK/N)**2)**EX)
      J = JFACT-I
    7 F(J) = -F(I)
      GO TO 12
C        BELOW IS BESSEL WEIGHTING.
    8 DEN = 1.
      DS = 1.
      D = 0.
    9 D = D+2.
      DS = DS*EX*EX/(D*D)
      DEN = DEN+DS
      IF(DS.GT..2E-8*DEN) GO TO 9
      DO 11 I=ISTA,LF
      AK = I+KFACT
      EXX = EX*SQRT(1.-(AK/N)**2)
      ANUM = 1.
      DS = 1.
      D = 0.
   10 D = D+2.
      DS = DS*EXX*EXX/(D*D)
      ANUM = ANUM+DS
      IF(DS.GT..2E-8*ANUM) GO TO 10
      F(I) = F(I)*ANUM/DEN
      J = JFACT-I
   11 F(J) = -F(I)
   12 RETURN
      END
