C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE IDEF(FMAX,TDEL,WC,LF,F)
C                            FORTRAN BY KEN PEACOCK  10-6-76
C     SUBROUTINE IDEF CONSTRUCTS THE OPERATOR FOR THE IDEAL HIGHCUT
C     (LOWPASS) FILTER.  WEIGHTING IS AVAILABLE ON OPTION.
C        INPUTS ARE...
C             FMAX, LIMITING FREQUENCY TO PASS.
C             TDEL, SAMPLE INCREMENT IN SECONDS.
C             WC, 0 MEANS TO OUTPUT RAW OPERATOR, .NE.0 MEANS TO USE
C                  A ROSS WEIGHT FUNCTION WITH EXPONENT WC.
C             LF, LENGTH OF FILTER IN SAMPLES, LF MUST BE ODD.
C        OUTPUT IS...
C             F, THE LF-LENGTH OUTPUT ARRAY.
C     CODED FOR THE IBM 370/158 COMPUTER.
C     VERSION AS OF 11-30-78
C
      DIMENSION F(1)
      FACT1 = 2.*3.1415927*FMAX*TDEL
      FACT2 = 3.1415927*TDEL
      N = LF/2
      ISTA = N+2
      KFACT = 1-ISTA
      JFACT = LF+1
      DO 1 I=ISTA,LF
      AK = I+KFACT
      F(I) = SIN(FACT1*AK)/(FACT2*AK)
      J = JFACT-I
    1 F(J) = F(I)
      F(ISTA-1) = 2.*FMAX
      IF(WC.EQ.0.) GO TO 3
      DO 2 I=ISTA,LF
      AK = I+KFACT
      F(I) = F(I)*((1.-(AK/N)**2)**WC)
      J = JFACT-I
    2 F(J) = F(I)
    3 RETURN
      END
