C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine maskit   (dt,dx,vel1,vel2,pct,ipow,pass,
     1                     ntrc,nsamp, nf,nk,nk2,mask,work,
     2                     kstrip, kcen)

#include <f77/iounit.h>
#include <f77/lhdrsz.h>

      real       mask(nf,ntrc), work(nf,ntrc)
      integer    ipow,kl,ku,ikl,iku
      real       xkl,xku,ykl,yku,kcen
      real       dt,dx,pct,pf,fnyq,knyq,delf,delk
      logical    pass, kstrip

c---
c  nk  - the center point of the k-portion of the transform
c  nk2 - the full width in k-dimension
c  nf  - the center of the f-transform
c---


      pf = .01 * pct
      a0 = .5
      a1 = .25

      fnyq = 1. / (2.*dt)
      knyq = 1. / (2.*dx)
      delf = fnyq / float(nf-1)
      delk = knyq / float(nk)

      if (pass) then
          do  j = 1, ntrc
              do  i = 1, nf
                  work (i,j) = 0.0
              enddo
          enddo
      else
          do  j = 1, ntrc
              do  i = 1, nf
                  work (i,j) = 1.0
              enddo
          enddo
      endif


      nf2 = 2 * nf
      if (kstrip) then
         nks = .01 * kcen * nk
         ks  = nks - pf*nk 
         ke  = nks + pf*nk 
         ksl = nk - ke
         kel = nk - ks
         ksr = nk + ks
         ker = nk + ke
         if (ksl .eq. nk .and. kel .eq. nk) ksl = nk - 1
         if (ksr .eq. nk .and. ker .eq. nk) ksr = nk + 1
     
      else
         vu = amax1 (vel1,vel2)
         vl = amin1 (vel1,vel2)
         delv = .5 * (vu - vl)
      endif

      write(LERR,*)' '
      write(LERR,*)'Velocity Filter Values'
      write(LERR,*)'fnyq:         = ',fnyq
      write(LERR,*)'knyq:         = ',knyq
      write(LERR,*)'nf:           = ',nf
      write(LERR,*)'ntrc:         = ',ntrc
      write(LERR,*)'nk:           = ',nk
      write(LERR,*)'delf:         = ',delf
      write(LERR,*)'delk:         = ',delk
      if (kstrip) then
         write(LERR,*)'negative k-index start =  ',ksl
         write(LERR,*)'negative k-index end   =  ',kel
         write(LERR,*)'positive k-index start =  ',ksr
         write(LERR,*)'positive k-index end   =  ',ker
      else
         write(LERR,*)'delv:         = ',delv
         write(LERR,*)'vu            = ',vu
         write(LERR,*)'vl            = ',vl
      endif
      write(LERR,*)' '

c     if (vu .lt. 0. .AND. vl .lt. 0.) j0 = -1
c     if (vu .gt. 0. .AND. vl .gt. 0.) j0 = +1
      

      IF (kstrip) THEN

          do  i = 1, nf

              if (pass) then
                 do  j = ksl, kel
                     work (i,j) = 1.0
                 enddo
                 do  j = ksr, ker
                     work (i,j) = 1.0
                 enddo
              else
                 do  j = ksl, kel
                     work (i,j) = 0.0
                 enddo
                 do  j = ksr, ker
                     work (i,j) = 0.0
                 enddo
              endif
          enddo

      ELSE
          do  i = 1, nf

              ii = nf - i + 1

              xkl = 1.00 * delf * float(i-1) / vl
              xku = 1.00 * delf * float(i-1) / vu
              ykl = float(nk) + xkl / delk
              yku = float(nk) + xku / delk
              ikl = nint (ykl)
              iku = nint (yku)
              kl  = min0 (ikl,iku) + 1
              ku  = max0 (ikl,iku) + 1

              if (kl .lt. 1) kl = 1
              if (ku .gt. ntrc) ku = ntrc

              if (pass) then
                 do  j = kl, ku
                     work (ii,j) = 1.0
                 enddo
              else
                 do  j = kl, ku
                     work (ii,j) = 0.0
                 enddo
              endif

          enddo

      ENDIF
c    apply 3-pt smoothing in both vertical & horz directions
c-----
      do  j = 1, ntrc
          do  i = 2, nf-1
              mask (i,j) = a1 * work (i-1,j) + a0 * work (i,j) +
     1                     a1 * work (i+1,j)
          enddo
          mask (1,j)  = .5 * (work(1,j)  + work(2,j))
          mask (nf,j) = .5 * (work(nf,j) + work(nf-1,j))
      enddo

      do  i = 1, nf
          do  j = 2, ntrc-1
              mask (i,j) = a1 * work (i,j-1) + a0 * work (i,j) +
     1                     a1 * work (i,j+1)
          enddo
c         mask (i,1)    = .5 * (work(i,1)    + work(i,2))
          mask (i,ntrc) = .5 * (work(i,ntrc) + work(i,ntrc-1))
          mask (i,1)    = 0.
c         mask (i,ntrc) = 0.
      enddo
c-----
c    do it again but in reverse order
c-----
      do  j = 1, ntrc
          do  i = 1, nf
              work (i,j) = mask (i,j)
          enddo
      enddo

      do  i = 1, nf
          do  j = 2, ntrc-1
              mask (i,j) = a1 * work (i,j-1) + a0 * work (i,j) +
     1                     a1 * work (i,j+1)
          enddo
c         mask (i,1)    = .5 * (work(i,1)    + work(i,2))
          mask (i,ntrc) = .5 * (work(i,ntrc) + work(i,ntrc-1))
          mask (i,1)    = 0.
c         mask (i,ntrc) = 0.
      enddo

      do  j = 1, ntrc
          do  i = 2, nf-1
              mask (i,j) = a1 * work (i-1,j) + a0 * work (i,j) +
     1                     a1 * work (i+1,j)
          enddo
          mask (1,j)  = .5 * (work(1,j)  + work(2,j))
          mask (nf,j) = .5 * (work(nf,j) + work(nf-1,j))
      enddo

      if (ipow .gt. 1) then
          do  j = 1, ntrc
              do  i = 1, nf
                  wt = mask (i,j)
                  mask (i,j) = wt ** ipow
              enddo
          enddo
      endif


      return
      end
