C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C**********************************************************************C
C
C     PROGRAM MODULE dipnmo
C
C**********************************************************************C
C
C dipnmo READS SEISMIC TRACE DATA FROM AN INPUT FILE,
C APPLIES NORMAL MOVEOUT (WITH OPTIONAL STATICS BEFORE),
C AND PRINTS UPDATED LINE HEADER AND REQUIRED RECORDS
C OR TRACES
C
C SUBROUTINE CALLS: RTAPE, HLH, WRTAPE, SAVE
C
C**********************************************************************C
C
C     DECLARE VARIABLES
C
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/sisdef.h>
#include <f77/lhdrsz.h>

      INTEGER     ITR ( SZLNHD ) , NTR (SZLNHD)
      INTEGER LHED(SZLNHD) , LVHED(SZLNHD), LUIN, LUOUT, NBYTES,LUVEL
      INTEGER NSAMP, NSI, NTRC, NREC, IFORM, LBYTES, VFLAG,vrs,vre
      INTEGER NSAMPV, NSIV, NTRCV, NRECV, LVBYTES, IFORMV,vst,ved
      REAL    TRI ( SZLNHD ),V(SZLNHD),WORK(SZLNHD)
#include <f77/pid.h>
      CHARACTER   NAME * 6, ntap * 256, otap * 256, vmod *256
      logical verbos, query, stat,remove
      integer argis, pipe
      integer irs, ire, ns, ne
      integer nreout, ntrout
C
c     EQUIVALENCE ( ITR(129), TRI (1) )
c     EQUIVALENCE ( NTR(129), V (1) )
      EQUIVALENCE ( ITR(  1), LHED(1) )
      EQUIVALENCE ( NTR(  1), LVHED(1) )
      DATA  NBYTES / 0 /, LBYTES / 0 /, name/'DIPNMO'/
      DATA  NVBYTES / 0 /, LVBYTES / 0 /
      DATA  pipe/3/


C**********************************************************************C
C     get help if necessary
C**********************************************************************C
      query = ( argis ( '-?' ) .gt. 0 )
      if ( query ) then
        call help()
        stop
      endif

C**********************************************************************C
C     open printout file
C**********************************************************************C
#include <f77/open.h>
      
C**********************************************************************C
C     read command line parameters
C**********************************************************************C
      call cmdln(ntap,otap,vmod,theta,ns,ne,irs,ire,vrs,vre,stat,remove,
     1           verbos)
      vst = 1
      ved = 1
      if ( verbos ) then
         write(LERR,*)' Dip Angle                            =  ',theta
         write(LERR,*)' First record to process              =  ',irs
         write(LERR,*)' Last record to process               =  ',ire
         write(LERR,*)' First velocity to use                =  ',vrs
         write(LERR,*)' Last  velocity to use                =  ',vre
         write(LERR,*)' Starting trace number                =  ',ns
         write(LERR,*)' Ending   trace number                =  ',ne
         write(LERR,*)' Remove nmo (true ?)                  =  ',remove
         write(LERR,*)' Apply statics before nmo             =  ',istat
      end if
      dip = 2. * sin( 3.14159265*theta/180. )
      write(LERR,*)'dip factor= ',dip

C**********************************************************************C
C     open logical i/o units
C     check line header; save key values
C**********************************************************************C
      call getln( luin, ntap, 'r', 0)
      call getln(luout, otap, 'w', 1)
      if (vmod .ne. ' ') then
          call getln(luvel, vmod, 'r',-1)
      else
          write(LERR,*)'anmo assumed to be running inside IKP'
          call sisfdfit (luvel, pipe)
      endif
      if  (luvel .lt. 0)   then
           call error ('dipnmo error: velocity file -v not accessible')
      endif
c-----------------
c  input data
c-----------------
      vflag=1
      lbytes=0
      CALL RTAPE (LUIN , ITR , lbytes           )
      if(lbytes .eq. 0) then
         write(LERR,*)'DIPNMO: no header read on unit ',luin
         write(LERR,*)'FATAL'
         stop
      endif
      CALL HLHprt    ( ITR , LBYTEs, name, 6,          LERR)
#include <f77/saveh.h>

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)

c-----------------
c  velocity data
c-----------------
      lvbytes=0
      CALL RTAPE (LUVEL , NTR , lvbytes          )
      if(lvbytes .eq. 0) then
         write(LERR,*)'DIPNMO: no header read on velocity unit ',luvel
         write(LERR,*)'FATAL'
         stop
      endif
      call saver(ntr, 'NumSmp', nsampv, LINHED)
      call saver(ntr, 'SmpInt', nsiv  , LINHED)
      call saver(ntr, 'NumTrc', ntrcv , LINHED)
      call saver(ntr, 'NumRec', nrecv , LINHED)
      call saver(ntr, 'Format', iformv, LINHED)

         if(ntrcv .ne. 1) then
            call error(' ')
            call error('velocity data file must have 1 trace/record')
            call error('check velin run; do a scan of velocity file')
            call error('FATAL')
            stop
         endif
c--------------------------------------
c   vflag=0 single velocity function
c   vflag=1 multiple velocity function
c--------------------------------------
      if(nrecv .le. 1) vflag=0

         dt = real (nsi) * unitsc

      if ( verbos ) then
         write(LERR,*)' Values read from input data set lineheader'
         write(LERR,*)' # of Samples/Trace =  ',nsamp
         write(LERR,*)' Sample Interval    =  ',nsi
         write(LERR,*)' Traces per Record  =  ',ntrc
         write(LERR,*)' Records per Line   =  ',nrec
         write(LERR,*)' Format of Data     =  ',iform
         if(vflag .eq. 0) then
            write(LERR,*)' Single velocity function will be used'
         endif
         if(stat) write(LERR,*)' Apply Internal Statics'
         if(remove)write(LERR,*)' Remove normal moveout'
         write(LERR,*)' Values read from velocity data set lineheader'
         write(LERR,*)' # of Samples/Trace =  ',nsampv
         write(LERR,*)' Sample Interval    =  ',nsiv
         write(LERR,*)' Traces per Record  =  ',ntrcv
         write(LERR,*)' Records per Line   =  ',nrecv
         write(LERR,*)' Format of Data     =  ',iformv
      end if

C**********************************************************************C
C     CHECK DEFAULT VALUES AND SET PARAMETERS
C**********************************************************************C
      call cmdchk(ns,ne,irs,ire,ntrc,nrec)
      call cmdchk(vst,ved,vrs,vre,ntrcv,nrecv)

c-----
c      modify header as needed
c-----
      nreout = ire - irs + 1
      ntrout =  ne -  ns + 1
       call savew( itr, 'NumTrc',ntrout, LINHED)
       call savew( itr, 'NumRec',nreout, LINHED)
      call savhlh(itr, lbytes, lbyout)

C**********************************************************************C
C     write out modified line header
C**********************************************************************C
      call wrtape(luout, itr, lbyout)

c-----
c      skip unwanted records
c-----
      nvbytes=1
c---------------------------------
c     multiple velocity functions
c---------------------------------
      if(vflag .eq. 1) then
         if(vrs .le. nrecv) then
           call recskp(1,vrs-1,luvel,ntrcv,ntr)
         else
             call error('start record to skip to exceeds number')
             call error('records on velocity file')
             call error('check velin run to make sure your velocity')
             call error('model covers the part of the data between')
             write(LERR,*)'records ',vrs,' and ', vre
             stop
         endif
c-------------------------------------------------------
c     slingle velocity function:  read him right away
c-------------------------------------------------------
      elseif(vflag .eq. 0) then
           nvbytes=0
           call rtape (luvel,ntr,nvbytes)
           if(nvbytes .eq. 0) then
              write(LERR,*)'End of file on velocity file: FATAL'
              stop
            endif
            call vmov (ntr(ITHWP1), 1, V, 1, nsampv)
      endif
           call recskp(1,irs-1,luin, ntrc,itr)

c--------------------------------------------------------------------
c       read trace
c      beware perhaps the individual trace number should change ?
c-----
c   when reading velocity traces make sure that if we run out of vel. traces
c   we use the last vel trace to the end of the line...
c--------------------------------------------------------------------
        nvbytes=1
        DO 5000 JJ = irs, ire

           if(vflag.eq.1 .and. nvbytes.ne.0 .and. jj.le.vre) then
              nvbytes=0
              call rtape (luvel,ntr,nvbytes)
c  ... and don't stop the propgram if we run out of velocity functions
c             if(nvbytes .eq. 0) go to 999
           endif
           call vmov (ntr(ITHWP1), 1, V, 1, nsampv)

c-------------------
c  do we have valid
c  velocities?
               call dotpr (v,1,v,1,vdot,nsampv)
               if (abs(vdot) .lt. 1.e-06) then
                  write(LERR,*)'Velocity trace contains zeros'
                  write(LERR,*)'---    FATAL  ---'
                  write(LERR,*)'Check the velin step thoroughly'
                  go to 999
               endif
c-------------------

c---------------
c  skip to start
c  of record
           call trcskp(jj,1,ns-1,luin,ntrc,itr)
c---------------

           DO 5001 KK = ns, ne

               nbytes = 0
               CALL RTAPE  ( LUIN, ITR, NBYTES )
               if(nbytes .eq. 0) then
                  write(LERR,*)'End of file on input:'
                  write(LERR,*)'  rec= ',jj,'  trace= ',kk
                  go to 999
               endif
               call vmov (itr(ITHWP1), 1, tri, 1, nsamp)
               call saver2(lhed,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                     ist    , TRACEHEADER)
               call saver2(lhed,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1                     ids    , TRACEHEADER)
               dist = iabs (ids)
               call vclr(work,1,nsamp)

                  IF (ist .ne. 30000) then
                    ist=ist/nsi
                    if(.not.stat) ist=1
                    if(ist .eq. 0) ist=1
                    if(ist .lt. 0) then
                       ist=-ist
                       call vmov(tri(ist),1,work(1),1,nsamp)
                    else
                       call vmov(tri(1),1,work(ist),1,nsamp)
                    endif
                       call x2t2dip(WORK,dt,NSAMP,dist,dip,V,remove)
                  ENDIF

                  call vmov(work,1,itr(ITHWP1),1,nsamp)
                  call wrtape (luout,itr, nbytes)

 5001          continue

c--------------
c  skip to end
c  of record
           call trcskp(jj,ne+1,ntrc,luin,ntrc,itr)
c--------------

5000  CONTINUE
  999 continue
      call lbclos ( luin )
      call lbclos ( luout )
      call lbclos ( luvel )
      END


c------------------------------------------------------
c  write messages to printout
c------------------------------------------------------
      subroutine error(mesgs)
#include <f77/iounit.h>
      character     mesgs*(*)
      write(LERR,*) mesgs
      stop
      end

c------------------------------------------------------
c  online help screen
c------------------------------------------------------
      subroutine help
#include <f77/iounit.h>

         write(LER,*)
     :'***************************************************************'
      write(LER,*)
     :'Run this program by typing: dipnmo and the following arguments'
         write(LER,*)
     :' -N [ntap]    (stdin)      : Input data file name'
        write(LER,*)
     :' -O [otap]    (stdout)      : Output data file name'
        write(LER,*)
     :' -v [vmod] velocity model (no default)                     '
        write(LER,*)
     :' -d [theta] dip angle (deg) measured from horizontal (def=0)'
        write(LER,*)
     :' -ns [ns] starting trace (default = 1)'
      write(LER,*)
     :' -ne [ne] ending trace   (default = all traces)'
      write(LER,*)
     :' -rs[irs] starting record (default = 1)'
      write(LER,*)
     :' -re[ire] ending record (default = all)'
      write(LER,*)
     :' -sv[vrs] starting velocity record (default = 1)'
      write(LER,*)
     :' -ev[vrs] ending velocity record (default = last)'
      write(LER,*)
     :' -S apply trace header statics'
      write(LER,*)
     :' -R remove normal moveout'
      write(LER,*)
     :' -V verbose printout'
      write(LER,*)
     :'Usage: dipnmo -N[ntap] -O[otap] -v[vmod] -d[theta] -ns[] -ne[]'
         write(LER,*)
     :'             -rs[] -re[] -sv[] -ve[] -S -R -V'
         write(LER,*)
     :'***************************************************************'

      return
      end

C**********************************************************************C
C     get command line parameters
C**********************************************************************C
      subroutine cmdln(ntap,otap,vmod,theta,ns,ne,irs,ire,vrs,vre,stat,
     1                 remove,verbos)
c-----
c     get command arguments
c
c     ntap  - C*100  input file name
c     otap  - C*100  output file name
c     vmod  - C*100  velocity file name
c   theta   - R      dip angle
c      ns   - I      start trace
c      ne   - I      stop end trace
c     irs   - I      start record
c     ire   - I      stop end record
c     vrs   - I      start velocity record
c     vre   - I      end velocity record
c    stat   - L      normalize stacked trace by # live traces
c  remove   - L      remove normal moveout
c    verbos - L      verbose output or not
c-----
#include <f77/iounit.h>
      real        theta
      integer     ns,ne,irs,ire,vrs,vre, argis
      character   ntap*(*),otap*(*),vmod*(*)
      logical     stat,remove,verbos

         call argstr ('-N', ntap, ' ', ' ' )
         call argstr ('-O', otap, ' ', ' ' )
         call argstr ('-v',vmod, ' ', ' ')
         call argr4  ('-d',theta,0.,0.)
         call argi4  ('-ns',ns,0,0)
         call argi4  ('-ne',ne,0,0)
         call argi4  ('-rs',irs,0,0)
         call argi4  ('-re',ire,0,0)
         call argi4  ('-sv',vrs,1,1)
         call argi4  ('-ev',vre,0,0)
         stat = ( argis ('-S') .gt. 0 )
         remove = ( argis ('-R') .gt. 0 )
         verbos = ( argis ('-V') .gt. 0 )

         if( abs(theta) .gt. 89. ) then
            write(LERR,*)'Dip angle too close to 90 deg -- FATAL'
            write(LERR,*)'decrease the dip angle & rerun'
            stop
         endif

      return
      end
