C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine x2t2dip (y,dt,n,x,dip,v,remove)

#include <f77/lhdrsz.h>

c
c     y = data trace
c     v = velocity trace (velocity vs sample)
c    dt = sample interval
c     n = number samples/trace
c     x = distance
c   dip = dip term ( 2 * sin(theta) )
c remove= if true to 'unmormal movelout'
c
      real*4 rinter
      real *4 y(*), v(*), z(SZSMPM)
      logical remove
      xt = x/dt
      call vclr (z,1,n)

      if(remove) then

      do 2000 i = n,2,-1
         xvi = xt/( v(i) )
         tnmo =  sqrt (abs((i-1)**2 + xvi**2 + i*xvi*dip))+1
            j= tnmo
            dj= tnmo - j
c-------
c      check for bounds
c-----
      if (j .ge. 1 .and. j .le. n) then
c           y(j) = rinter ( z(i),z(i+1),dj)
            z(j) = y(i) + dj * (y(i-1) - y(i))
      endif
 2000       continue
c      jm1 = j-1
c      do 2010 ii=1,jm1
c            y(ii)=0.
c 2010      continue
c      z(n) = 0.

      else

      do 1000 i = 1,n
         xvi = xt/( v(i) )
         tnmo = sqrt (abs((i-1)**2 + xvi**2 + i*xvi*dip))+1
            j= tnmo
            dj= tnmo - j
c-------
c      check for bounds
c-----
      if (j .ge. 1 .and. j .le. (n-1)) then
c            y(i) = 0.
c           y(i) = rinter ( z(j),z(j+1),dj)
            z(i) = y(j) + dj * (y(j+1) - y(j))
      endif
 1000       continue

      endif

      call vmov (z,1,y,1,n)

      return
      end
