C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine arrange (nlive,ndead,ntrc,ngrp,items,idist,dx,xmod,
     1                    itrce,idead,MODEL,isht,igrp,idi,ili,split,
     2                    ifmt_StaCor,l_StaCor, ln_StaCor, ntrm, ntro,
     3                    ifmt_hdrwrd,l_hdrwrd, ln_hdrwrd, nopad,
     4                    ifmt_SrcLoc,l_SrcLoc, ln_SrcLoc, nin,
     5                    ifmt_RecInd,l_RecInd, ln_RecInd,
     6                    ifmt_DphInd,l_DphInd, ln_DphInd,
     6                    ifmt_LinInd,l_LinInd, ln_LinInd,
     7                    ifmt_RecNum,l_RecNum, ln_RecNum,
     8                    itr, lhed, itemt, irec, jdist, interp)

#include <save_defs.h>
#include <f77/sisdef.h>
#include <f77/lhdrsz.h>
#include <f77/iounit.h>

      integer         itr(*)
      integer         lhed(*)
      integer         itrce(*), idead(*)
      integer         idist(*),isht(*),igrp(*),idi(*),ili(*)
      real            xmod(*)
      integer         jndx(SZLNHD)
      integer         jnlx(SZLNHD)
      integer         jdist(SZLNHD)
      integer         kdist(SZLNHD)
      integer         ldist(SZLNHD)
      integer         jsht(SZLNHD),jgrp(SZLNHD),jdi(SZLNHD)
      integer         jli(SZLNHD)
      logical         split, MODEL, interp, nopad, nin

      SAVE

      do  j = nlive+1, ntrm
          idist(j) = -999999
      enddo

      do  100  j = 1, ntrm

          jnlx(j)   =  0
          jndx(j)   =  0
          jdist(j)  = -999999
          kdist(j)  = -999999
          ldist(j)  = -999999
          jsht(j)   =  0
          jgrp(j)   =  0
          jdi(j)    =  0
          jli(j)    =  0
100   continue

c     write(0,*)'model'
c     write(0,*)(xmod(i),i=1,ngrp)
c     write(0,*)(idist(i),i=1,nlive)

c-----------------------------------
c  find position of first (min) input trace within model
c  the input trace distances have been ordered from most
c  neg. to most pos.
c-----------------------------------

      call minmgv (xmod, 1, xmin, locmin, ngrp)
      if (.not. split) then
         locmin = locmin - 1
      endif
c     write(0,*)'xmin, locmin= ',xmin, locmin

c-----------------------------------
c  find position of input traces within model
c  starting from initial model location
c  of the min input trc distance
c-----------------------------------

          mismin = 999999
          mislst = 0
          jx     = 0
          kx     = 0
          DO  j = 1, nlive

              discur = idist(j)
    
              xloc   = discur / dx
              if (nin) then
                 miscur  = nint (xloc) + loc
              else
                 miscur  = ifix (xloc) + loc
              endif
              if (miscur .le. mismin) mismin = miscur
              if (miscur .eq. mislst) then
                 jx = jx + 1
                 kx = kx + 1
                 missdx   = miscur + kx
                 jnlx (j) = locmin + missdx
              else
                 jx       = 0
                 jnlx (j) = locmin + miscur + kx
                 mislst   = miscur
              endif

c     write(0,*)'J= ',j,' cur,loc,miscur,sdx,lst= ',
c    1discur,xloc,miscur,missdx,mislst,jnlx(j)

          ENDDO

c-----
c  if we retain the original # traces/rec on output (nopad) then we must
c  adjust the starting pointer into the model array to be 1 (even if the
c  first distance of the input spread is gt 1).
c-----
      if (nopad) then
         minloc = jnlx (1) - 1
         do  j = 1, nlive
             jnlx (j) = jnlx (j) - minloc
         enddo
      endif

c     write(0,*)(jnlx(j),j=1,nlive)

      do  j = 1, nlive
          ldist (j) = xmod(jnlx(j))
      enddo

      if (nlive .lt. 2) go to 17
c     if (nlive .lt. 2) return

c     write(0,*)'jnlx'
c     write(0,*)(jnlx(ii),ii=1,nlive)

c----
c   if the pointer runs off the end of the model spread find the adjustment
c   that gets it back
c----
      do  j = 1, nlive
          jnlx (j) = jnlx (j) + ishft
      enddo
      jnlst = jnlx (nlive)
      jnfst = jnlx (1)
      if (jnlst .gt. ngrp) then
          joff = jnlst - ngrp
          do  j = 1, nlive
              jnlx (j) = jnlx (j) - joff
          enddo
      endif

c     write(0,*)'jnlx'
c     write(0,*)(jnlx(ii),ii=1,nlive)


17    continue

      il = 1
      id = 0
      ic = 0

      DO  20  j = 1, ntro

          if (j .eq. jnlx(il)) then

             ic = ic + 1
             jndx(ic) = il
             kdist(j) = idist(il)
             jdist(j) = ldist(il)
             jsht (j) = isht (il)
             jgrp (j) = igrp (il)
             jdi  (j) = idi  (il)
             jli  (j) = ili  (il)
             il = il + 1

          else

             ic = ic + 1
             id = id + 1
             jndx(ic) = nlive + id
             kdist(j) = -999999

          endif

20    CONTINUE

      il = il - 1


c     write(0,*)'dist'
c     write(0,*)(idist(i),i=1,nlive)
c     write(0,*)'kdist'
c     write(0,*)(kdist(i),i=1,ntrm)
c     write(0,*)'jnlx'
c     write(0,*)(jndx(i),i=1,ntrm)
c     write(0,*)'jdist'
c     write(0,*)(jdist(i),i=1,ntrm)
c     write(0,*)(jsht(i),i=1,ntrm)
c     write(0,*)(jgrp(i),i=1,ntrm)
c     write(0,*)(jdi(i),i=1,ntrm)
c     write(0,*)(jli(i),i=1,ntrm)

      do  30  j = 1, ntro

          istrc = (jndx(j)-1) * itemt
          idtrc = (j-1)       * itemt

          do  29  i = 1, itemt

              lhed(i) = itrce(istrc+i)
29        continue


          if (interp) then
             call savew2(lhed,ifmt_hdrwrd,l_hdrwrd, ln_hdrwrd,
     1                   jdist(j)  , TRACEHEADER)
          else
             call savew2(lhed,ifmt_hdrwrd,l_hdrwrd, ln_hdrwrd,
     1                   kdist(j)  , TRACEHEADER)
          endif

          call savew2(lhed,ifmt_SrcLoc,l_SrcLoc, ln_SrcLoc,
     1                jsht (j)  , TRACEHEADER)
          call savew2(lhed,ifmt_RecInd,l_RecInd, ln_RecInd,
     1                jgrp (j)  , TRACEHEADER)
          call savew2(lhed,ifmt_DphInd,l_DphInd, ln_DphInd,
     1                jdi  (j)  , TRACEHEADER)
          call savew2(lhed,ifmt_LinInd,l_LinInd, ln_LinInd,
     1                jli  (j)  , TRACEHEADER)
          call savew2(lhed,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                irec      , TRACEHEADER)
          if (jdist(j) .eq. -999999) then
             call savew2(lhed,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                   30000     , TRACEHEADER)
             call savew2(lhed,ifmt_hdrwrd,l_hdrwrd, ln_hdrwrd,
     1                   0         , TRACEHEADER)
          endif

          do  ii = 1, itemt
              idead(idtrc+ii) = lhed(ii)
          enddo

          idist (j) = kdist (j)

30    continue

      return
      end
