C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine binner  (nlive,nsamp,ntrc,ngrp,items,idist,xmod,itrce,
     1                    idead,tabl1,tabl2,zz,iz,array,iflag,verbos,
     3                    ifmt_DstSgn,l_DstSgn, ln_DstSgn, ntrm,ntro,
     4                    work1, work2, jdist, dx, JJ, itemt, irec,lhed)

#include <save_defs.h>
#include <f77/sisdef.h>
#include <f77/lhdrsz.h>
#include <f77/iounit.h>

      integer         itrce(*), idead(*), lhed(*)
      integer         idist(SZLNHD)
      real            xmod(SZLNHD), array(*)

      real            tabl1(SZLNHD), tabl2(SZLNHD), zz(4*SZLNHD)
      integer         iz(SZLNHD)

      real            work1(SZLNHD), work2(SZLNHD)
      integer         jdist(SZLNHD)
      integer         ipos(SZLNHD)
      logical         verbos

      SAVE

      do    j = 1, ntro
            istrc = (j-1) * itemt + 1
            ittrc = (j-1) * nsamp + 1
            call move (1, array(ittrc), idead(istrc+ITRWRD), 
     1                 nsamp*SZSMPD)
      enddo

      if (verbos) then
      write(LERR,*)' '
      write(LERR,*)'Unbinned trace distances'
      write(LERR,100)(idist(i),i=1,ntro)
      write(LERR,*)'Binned trace distances'
      write(LERR,100)(jdist(i),i=1,ntro)
100   format(10i8)
      write(LERR,*)' '
      endif


         ic = 0
         do  j = 1, ntro
             if (idist(j) .ne. -999999) then
                ic = ic + 1
                ipos  (ic) = j
                tabl1 (ic) = idist (j)
                tabl2 (ic) = jdist (j)
             endif
         enddo
         ntrl  = ic
         ntrl1 = ic + 1
      tmin1 = tabl1 (1)
      tmin2 = tabl2 (1)

      tmin  = abs ( amin1 (tmin1, tmin2) ) + 1.
      do  j = 1, ntrl

          tabl1 (j) = tabl1 (j) + tmin
          tabl2 (j) = tabl2 (j) + tmin
      enddo
      tabl2 (ntrl1) = tabl2 (ntrl) + dx

      if (verbos) then
      write(LERR,*)' '
      write(LERR,*)'Live Trace= ',ntrl
      write(LERR,*)'Table1:'
      write(LERR,101)(tabl1(i),i=1,ntrl)
      write(LERR,*)'Table2:'
      write(LERR,101)(tabl2(i),i=1,ntrl)
101   format(10f8.0)
      write(LERR,*)' '
      endif

         DO  i = 1, nsamp

             call vclr (work1, 1, ntrl)
             do  j = 1, ntrl
                 ittrc = (ipos(j)-1) * nsamp + i
                 work1 (j) = array (ittrc)
             enddo

             call vclr (work2, 1, ntrl)
             call fcuint (tabl1, work1, ntrl, tabl2, work2, ntrl,
     1                    iz, zz, iflag)
             iflag = 0

             do  j = 1, ntrl
                 ittrc = (j-1) * nsamp + i
                 array (ittrc) = work2 (j)
             enddo

         ENDDO

         do  j = 1, ntrl
             istrc = (ipos(j)-1) * itemt + 1
             ittrc = (j-1) * nsamp + 1
             call move (1, idead(istrc+ITRWRD), array(ittrc), 
     1                  nsamp*SZSMPD)

             do  i = 1, itemt

                 lhed(i) = idead(istrc+i)
             enddo

             do  i = 1, itemt

                 idead(istrc+i) = lhed(i)
             enddo

             idist(j) = jdist(j)

         enddo


      return
      end
