C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C**********************************************************************C
C
C     PROGRAM MODULE DIstance SORT traces, record-by-record
C
C**********************************************************************C
C
C DISORT reads each seismic record, sorts the trace ordering according
C to either ascending or descending order, then outputs the record
C
C SUBROUTINE CALLS: RTAPE, HLH, SAVE, SORT
C
C**********************************************************************C
C
C     DECLARE VARIABLES
C
#include <localsys.h>
#include <f77/iounit.h>
#include <f77/sisdef.h>
#include <save_defs.h>
#include <f77/lhdrsz.h>
 
      INTEGER * 2 ITR ( SZLNHD )
      INTEGER     LHED( SZLNHD ),idist(SZLNHD),jndx(SZLNHD)
      INTEGER * 2 ITR0 ( SZLNHD )
      INTEGER     LHED0( SZLNHD )
      REAL        HEAD( SZLNHD )
      INTEGER     NSAMP, NSI, NTRC, NREC, IFORM
      INTEGER     LUIN , LBYTES, NBYTES, luout
      integer     isht(SZLNHD), idi(SZLNHD), igrp(SZLNHD)
      integer     ili(SZLNHD)
      integer     argis
      real        dis, dmin, dmax
      real        xmod ( SZLNHD )

      real        tabl1(SZLNHD), tabl2(SZLNHD), zz(4*SZLNHD)
      real        work1(SZLNHD), work2(SZLNHD)
      integer     iz(SZLNHD)
      integer     jdist(SZLNHD)

      real        array
      pointer     (wkarry, array(1))
      integer     itrce
      pointer     (wktrce, itrce(1))
      integer     idead
      pointer     (wkdead, idead(1))

      CHARACTER   NAME * 6, ntap * 100, otap * 100, hdrwrd * 6
      
#include <f77/pid.h>
      logical verbos,query,reverse,pass,nopad,heap,split,model,back
      logical bin, interp, dead, neg, nin
 
      EQUIVALENCE ( ITR(1), LHED(1), HEAD(1) )
      EQUIVALENCE ( ITR0(1), LHED0(1) )
      DATA LHED0/SZLNHD*0/
      DATA NAME     /'DISORT'/
      DATA LUIN / 1 /, LBYTES / 0 /, NBYTES / 0 /
      data verbos/.true./, back/.false./

C**********************************************************************C
C     get online help if necessary
C**********************************************************************C
      query = (argis('-?') .gt. 0 .or. argis('-h') .gt. 0)
      if( query ) then
          call help()
          stop
      endif

C**********************************************************************C
C     open printout file
C**********************************************************************C
#include <f77/open.h>

C**********************************************************************C
C     read command line parameters
C**********************************************************************C
      call cmdln(ntap,otap,ntr,dmin,dmax,pass,reverse,
     1            split,offfar,dx,ngrpi,model,nopad,verbos,bin,
     2            interp,dead,neg,hdrwrd,nin)

C**********************************************************************C
C     get logical data units, get header values, update line header
C**********************************************************************C
      call getln( luin, ntap, 'r', 0)
      call getln(luout, otap, 'w', 1)

      CALL RTAPE ( LUIN, ITR, LBYTES           )
      if(lbytes .eq. 0) then
         write(LERR,*)'DISORT: no header read on unit ',luin
         write(LERR,*)'ntap =  ',ntap
         write(LERR,*)'FATAL'
         stop
      endif

      CALL HLHprt    ( ITR , LBYTES, NAME, 6,         LERR)

c------
c     save certain parameters

#include <f77/saveh.h>
 
c     For trace header values we take mnemonics and build a
c     set of pointers to an I*2 array equivalenced to the
c     RTAPE  Integer array (headers + data)
c     TRACEHEADER is a value in the include file <sisdef.h> that
c     refers to the trace header
 
      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('LinInd',ifmt_LinInd,l_LinInd,ln_LinInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu(hdrwrd,ifmt_hdrwrd,l_hdrwrd,ln_hdrwrd,TRACEHEADER)

      if(nsamp .gt. SZLNHD) nsamp=SZLNHD

c-----------------------
c  model trace distances

      offx = offfar + dx

      IF (model) THEN

                 dmin =  99999.
                 dmax = -99999.

         if (split) then
            x = -dx
         else
            x = -dx
         endif

         do      j = 1, SZSMPM
 
             x = x + dx
             if (x .gt. offx) then
                 ngrp2 = j-1
                 go to 21
             else
                 xmod (j) = x
             endif
         enddo

21       continue
 
         if (split) then
            x = 0.
            do      j = 1, ngrp2
                x = x - dx
                xmod (ngrp2 + j) = x
            enddo
            ngrp = 2 * ngrp2
         else
            ngrp = ngrp2
         endif

         if (.not. split .and. neg) then
            call vsmul (xmod, 1, -1., xmod, 1, ngrp)
         endif
         call rsort (xmod , iz, ngrp)

         if (xmod(1) .le. xmod(2)) then
             back = .false.
         else
             back = .true.
         endif

          write(LERR,*)'Model group interval= ',dx,
     1                 '  Number grps= ',ngrp
          do  92 j = 1, ngrp
              write(LERR,*)'Trace ',j,'  model distance= ',xmod(j)
92        continue
          write(LERR,*)' '
          
          dx = abs (dx)

          if (nopad) then
              ntr = ntrc
          else
              ntr = ngrp
          endif
          ntrco = ntr
      ELSE

         ngrp = ntrc
         if(nopad) then
            if(ntr .le. 0) ntr = ntrc
         else
            ntr = ntrc
         endif
         if (dead) ntr = ntrc
         ntrco = ntrc

      ENDIF
c-----------------------
                 

      call savew( itr, 'NumTrc', ntr   , LINHED)
      call savew( itr, 'NumSmp', nsamp , LINHED)
      call savhlh( itr, lbytes, lbyout)

      call wrtape(luout,itr,lbyout)

C**********************************************************************C
C     print out key header values
C**********************************************************************C
       write(LERR,*)
       write(LERR,*)' Values read from input data set line header'
       write(LERR,*)
       write(LERR,*) ' # of Samples/Trace =  ', nsamp
        write(LERR,*) ' Sample Interval    =  ', nsi  
        write(LERR,*) ' Traces per Record  =  ', ntrc 
        write(LERR,*) ' Output traces/rec  =  ', ntr
        write(LERR,*) ' Records per Line   =  ', nrec 
        write(LERR,*) ' Format of Data     =  ', iform
        write(LERR,*) ' Minimum distance   =  ', dmin
        write(LERR,*) ' Maximum distance   =  ', dmax
        write(LERR,*) ' Doing sorting on hdr word = ',hdrwrd
        if(pass)write(LERR,*)' Pass  dmin < dist < dmax'
        if(dead)write(LERR,*)' Rejected dists are marked as dead'
        if(.not.pass)write(LERR,*)' Reject  dmin < dist < dmax'
        if(reverse) then
            write(LERR,*)' Reverse distance order'
        else
            write(LERR,*)' Ascending distance order'
        endif
        if(nopad) then
            write(LERR,*)' Do Not Pad Output Records With Null Traces'
        else
            write(LERR,*)' Pad Output Records With Null Traces'
        endif
        if(model) then
            write(LERR,*)'Will model trace distances and output traces'
            write(LERR,*)'in their proper distance slots'
            write(LERR,*)'Far offset will be ',offfar
            write(LERR,*)'Groups interval will be ', dx
            if (nin) then
            write(LERR,*)'Regridding done to nearest integer'
            else
            write(LERR,*)'Regridding done to integer granularity'
            endif
            if (split) then
               write(LERR,*)'Split Spread assumed'
            else
               write(LERR,*)'Single Ender Spread assumed'
               if (neg)
     1         write(LERR,*)'single ender has negative distances'
            endif
        endif
c---------------------------------------------------
c  malloc only space we're going to use
      heap = .true.

      ntrm = max (ntrc, ngrp)

      items    = ntrm * (ITRWRD + nsamp)
      if (model) then
         itemr = ntrm *           nsamp
      else
         itemr = SZSMPD
      endif

      write(LERR,*)'items= ',items
      write(LERR,*)'itemr= ',itemr
      call galloc (wktrce, items*SZSMPD, errcod, abort)
      if (errcod .ne. 0) heap = .false.
      call galloc (wkdead, items*SZSMPD, errcod, abort)
      if (errcod .ne. 0) heap = .false.
      call galloc (wkarry, itemr*SZSMPD, errcod, abort)
      if (errcod .ne. 0) heap = .false.

      if (.not. heap) then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) items*SZSMPD,'  bytes'
         write(LERR,*) items*SZSMPD,'  bytes'
         write(LERR,*) itemr*SZSMPD,'  bytes'
         write(LERR,*)' '
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) items*SZSMPD,'  bytes'
         write(LERR,*) items*SZSMPD,'  bytes'
         write(LERR,*) itemr*SZSMPD,'  bytes'
         write(LERR,*)' '
      endif
      items = items * SZSMPD

      if (interp) call vclr (array, 1, ntrm*nsamp)

c---------------------------------------------------
 

C**********************************************************************C
C
C     read record, sort on distances, limit distances, then output
C
C**********************************************************************C
 
      itemt = ITRWRD + nsamp
      
      DO 100 JJ = 1, NREC

           il = 0
           id = 0
           iflag = 1

           call move (0, idead, 0, items)
           call move (0, itrce, 0, items)

           DO 99 KK = 1, NTRC

              nbytes=0
              CALL RTAPE  ( LUIN , itr, NBYTES         )
               if(nbytes .eq. 0) then
                  write(LERR,*)'End of file on input:'
                  write(LERR,*)'  rec= ',jj,'  trace= ',kk
                  go to 999
               endif
               call saver2(lhed,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                     istatic , TRACEHEADER)

c---------------------------
c  put traces into array
c  put dead trcs into array


              IF (istatic .eq. 30000) THEN

                call savew2(lhed,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1                      32767  , TRACEHEADER)
                 id = id + 1
                 istrc = (id-1) * itemt
                 do    i=1,itemt
                    idead(istrc+i) = lhed(i)
                 enddo

              ELSE

                 il = il + 1
                 call saver2(lhed,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                       irec      , TRACEHEADER)
                 call saver2(lhed,ifmt_hdrwrd,l_hdrwrd, ln_hdrwrd,
     1                       idist(il) , TRACEHEADER)
                 call saver2(lhed,ifmt_SrcLoc,l_SrcLoc, ln_SrcLoc,
     1                       isht(il)  , TRACEHEADER)
                 call saver2(lhed,ifmt_RecInd,l_RecInd, ln_RecInd,
     1                       igrp(il)  , TRACEHEADER)
                 call saver2(lhed,ifmt_DphInd,l_DphInd, ln_DphInd,
     1                       idi (il)  , TRACEHEADER)
                 call saver2(lhed,ifmt_LinInd,l_LinInd, ln_LinInd,
     1                       ili (il)  , TRACEHEADER)

                 istrc = (il - 1) * itemt

                 do    i=1,itemt
                    itrce(istrc+i) = lhed(i)
                 enddo

              ENDIF


c--------------------------------------------------------------------
c  put distances into array and store original trace indices into array
c  & store static values in original order
c  because we put 32676 in the distance word of dead traces they end
c  up on the right side of the spread

              jndx(kk)  = kk
 
   99     CONTINUE

          nlive = il
          ndead = id

          if (nlive+ndead .ne. ntrc) then
             write(LERR,*)'Number live traces + dead traces= ',
     1                     nlive+ndead
             write(LERR,*)'does not equal # traces/gather= ',ntrc
             write(LERR,*)'FATAL HEART ATTACK for disort at'
             write(LERR,*)'record ',jj,'  trace ',kk
             go to 999
          endif

c---------------------------
c  sort live traces by dist
c  move dead traces into 
c  right side of array

          ic = 0
          do  64  j = il+1, ntrc

              ic = ic + 1
              istrc =  (j-1) * itemt
              idtrc = (ic-1) * itemt

              do  63  i = 1, itemt
                  itrce(istrc+i) = idead(idtrc+i)
63            continue
64        continue


c------------------
c sort on distances
c of live traces

          call sort (idist, jndx, nlive, back)

          call reorder (isht, jndx, nlive)
          call reorder (igrp, jndx, nlive)
          call reorder (idi , jndx, nlive)
          call reorder (ili , jndx, nlive)

c-----------------------
c stuff sorted live trcs
c into temp storeage

          do  66  j = 1, nlive

              istrc = (jndx(j) - 1) * itemt
              ittrc =       (j - 1) * itemt

              do  65  i = 1, itemt
                  idead(ittrc+i) = itrce(istrc+i)
65            continue

66        continue

c-----------------------
c copy sorted live traces
c back into primary store

          do  j = 1, nlive

              istrc = (j - 1) * itemt

              do    i = 1, itemt
                  itrce(istrc+i) = idead(istrc+i)
              enddo
          enddo


c---------------------------
c put traces into proper
c locations in gather
           IF (model) THEN

c-----------------------
c            take care of duplicate
c            trc dists (result maybe
c            of too coarse binning
c            before?)

             call dupdst  (nlive,nsamp,ntr,items,idist,itrce,
     1                     idead,itemt,work1, work2)

             call arrange (nlive,ndead,ntrc,ngrp,items,idist,dx,xmod,
     1                     itrce,idead,model,isht,igrp,idi,ili,split,
     2                     ifmt_StaCor,l_StaCor, ln_StaCor,ntrm,ntr,
     3                     ifmt_hdrwrd,l_hdrwrd, ln_hdrwrd, nopad,
     4                     ifmt_SrcLoc,l_SrcLoc, ln_SrcLoc, nin,
     5                     ifmt_RecInd,l_RecInd, ln_RecInd,
     6                     ifmt_DphInd,l_DphInd, ln_DphInd,
     6                     ifmt_LinInd,l_LinInd, ln_LinInd,
     7                     ifmt_RecNum,l_RecNum, ln_RecNum,
     8                     itr, lhed, itemt, irec, jdist, interp)
c---------------------------
c bin & interpolate rearranged
c traces onto model distances

             if (interp)
     1       call binner (nlive,nsamp,ntrc,ngrp,items,idist,xmod,itrce,
     2                    idead,tabl1,tabl2,zz,iz,array,iflag,verbos,
     3                    ifmt_hdrwrd,l_hdrwrd, ln_hdrwrd, ntrm,ntr,
     4                    work1,work2,jdist,dx,JJ,itemt,irec,lhed)
          ELSE

 
             do  j = 1, nlive
 
                 istrc = (j - 1) * itemt
 
                 do    i = 1, itemt
                     idead(istrc+i) = itrce(istrc+i)
                 enddo
             enddo


          ENDIF


           ic = 0
           DO 199 KK = 1, NTRCo

c------------------------------------------------------------
c  put traces into output vector in ascending distance order
c  and output within range of distances

               jt = kk
               if( reverse ) jt = ntrc-kk+1
               dis = idist(jt)

           IF(pass) then

              if ( dead ) then

              if(dis .ge. dmin .and. dis .le. dmax) then
    
                 ic = ic + 1
                 if (ic .gt. ntr) go to 100
                 istrc = (jt-1) * itemt
                 do  i=1,itemt
                     lhed(i) = idead(istrc+i)
                 enddo
                 if(verbos) then
                   call saver2(lhed,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1                         idis , TRACEHEADER)
                    write(LERR,*)'writing trace ',itr(l_TrcNum),
     &                            ' record ',irec,
     &                            ' dist= ',idis
                 endif
 
                 lhed (ITHWP1) = 0
                 call saver2(lhed,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                       irr  , TRACEHEADER)
                 if (irr .eq. 0) then
                    call savew2(lhed,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                          irec , TRACEHEADER)
                    call savew2(lhed,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                          30000, TRACEHEADER)
                 endif
                 call savew2(lhed,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                       ic        , TRACEHEADER)
                 call wrtape(luout,itr,nbytes)
              else
                 ic = ic + 1
                 if (ic .gt. ntr) go to 100
                 istrc = (jt-1) * itemt
                 do  i=1,itemt
                     lhed(i) = idead(istrc+i)
                 enddo
                 call saver2(lhed,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                       irr  , TRACEHEADER)
                 if (irr .eq. 0) then
                    call savew2(lhed,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                          irec , TRACEHEADER)
                 endif
                 call savew2(lhed,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                       ic        , TRACEHEADER)
                 call savew2(lhed,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                       30000 , TRACEHEADER)
                 call wrtape(luout,itr,nbytes)
              endif

              else


              if(dis .ge. dmin .and. dis .le. dmax) then
     
                 ic = ic + 1          
                 if (ic .gt. ntr) go to 100
                 istrc = (jt-1) * itemt
                 do  i=1,itemt
                     lhed(i) = idead(istrc+i)
                 enddo
                 if(verbos) then
                   call saver2(lhed,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1                         idis , TRACEHEADER)
                    write(LERR,*)'writing trace ',itr(l_TrcNum),
     &                            ' record ',irec,
     &                            ' dist= ',idis
                 endif

                 lhed (ITHWP1) = 0
                 call saver2(lhed,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                       irr  , TRACEHEADER)
                 if (irr .eq. 0) then
                    call savew2(lhed,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                          irec , TRACEHEADER)
                    call savew2(lhed,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                          30000, TRACEHEADER)
                 endif
                 call savew2(lhed,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                       ic        , TRACEHEADER)
                 call wrtape(luout,itr,nbytes)
              endif

              endif

           ELSEIF( .not. pass) then

              if ( dead ) then

              if(dis .le. dmin .or. dis .ge. dmax) then
 
                 ic = ic + 1
                 if (ic .gt. ntr) go to 100
                 istrc = (jt-1) * itemt
                 do  i=1,itemt
                     lhed(i) = idead(istrc+i)
                 enddo
                 if(verbos) then
                   call saver2(lhed,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1                         idis , TRACEHEADER)
                    write(LERR,*)'writing trace ',itr(l_TrcNum),
     &                            ' record ',itr(l_RecNum),
     &                            ' dist= ',itr(l_DstSgn)
                 endif
 
                 lhed (ITHWP1) = 0
                 call saver2(lhed,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                       irr  , TRACEHEADER)
                 if (irr .eq. 0) then
                    call savew2(lhed,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                          irec , TRACEHEADER)
                    call savew2(lhed,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                          30000, TRACEHEADER)
                 endif
                 call savew2(lhed,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                       ic        , TRACEHEADER)
                 call wrtape(luout,itr,nbytes)
              else
                 ic = ic + 1
                 if (ic .gt. ntr) go to 100
                 istrc = (jt-1) * itemt
                 do  i=1,itemt
                     lhed(i) = idead(istrc+i)
                 enddo
                 call saver2(lhed,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                       irr  , TRACEHEADER)
                 if (irr .eq. 0) then
                    call savew2(lhed,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                          irec , TRACEHEADER)
                 endif
                 call savew2(lhed,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                       ic        , TRACEHEADER)
                 call savew2(lhed,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                       30000 , TRACEHEADER)
                 call wrtape(luout,itr,nbytes)
              endif
             
              else

              if(dis .le. dmin .or. dis .ge. dmax) then
               
                 ic = ic + 1          
                 if (ic .gt. ntr) go to 100
                 istrc = (jt-1) * itemt
                 do  i=1,itemt
                     lhed(i) = idead(istrc+i)
                 enddo
                 if(verbos) then
                   call saver2(lhed,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1                         idis , TRACEHEADER)
                    write(LERR,*)'writing trace ',itr(l_TrcNum),
     &                            ' record ',itr(l_RecNum),
     &                            ' dist= ',itr(l_DstSgn)
                 endif

                 lhed (ITHWP1) = 0
                 call saver2(lhed,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                       irr  , TRACEHEADER)
                 if (irr .eq. 0) then
                    call savew2(lhed,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                          irec , TRACEHEADER)
                    call savew2(lhed,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                          30000, TRACEHEADER)
                 endif
                 call savew2(lhed,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                       ic        , TRACEHEADER)
                 call wrtape(luout,itr,nbytes)
              endif

              endif

           ENDIF
c---------------------------------------------------------------

  199      CONTINUE

         IF ( dead ) go to 100

         if( nopad ) then
           if(ic .ne. ntr) then
              write(LERR,*)'WARNNG from disort rec ',irec,':'
              write(LERR,*)'Wrong number of traces/rec on command line'
              write(LERR,*)'Actual number output is  ',ic,ntr
              write(LERR,*)'Padding record out to ',ntr,' traces'
c             go to 100
              do 71  ip = ic+1, ntr
                     jt = ip
                     if(reverse) jt = ntr-ip+1
                     call savew2(lhed0,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                           irec      , TRACEHEADER)
                     call savew2(lhed0,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                           ip        , TRACEHEADER)
                     call savew2(lhed0,ifmt_DstUsg,l_DstUsg, ln_DstUsg,
     1                           iabs(idist(jt)), TRACEHEADER)
                        if (interp) then
                        call savew2(lhed0,ifmt_DstSgn,l_DstSgn,
     1                              ln_DstSgn,jdist(jt) , TRACEHEADER)
                     else
                        call savew2(lhed0,ifmt_DstSgn,l_DstSgn,
     1                              ln_DstSgn,idist(jt) , TRACEHEADER)
                     endif
                     call savew2(lhed0,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                           30000     , TRACEHEADER)
    
                     lhed0 (ITHWP1) = 0
                  call wrtape(luout,itr0,nbytes)
   71         continue
           endif

         else
           do 69  ip = ic+1, ntrc
                  jt = ip
                  if(reverse) jt = ntrc-ip+1
                  call savew2(lhed0,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                        irec      , TRACEHEADER)
                  call savew2(lhed0,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                        ip        , TRACEHEADER)
                  call savew2(lhed0,ifmt_DstUsg,l_DstUsg, ln_DstUsg,
     1                        iabs(idist(jt)), TRACEHEADER)
                  if (interp) then
                     call savew2(lhed0,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1                           jdist(jt) , TRACEHEADER)
                  else
                     call savew2(lhed0,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1                           idist(jt) , TRACEHEADER)
                  endif
                  call savew2(lhed0,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                        30000     , TRACEHEADER)

                  lhed0 (ITHWP1) = 0
                  call wrtape(luout,itr0,nbytes)
   69      continue
         endif

  100 CONTINUE

  999 continue
       call lbclos(luin)
       call lbclos(luout)
      END

      subroutine sort(ix, key, no, back)
c-----
c     This provides a sort of items
c     x(i) is the array to be sorted
c     key(i) is the pointer array
c     no is the number of points to be sorted
c     After the sort x(i) will be ordered from least to
c           greatest
c     key(1) will point to the position in the original array
c     with the least value
c-----
      dimension ix(1),key(1)
      dimension iy(8192), ley(8192)
      logical   back

      do 1 i=1,no
    1 key(i)=i
      mo=no
    2 if(mo-15)21,21,23
   21 if(mo-1)29,29,22
   22 mo=2*(mo/4)+1
      goto 24
   23 mo=2*(mo/8)+1
   24 ko=no-mo
      jo=1
   25 i=jo
   26 if(ix(i)-ix(i+mo))28,28,27
   27 temp=ix(i)
      ix(i)=ix(i+mo)
      ix(i+mo)=temp
      kemp=key(i)
      key(i)=key(i+mo)
      key(i+mo)=kemp
      i=i-mo
      if(i-1)28,26,26
   28 jo=jo+1
      if(jo-ko)25,25,2
   29 continue

      if (back) then
         do 100 j = 1, no
            iy (no-j+1) = ix(j)
            ley(no-j+1) = key(j)
100      continue
         do 101 j = 1, no
            ix(j) = iy(j)
            key(j) = ley(j)
101      continue
         return
      else
         return
      endif

      end

c------------------
c  online help

      subroutine help
#include <f77/iounit.h>

      
        write(LER,*)' '
        write(LER,*)'Command Line Arguments for DISORT: sort traces'
        write(LER,*)'       record-by-record according to distances'
        write(LER,*)'       bin trace distances, or sort each record'
        write(LER,*)'       according to specified header word'
        write(LER,*)' '
        write(LER,*)'Input....................................... (def)'
        write(LER,*)' '
        write(LER,*)'-N[ntap]   -- input data set'
        write(LER,*)'-O[otap]   -- output data set'
        write(LER,*)'-hw[hdrwrd]-- key trace header word (DstSgn)'
        write(LER,*)'              Must be distance if binning option'
        write(LER,*)'-ntr[ntr]  -- output traces/rec if dmin or dmax is'
        write(LER,*)'              given on command line'
        write(LER,*)'-dmax[dmax]-- maximum distance'
        write(LER,*)'-dmin[dmin]-- minimum distance'
        write(LER,*)' '
        write(LER,*)'-xn[offfar]-- gather spread model far offset'
        write(LER,*)'-xd[dx]    -- gather spread model group interval'
        write(LER,*)'-M         -- model spread & put dead traces in'
        write(LER,*)'-neg       -- input dists are all neg (single end)'
        write(LER,*)'              proper horizontal positions'
        write(LER,*)'-nint      -- regridding based on nearest integer,'
        write(LER,*)'              else regridding based on integer'
        write(LER,*)'-S         -- split spread, else single ender'
        write(LER,*)'-I         -- interpolate trcs onto model offsets'
        write(LER,*)'              (after first putting dead trcs in'
        write(LER,*)'              correct horizontal location)'
        write(LER,*)' '
        write(LER,*)'-P         -- if present, pass dists between dmin'
        write(LER,*)'              dmax, else reject betw dmin-dmax'
        write(LER,*)'-D         -- rejected dists are marked dead but'
        write(LER,*)'              kept in the output record'
        write(LER,*)'-R         -- distances are descending order'
        write(LER,*)'-F         -- dead traces put on positive end of'
        write(LER,*)'              spread; otherwise on neg end'
        write(LER,*)'-X         -- do not pad output recs with null trac
     1es'
        write(LER,*)'              Bin option: do not expand to model sp
     1read'
        write(LER,*)'-V         -- verbos printout'
        write(LER,*)' '
        write(LER,*)'Usage:'
        write(LER,*)' disort -N[] -O[] [ [ -I -M -S -neg -nint ]'
        write(LER,*)'        -R -D -P -F -X -V] -dmax[] -dmin[]'
        write(LER,*)'        -ntr[] -xd[] -xn[] -hw[]'
        write(LER,*)' '
      return
      end

      subroutine cmdln(ntap,otap,ntr,dmin,dmax,pass,reverse,
     1                  split,offfar,dx,ndx,model,nopad,verbos,bin,
     2                  interp,dead,neg,hdrwrd,nin)
c-----
c     get command arguments
c
c     ntap  - C*100  input file name
c     otap  - C*100  output file name
c     ntr   - I      output traces/rec
c    dmin   - R      min distance to stack
c    dmax   - R      max distance to stack
c  offfar   - R      near offset for spread model
c     dx    - R      group interval
c    ndx    - I      Number groups
c    pass   - L      pass range of distances
c   nopad   - L      do not pad output records
c   split   - L      split spread
c   model   - L      model spread
c   reverse - L      reverse order of distances
c    verbos - L      verbose output or not
c-----
      
#include <f77/iounit.h>
      integer    ntr, argis
      real       dmin, dmax
      logical    verbos, pass, reverse, nopad, split, model, bin
      logical    interp, dead, neg, nin
      character  ntap*(*), otap*(*), hdrwrd*6

         call argstr('-N',ntap,' ',' ') 
         call argstr('-O',otap,' ',' ') 
         call argstr('-hw',hdrwrd,'DstSgn','DstSgn') 
         call argi4('-ntr',ntr,0,0)
         call argr4('-dmax',dmax, 99999., 99999.)
         call argr4('-dmin',dmin,-99999.,-99999.)
         call argr4('-xn',offfar,0.,0.)
         call argr4('-xd',dx,0.,0.)
         call argi4('-gn',ndx,0,0)

         pass    = (argis('-P') .gt. 0)
         bin     = (argis('-B') .gt. 0)
         interp  = (argis('-I') .gt. 0)
         nopad   = (argis('-X') .gt. 0)
         split   = (argis('-S') .gt. 0)
         model   = (argis('-M') .gt. 0)
         dead    = (argis('-D') .gt. 0)
         reverse = (argis('-R') .gt. 0)
         neg     = (argis('-neg') .gt. 0)
         nin     = (argis('-nint') .gt. 0)
         verbos  = (argis('-V') .gt. 0)


         if (interp .and. .not.model) model = .true.

         if (dx .eq. 0. .and. model) then
             write(LERR,*)'Must include group interval for model'
             write(LERR,*)'spead and/or interp options.'
            write(LERR,*)'Include'
            write(LERR,*)'            -M [ -I ] -xn[] -xd[]'
            write(LERR,*)'on cms line & rerun'
             stop
         endif

         if (dx .eq. 0. .and. interp) then
            write(LERR,*)'Must include group interval for interp'
            write(LERR,*)'Include'
            write(LERR,*)'            -M -I -xn[] -xd[]'
            write(LERR,*)'on cms line & rerun'
            stop
         endif

         if (model) then
                 dmin = -99999.
                 dmax = +99999.
         endif
         
         if(dmax .eq. 99999. .and. dmin .eq. -99999.) then
             ntr = -1
             if(.not. pass) then
                 dmin =  99999.
                 dmax = -99999.
             endif
         endif
         if(dmax .ne. 99999. .or. dmin .ne. -99999.) then
             if(ntr .eq. 0 .AND. .not. dead) then
                write(LERR,*)'For range limiting, output traces/rec must
     1 be given'
                write(LERR,*)'Put this value on command line; rerun'
                stop
             endif
         endif
         
      return
      end

      subroutine reorder (inout, jndx, n)

#include <f77/lhdrsz.h>

      integer    inout(*), jndx(*)
      integer    itmp(SZLNHD)

      do  1  i = 1, n

          itmp(i) = inout( jndx(i) )
1     continue

      do  2  i = 1, n

          inout(i) = itmp(i)
2     continue

      return
      end
